# FI Base EpisodeOfCare - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base EpisodeOfCare**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-episode-of-care-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-episode-of-care-mappings.md) 
*  [Examples](StructureDefinition-fi-base-episode-of-care-examples.md) 
*  [XML](StructureDefinition-fi-base-episode-of-care.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-episode-of-care.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-episode-of-care.profile.ttl.md) 

## Resource Profile: FI Base EpisodeOfCare 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-episode-of-care | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBaseEpisodeOfCare |

 
This is the Finnish base profile for the EpisodeOfCare resource. 

**Usages:**

* Refer to this Profile: [FI Base Encounter](StructureDefinition-fi-base-encounter.md), [FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md), [FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md), [FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html)...Show 2 more,[FI Base MedicationAdministration](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-administration.html)and[FI Base MedicationStatement](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-statement.html)
* Examples for this Profile: [EpisodeOfCare/id-for-episode-1](EpisodeOfCare-id-for-episode-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-episode-of-care)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [EpisodeOfCare](http://hl7.org/fhir/R4/episodeofcare.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [EpisodeOfCare](http://hl7.org/fhir/R4/episodeofcare.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [EpisodeOfCare](http://hl7.org/fhir/R4/episodeofcare.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [EpisodeOfCare](http://hl7.org/fhir/R4/episodeofcare.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-episode-of-care.csv), [Excel](StructureDefinition-fi-base-episode-of-care.xlsx), [Schematron](StructureDefinition-fi-base-episode-of-care.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

