# FI Base Encounter - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Encounter**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-encounter-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-encounter-mappings.md) 
*  [Examples](StructureDefinition-fi-base-encounter-examples.md) 
*  [XML](StructureDefinition-fi-base-encounter.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-encounter.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-encounter.profile.ttl.md) 

## Resource Profile: FI Base Encounter 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBaseEncounter |

 
This is the Finnish base profile for the Encounter resource. 

### Scope and Usage

The Finnish Core Encounter profile is intended to encapsulate the most common and basic data model of encounters in Finnish healthcare systems. The profile also defines encounter's relation to the Kanta registry. As such the profile should be usable in most Finnish contexts.

#### Relation to Finnish palvelutapahtuma

[Kanta](https://www.kanta.fi/) is the Finnish national central registry of health and social welfare information. It has a specification for Palvelutapahtuma, this is typically translated as service-event or encompassing encounter.

The scope of **palvelutapahtuma** is described in [Kanta documentation](https://www.kanta.fi/jarjestelmakehittajat/liite-2-palvelutapahtumien-esimerkkeja) (in Finnish). It's scope is not always the same as the encounter's. Encounter and **palvelutapahtuma** will overlap as concepts (depending on implementation). Some encounters clearly align with **palvelutapahtuma** while others don't. **Palvelutapahtuma** may contain multiple encounters. For example a series of treatments is considered to be a singular **palvelutapahtuma**, but systems most likely want to express each visit as a separate encounter (see kanta doc for the description of **hoitosarja**, there are other examples too).

For deeper techical details, see (in Finnish):

* Kanta [CDA R2 Header](https://www.kanta.fi/jarjestelmakehittajat/potilastiedon-arkiston-cda-r2-header) version 4.66 or later. 
* Descriptions of **palvelutapahtuma**
 
* Kanta [HL7 V3 Medical Records specification](https://www.kanta.fi/jarjestelmakehittajat/potilastiedon-arkiston-medical-records). 
* Shows the role of **palvelutapahtuma** when making requests to Kanta
 

##### Why does an encounter need this information?

Kanta HL7 V3 Medical Records specification requires that both queries and archivals transmit **palvelutapahtuma**'s OID identifier on each request. A client application that is integrated to a patient administration system (one that masters the data of encounters) often needs to create and query Kanta Medical records. Encounter is the best "vessel" we have to transmit this information.

For example a laboratory information system may have it's own Kanta Medical Records capabilities and will archive lab results directly to Kanta. It receives encounter id in SMART App Launch context. Laboratory system can resolve **palvelutapahtuma**'s OID identifier by fetching the encounter resource.

##### How to communicate the palvelutapahtuma via the Encounter resource

This method is applicable for resources that have a direct link to Encounter.

An Encounter that is a **palvelutapahtuma** SHALL have an identifier with `use=official` and the value of that identifier SHALL be the OID of a **palvelutapahtuma**.

Other levels of encounter that are not a **palvelutapahtuma**, MUST NOT contain an identifier with `use=official`.

The resource referring to the Encounter, may link to the **palvelutapahtuma** Encounter directly, or to a lower level Encounter (some systems call these **prosessitapahtuma**). In this case, the lower level Encounters SHALL have a chain of `.partOf` links eventually leading to the **palvelutapahtuma** Encounter.

##### How to communicate the palvelutapahtuma without an Encounter resource

When the resource does not have a direct link to Encounter or if the chaining of Encounter resources is considered too complex, the [ServiceEvent extension](StructureDefinition-service-event.md) can be used instead.

#### Organizational responsibility

The unit responsible for the encounter SHOULD be communicated using the `serviceProvider` property.

For instance, there's a [detailed example with explanations](Encounter-id-for-ward-encounter.md) for how to fetch patients in a ward.

**Usages:**

* Refer to this Profile: [FI Base Encounter](StructureDefinition-fi-base-encounter.md), [Fi Base Immunization](StructureDefinition-fi-base-immunization.md), [FI Base MedicationAdministration](StructureDefinition-fi-base-medication-administration.md), [FI Base MedicationRequest](StructureDefinition-fi-base-medication-request.md)...Show 11 more,[FI Base MedicationStatement](StructureDefinition-fi-base-medication-statement.md),[FI Base Observation](StructureDefinition-fi-base-observation.md),[Fi Base Procedure](StructureDefinition-fi-base-procedure.md),[FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html),[Fi Base Immunization](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-immunization.html),[FI Base MedicationAdministration](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-administration.html),[FI Base MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-request.html),[FI Base MedicationStatement](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-medication-statement.html),[FI Base Observation](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-observation.html),[FI Base Patient MedicationRequest](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-patient-medication-request.html)and[Fi Base Procedure](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-procedure.html)
* Examples for this Profile: [Encounter/id-for-child-encounter-2](Encounter-id-for-child-encounter-2.md), [Encounter/id-for-child-encounter](Encounter-id-for-child-encounter.md), [Encounter/id-for-palvelutapahtuma](Encounter-id-for-palvelutapahtuma.md), [Encounter/id-for-visit](Encounter-id-for-visit.md) and [Encounter/id-for-ward-encounter](Encounter-id-for-ward-encounter.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base EpisodeOfCare(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-episode-of-care)](StructureDefinition-fi-base-episode-of-care.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Appointment(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-appointment)](StructureDefinition-fi-base-appointment.md)
* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [Fi Base Procedure(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-procedure)](StructureDefinition-fi-base-procedure.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Encounter](http://hl7.org/fhir/R4/encounter.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base EpisodeOfCare(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-episode-of-care)](StructureDefinition-fi-base-episode-of-care.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Appointment(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-appointment)](StructureDefinition-fi-base-appointment.md)
* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [Fi Base Procedure(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-procedure)](StructureDefinition-fi-base-procedure.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)
* [FI Base Organization(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-organization)](StructureDefinition-fi-base-organization.md)
* [FI Base Encounter(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-encounter)](StructureDefinition-fi-base-encounter.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-encounter.csv), [Excel](StructureDefinition-fi-base-encounter.xlsx), [Schematron](StructureDefinition-fi-base-encounter.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

