# FI Base Appointment - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FI Base Appointment**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-fi-base-appointment-definitions.md) 
*  [Mappings](StructureDefinition-fi-base-appointment-mappings.md) 
*  [Examples](StructureDefinition-fi-base-appointment-examples.md) 
*  [XML](StructureDefinition-fi-base-appointment.profile.xml.md) 
*  [JSON](StructureDefinition-fi-base-appointment.profile.json.md) 
*  [TTL](StructureDefinition-fi-base-appointment.profile.ttl.md) 

## Resource Profile: FI Base Appointment 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-appointment | *Version*:2.0.0-ci |
| Draft as of 2025-10-05 | *Computable Name*:FiBaseAppointment |

 
This is the Finnish base profile for the Appointment resource. 

### Scope and Usage

This implementation guide does not profile scheduling related resources.

However, references to [Appointment](), [Schedule](), and [Slot]() resources are included here in order to draw the readers attention to another implementation guide published by HL7 Finland:

* [Finnish Scheduling](https://hl7.fi/fhir/finnish-scheduling/)

In addition to implementation guides published by HL7 Finland, there is also ongoing work on FHIR APIs for scheduling in the national Kanta system.

Do note also the older implementation guides by HL7 Finland:

* [Finnish Appointment](https://simplifier.net/finnishappointment/)
* [Finnish Scheduling](https://simplifier.net/finnishschedulingr4/)

The contents of both of these older implementation guides are now considered outdated.

The concepts and resources have been used, most notably by [Omaolo](https://www.omaolo.fi) symptom assessment services, [Palveluohjain](https://www.cgi.com/fi/fi/tuoteratkaisut/sahkoinen-asiointialusta) service (previously known *ajanvaraus ja palveluohjain -sovellus* AVPH) scheduling service, and the scheduling API of the [OMNI360](https://www.cgi.com/fi/fi/tuoteratkaisut/omni360) electronic health record system.

Implementers should read these implementation guides with caution and verify the latest state of the art from their customers or from vendors of real world implementations.

HL7 Finland is currently considering updating the published implementation guides.

**Usages:**

* Refer to this Profile: [FI Base Encounter](StructureDefinition-fi-base-encounter.md) and [FI Base Encounter](https://hl7.fi/fhir/finnish-base-profiles/1.0.0/StructureDefinition-fi-base-encounter.html)
* Examples for this Profile: [Appointment/appointment-general-practitioner](Appointment-appointment-general-practitioner.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.fi.base|current/StructureDefinition/fi-base-appointment)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Appointment](http://hl7.org/fhir/R4/appointment.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Appointment](http://hl7.org/fhir/R4/appointment.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [Fi Base Procedure(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-procedure)](StructureDefinition-fi-base-procedure.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)
* [FI Base Slot(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-slot)](StructureDefinition-fi-base-slot.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)

**Extensions**

This structure refers to these extensions:

* [https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/RestrictionParent](StructureDefinition-RestrictionParent.md)
* [https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/ReleaseDateForPatientViewing](StructureDefinition-ReleaseDateForPatientViewing.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Appointment](http://hl7.org/fhir/R4/appointment.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Appointment](http://hl7.org/fhir/R4/appointment.html) 

**Summary**

**Structures**

This structure refers to these other structures:

* [FI Base Condition(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-condition)](StructureDefinition-fi-base-condition.md)
* [Fi Base Procedure(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-procedure)](StructureDefinition-fi-base-procedure.md)
* [FI Base Observation(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-observation)](StructureDefinition-fi-base-observation.md)
* [FI Base Slot(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-slot)](StructureDefinition-fi-base-slot.md)
* [FI Base Patient(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-patient)](StructureDefinition-fi-base-patient.md)
* [FI Base Practitioner(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner)](StructureDefinition-fi-base-practitioner.md)
* [FI Base PractitionerRole(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-practitioner-role)](StructureDefinition-fi-base-practitioner-role.md)
* [FI Base Location(https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/fi-base-location)](StructureDefinition-fi-base-location.md)

**Extensions**

This structure refers to these extensions:

* [https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/RestrictionParent](StructureDefinition-RestrictionParent.md)
* [https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/ReleaseDateForPatientViewing](StructureDefinition-ReleaseDateForPatientViewing.md)

 

Other representations of profile: [CSV](StructureDefinition-fi-base-appointment.csv), [Excel](StructureDefinition-fi-base-appointment.xlsx), [Schematron](StructureDefinition-fi-base-appointment.sch) 

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

