# Vaccination for TBE - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Vaccination for TBE**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](Immunization-ImmunizationVaccinationExample.xml.md) 
*  [JSON](Immunization-ImmunizationVaccinationExample.json.md) 
*  [TTL](Immunization-ImmunizationVaccinationExample.ttl.md) 

## Example Immunization: Vaccination for TBE

Profile: [Fi Base Immunization](StructureDefinition-fi-base-immunization.md)

**Vaccination Recorder**: [Practitioner Dave Doctor](Practitioner-practitioner-licensed-physician.md)

**identifier**: [URI](http://terminology.hl7.org/5.0.0/NamingSystem-uri.html)/urn:oid:1.3.6.1.4.1.21367.2005.3.7.1234

**status**: Completed

**vaccineCode**: Inaktivoitu puutiaisaivotulehdusrokote (koko virus)

**patient**: [Testi Henkilö Male, DoB: 1990-01-01 ( National Identifier for Finland (use: official, ))](Patient-patient-of-municipality.md)

**encounter**: [Encounter: identifier = urn:oid:1.2.246.10.6794809.14011.2023.200035 (use: official, ); status = in-progress; class = inpatient encounter (ActCode#IMP); period = 2022-02-27 01:03:00+0200 --> (ongoing)](Encounter-id-for-palvelutapahtuma.md)

**occurrence**: 2023-01-10

**primarySource**: false

**location**: [Location Kirurgian poliklinikka](Location-LocationExample.md)

**expirationDate**: 2025-02-15

**site**: OO

**route**: IM

**doseQuantity**: 5 mg(Details: UCUM codemg = 'mg')

### Performers

| | | |
| :--- | :--- | :--- |
| - | **Function** | **Actor** |
| * | Administering Provider | [Practitioner Dave Doctor](Practitioner-practitioner-licensed-physician.md) |

**reasonCode**: Procedure to meet occupational requirement

### ProtocolApplieds

| | | | |
| :--- | :--- | :--- | :--- |
| - | **TargetDisease** | **DoseNumber[x]** | **SeriesDoses[x]** |
| * | TBE | 1 | 3 |

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

