# Patient generated glucose observations and insulin administrations as a bundle, in English - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient generated glucose observations and insulin administrations as a bundle, in English**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](Bundle-diabetes-data-bundle-kantaphr-r4-en.xml.md) 
*  [JSON](Bundle-diabetes-data-bundle-kantaphr-r4-en.json.md) 
*  [TTL](Bundle-diabetes-data-bundle-kantaphr-r4-en.ttl.md) 

## Example Bundle: Patient generated glucose observations and insulin administrations as a bundle, in English

Bundle diabetes-data-bundle-kantaphr-r4-en of type batch

-------

Entry 1 - fullUrl = urn:uuid:4722e3a5-cfc2-46bc-9ba4-a6b3e14a48a2

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 16:39:35
Glucose [Moles/volume] in Body fluid: 7.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cc872afa-7edc-5ff3-9bd6-2b8f890427bb

```

-------

Entry 2 - fullUrl = urn:uuid:d81b0e57-7731-460b-a8ba-36a2e347218b

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 16:44:36
Glucose [Moles/volume] in Body fluid: 7.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:14fd2d60-d534-5a8a-81b9-b053cec5ff61

```

-------

Entry 3 - fullUrl = urn:uuid:ee090a2a-9dca-4de3-82c3-60c823fcd04f

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 16:49:37
Glucose [Moles/volume] in Body fluid: 7.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e7e77de7-227e-5b1c-b60a-6bda9aaf60cf

```

-------

Entry 4 - fullUrl = urn:uuid:a8f7bb5a-5f3a-411d-8955-78da4484e215

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 16:54:35
Glucose [Moles/volume] in Body fluid: 7.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4e0fc3cd-039f-531f-a345-db3951b8aca3

```

-------

Entry 5 - fullUrl = urn:uuid:965a874a-84eb-46c9-b8b1-dbf0103156dc

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 16:59:35
Glucose [Moles/volume] in Body fluid: 7.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cc80e90e-bd3e-5248-85eb-ba272c9df97e

```

-------

Entry 6 - fullUrl = urn:uuid:13be46a0-037f-456e-88b1-5eb3021558c3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:04:35
Glucose [Moles/volume] in Body fluid: 7.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:65e98128-831a-5b95-a130-65fd82763c9c

```

-------

Entry 7 - fullUrl = urn:uuid:9b1dd367-e1c1-436b-8ed2-62a15f252025

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:09:35
Glucose [Moles/volume] in Body fluid: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0546b65e-9b5f-5295-8c77-b4f5d8f12c82

```

-------

Entry 8 - fullUrl = urn:uuid:7014ffd8-802d-4713-92ca-87398ec56790

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:14:35
Glucose [Moles/volume] in Body fluid: 8.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a75f02fe-0142-54de-a738-34d88e755d0e

```

-------

Entry 9 - fullUrl = urn:uuid:f43e2765-ff03-4e8c-9c47-d69926042a8c

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:19:36
Glucose [Moles/volume] in Body fluid: 8.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0c10ed3a-4d62-5f99-956f-c666fb7bf2e2

```

-------

Entry 10 - fullUrl = urn:uuid:2b3c84d8-e821-4468-af9a-bc190114b3f6

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 17:23:17 - 17:28:16
Fast-acting insulin 0.07 IU (0.79 IU/h, 1.13 % = 0.89 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b03ebc59-36fa-5ad8-ab77-abea501a1fbe

```

-------

Entry 11 - fullUrl = urn:uuid:eeae941a-9174-4905-9b6c-8c321d9ed073

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:24:35
Glucose [Moles/volume] in Body fluid: 8.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:69ac5189-31d1-5f25-b958-372743bc59fa

```

-------

Entry 12 - fullUrl = urn:uuid:6546fdc3-4bbd-4cc0-be68-b996fc51c8a9

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 17:28:16 - 17:33:17
Fast-acting insulin 0.07 IU (0.82 IU/h, 1.17 % = 0.95 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:25d008b4-ebcb-5030-a30d-026992e793fc

```

-------

Entry 13 - fullUrl = urn:uuid:42486d03-bf0a-4230-899a-5b65c41f70ad

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:29:34
Glucose [Moles/volume] in Body fluid: 9.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:16cd6b76-affd-580d-a886-779167a4c7ae

```

-------

Entry 14 - fullUrl = urn:uuid:bbffa86d-824f-45a7-9285-b4b2bde6f5ec

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 17:33:17 - 17:38:18
Fast-acting insulin 0.16 IU (1.94 IU/h, 2.77 % = 5.37 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e1aa15b5-a6d9-5514-a4e6-4a75162f7276

```

-------

Entry 15 - fullUrl = urn:uuid:c6b52756-a10e-432a-ad8a-a452de0deb3e

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 17:33:53
Fast-acting insulin 1.26 IU

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:be0460a0-2ed1-52c8-8915-ff4b59f01728

```

-------

Entry 16 - fullUrl = urn:uuid:d610fce2-7a83-46a1-ac70-9e35d51099ed

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:34:35
Glucose [Moles/volume] in Body fluid: 9.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b915ce00-3f1d-5eea-872a-ed7db40422c8

```

-------

Entry 17 - fullUrl = urn:uuid:bcce2119-a8d4-425c-9b4d-c130a3dc4b2b

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 17:38:18 - 18:21:18
Fast-acting insulin 0.50 IU (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:622f2cb4-e78b-502d-a7cc-80ccaf67eb73

```

-------

Entry 18 - fullUrl = urn:uuid:dc8744ba-919b-49cf-821b-7b6961e77786

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:39:34
Glucose [Moles/volume] in Body fluid: 9.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6cb25538-02ce-5d57-91d7-0fabcbdaffc2

```

-------

Entry 19 - fullUrl = urn:uuid:346c0d11-b121-4024-a98e-06bb697b05b3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:44:37
Glucose [Moles/volume] in Body fluid: 9.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e794302f-f23c-5b3b-93fe-f724ab74cab6

```

-------

Entry 20 - fullUrl = urn:uuid:a3deeec5-42fb-4222-9c53-041aa5437b4e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:49:37
Glucose [Moles/volume] in Body fluid: 10.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:53790f00-792e-5943-98cc-77eddfd9af36

```

-------

Entry 21 - fullUrl = urn:uuid:3fa1d0c8-70d5-4721-ab50-11f7a6a73290

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:54:36
Glucose [Moles/volume] in Body fluid: 10.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a6eb9a3f-9f03-5c29-ac98-ee7d410ebbe6

```

-------

Entry 22 - fullUrl = urn:uuid:5d430797-0013-414a-9c59-899977b66b33

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 17:59:35
Glucose [Moles/volume] in Body fluid: 10.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4e8c83a6-11a8-57fa-90f4-8f3528d52043

```

-------

Entry 23 - fullUrl = urn:uuid:28c07242-09ec-417b-9940-d798c0112ed3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:04:36
Glucose [Moles/volume] in Body fluid: 10.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0e883d1f-743a-58d6-ac63-a6978c6889dd

```

-------

Entry 24 - fullUrl = urn:uuid:7f977137-3c3e-4598-908d-fb6fd8c8e00b

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:09:36
Glucose [Moles/volume] in Body fluid: 10.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a6f1e9f3-a982-5afa-b016-86fc20a14704

```

-------

Entry 25 - fullUrl = urn:uuid:497b4071-a0af-40c4-ab8d-b5501ec83fbe

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:14:36
Glucose [Moles/volume] in Body fluid: 10.93 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f44d2664-f36b-57dd-afbb-c37e3e7f3975

```

-------

Entry 26 - fullUrl = urn:uuid:9b7c4166-3f5c-4eba-b0b9-c77516883153

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:19:36
Glucose [Moles/volume] in Body fluid: 11.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:46f6c33c-f878-537e-98ab-6fbdbe4cb952

```

-------

Entry 27 - fullUrl = urn:uuid:60fb3801-dcd6-44ad-8bf5-750b8094da43

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 18:21:18 - 18:26:17
Fast-acting insulin 0.06 IU (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5b1f8e3d-8511-537a-abb4-99e700368cf8

```

-------

Entry 28 - fullUrl = urn:uuid:f5688eed-62b0-40ee-ab77-79282c0df567

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:24:36
Glucose [Moles/volume] in Body fluid: 10.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:99cc6d8b-f017-5554-ad94-b1f275c55acf

```

-------

Entry 29 - fullUrl = urn:uuid:b745d244-699a-4770-ab8a-6c157f400408

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 18:26:17 - 18:28:26
Fast-acting insulin 0.03 IU (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:20b9e2cb-0514-5428-9b2b-d850c851bb54

```

-------

Entry 30 - fullUrl = urn:uuid:2e118ae9-a0fb-453e-9aa8-b00db169a8b9

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 18:28:26 - 18:33:28
Fast-acting insulin 0.13 IU (1.59 IU/h, 2.27 % = 3.62 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8ebfeb1c-9e71-5e46-8cd0-2a3ac81649af

```

-------

Entry 31 - fullUrl = urn:uuid:67d28e09-c1f4-4035-b4a9-1e3f9ad6f9f3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:29:36
Glucose [Moles/volume] in Body fluid: 10.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2fca3b82-4386-56b7-9937-c3904c78910e

```

-------

Entry 32 - fullUrl = urn:uuid:216ab8af-4963-4c80-801f-ed99e1c9ab54

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 18:33:28 - 18:58:32
Fast-acting insulin 0.29 IU (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1149ec01-d973-5450-b814-d7f919fae2e3

```

-------

Entry 33 - fullUrl = urn:uuid:fe7172d1-46b4-4c01-8eab-8fea53849b1a

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:34:34
Glucose [Moles/volume] in Body fluid: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:df9fed36-26df-5ac5-925f-7869a63af41e

```

-------

Entry 34 - fullUrl = urn:uuid:19f79134-a9ea-4cf2-a877-c630e5f572b3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:39:34
Glucose [Moles/volume] in Body fluid: 9.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0d457f0e-cd7d-59ee-986b-39997b3b1229

```

-------

Entry 35 - fullUrl = urn:uuid:43edb575-006e-4ae2-9816-2face25882ef

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:44:34
Glucose [Moles/volume] in Body fluid: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4792c66a-bc06-5c2b-800a-25255e892262

```

-------

Entry 36 - fullUrl = urn:uuid:fa6953cd-0e97-407a-b625-c4c08960cf14

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:49:37
Glucose [Moles/volume] in Body fluid: 9.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f18740e4-bea3-5f98-996b-1e76d6a81e85

```

-------

Entry 37 - fullUrl = urn:uuid:a257df1e-0df8-4aa1-a640-54e0e5a5ffbe

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:54:34
Glucose [Moles/volume] in Body fluid: 9.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:608ee10a-e614-5ea8-9672-a6b4922846c4

```

-------

Entry 38 - fullUrl = urn:uuid:3559a269-6226-4178-809c-0a8b7119eef4

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 18:58:32 - 19:03:33
Fast-acting insulin 0.07 IU (0.85 IU/h, 1.22 % = 1.04 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cb7e673f-321f-57a5-ab3b-3bd88ab970d1

```

-------

Entry 39 - fullUrl = urn:uuid:9f8bcf8a-6202-4efb-871d-21d9051fc87d

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 18:59:34
Glucose [Moles/volume] in Body fluid: 9.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0dbe7271-281f-58d5-92c7-d8e670558886

```

-------

Entry 40 - fullUrl = urn:uuid:de7b990c-aa19-4fc1-9f98-0ef05f6abb98

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:03:33 - 19:08:33
Fast-acting insulin 0.07 IU (0.78 IU/h, 1.12 % = 0.87 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6d04a224-dbbd-588d-97b3-a321ed856322

```

-------

Entry 41 - fullUrl = urn:uuid:7ac88782-1dce-46b4-8c0a-3b535bd9b46e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:04:34
Glucose [Moles/volume] in Body fluid: 9.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:12f561d3-59ea-5656-913e-f38c30976bc2

```

-------

Entry 42 - fullUrl = urn:uuid:fe54fc42-216e-48ee-bd97-c6a6f6599e60

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:08:33 - 19:13:35
Fast-acting insulin 0.07 IU (0.89 IU/h, 1.27 % = 1.13 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f5b5024a-8174-599d-addf-ffb1c88efddf

```

-------

Entry 43 - fullUrl = urn:uuid:7d611284-685f-4928-812b-21f72dc972ea

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:09:34
Glucose [Moles/volume] in Body fluid: 10.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:157f6d53-47a0-5635-8f71-6769b0f80ac2

```

-------

Entry 44 - fullUrl = urn:uuid:ab64e91e-4352-44c1-b61f-53ceaf5299a8

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:13:35 - 19:18:35
Fast-acting insulin 0.11 IU (1.31 IU/h, 1.87 % = 2.44 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:944f1aa4-411b-5df5-8b96-c43ed1917292

```

-------

Entry 45 - fullUrl = urn:uuid:1ad2efef-74e4-4c80-874d-6578d2caf190

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:13:48
Fast-acting insulin 1.07 IU

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3bf76f75-4801-5e9a-bdf4-91039185cafc

```

-------

Entry 46 - fullUrl = urn:uuid:a7ee2864-0733-4446-aef5-34086eb17c5b

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:14:34
Glucose [Moles/volume] in Body fluid: 10.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e01c34cb-b029-5ca9-91a8-f33288747d54

```

-------

Entry 47 - fullUrl = urn:uuid:4ff0a5f2-7de5-4854-8e83-639082d18982

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:18:35 - 19:28:37
Fast-acting insulin 0.12 IU (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2a9f8b79-087c-5c4e-8ec8-4271bd05cced

```

-------

Entry 48 - fullUrl = urn:uuid:fb5adfb1-81b5-4250-80e1-252219a6f8f4

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:19:34
Glucose [Moles/volume] in Body fluid: 10.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4da741ad-ab6b-55a8-8565-6102e83f1831

```

-------

Entry 49 - fullUrl = urn:uuid:f010ce27-f39a-4afc-b7cf-1cfaf52dc492

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:24:34
Glucose [Moles/volume] in Body fluid: 10.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0634f768-3da9-53dd-b2a2-7fd25b13f5f9

```

-------

Entry 50 - fullUrl = urn:uuid:60aa453a-8052-43e3-b43a-2cd03d082a14

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:28:37 - 19:33:37
Fast-acting insulin 0.09 IU (1.08 IU/h, 1.55 % = 1.67 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5848f34d-7cca-5e0f-8024-20574232f6c8

```

-------

Entry 51 - fullUrl = urn:uuid:419d57d1-a986-4b0c-8746-e65f0fbf91a8

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:29:35
Glucose [Moles/volume] in Body fluid: 10.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c1b2523d-1a51-5810-ae4a-4b1635bb6b15

```

-------

Entry 52 - fullUrl = urn:uuid:b4e55090-51f8-462e-bd96-d781000e52e2

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:33:37 - 19:38:39
Fast-acting insulin 0.07 IU (0.82 IU/h, 1.17 % = 0.96 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5dd0a058-463a-5cd0-bfb7-3e47f9403c17

```

-------

Entry 53 - fullUrl = urn:uuid:cdb4b07f-7094-45a5-968f-a3c1f9ab9a50

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:34:34
Glucose [Moles/volume] in Body fluid: 11.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1d11524f-15d5-5556-b0c7-af1fdec759a2

```

-------

Entry 54 - fullUrl = urn:uuid:697273fc-c2ce-4f5a-8bf2-e624810c322a

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:38:39 - 19:43:39
Fast-acting insulin 0.10 IU (1.18 IU/h, 1.68 % = 1.99 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:98fba491-59a0-5a34-a4ce-21582a005068

```

-------

Entry 55 - fullUrl = urn:uuid:e7c41b3f-b1b3-41ec-8a14-14fcc84e9e86

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:39:34
Glucose [Moles/volume] in Body fluid: 11.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:982f516f-e35d-5533-b8b3-c34616ec69e7

```

-------

Entry 56 - fullUrl = urn:uuid:19dda9e4-25a1-4879-96c0-46a4d64c7879

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:43:39 - 19:48:40
Fast-acting insulin 0.14 IU (1.68 IU/h, 2.40 % = 4.02 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:08f442a4-5720-58bd-a6ea-f11e66e43989

```

-------

Entry 57 - fullUrl = urn:uuid:0c3921cf-03cf-4cd3-88c0-3f291ea58296

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:44:34
Glucose [Moles/volume] in Body fluid: 11.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:93b100bc-153e-5953-b582-29ea5a2b2eec

```

-------

Entry 58 - fullUrl = urn:uuid:ba07c584-3945-450f-adc0-9bcc02fe5133

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:48:40 - 19:53:40
Fast-acting insulin 0.15 IU (1.83 IU/h, 2.62 % = 4.79 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7bc8132e-e7fd-5011-b87e-d82ad814e905

```

-------

Entry 59 - fullUrl = urn:uuid:34d74ae8-2246-46c3-b177-3bf570288ae3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:49:34
Glucose [Moles/volume] in Body fluid: 11.82 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:03ce1aba-52dc-5bc3-899d-918dc3e13e12

```

-------

Entry 60 - fullUrl = urn:uuid:1740d9a9-10b4-4ec4-b369-e8d8e709a7f6

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:53:40 - 19:58:41
Fast-acting insulin 0.15 IU (1.76 IU/h, 2.51 % = 4.41 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4947bc7b-ed02-5426-8d4c-a2d035f3ebfc

```

-------

Entry 61 - fullUrl = urn:uuid:c6118abd-4d37-4051-bc2a-90c2255a866e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:54:34
Glucose [Moles/volume] in Body fluid: 11.93 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:076bb5d8-a33f-5cc8-be9b-d0902ddddd70

```

-------

Entry 62 - fullUrl = urn:uuid:16996ec5-ccb1-4bfb-9fd4-0097b58020fa

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 19:58:41 - 20:03:43
Fast-acting insulin 0.14 IU (1.70 IU/h, 2.43 % = 4.12 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a2ce4ac4-f608-5184-a9f8-aac490202080

```

-------

Entry 63 - fullUrl = urn:uuid:dc14c7f8-7cd3-4488-bdd7-dbf94c9c3f38

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 19:59:34
Glucose [Moles/volume] in Body fluid: 12.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3bb620c9-487a-596c-9547-ae724115926a

```

-------

Entry 64 - fullUrl = urn:uuid:3f14f2a2-593c-487a-90c8-8ab1750a3f42

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 20:03:43 - 20:08:44
Fast-acting insulin 0.14 IU (1.73 IU/h, 2.47 % = 4.28 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7628f5fa-5c15-5fd2-b20c-f2a830d04f07

```

-------

Entry 65 - fullUrl = urn:uuid:0d836575-452b-4c39-9756-1c9d531d1763

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:04:34
Glucose [Moles/volume] in Body fluid: 12.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:433129a6-83e4-587a-b2ef-b9ee52d94ec4

```

-------

Entry 66 - fullUrl = urn:uuid:fbbdefc2-38ea-4c4d-a074-6d13571933ae

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 20:08:44 - 20:13:43
Fast-acting insulin 0.16 IU (1.94 IU/h, 2.77 % = 5.38 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a86f73ed-5f71-5e59-b831-ccc0a2c10e44

```

-------

Entry 67 - fullUrl = urn:uuid:93d9820a-107f-4296-aa3f-f4bb38e60ac1

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:09:34
Glucose [Moles/volume] in Body fluid: 12.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dbd8ed12-1072-5ce5-9577-b86dfbf91f3a

```

-------

Entry 68 - fullUrl = urn:uuid:2ed68d33-800e-4615-ba8d-b32e32e6edc7

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 20:13:43 - 20:18:46
Fast-acting insulin 0.18 IU (2.16 IU/h, 3.09 % = 6.67 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4d2172b6-39db-55d0-86e9-e3641a0ab2c8

```

-------

Entry 69 - fullUrl = urn:uuid:85ee928f-9893-4bcf-83b2-441ded373ef7

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:14:34
Glucose [Moles/volume] in Body fluid: 12.54 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a2867555-be6c-5b98-a978-cd32bae3da30

```

-------

Entry 70 - fullUrl = urn:uuid:d077883f-e409-4076-9cc6-a2f18e91320d

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 20:18:46 - 20:23:46
Fast-acting insulin 0.19 IU (2.33 IU/h, 3.33 % = 7.74 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cb8860ad-3776-5438-a1fb-253344010759

```

-------

Entry 71 - fullUrl = urn:uuid:863a39da-b63b-433e-a95f-48e4b2fa52dc

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 20:19:00
Fast-acting insulin 1.37 IU

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9eed4f67-eaff-5184-817b-5000cd303667

```

-------

Entry 72 - fullUrl = urn:uuid:66276afc-8f7c-49dd-98e3-940006299af2

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:19:34
Glucose [Moles/volume] in Body fluid: 12.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:559cca1d-b448-527e-b986-9217804b4167

```

-------

Entry 73 - fullUrl = urn:uuid:7cdb9bf8-a08c-495a-bcd9-fd1f16bf6ddc

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 20:23:46 - 22:09:02
Fast-acting insulin 1.23 IU (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f658fb6c-3bba-54b8-bf6b-a143bc9ceec6

```

-------

Entry 74 - fullUrl = urn:uuid:6701c4be-6946-4533-ae85-8e5782bf2701

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:24:35
Glucose [Moles/volume] in Body fluid: 12.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:352da330-38df-5458-8f7a-2d66b66305cf

```

-------

Entry 75 - fullUrl = urn:uuid:dcb789b1-883c-4bab-a716-77ae93bb9360

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:29:35
Glucose [Moles/volume] in Body fluid: 12.54 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d5213bde-1db0-5043-a985-7dfcfde92f82

```

-------

Entry 76 - fullUrl = urn:uuid:968b8e9d-c458-4fc3-afed-09a275bab496

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:34:34
Glucose [Moles/volume] in Body fluid: 12.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d9e9fbf2-46d4-518b-a748-81ee9713bffc

```

-------

Entry 77 - fullUrl = urn:uuid:902c4034-a7e4-483c-8bbf-11eb45b52a12

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:39:34
Glucose [Moles/volume] in Body fluid: 11.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:49e1baae-878e-58d3-be5b-875d2aafa928

```

-------

Entry 78 - fullUrl = urn:uuid:8e114d28-ce3c-4896-96e7-2a5dd299e1ec

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:44:34
Glucose [Moles/volume] in Body fluid: 11.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8d059e4c-bce1-5d96-b7ad-2739b8f1d6e7

```

-------

Entry 79 - fullUrl = urn:uuid:3c44e022-5738-4a11-8a20-e67dedebd1fa

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:49:34
Glucose [Moles/volume] in Body fluid: 11.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2c940a56-9b2c-566f-bf84-8348f171be69

```

-------

Entry 80 - fullUrl = urn:uuid:81fa473a-729b-4cbe-bab9-1576d1724925

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:54:34
Glucose [Moles/volume] in Body fluid: 11.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1c4bbc10-ef00-5eb5-9b5c-6cb4a74c2044

```

-------

Entry 81 - fullUrl = urn:uuid:344db6e8-2e48-4031-9d49-b8a2d972940e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 20:59:34
Glucose [Moles/volume] in Body fluid: 11.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:57871e54-e18f-5846-be0b-f5867e9e902e

```

-------

Entry 82 - fullUrl = urn:uuid:fcc91ca2-9c7d-4ab1-8770-78a3c154e2d5

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:04:34
Glucose [Moles/volume] in Body fluid: 10.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:893fd0d8-2c91-5e65-bf19-e6aea2c8a7e1

```

-------

Entry 83 - fullUrl = urn:uuid:478a09bd-c676-4a70-9277-fec4fa4835fd

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:09:34
Glucose [Moles/volume] in Body fluid: 10.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a1677af8-3361-58d7-85c8-4a6e859ff7f8

```

-------

Entry 84 - fullUrl = urn:uuid:72007ae5-ab12-4f26-af3a-92e32224f245

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:14:34
Glucose [Moles/volume] in Body fluid: 10.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:89a4ac13-83a3-58b5-93c1-2d0e05a631c8

```

-------

Entry 85 - fullUrl = urn:uuid:32b2bcf6-633e-4844-93b2-6702c4938455

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:19:35
Glucose [Moles/volume] in Body fluid: 10.21 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ca6c2a5a-a11b-562c-8a40-8d01d8521e60

```

-------

Entry 86 - fullUrl = urn:uuid:efa29785-250c-4beb-a1ae-a5ca033b0b5e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:24:34
Glucose [Moles/volume] in Body fluid: 9.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ed4e54e0-4f9d-5451-87ef-a9b288a850f5

```

-------

Entry 87 - fullUrl = urn:uuid:e0eea7cc-ab7e-46cc-bae7-56b6ff80af59

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:29:34
Glucose [Moles/volume] in Body fluid: 9.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f274204e-058a-5726-80fe-44bcaacd8a4d

```

-------

Entry 88 - fullUrl = urn:uuid:2eeaaee4-a1d0-4527-8acc-4c75f372379a

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:34:35
Glucose [Moles/volume] in Body fluid: 9.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4e8e693f-d170-5030-b49a-935d817a9aec

```

-------

Entry 89 - fullUrl = urn:uuid:5193cf97-fae8-497f-8065-a626f5c56be3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:39:34
Glucose [Moles/volume] in Body fluid: 8.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:399f8c15-5ce6-5947-b41a-278385de2244

```

-------

Entry 90 - fullUrl = urn:uuid:5ee8f2f5-7df2-49ee-bccb-b02dfc6c067d

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:44:34
Glucose [Moles/volume] in Body fluid: 8.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c74d6341-9a46-5383-a71c-a8c294a50a60

```

-------

Entry 91 - fullUrl = urn:uuid:26e864f8-4844-480f-9e57-3a2e3a86ed53

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:49:34
Glucose [Moles/volume] in Body fluid: 8.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:6d6b37f4-5af0-561d-b1d9-8a03401db1a6

```

-------

Entry 92 - fullUrl = urn:uuid:202b1cfb-923e-4984-84c4-3fc00f126fd1

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:54:34
Glucose [Moles/volume] in Body fluid: 8.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:acaac317-db2c-53ed-b978-d16762a13283

```

-------

Entry 93 - fullUrl = urn:uuid:72e951f4-2c9d-450f-a2b0-fbd036ac29f7

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 21:59:34
Glucose [Moles/volume] in Body fluid: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0204ecf3-e418-5eae-857d-b07749278733

```

-------

Entry 94 - fullUrl = urn:uuid:e59b9f73-16ed-4b50-bb23-b4370714616e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:04:34
Glucose [Moles/volume] in Body fluid: 7.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7a3f2aa1-ef68-501b-946e-98813f3008a9

```

-------

Entry 95 - fullUrl = urn:uuid:9156c2d0-29f3-4617-86cb-4164e0934d19

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:09:02 - 22:14:03
Fast-acting insulin 0.02 IU (0.18 IU/h, 0.26 % = 0.05 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:13965669-3b13-50ea-9c5d-8cbdb6bd1fb7

```

-------

Entry 96 - fullUrl = urn:uuid:9c1e2d85-90e9-42d6-96d3-b7df05756561

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:09:34
Glucose [Moles/volume] in Body fluid: 6.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5b6471d1-e855-5829-84c6-2eb7ecc39f55

```

-------

Entry 97 - fullUrl = urn:uuid:2eeba870-c87d-4163-9ecb-76969c53926b

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:14:03 - 22:24:05
Fast-acting insulin 0.00 IU (0.00 IU/h, 1.00 % = 0.00 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b10bff63-34c4-51fd-87c4-16f2b84f069f

```

-------

Entry 98 - fullUrl = urn:uuid:7200d914-ad03-4186-91a1-06482ed10544

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:14:34
Glucose [Moles/volume] in Body fluid: 6.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d29f88b7-0ee1-5021-b3fc-44ad10c200c5

```

-------

Entry 99 - fullUrl = urn:uuid:7546e17e-30f7-415d-b90e-0e134f1836dc

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:15:14
Fast-acting insulin 2.50 IU

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e07c3cc1-d4c9-5557-b5c3-84bae6fbe574

```

-------

Entry 100 - fullUrl = urn:uuid:06f2cee3-c538-4ee9-81e5-5d0f6dd7c893

Resource Observation:

> Code: LOINC 9059-7 (Carbohydrate intake Estimated)
Time: 9/4/2021 22:15:14
Carbohydrate intake Estimated: 30 g

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:dcad949c-c4d9-5def-bbbe-5d2a54831eaf

```

-------

Entry 101 - fullUrl = urn:uuid:976c8c2b-4435-4fb4-a478-caff313699d3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:19:34
Glucose [Moles/volume] in Body fluid: 6.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3d08d1f4-f781-536f-931a-70cbc9742db6

```

-------

Entry 102 - fullUrl = urn:uuid:10fadb01-04d2-4727-b9d8-d27f77332144

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:24:05 - 22:29:05
Fast-acting insulin 0.05 IU (0.62 IU/h, 0.88 % = 0.54 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4f9174df-e6d8-5e10-a138-41b68ee44214

```

-------

Entry 103 - fullUrl = urn:uuid:1f57ee90-7bd7-471d-85cd-38bf06df5d30

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:24:34
Glucose [Moles/volume] in Body fluid: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bf73dc9d-73fd-542d-85f5-9935a7a82ef3

```

-------

Entry 104 - fullUrl = urn:uuid:db540c6e-2a3a-4337-9f35-de115ab31b34

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:29:05 - 22:34:06
Fast-acting insulin 0.03 IU (0.32 IU/h, 0.46 % = 0.15 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a1b0bc25-44be-57bc-ab33-1df47e3c4e35

```

-------

Entry 105 - fullUrl = urn:uuid:26cc54b5-47e2-4e34-990e-48e1ee3698f5

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:29:34
Glucose [Moles/volume] in Body fluid: 6.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9513b867-01b1-584b-bd65-6aefede0b032

```

-------

Entry 106 - fullUrl = urn:uuid:4443fdc8-c20e-434b-ad7c-d87c378ecfc5

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:34:06 - 22:39:07
Fast-acting insulin 0.05 IU (0.64 IU/h, 0.91 % = 0.59 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:0aefad90-34fa-59ee-a895-b397743a2d0b

```

-------

Entry 107 - fullUrl = urn:uuid:56cd6110-29f4-4a37-aa0d-83323d765a15

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:34:34
Glucose [Moles/volume] in Body fluid: 6.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ff6f9499-7b60-5e4f-885d-ea5aae66cd9e

```

-------

Entry 108 - fullUrl = urn:uuid:da9b94c7-acab-474f-b4ff-afd28ef432c3

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:39:07 - 22:44:08
Fast-acting insulin 0.06 IU (0.7 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c6bdc52a-5644-517e-9df7-06f3d3969a65

```

-------

Entry 109 - fullUrl = urn:uuid:37a0db7f-96e9-426d-9cce-c66c7a5150ae

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:39:34
Glucose [Moles/volume] in Body fluid: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1a42c8f3-a70c-5305-968f-46654ade4b12

```

-------

Entry 110 - fullUrl = urn:uuid:42c8e450-9f65-4d85-8ad4-88dde613d76f

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:44:08 - 22:49:09
Fast-acting insulin 0.06 IU (0.69 IU/h, 0.98 % = 0.68 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c30d3903-9b75-5011-84c1-f03b1e117b83

```

-------

Entry 111 - fullUrl = urn:uuid:bf0240d5-9f47-425c-8578-ac264ff5d7e5

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:44:34
Glucose [Moles/volume] in Body fluid: 5.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a7cd3390-8224-510e-be33-9c6f1011d151

```

-------

Entry 112 - fullUrl = urn:uuid:f2b31308-11eb-4c31-ae1e-0b4a3f0e29cb

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:49:09 - 22:54:10
Fast-acting insulin 0.02 IU (0.23 IU/h, 0.33 % = 0.07 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:64d05d0a-3679-5a6a-881d-23126e30986e

```

-------

Entry 113 - fullUrl = urn:uuid:11c3765b-d473-4ebe-a255-9127955fa3e3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:49:34
Glucose [Moles/volume] in Body fluid: 5.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4f85cf8e-3bd5-5121-88de-c64beff219c8

```

-------

Entry 114 - fullUrl = urn:uuid:e8d43f66-a264-4a6b-98ba-2127ab7ec837

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:54:10 - 22:59:11
Fast-acting insulin 0.02 IU (0.21 IU/h, 0.31 % = 0.07 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e7560951-5cc0-5b59-8eae-aede9fc4a095

```

-------

Entry 115 - fullUrl = urn:uuid:22c57873-87e1-4e69-a753-2e70143dbb3a

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:54:34
Glucose [Moles/volume] in Body fluid: 5.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d7204b21-086b-55bf-8739-e3dba053b02d

```

-------

Entry 116 - fullUrl = urn:uuid:71a9680e-5403-460b-8bbb-147005899208

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 22:59:11 - 23:04:11
Fast-acting insulin 0.01 IU (0.11 IU/h, 0.16 % = 0.02 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7e51f275-01ea-5fe7-a2a5-dd38d36e32af

```

-------

Entry 117 - fullUrl = urn:uuid:f463aa99-b373-4bc8-820f-e95e3bdf3ce3

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 22:59:34
Glucose [Moles/volume] in Body fluid: 4.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:73646a92-8275-531e-93cf-d6ac463bdb3f

```

-------

Entry 118 - fullUrl = urn:uuid:3253abf3-f70b-4a0c-b3b5-3bb2693b1b04

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 23:04:11 - 23:24:14
Fast-acting insulin 0.00 IU (0.00 IU/h, 1.00 % = 0.00 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3ff92eeb-a7de-5794-a968-3b586ec7246a

```

-------

Entry 119 - fullUrl = urn:uuid:fdeb3caf-1ba7-4924-bfa2-50a2e401632a

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:04:35
Glucose [Moles/volume] in Body fluid: 5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1bb168a2-e92d-5b24-97b6-2e100c0dd6ce

```

-------

Entry 120 - fullUrl = urn:uuid:2fde97ae-e1d0-4c85-bd15-854ea892e2d7

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:09:35
Glucose [Moles/volume] in Body fluid: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4121379b-bf1a-5e98-86e9-02b69b0cfeaa

```

-------

Entry 121 - fullUrl = urn:uuid:3235a14c-25f9-4242-91e7-db68830add61

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:14:35
Glucose [Moles/volume] in Body fluid: 5.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b4de8a64-27f8-5130-8b61-95918f85779e

```

-------

Entry 122 - fullUrl = urn:uuid:af232377-50d6-4abb-a093-33b9fd885c14

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:19:34
Glucose [Moles/volume] in Body fluid: 5.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b269e9f0-b9e3-59cd-ae09-45fd75a4faed

```

-------

Entry 123 - fullUrl = urn:uuid:6ff9d3e6-6bbd-4cb3-a254-ff088f9eb1a2

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 23:24:14 - 23:29:14
Fast-acting insulin 0.01 IU (0.12 IU/h, 0.16 % = 0.02 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:58c5aa90-e992-59b1-bb13-f4f5d3564743

```

-------

Entry 124 - fullUrl = urn:uuid:f8e1f041-67c3-42be-bea3-34ff65be3122

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:24:33
Glucose [Moles/volume] in Body fluid: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0bc2c6d0-6940-5cb2-a2a5-9aebd256f191

```

-------

Entry 125 - fullUrl = urn:uuid:0722a8d9-05d8-44fb-b6ee-b106258d2d71

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 23:29:14 - 23:34:16
Fast-acting insulin 0.01 IU (0.17 IU/h, 0.23 % = 0.04 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:94d6da55-ba0d-56fb-b8ca-e8e1df9fff5f

```

-------

Entry 126 - fullUrl = urn:uuid:1f6c888d-607a-4183-8a07-5c99c5f8393b

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:29:33
Glucose [Moles/volume] in Body fluid: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b71880d6-f3d0-5bc2-8450-a4afd2644a0f

```

-------

Entry 127 - fullUrl = urn:uuid:52c146cf-e283-4b50-ba29-af8691e67d9a

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 23:34:16 - 23:44:17
Fast-acting insulin 0.13 IU (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8ab07008-3638-5c69-bff1-07b7c2fc3521

```

-------

Entry 128 - fullUrl = urn:uuid:b794f973-814a-44c2-8c9f-088714fd9df6

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:34:34
Glucose [Moles/volume] in Body fluid: 5.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c6ff3ef4-fb62-59e6-8a3a-79cd9a864c54

```

-------

Entry 129 - fullUrl = urn:uuid:3d4cf506-55d8-4a68-bdcb-25c0bc8c7bb0

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:39:34
Glucose [Moles/volume] in Body fluid: 5.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:57894ae3-eca3-5321-b611-bda39979ff86

```

-------

Entry 130 - fullUrl = urn:uuid:62324266-7fae-4635-b45b-e04cffe38674

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 23:44:17 - 23:49:18
Fast-acting insulin 0.04 IU (0.51 IU/h, 0.67 % = 0.34 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e8f382e6-52bd-52db-badc-8006c9dc6f70

```

-------

Entry 131 - fullUrl = urn:uuid:384010e9-1555-4d08-9487-c4a0f5120b9e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:44:34
Glucose [Moles/volume] in Body fluid: 5.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2b213b96-e2ed-5c85-b204-fe67f020061f

```

-------

Entry 132 - fullUrl = urn:uuid:e7451e57-f91a-4b11-be42-848e82515d6d

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 23:49:18 - 23:54:20
Fast-acting insulin 0.01 IU (0.13 IU/h, 0.17 % = 0.02 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:dd883a82-6dee-564c-9b07-989dd25dc0aa

```

-------

Entry 133 - fullUrl = urn:uuid:06d841b2-65eb-4555-bb23-4291d4c4b40d

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:49:34
Glucose [Moles/volume] in Body fluid: 5.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1c0b31fa-8b67-588e-bd51-d33b83371fee

```

-------

Entry 134 - fullUrl = urn:uuid:e6a78dfd-191e-4e35-a843-4abba6479a33

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 23:54:20 - 23:59:20
Fast-acting insulin 0.01 IU (0.12 IU/h, 0.15 % = 0.02 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:96f932ba-fdbc-57c7-885c-6390eaca0268

```

-------

Entry 135 - fullUrl = urn:uuid:878bad8d-5bb6-44d8-86e1-d06499227195

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:54:33
Glucose [Moles/volume] in Body fluid: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:512b0c53-d18e-5b90-ac21-7f9c40982869

```

-------

Entry 136 - fullUrl = urn:uuid:513e40b3-a94c-4dc8-8923-014750f9763a

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/4/2021 23:59:20 - 9/5/2021 00:00:00
Fast-acting insulin 0.00 IU (0.13 IU/h, 0.17 % = 0.02 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:dba1608f-03eb-5661-b852-b73cba9c82b5

```

-------

Entry 137 - fullUrl = urn:uuid:b79d1bb0-87f5-4f07-a646-fe996d5f0246

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/4/2021 23:59:33
Glucose [Moles/volume] in Body fluid: 5.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:daed2887-9501-5167-9921-7b8dc02c6e45

```

-------

Entry 138 - fullUrl = urn:uuid:1e11bb7c-86f3-49f9-ac0a-cc7e9a71ea28

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 00:00:00 - 00:02:30
Fast-acting insulin 0.01 IU (0.12600000202655792 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:03b2b99a-4244-54d3-9e87-b793e33a5485

```

-------

Entry 139 - fullUrl = urn:uuid:b67c50dc-504d-4121-9056-a0686c45d585

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 00:02:30 - 00:22:06
Fast-acting insulin 0.00 IU (0 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1e53484b-3f70-555f-b39e-20abcfdd8cfa

```

-------

Entry 140 - fullUrl = urn:uuid:ece7f7e3-0131-42e8-bb93-7e86998bba01

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:04:33
Glucose [Moles/volume] in Body fluid: 4.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c4a5d9c-6511-5ecf-aaac-82e12445dfc4

```

-------

Entry 141 - fullUrl = urn:uuid:169ffc0a-b653-4525-bf36-099a23203405

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:09:33
Glucose [Moles/volume] in Body fluid: 4.5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ce0793a5-cca1-533c-b906-2e4a4929ebb2

```

-------

Entry 142 - fullUrl = urn:uuid:002a7e2f-6c3e-49b8-b4a1-57b5d967d77e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:14:34
Glucose [Moles/volume] in Body fluid: 4.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:652819ce-baed-5909-aba9-99b8f49c8dd6

```

-------

Entry 143 - fullUrl = urn:uuid:8eda02d4-8b00-4610-b74c-3a0d5d9c75b7

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:19:34
Glucose [Moles/volume] in Body fluid: 3.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2d5b397c-6570-54fb-bf10-5722968c156f

```

-------

Entry 144 - fullUrl = urn:uuid:ef79036b-be66-4209-a079-311008576366

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 00:22:06 - 01:57:19
Fast-acting insulin 0.00 IU (0.00 IU/h, 1.00 % = 0.00 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:71a8c901-5aa7-55f3-b73f-348998b31263

```

-------

Entry 145 - fullUrl = urn:uuid:5830df0d-5c8a-4323-b7f6-17acc1413f97

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:24:34
Glucose [Moles/volume] in Body fluid: 3.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:60eadc85-d5c9-565d-81e6-079fb1a6c6e7

```

-------

Entry 146 - fullUrl = urn:uuid:e4f91810-d07b-4dd9-af82-2578b15dc15a

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:29:33
Glucose [Moles/volume] in Body fluid: 2.78 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3ab36540-6136-528b-9492-66242abcbbfa

```

-------

Entry 147 - fullUrl = urn:uuid:2fda7601-5fb7-444d-abbb-6b250ce8dcaf

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:34:33
Glucose [Moles/volume] in Body fluid: 2.89 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:224568b1-1961-5a00-9448-f11839de0f30

```

-------

Entry 148 - fullUrl = urn:uuid:81398e54-e2eb-4831-a83a-6ed7acbf26ca

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:39:33
Glucose [Moles/volume] in Body fluid: 3.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:194755aa-b4f0-5dfd-b064-3a02c882d8ff

```

-------

Entry 149 - fullUrl = urn:uuid:8872ebaa-34da-4fc8-9467-99a95bf26f6e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:44:33
Glucose [Moles/volume] in Body fluid: 3.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:56160a1a-26c1-5552-b98c-a6bf7bee2b50

```

-------

Entry 150 - fullUrl = urn:uuid:44d92cad-f65a-47c7-ad49-5a4569cc3788

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:49:33
Glucose [Moles/volume] in Body fluid: 3.39 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:73811c85-2727-5182-8864-8cf566762c0a

```

-------

Entry 151 - fullUrl = urn:uuid:c628cdfc-3e1c-4c77-8cf8-a3e836d24640

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:54:33
Glucose [Moles/volume] in Body fluid: 3.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:83043aed-bb76-5c88-9595-9173ea049241

```

-------

Entry 152 - fullUrl = urn:uuid:651ae3d5-1bb0-437c-a718-bdfe2a70a775

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 00:59:33
Glucose [Moles/volume] in Body fluid: 3.5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a6ed35df-c0e2-5f83-9139-92ee94eec996

```

-------

Entry 153 - fullUrl = urn:uuid:66b22184-9575-46ce-b9ec-1e267639a7d8

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:04:33
Glucose [Moles/volume] in Body fluid: 3.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f2ad1776-4a3f-5c34-b1f2-88077958e303

```

-------

Entry 154 - fullUrl = urn:uuid:045c6947-0cf5-43b8-b85d-9dc65cac1105

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:09:33
Glucose [Moles/volume] in Body fluid: 3.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c5d7ac3c-05ea-5966-bf37-193b566cfe66

```

-------

Entry 155 - fullUrl = urn:uuid:25e06b8a-3ea7-4fb0-af10-2ebe6ed93223

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:14:33
Glucose [Moles/volume] in Body fluid: 3.89 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:222e7cf1-8cbe-5ddf-88ee-a07e2fbfce3c

```

-------

Entry 156 - fullUrl = urn:uuid:d3917652-ea69-463b-bf1d-21f7cee68730

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:19:33
Glucose [Moles/volume] in Body fluid: 3.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:934b9db3-ef24-522f-bd7f-5950bd689809

```

-------

Entry 157 - fullUrl = urn:uuid:5d862a97-2b16-4a78-be36-608e7c6f63f6

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:24:33
Glucose [Moles/volume] in Body fluid: 3.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9425df38-ad70-55e6-aaf3-5e15974db11f

```

-------

Entry 158 - fullUrl = urn:uuid:af0294a3-995b-4b62-aa95-6d804a2ebd91

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:29:33
Glucose [Moles/volume] in Body fluid: 3.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:90581da4-cef1-549d-9b47-0af1f68504d1

```

-------

Entry 159 - fullUrl = urn:uuid:af3eb92f-09ee-45f0-b37e-320e484dc2b8

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:34:33
Glucose [Moles/volume] in Body fluid: 3.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a2863396-d2fb-5393-8778-052cacdca860

```

-------

Entry 160 - fullUrl = urn:uuid:88d29c32-139b-4d44-b052-9cf16fafab6e

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:39:33
Glucose [Moles/volume] in Body fluid: 3.89 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ba8966aa-b163-5cb8-941b-903f479f7a5c

```

-------

Entry 161 - fullUrl = urn:uuid:1a4beb0f-7c59-4c2e-b3ce-a70f0764b98d

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:44:33
Glucose [Moles/volume] in Body fluid: 4 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a849f883-bda2-5c5f-af6c-196086dd9d72

```

-------

Entry 162 - fullUrl = urn:uuid:1c8dc273-785e-47c9-9ad3-66c686b659e7

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:49:33
Glucose [Moles/volume] in Body fluid: 4.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:adf525b2-d779-5d79-a1a6-cb5c3b8e04ea

```

-------

Entry 163 - fullUrl = urn:uuid:045c2159-80f7-4251-9720-16a5a01ca46f

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:54:33
Glucose [Moles/volume] in Body fluid: 4.39 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:92d98712-5707-5a52-8560-8a110f9d590d

```

-------

Entry 164 - fullUrl = urn:uuid:76f29725-42a6-4bff-bf77-b5e7016f82ad

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 01:57:19 - 02:02:20
Fast-acting insulin 0.02 IU (0.19 IU/h, 0.25 % = 0.05 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:624ced63-1b8e-5baf-87e4-e9c3808eb500

```

-------

Entry 165 - fullUrl = urn:uuid:888eb56f-f9a8-45ce-be5b-50f3a0625200

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 01:59:33
Glucose [Moles/volume] in Body fluid: 4.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2daff562-e43e-5c93-9cb3-ec64234ac386

```

-------

Entry 166 - fullUrl = urn:uuid:0ea802fe-4204-4a34-bd55-0b1573bb71c4

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:02:20 - 02:07:21
Fast-acting insulin 0.02 IU (0.28 IU/h, 0.38 % = 0.11 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:59b3c9c6-7e9b-57bf-b755-12d3fde9fd2b

```

-------

Entry 167 - fullUrl = urn:uuid:0f1242bd-6bb3-45b5-8739-bd072d7f97d6

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:04:33
Glucose [Moles/volume] in Body fluid: 4.5 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:777e8f3f-8ab9-555b-81a5-02dcc197bc94

```

-------

Entry 168 - fullUrl = urn:uuid:f66961e0-7508-4448-9e68-9b645e577402

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:07:21 - 02:12:22
Fast-acting insulin 0.01 IU (0.16 IU/h, 0.22 % = 0.04 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:ea31d397-b4ed-5d7c-bf84-2aeecee2d6b9

```

-------

Entry 169 - fullUrl = urn:uuid:46031fc2-c60c-48b5-bcb5-230a4b1cebe5

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:09:35
Glucose [Moles/volume] in Body fluid: 4.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:ab633135-0024-59d2-a30f-7078badaaeb1

```

-------

Entry 170 - fullUrl = urn:uuid:7affc777-1684-4d10-a88c-c485190ff4a5

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:12:22 - 02:27:23
Fast-acting insulin 0.00 IU (0.00 IU/h, 1.00 % = 0.00 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:98e14395-e31b-5908-8f77-d90d8a871204

```

-------

Entry 171 - fullUrl = urn:uuid:01f1ef0c-8117-4434-901a-15b4edda0444

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:14:33
Glucose [Moles/volume] in Body fluid: 4.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a210866e-f9b4-5c92-9bb5-7dc244ddb658

```

-------

Entry 172 - fullUrl = urn:uuid:6f68c955-5cc5-4eb1-8b92-69b09f9a9149

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:19:33
Glucose [Moles/volume] in Body fluid: 4.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e2db2bfe-437b-5af3-ae9f-0f22bbe3c1f2

```

-------

Entry 173 - fullUrl = urn:uuid:5d592062-07fe-45a8-9b61-ebcdab2be24f

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:24:33
Glucose [Moles/volume] in Body fluid: 4.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:862cec0b-dca7-5b03-ad4e-eb6bb3bc85ed

```

-------

Entry 174 - fullUrl = urn:uuid:2507ded4-77b1-436e-81de-61d469d37c56

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:27:23 - 02:32:24
Fast-acting insulin 0.03 IU (0.33 IU/h, 0.44 % = 0.14 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2c4122ce-4863-5fd6-a29e-8aebf4cb3074

```

-------

Entry 175 - fullUrl = urn:uuid:235b7f0b-3922-4016-b561-6df731dfe533

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:29:40
Glucose [Moles/volume] in Body fluid: 4.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:af98d7fe-879b-510e-a889-6574c7ac5d0f

```

-------

Entry 176 - fullUrl = urn:uuid:5a61fb8f-40f6-4cfe-915a-38696eb3ab68

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:32:24 - 02:37:24
Fast-acting insulin 0.03 IU (0.33 IU/h, 0.44 % = 0.14 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:208ef0df-1feb-5f05-af2a-6c8decaa43d4

```

-------

Entry 177 - fullUrl = urn:uuid:b936d695-c59d-4c13-975d-be343d308883

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:34:40
Glucose [Moles/volume] in Body fluid: 5.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:864a5b4e-7b72-5201-8672-c14ff48d7c4f

```

-------

Entry 178 - fullUrl = urn:uuid:8492f2b7-97f2-4289-99d5-369b67b0f960

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:37:24 - 02:42:25
Fast-acting insulin 0.04 IU (0.46 IU/h, 0.61 % = 0.28 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:70ab8016-7c75-5703-9e71-f7a69b0d6877

```

-------

Entry 179 - fullUrl = urn:uuid:7ee65ea0-85a7-40e9-9c06-88e6ec034e33

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:39:40
Glucose [Moles/volume] in Body fluid: 5.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f5d2c12d-7c69-59df-92c1-b0a15da8c404

```

-------

Entry 180 - fullUrl = urn:uuid:63755953-e488-456d-a334-35946523c342

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:42:25 - 02:47:26
Fast-acting insulin 0.05 IU (0.58 IU/h, 0.77 % = 0.45 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:acf8034e-1249-58d0-a31f-70fcf796cbf3

```

-------

Entry 181 - fullUrl = urn:uuid:7634be5e-18b6-429e-81f3-8ce5f454fc8a

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:44:34
Glucose [Moles/volume] in Body fluid: 5.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2879aa75-bd1c-552c-8705-345b76dac8bf

```

-------

Entry 182 - fullUrl = urn:uuid:8a61b33f-8cfc-4f06-a88f-3c29cbdbf6c2

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:47:26 - 02:52:27
Fast-acting insulin 0.06 IU (0.75 IU/h, 1.00 % = 0.75 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:7772e4b0-9a60-5f81-98ed-52c801f3be45

```

-------

Entry 183 - fullUrl = urn:uuid:98b2a7bf-6ccc-49eb-8d28-8c222616f7bf

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:49:33
Glucose [Moles/volume] in Body fluid: 5.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:053b8987-1c67-53d4-a019-5a3feeb83b5d

```

-------

Entry 184 - fullUrl = urn:uuid:9f36f392-6538-4af3-a2d8-7c294ee06d54

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:52:27 - 02:57:28
Fast-acting insulin 0.06 IU (0.76 IU/h, 1.01 % = 0.76 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:aecfa660-511e-5f1b-be7a-9c40fbd99a08

```

-------

Entry 185 - fullUrl = urn:uuid:1f647e4c-0acd-4bba-aee8-86c48b481093

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:54:33
Glucose [Moles/volume] in Body fluid: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3698ffab-9ae7-5ca7-85c5-b835a30c098b

```

-------

Entry 186 - fullUrl = urn:uuid:01d50f63-bc00-4c4c-a9a0-a5d8b54ea13b

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 02:57:28 - 03:02:29
Fast-acting insulin 0.09 IU (1.06 IU/h, 1.42 % = 1.51 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:60893ca0-1d1e-5819-b245-37a1ea6a2106

```

-------

Entry 187 - fullUrl = urn:uuid:ee0af012-c87e-4181-b62d-3e03abe57941

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 02:59:36
Glucose [Moles/volume] in Body fluid: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2140539b-0df7-598a-bb10-716ceaada348

```

-------

Entry 188 - fullUrl = urn:uuid:e986c54b-bfd0-4c4a-b1e2-ead4e73d6ebe

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:02:29 - 03:07:30
Fast-acting insulin 0.08 IU (1.01 IU/h, 1.35 % = 1.37 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:8335c38d-403c-51b1-9391-12124a4e00e3

```

-------

Entry 189 - fullUrl = urn:uuid:9442ca0e-0d31-40ca-81ed-47391c12b39c

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:04:34
Glucose [Moles/volume] in Body fluid: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f2bc2469-0944-5eae-ad7e-fb06d4dc1f4e

```

-------

Entry 190 - fullUrl = urn:uuid:b4ee7c3a-1b8d-4f75-a3af-23608b48d4e9

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:07:30 - 03:12:31
Fast-acting insulin 0.08 IU (1.00 IU/h, 1.34 % = 1.35 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2325051e-4d0e-50d9-bf18-cbef9d960229

```

-------

Entry 191 - fullUrl = urn:uuid:c347b0c6-6f67-48b3-9915-04a8406e4aec

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:09:34
Glucose [Moles/volume] in Body fluid: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cbb4f192-58a5-57fd-b725-ec9a5512b67d

```

-------

Entry 192 - fullUrl = urn:uuid:6e1eceb0-4b13-441d-8649-07760e410cf0

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:12:31 - 03:17:30
Fast-acting insulin 0.08 IU (0.99 IU/h, 1.33 % = 1.32 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3c3cd9d1-0102-5cc7-b409-7c74b4105d51

```

-------

Entry 193 - fullUrl = urn:uuid:4313ae23-5691-4f9d-b0a6-36fca7f08328

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:14:34
Glucose [Moles/volume] in Body fluid: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4065cf76-532a-5b61-b9cd-1bca726958a6

```

-------

Entry 194 - fullUrl = urn:uuid:d205a301-fa05-4c85-8da7-98c9e002677b

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:17:30 - 03:22:31
Fast-acting insulin 0.10 IU (1.25 IU/h, 1.67 % = 2.09 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:06c7d4f6-68e1-5463-a28f-276ba97280b7

```

-------

Entry 195 - fullUrl = urn:uuid:0696847b-4d45-4722-9fcb-9ff303651768

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:19:36
Glucose [Moles/volume] in Body fluid: 6.66 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:59af106a-3373-5b8f-ab4b-23cad333646b

```

-------

Entry 196 - fullUrl = urn:uuid:afed9f71-fbd1-4bdc-bba6-8900513735e1

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:22:31 - 03:27:31
Fast-acting insulin 0.12 IU (1.50 IU/h, 1.99 % = 2.98 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e9b6ab19-7e16-5d05-941e-1d9fc620f2e6

```

-------

Entry 197 - fullUrl = urn:uuid:3b7c4202-2bab-49e1-91b3-07017d068efe

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:24:34
Glucose [Moles/volume] in Body fluid: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:58a1068b-000f-5801-991b-048925b71c3c

```

-------

Entry 198 - fullUrl = urn:uuid:46e63f92-3a0e-4bbc-961a-489a0d2c324d

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:27:31 - 03:32:33
Fast-acting insulin 0.14 IU (1.66 IU/h, 2.21 % = 3.66 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:72ffd135-c4fa-5874-8c1f-88fa46ce9ed5

```

-------

Entry 199 - fullUrl = urn:uuid:99a5f63c-46b3-4d18-8a12-901ffce62c1c

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:29:33
Glucose [Moles/volume] in Body fluid: 6.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a03d29ce-3391-5fcc-9b93-d13db62ef167

```

-------

Entry 200 - fullUrl = urn:uuid:1da828eb-3570-49bd-ae13-0349e760b886

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:32:33 - 03:37:35
Fast-acting insulin 0.13 IU (1.52 IU/h, 2.03 % = 3.10 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5ee6d0be-8df2-5f45-8358-a46b606a620e

```

-------

Entry 201 - fullUrl = urn:uuid:38169426-d209-4f11-979b-b9ee22d88fbd

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:34:39
Glucose [Moles/volume] in Body fluid: 7.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:94465ea7-6dcc-58b4-ab95-c4f25e611171

```

-------

Entry 202 - fullUrl = urn:uuid:95094e0e-3908-4f6d-bbbc-d9a6f67ac256

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:37:35 - 03:42:34
Fast-acting insulin 0.16 IU (1.95 IU/h, 2.60 % = 5.06 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2efaf501-8181-5657-9d2c-79c5ef689fb1

```

-------

Entry 203 - fullUrl = urn:uuid:e213a05f-7d51-42a5-9580-5e6c06b00d02

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:39:34
Glucose [Moles/volume] in Body fluid: 7.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:556655e1-3505-556d-a850-7b81bab47b18

```

-------

Entry 204 - fullUrl = urn:uuid:e96533a3-b6e4-48d0-ab46-9d06e9d8328f

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:42:34 - 03:47:35
Fast-acting insulin 0.19 IU (2.23 IU/h, 2.98 % = 6.64 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f68ad702-cb7f-585c-9607-68840eeb860c

```

-------

Entry 205 - fullUrl = urn:uuid:4872eb6a-2184-4978-8e16-f51dc41a666d

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:44:36
Glucose [Moles/volume] in Body fluid: 7.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:144ec8a0-8df4-5352-ad82-31f4b24e0fe7

```

-------

Entry 206 - fullUrl = urn:uuid:bb65b2fa-2ba6-4fb8-8a6b-e23cf5705a8b

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:47:35 - 03:52:35
Fast-acting insulin 0.16 IU (1.98 IU/h, 2.64 % = 5.21 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4676df31-287d-564d-905a-8fc0edc784f8

```

-------

Entry 207 - fullUrl = urn:uuid:f03307a3-2b4a-4e34-b6d0-94f511098f63

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:49:33
Glucose [Moles/volume] in Body fluid: 7.6 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:87bf53bb-7786-5401-891e-286c66db091c

```

-------

Entry 208 - fullUrl = urn:uuid:40298eaf-afd8-4f4e-acfa-d355094847e6

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:52:35 - 03:57:38
Fast-acting insulin 0.15 IU (1.76 IU/h, 2.35 % = 4.13 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:70ff2ca3-3dac-5e77-bde7-a302fc7cd89b

```

-------

Entry 209 - fullUrl = urn:uuid:4865e474-f6fc-4548-8cea-74ed360f5052

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:54:33
Glucose [Moles/volume] in Body fluid: 7.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:934f9363-6fa4-5703-9bba-87d4bbfe6244

```

-------

Entry 210 - fullUrl = urn:uuid:d180430a-154a-421d-9e8b-2fe009243016

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 03:57:38 - 04:55:37
Fast-acting insulin 0.72 IU (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bf2941ce-6c8d-54bf-9fcd-0f5a0b584c12

```

-------

Entry 211 - fullUrl = urn:uuid:6ce535cc-0932-403e-8c06-c97f27c93c5d

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 03:59:34
Glucose [Moles/volume] in Body fluid: 7.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1d6f33fa-59ea-55f5-b0a4-f44102720bd2

```

-------

Entry 212 - fullUrl = urn:uuid:d5cdf6f1-5355-4954-aaff-5e4b87749fc5

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:04:33
Glucose [Moles/volume] in Body fluid: 7.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1b731896-62e3-552d-a813-f9564d14044a

```

-------

Entry 213 - fullUrl = urn:uuid:08d6a994-b79a-4855-b993-00e22e99eb9b

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:09:35
Glucose [Moles/volume] in Body fluid: 7.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:aa796ae3-422d-54ce-b47a-003eab6f9b84

```

-------

Entry 214 - fullUrl = urn:uuid:90a48bbb-6982-4040-8bb9-e589954a782f

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:14:35
Glucose [Moles/volume] in Body fluid: 7.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b468e3e3-af9c-56d2-b7c7-d82ca23022c0

```

-------

Entry 215 - fullUrl = urn:uuid:268b74f4-230c-41ab-b9dc-507a0fcb488c

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:19:35
Glucose [Moles/volume] in Body fluid: 7.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b9c5f06c-7a0e-5366-a301-f394715ada8e

```

-------

Entry 216 - fullUrl = urn:uuid:6c78f60b-95d3-403a-883b-49b2ded0bf94

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:24:34
Glucose [Moles/volume] in Body fluid: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:573c167a-4cfb-56ae-bd53-bc29f2d08529

```

-------

Entry 217 - fullUrl = urn:uuid:8fa59498-49ab-458b-a48c-78d7a20ac691

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:29:35
Glucose [Moles/volume] in Body fluid: 6.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:5b845df6-2aa1-5c06-afd4-c39a7e1b77ae

```

-------

Entry 218 - fullUrl = urn:uuid:e8dc08de-584c-42d9-a686-aeec4479946c

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:34:34
Glucose [Moles/volume] in Body fluid: 6.88 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e3c156bb-6c00-5f59-9bd3-f4407b0ec3fd

```

-------

Entry 219 - fullUrl = urn:uuid:b48111ea-c717-4dc1-8c78-d615a6315a88

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:39:33
Glucose [Moles/volume] in Body fluid: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:df7c2bfb-cad1-54a2-8b30-c99828d9f5a9

```

-------

Entry 220 - fullUrl = urn:uuid:1de2911d-61c1-44a8-ae29-574f7b332931

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:44:33
Glucose [Moles/volume] in Body fluid: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:8de3ce69-78c3-52f0-8c78-adc3158193a4

```

-------

Entry 221 - fullUrl = urn:uuid:3dfe7bb2-eb8b-4e63-90c9-14edfa113479

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:49:33
Glucose [Moles/volume] in Body fluid: 6.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c41ab1d3-3dd3-5f9d-8768-5ffbeb3b2214

```

-------

Entry 222 - fullUrl = urn:uuid:d99fb676-40b5-4e3d-85e8-fad7b6ce35e4

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:54:33
Glucose [Moles/volume] in Body fluid: 6.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:096fa8d2-01f8-57f8-8cbb-0e984d85a5e4

```

-------

Entry 223 - fullUrl = urn:uuid:2bf25821-fd27-4bcb-9197-699c76fb221a

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 04:55:37 - 05:00:36
Fast-acting insulin 0.06 IU (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:648394fe-a351-55c4-8b3e-bb692e7348ce

```

-------

Entry 224 - fullUrl = urn:uuid:130e4ae0-7dd5-4b97-8f2b-a0b6061a9725

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 04:59:33
Glucose [Moles/volume] in Body fluid: 6.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:42c61494-e582-50d1-993e-0c385c3658b2

```

-------

Entry 225 - fullUrl = urn:uuid:1f1a5c25-5044-4ecd-9d9e-9d9cec6d0a3e

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:00:36 - 05:02:46
Fast-acting insulin 0.03 IU (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:82d53120-de5b-5c0c-ba4b-3b3b599ae4b2

```

-------

Entry 226 - fullUrl = urn:uuid:493bdc85-f577-4e94-b53b-8d74daebb5a5

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:02:46 - 05:07:47
Fast-acting insulin 0.05 IU (0.65 IU/h, 0.86 % = 0.56 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:460322fb-cd34-581b-a71c-41b0f1830d9a

```

-------

Entry 227 - fullUrl = urn:uuid:62f158dd-4c02-4bc1-a7e3-3ee7c3502046

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:04:33
Glucose [Moles/volume] in Body fluid: 6.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:fc378165-ad09-531f-b7f6-f404e6996079

```

-------

Entry 228 - fullUrl = urn:uuid:140aaa33-98ef-4d32-b509-d445b18766df

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:07:47 - 05:12:48
Fast-acting insulin 0.03 IU (0.35 IU/h, 0.46 % = 0.16 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d76fa174-47fd-5aec-8b25-152b7f5056ca

```

-------

Entry 229 - fullUrl = urn:uuid:6adfc713-ba1c-4475-a75d-432e8dc8c9a7

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:09:33
Glucose [Moles/volume] in Body fluid: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7dd4013a-f680-516e-adcf-867e1731b09a

```

-------

Entry 230 - fullUrl = urn:uuid:585760cb-d281-4005-9477-e86f553c4848

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:12:48 - 05:17:48
Fast-acting insulin 0.05 IU (0.56 IU/h, 0.75 % = 0.42 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3aacb4a7-e590-5356-9a25-d179c24533f4

```

-------

Entry 231 - fullUrl = urn:uuid:3f1e047f-7fcd-4bd9-8252-0026312157e9

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:14:33
Glucose [Moles/volume] in Body fluid: 6.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:c57cafd5-49d5-5868-9ce1-4a85ad88ccb0

```

-------

Entry 232 - fullUrl = urn:uuid:183531fe-2502-4cc8-b0a5-d33df3b12dfa

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:17:48 - 05:22:49
Fast-acting insulin 0.06 IU (0.75 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b016e042-73af-5a32-b114-de091a9720f4

```

-------

Entry 233 - fullUrl = urn:uuid:72d7712e-5699-4471-a23a-438a65f3257d

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:19:33
Glucose [Moles/volume] in Body fluid: 6.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:31bdedb7-20ea-5110-be4c-a9c5c3302bd2

```

-------

Entry 234 - fullUrl = urn:uuid:50d3b42e-9fba-45f3-813f-bba07f0f4b59

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:22:49 - 05:27:50
Fast-acting insulin 0.11 IU (1.36 IU/h, 1.82 % = 2.48 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:e924dcf3-fec9-594f-97d0-82a4fa46d551

```

-------

Entry 235 - fullUrl = urn:uuid:931f2efd-42e8-4ebb-8fe7-1fd613f44e78

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:24:33
Glucose [Moles/volume] in Body fluid: 6.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d340b672-2385-5a5b-8fee-caab2a6d02ae

```

-------

Entry 236 - fullUrl = urn:uuid:d814ef50-c55b-4ca4-b4d7-fb512e6940ba

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:27:50 - 05:32:50
Fast-acting insulin 0.12 IU (1.41 IU/h, 1.88 % = 2.64 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:456a92a0-ac9c-5a7c-a811-dc2ea774cad5

```

-------

Entry 237 - fullUrl = urn:uuid:0c44ecaa-4ddc-4e5f-ac70-c394a8aab0c0

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:29:33
Glucose [Moles/volume] in Body fluid: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d4482a79-0095-5805-81f1-f556e5e835cf

```

-------

Entry 238 - fullUrl = urn:uuid:21507115-15b9-4f77-ba77-e48a3054d864

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:32:50 - 05:37:51
Fast-acting insulin 0.08 IU (0.92 IU/h, 1.08 % = 0.99 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:87952b92-9350-5867-985c-74b167d47f13

```

-------

Entry 239 - fullUrl = urn:uuid:be4bad3d-21bd-4e5a-a0df-7ea6aa19bce2

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:34:33
Glucose [Moles/volume] in Body fluid: 6.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:61a981a4-7717-5dcd-b1be-d47b8a2cbfc6

```

-------

Entry 240 - fullUrl = urn:uuid:79cafb38-0760-4626-93d6-ab342cd90570

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:37:51 - 05:42:52
Fast-acting insulin 0.07 IU (0.85 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:5359e3b7-e7d2-51d5-82c1-a8f41f45c455

```

-------

Entry 241 - fullUrl = urn:uuid:e9b14d26-0ae7-4c60-adeb-535dd9dee0a5

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:39:33
Glucose [Moles/volume] in Body fluid: 6.44 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1a0448e4-56dd-58b3-9a39-d72d39ad5c25

```

-------

Entry 242 - fullUrl = urn:uuid:a087f4d1-6543-464f-a92b-f756f6aac441

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:42:52 - 05:47:52
Fast-acting insulin 0.05 IU (0.55 IU/h, 0.64 % = 0.35 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:d29d53cd-2816-5703-969f-8b86fbe752b2

```

-------

Entry 243 - fullUrl = urn:uuid:31364cad-2884-40f5-89c2-0d5a3f0753b4

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:44:33
Glucose [Moles/volume] in Body fluid: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:d7a3e8a5-d6ef-5d51-b823-511274c58669

```

-------

Entry 244 - fullUrl = urn:uuid:a96742d4-8a8f-4fdd-8cd2-89564cc5c913

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:47:52 - 05:52:53
Fast-acting insulin 0.02 IU (0.30 IU/h, 0.35 % = 0.10 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:1eab6c77-204b-5701-a254-d810a393b875

```

-------

Entry 245 - fullUrl = urn:uuid:c4185cea-6d74-457b-b956-562dcb9ee99a

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:49:33
Glucose [Moles/volume] in Body fluid: 6.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:7daff9ba-922e-58b5-a20f-dfd7ae024f99

```

-------

Entry 246 - fullUrl = urn:uuid:67b282e5-f3c7-4566-9c45-c81b87d6d3bc

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:52:53 - 05:57:54
Fast-acting insulin 0.03 IU (0.34 IU/h, 0.40 % = 0.13 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4c24ff72-8341-5662-93a2-158a5c8e635b

```

-------

Entry 247 - fullUrl = urn:uuid:12712e74-38c1-4634-a5fe-c43c7b97d879

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:54:33
Glucose [Moles/volume] in Body fluid: 6.11 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:80a4d484-1383-5f7a-8e3a-f1ea02f34ed0

```

-------

Entry 248 - fullUrl = urn:uuid:aeba1747-6d89-49ac-ba03-b91ff575ba41

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 05:57:54 - 06:02:54
Fast-acting insulin 0.03 IU (0.36 IU/h, 0.42 % = 0.15 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:67408a79-a462-56f3-b84f-4224c7d7be5d

```

-------

Entry 249 - fullUrl = urn:uuid:45f71bf5-0f90-4c64-91d1-ec2ffd7307c5

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 05:59:33
Glucose [Moles/volume] in Body fluid: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:b8eae3d0-3b22-5287-abc4-0089cca7fc6e

```

-------

Entry 250 - fullUrl = urn:uuid:4ef7e2ba-ff7b-4731-be44-2fb27fafab21

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:02:54 - 06:07:55
Fast-acting insulin 0.02 IU (0.28 IU/h, 0.33 % = 0.09 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:97eb143b-cebb-57e6-8520-f53ef325ff83

```

-------

Entry 251 - fullUrl = urn:uuid:a239fdad-4a14-4b11-840c-bb01850f9823

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:04:33
Glucose [Moles/volume] in Body fluid: 5.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:847d176a-aaa4-5466-9222-508ed7051bcf

```

-------

Entry 252 - fullUrl = urn:uuid:815da391-e785-4932-b28e-1deabc0c0d4a

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:07:55 - 06:12:56
Fast-acting insulin 0.02 IU (0.20 IU/h, 0.23 % = 0.05 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:188b548e-8386-52e7-8675-8ea1c3892bb8

```

-------

Entry 253 - fullUrl = urn:uuid:f2e88ab0-ed35-48e2-bb9d-4c1b8434651a

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:09:34
Glucose [Moles/volume] in Body fluid: 5.38 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:304da3d3-f42c-5820-a07a-4fac1e77aaf3

```

-------

Entry 254 - fullUrl = urn:uuid:486c81a5-6a54-4bc0-b233-0c1ce77994ca

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:12:56 - 06:17:58
Fast-acting insulin 0.00 IU (0.00 IU/h, 1.00 % = 0.00 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:18afbb4f-f83c-5126-bed2-6dcd906044a0

```

-------

Entry 255 - fullUrl = urn:uuid:108bd6e4-a564-40b3-b53d-bffdccd00264

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:14:33
Glucose [Moles/volume] in Body fluid: 5.72 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:1603c869-56ca-58ea-bcbc-06e506af321d

```

-------

Entry 256 - fullUrl = urn:uuid:3a16b7ff-a57d-4618-81aa-786fee79a7db

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:17:58 - 06:22:57
Fast-acting insulin 0.02 IU (0.28 IU/h, 0.32 % = 0.09 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:a93b8336-c0dc-5179-874a-ec07f33719ca

```

-------

Entry 257 - fullUrl = urn:uuid:bb5b39d5-4e75-4926-86e9-b077cedeca79

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:19:34
Glucose [Moles/volume] in Body fluid: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0b9ffb22-4bae-5faf-81d0-3404ac0d54aa

```

-------

Entry 258 - fullUrl = urn:uuid:daea00fd-f98a-4ccb-99d6-45ce3a5036d9

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:22:57 - 06:27:57
Fast-acting insulin 0.11 IU (1.26 IU/h, 1.48 % = 1.87 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:07c63c2b-b982-53fa-a2be-936b1def06e2

```

-------

Entry 259 - fullUrl = urn:uuid:56287a7a-90b2-4c83-be7e-3f8911db2428

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:24:37
Glucose [Moles/volume] in Body fluid: 6.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:24a3bbff-378a-59f1-b63d-71b8b908d277

```

-------

Entry 260 - fullUrl = urn:uuid:573df9b7-5420-4480-96fb-b8063bc79b9d

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:27:57 - 06:32:58
Fast-acting insulin 0.14 IU (1.62 IU/h, 1.90 % = 3.08 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4eb22c7a-f8cf-5750-b6ac-0bce495240d2

```

-------

Entry 261 - fullUrl = urn:uuid:9a16cce7-73db-4954-b75d-f1bc33ed31d1

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:29:34
Glucose [Moles/volume] in Body fluid: 6.27 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0cf3f34b-03cd-5167-9a6a-a3f9bc5a19b9

```

-------

Entry 262 - fullUrl = urn:uuid:43a5e3e6-d64f-4851-81b1-dee9ac155af0

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:32:58 - 06:38:00
Fast-acting insulin 0.10 IU (1.14 IU/h, 1.34 % = 1.54 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:cfd0a3cd-5788-59bd-a5f6-aafe89959734

```

-------

Entry 263 - fullUrl = urn:uuid:06e45d2b-6241-42c0-a6de-df197cc0d8e4

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:34:36
Glucose [Moles/volume] in Body fluid: 6.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f06d9ee8-4931-51ca-8198-d79877f550b4

```

-------

Entry 264 - fullUrl = urn:uuid:1f9086de-445b-4b56-8bef-2b64d4246e13

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:38:00 - 06:42:59
Fast-acting insulin 0.07 IU (0.85 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bca6d9ab-9f67-5b75-a027-924d1b7fa891

```

-------

Entry 265 - fullUrl = urn:uuid:3013f94a-ebd9-4ade-8d0e-5be2d912502b

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:39:33
Glucose [Moles/volume] in Body fluid: 5.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2c4368d5-a1b7-5b3c-84e8-fa6da5913d52

```

-------

Entry 266 - fullUrl = urn:uuid:79e3c1f8-3ce5-4844-985a-176480ba6db6

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:42:59 - 06:48:00
Fast-acting insulin 0.02 IU (0.20 IU/h, 0.23 % = 0.05 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:67dd7f64-992f-5c66-973f-6df935776e4c

```

-------

Entry 267 - fullUrl = urn:uuid:fecba9a3-f021-453c-b209-115b9f3984aa

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:44:33
Glucose [Moles/volume] in Body fluid: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:bd9ee6e6-a7e1-5ce2-a441-2e8e67bb071b

```

-------

Entry 268 - fullUrl = urn:uuid:a50eb61b-5f89-4e53-a827-d6f48363e2de

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 06:48:00 - 07:03:02
Fast-acting insulin 0.00 IU (0.00 IU/h, 1.00 % = 0.00 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:474adf39-d55c-574a-baed-c8e32c4bdc5c

```

-------

Entry 269 - fullUrl = urn:uuid:fcd88f43-8cc1-41ab-ba9d-2c06c9ccd2e2

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:49:33
Glucose [Moles/volume] in Body fluid: 5.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:4c48ecd4-2b24-581d-926e-6b75453c9abf

```

-------

Entry 270 - fullUrl = urn:uuid:8e88a619-da50-44ce-9daf-67a6bfb243e8

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:54:33
Glucose [Moles/volume] in Body fluid: 5.61 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:0892409a-9057-51ec-8275-79776a542de1

```

-------

Entry 271 - fullUrl = urn:uuid:0874e3df-0257-42ab-b08a-7e06b4d2ba7d

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 06:59:32
Glucose [Moles/volume] in Body fluid: 5.94 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cb81fe87-e180-53bb-879a-80b93cb799e5

```

-------

Entry 272 - fullUrl = urn:uuid:156ce8a7-78ff-4061-a618-50e026f48e30

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:03:02 - 07:08:03
Fast-acting insulin 0.08 IU (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:6100831d-18a8-5c12-a6a6-314bed44567e

```

-------

Entry 273 - fullUrl = urn:uuid:977d0330-b622-4292-ab18-9ef674a788d2

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:04:33
Glucose [Moles/volume] in Body fluid: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:f9fdd495-8216-5644-82d2-fda692580860

```

-------

Entry 274 - fullUrl = urn:uuid:f3b265cd-f45c-49a7-86d2-a5b8930d5065

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:08:03 - 07:13:04
Fast-acting insulin 0.09 IU (1.12 IU/h, 1.18 % = 1.32 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f90cd7b3-725f-56c6-b7e6-a6f5fb2a0049

```

-------

Entry 275 - fullUrl = urn:uuid:d953dd36-0805-4381-8b49-9d9c8656cabf

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:09:32
Glucose [Moles/volume] in Body fluid: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:91e51d2b-73b3-5f04-ad6b-18f129684c0f

```

-------

Entry 276 - fullUrl = urn:uuid:a27c68c5-31d1-46f5-a0bf-22a85fc296dd

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:13:04 - 07:23:05
Fast-acting insulin 0.16 IU (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:3d00900c-7dda-5d13-9abe-ae05bca75690

```

-------

Entry 277 - fullUrl = urn:uuid:945456c9-728a-4dfa-aa64-f42c11578d72

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:14:32
Glucose [Moles/volume] in Body fluid: 5.99 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3de8a649-9b8f-5407-b036-9a6e0ea1706c

```

-------

Entry 278 - fullUrl = urn:uuid:9d74c2d1-9f80-4b54-8aaa-2ba0ca2c5b88

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:19:32
Glucose [Moles/volume] in Body fluid: 6.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:105bcc8e-e6d7-5645-bbee-e6efa82956a6

```

-------

Entry 279 - fullUrl = urn:uuid:80ad9fd6-2c6f-4c1d-add1-3cd660958f20

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:23:05 - 07:28:06
Fast-acting insulin 0.08 IU (0.95 IU/h, 1.00 % = 0.94 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:9dea2596-e9a4-5a35-ab70-3764d8470a8a

```

-------

Entry 280 - fullUrl = urn:uuid:5e445c4e-ec41-420d-a5b9-dce983168ea0

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:24:33
Glucose [Moles/volume] in Body fluid: 6.16 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:16feb756-4859-5c73-9ac6-8b496b214ec0

```

-------

Entry 281 - fullUrl = urn:uuid:a71669ab-7534-40f4-bb5b-e37064b06c76

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:28:06 - 07:38:08
Fast-acting insulin 0.16 IU (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:fde698fa-96d4-5a48-ae34-f3560365198a

```

-------

Entry 282 - fullUrl = urn:uuid:6f0889b9-dfa5-43b6-a40a-e450ae97dbe1

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:29:33
Glucose [Moles/volume] in Body fluid: 6.49 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:a9ec541d-90ee-515a-845f-6c04ce3a413b

```

-------

Entry 283 - fullUrl = urn:uuid:9219c447-f2a6-4e8a-ade8-ae9a4f850b12

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:34:33
Glucose [Moles/volume] in Body fluid: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:85deff66-c153-529d-996a-ca35b011a5ee

```

-------

Entry 284 - fullUrl = urn:uuid:4e6f9a13-12d3-4fdd-80b2-a55dd5548e0f

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:38:08 - 07:43:07
Fast-acting insulin 0.18 IU (2.21 IU/h, 2.33 % = 5.16 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:2a984952-6623-5307-b4d4-a72d43d04e3d

```

-------

Entry 285 - fullUrl = urn:uuid:bd04bec3-cedd-4be7-83e5-c2e2c614fa10

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:39:32
Glucose [Moles/volume] in Body fluid: 6.83 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:735bb182-d9d9-590b-95ba-472a84848981

```

-------

Entry 286 - fullUrl = urn:uuid:49fc64b8-8ead-4e8f-b3bb-80e7b65b8d8b

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:43:07 - 07:48:08
Fast-acting insulin 0.13 IU (1.60 IU/h, 1.69 % = 2.70 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:bd69e18b-d455-564d-8d8b-35069c569c54

```

-------

Entry 287 - fullUrl = urn:uuid:169a9f42-b02a-41a9-81da-07d51229dd23

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:44:32
Glucose [Moles/volume] in Body fluid: 7.05 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:2cba9154-c867-56b6-8a8a-88b070f1b561

```

-------

Entry 288 - fullUrl = urn:uuid:f6ba477a-7a33-47fa-a371-bc44cdfbc7ee

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:48:08 - 07:53:09
Fast-acting insulin 0.12 IU (1.44 IU/h, 1.51 % = 2.18 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:812f525f-b3e6-5e02-a175-62ea74f5ae9b

```

-------

Entry 289 - fullUrl = urn:uuid:5264ca69-d58e-4a85-a7fb-4bf7c512598b

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:49:33
Glucose [Moles/volume] in Body fluid: 7.22 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:952ae7b3-a9f9-5eb1-98ed-ae6bbd06c402

```

-------

Entry 290 - fullUrl = urn:uuid:b38f107f-1082-489a-8247-402158cfcc04

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:53:09 - 07:58:11
Fast-acting insulin 0.09 IU (1.06 IU/h, 1.11 % = 1.18 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:4be5439b-7042-54d9-af6e-79c16d661c62

```

-------

Entry 291 - fullUrl = urn:uuid:fe3cc780-f34c-4056-93e4-3beeeff43385

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:54:33
Glucose [Moles/volume] in Body fluid: 7.33 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:cbcf862e-484e-5d15-afb2-efdef6d363d4

```

-------

Entry 292 - fullUrl = urn:uuid:b7172a65-3c42-47f9-9d03-28a8e3ab1297

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 07:58:11 - 08:03:11
Fast-acting insulin 0.08 IU (0.95 [iU]/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:aa694749-ab0d-59b4-a7b4-38ace3a62c97

```

-------

Entry 293 - fullUrl = urn:uuid:8a2a8f42-4eeb-4ee4-a477-e7ab053e450b

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 07:59:32
Glucose [Moles/volume] in Body fluid: 7.77 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:3988e0a1-a9d1-5516-8910-db1918835d01

```

-------

Entry 294 - fullUrl = urn:uuid:2384e13c-6371-48db-a5c0-ab5e50bd7fde

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 08:03:11 - 08:08:12
Fast-acting insulin 0.08 IU (0.96 IU/h, 1.01 % = 0.97 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:f3af5585-2a30-53e9-b69b-40ad0060155f

```

-------

Entry 295 - fullUrl = urn:uuid:fb13924f-62bd-45d8-86c8-8840d2c0aa37

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 08:04:32
Glucose [Moles/volume] in Body fluid: 8.1 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:e4b68d14-5107-51fe-a50b-ae84754515bc

```

-------

Entry 296 - fullUrl = urn:uuid:6a17e4c4-4f6f-4653-b8a8-cfa0e047053d

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 08:08:12 - 08:13:13
Fast-acting insulin 0.11 IU (1.36 IU/h, 1.44 % = 1.96 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:c2af22af-b91c-58bf-8730-518022413f5d

```

-------

Entry 297 - fullUrl = urn:uuid:c95aabe0-8ed3-4dbf-90bd-45de78526a44

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 08:09:33
Glucose [Moles/volume] in Body fluid: 8.55 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:eb5136b2-b4a9-5877-bd8e-403c1e4fe94c

```

-------

Entry 298 - fullUrl = urn:uuid:d6416abb-1280-42d2-bbcc-b965c78cd7f2

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 08:13:13 - 08:18:13
Fast-acting insulin 0.16 IU (1.94 IU/h, 2.04 % = 3.95 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:b4f2c938-2a0a-5b53-9996-05895ea17951

```

-------

Entry 299 - fullUrl = urn:uuid:255d1106-6870-4459-b638-59e964badefd

Resource Observation:

> Code: LOINC 14745-4 (Glucose [Moles/volume] in Body fluid)
Time: 9/5/2021 08:14:32
Glucose [Moles/volume] in Body fluid: 8.71 mmol/l

Request:

```
POST Observation/
If-None-Exist = identifier=urn:uuid:9942b1a0-7a95-5dc1-9799-022f2a330758

```

-------

Entry 300 - fullUrl = urn:uuid:03da3864-c9fa-43e3-900d-a7b303210979

Resource MedicationAdministration:

> Type of insulin: Fast-acting insulin
Code: SNOMED 411531001 (Short-acting insulin (substance)), ins-short-fast (Fast-acting insulin), SNOMED 67866001 (Insulin (substance))
Time: 9/5/2021 08:18:13 - 08:23:14
Fast-acting insulin 0.14 IU (1.73 IU/h, 1.82 % = 3.14 IU/h)

Request:

```
POST MedicationAdministration/
If-None-Exist = identifier=urn:uuid:80cf8990-a493-5193-adcc-0eb6c780a1d6

```

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

