# GP appointment - Finnish Base Profiles v2.0.0-ci

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **GP appointment**

Finnish Base Profiles, published by HL7 Finland. This guide is not an authorized publication; it is the continuous build for version 2.0.0-ci built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/fhir-fi/finnish-base-profiles/](https://github.com/fhir-fi/finnish-base-profiles/) and changes regularly. See the [Directory of published versions](https://hl7.fi/fhir/finnish-base-profiles/history.html)

*  [Narrative Content](#) 
*  [XML](Appointment-appointment-general-practitioner.xml.md) 
*  [JSON](Appointment-appointment-general-practitioner.json.md) 
*  [TTL](Appointment-appointment-general-practitioner.ttl.md) 

## Example Appointment: GP appointment

Note that a previous version of this example referred to extensions defined in another implementation guide, the [FinnishScheduling R4](https://simplifier.net/finnishschedulingr4/) IG. That schedulinig IG has since been updated and the canonical urls defined for the extensions have changed from `http://hl7.fi/fhir/StructureDefinition/ServiceEventExt`to [`https://hl7.fi/fhir/finnish-base-profiles/StructureDefinition/service-event`](./StructureDefinition-service-event.md) and from `http://hl7.fi/fhir/StructureDefinition/AppointmentMutabilityExtension` to [`https://hl7.fi/fhir/finnish-scheduling/StructureDefinition/mutable`](https://hl7.fi/fhir/finnish-scheduling/StructureDefinition-mutable.html). Note that the service event extension has been moved to this implementation guide. Also note that the previous URLs do not resolve, the new ones do.

Profile: [FI Base Appointment](StructureDefinition-fi-base-appointment.md)

**ServiceEvent**: urn:oid:1.2.246.10.3575029.10.50.14131.2023.159325

> **Appointment Mutability**
* Cancellable: false
* Reschedulable: false

**status**: Fulfilled

**serviceCategory**: SOTE9.2

**serviceType**: EEA

**appointmentType**: 101

**description**: Kuume

**start**: 2023-01-20 10:00:00+0200

**end**: 2023-01-20 10:20:00+0200

**slot**: [Slot: identifier = 123456789; serviceCategory = Lääkäripalvelut; serviceType = Yleislääkärin palvelu; appointmentType = Kertakäynti toimipaikassa; status = free; start = 2023-01-01 12:00:00+0200; end = 2023-01-01 12:30:00+0200](Slot-FreeSlot.md)

**created**: 2023-01-20 08:45:15+0200

> **participant****actor**:[Testi Henkilö Male, DoB: 1990-01-01 ( National Identifier for Finland (use: official, ))](Patient-patient-of-municipality.md)**required**: Required**status**: Accepted

> **participant****type**:primary performer**actor**:[Practitioner Dave Doctor](Practitioner-practitioner-licensed-physician.md)**required**: Required**status**: Accepted

> **participant****actor**:[Location Kirurgian poliklinikka](Location-LocationExample.md)**status**: Accepted

> **participant****actor**:[HealthcareService Vastaanottoaika*](HealthcareService-healthcareService-example.md)**status**: Accepted

 IG © 2022+ [HL7 Finland](https://www.hl7.fi/). Package hl7.fhir.fi.base#2.0.0-ci based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-05 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](https://hl7.fi/fhir/finnish-base-profiles/history.html)|![](cc0.png)|[Source](https://github.com/fhir-fi/finnish-base-profiles)|[Propose a change](https://github.com/fhir-fi/finnish-base-profiles/issues/new) 

