# C-CDA 3.0.0 Value Set Package Definition - Value Set Packages v0.1.0-cibuild

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **C-CDA 3.0.0 Value Set Package Definition**

## Library: C-CDA 3.0.0 Value Set Package Definition (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/cda/us/ccda-vsp/3.0.0/Library/hl7.fhir.us.ccda-vsp-3-0-0-draft | *Version*:2025-09 |
| Draft as of 2025-09-23 | *Computable Name*:CCDA300ValueSetPackageDefinition |

 
This is a draft version of a Value Set Refresh Package Definition for the Consolidated-CDA 3.0.0 implementation guide. It contains expansions of any value sets defined or used in the C-CDA 3.0.0 implementation guide, but refreshed using the code systems versions specified in the input expansion parameters. 

* Metadata: Title
  * ?: C-CDA 3.0.0 Value Set Package Definition
* Metadata: Version
  * ?: 2025-09
* Metadata: Approval Date
  * ?: 2025-09-23
* Metadata: Last Review Date
  * ?: 2025-09-23
* Metadata: Status
  * ?: Draft
* Metadata: Experimental
  * ?: true
* Metadata: Jurisdiction
  * ?: 001 from[http://unstats.un.org/unsd/methods/m49/m49.htm](http://unstats.un.org/unsd/methods/m49/m49.htm)
* Metadata: Steward (Publisher)
  * ?: Clinical Quality Framework
* Metadata: Description
  * ?: This is a draft version of a Value Set Refresh Package Definition for the Consolidated-CDA 3.0.0 implementation guide. It contains expansions of any value sets defined or used in the C-CDA 3.0.0 implementation guide, but refreshed using the code systems versions specified in the input expansion parameters.
* Metadata: Type
  * ?: asset-collection from[http://terminology.hl7.org/CodeSystem/library-type](http://terminology.hl7.org/6.5.0/CodeSystem-library-type.html)
* Metadata: Component
  * ?: **Resource**:`http://hl7.org/cda/us/ccda/ImplementationGuide/hl7.cda.us.ccda|3.0.0`**Canonical URL**:http://hl7.org/cda/us/ccda/ImplementationGuide/hl7.cda.us.ccda|3.0.0
* Metadata: Parameters
* Metadata: Parameter
  * ?: None
* Metadata: Expansion Parameters
* Metadata: 
  * ?: 
| | |
| :--- | :--- |
| **Name** | **Value** |
| system-version | `http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20230901` |
| system-version | `http://loinc.org|2.76` |
| system-version | [ActCodeversion: null9.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html) |
| system-version | [AdministrativeGenderversion: null3.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-AdministrativeGender.html) |
| system-version | `urn:oid:2.16.840.1.113883.6.238|1.2` |
| system-version | `http://www.ama-assn.org/go/cpt|2024` |
| system-version | `http://hl7.org/fhir/sid/cvx|20231102` |
| system-version | `http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets|2024` |
| system-version | `http://hl7.org/fhir/sid/icd-10-cm|2024` |
| system-version | `http://www.cms.gov/Medicare/Coding/ICD10|2024` |
| system-version | `http://www.nlm.nih.gov/research/umls/rxnorm|01022024` |
| system-version | `https://nahdo.org/sopt|9.2` |

* Metadata: Generated using version 0.5.3-cibuild of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "ccda-vsp-3-0-0-draft",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-manifestlibrary"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Parameters",
      "id" : "exp-params",
      "parameter" : [
        {
          "name" : "system-version",
          "valueCanonical" : "http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20230901"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://loinc.org|2.76"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/v3-ActCode|9.0.0"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/v3-AdministrativeGender|3.0.0"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "urn:oid:2.16.840.1.113883.6.238|1.2"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.ama-assn.org/go/cpt|2024"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/cvx|20231102"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets|2024"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/icd-10-cm|2024"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.cms.gov/Medicare/Coding/ICD10|2024"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.nlm.nih.gov/research/umls/rxnorm|01022024"
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://nahdo.org/sopt|9.2"
        }
      ]
    },
    {
      "resourceType" : "Parameters",
      "id" : "endpoints",
      "parameter" : [
        {
          "name" : "artifactEndpointConfiguration",
          "part" : [
            {
              "name" : "artifactRoute",
              "valueUri" : "http://cts.nlm.nih.gov/fhir/"
            },
            {
              "name" : "endpointUri",
              "valueUri" : "https://cts.nlm.nih.gov/fhir/"
            }
          ]
        },
        {
          "name" : "artifactEndpointConfiguration",
          "part" : [
            {
              "name" : "artifactRoute",
              "valueUri" : "http://terminology.hl7.org/"
            },
            {
              "name" : "endpointUri",
              "valueUri" : "https://tx.fhir.org/r4/"
            }
          ]
        },
        {
          "name" : "artifactEndpointConfiguration",
          "part" : [
            {
              "name" : "artifactRoute",
              "valueUri" : "http://hl7.org/fhir/"
            },
            {
              "name" : "endpointUri",
              "valueUri" : "https://tx.fhir.org/r4/"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters",
      "valueReference" : {
        "reference" : "#exp-params"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-endpointConfiguration",
      "valueReference" : {
        "reference" : "#endpoints"
      }
    }
  ],
  "url" : "http://hl7.org/cda/us/ccda-vsp/3.0.0/Library/hl7.fhir.us.ccda-vsp-3-0-0-draft",
  "version" : "2025-09",
  "name" : "CCDA300ValueSetPackageDefinition",
  "title" : "C-CDA 3.0.0 Value Set Package Definition",
  "status" : "draft",
  "experimental" : true,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "asset-collection"
      }
    ]
  },
  "date" : "2025-09-23",
  "publisher" : "Clinical Quality Framework",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://cqframework.org"
        }
      ]
    }
  ],
  "description" : "This is a draft version of a Value Set Refresh Package Definition for the Consolidated-CDA 3.0.0 implementation guide. It contains expansions of any value sets defined or used in the C-CDA 3.0.0 implementation guide, but refreshed using the code systems versions specified in the input expansion parameters.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "approvalDate" : "2025-09-23",
  "lastReviewDate" : "2025-09-23",
  "relatedArtifact" : [
    {
      "type" : "composed-of",
      "resource" : "http://hl7.org/cda/us/ccda/ImplementationGuide/hl7.cda.us.ccda|3.0.0"
    }
  ]
}

```
