# US Core 6.1.0 Draft Value Set Package Definition - Value Set Packages v0.1.0-cibuild

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core 6.1.0 Draft Value Set Package Definition**

## Library: US Core 6.1.0 Draft Value Set Package Definition (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core-vsp/6.1.0/Library/hl7.fhir.us.core-vsp-6-1-0-release | *Version*:2025-09 |
| Active as of 2025-10-14 | *Computable Name*:USCore610ValueSetPackageDefinition |

 
This is a released Value Set Refresh Package for the US Core 6.1.0 implementation guide. It contains expansions of any value sets defined or used in the US Core 6.1.0 implementation guide, but refreshed using the code systems versions specified in the input expansion parameters 

* Metadata: Title
  * ?: US Core 6.1.0 Draft Value Set Package Definition
* Metadata: Version
  * ?: 2025-09
* Metadata: Approval Date
  * ?: 2025-09-23
* Metadata: Last Review Date
  * ?: 2025-09-23
* Metadata: Experimental
  * ?: true
* Metadata: Jurisdiction
  * ?: 001 from[http://unstats.un.org/unsd/methods/m49/m49.htm](http://unstats.un.org/unsd/methods/m49/m49.htm)
* Metadata: Steward (Publisher)
  * ?: Clinical Quality Framework
* Metadata: Description
  * ?: This is a released Value Set Refresh Package for the US Core 6.1.0 implementation guide. It contains expansions of any value sets defined or used in the US Core 6.1.0 implementation guide, but refreshed using the code systems versions specified in the input expansion parameters
* Metadata: Type
  * ?: asset-collection from[http://terminology.hl7.org/CodeSystem/library-type](http://terminology.hl7.org/6.5.0/CodeSystem-library-type.html)
* Metadata: Component
  * ?: **Description**: ImplementationGuide US Core Implementation Guide, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core|6.1.0
* Metadata: Dependency
  * ?: **Description**: ImplementationGuide US Core Implementation Guide, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/CodeSystem/careplan-category`**Canonical URL**:http://hl7.org/fhir/us/core/CodeSystem/careplan-category
* Metadata: Dependency
  * ?: **Description**: CodeSystem US Core Condition Category Extension Codes, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/CodeSystem/condition-category|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/CodeSystem/condition-category|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/CodeSystem/us-core-category`**Canonical URL**:http://hl7.org/fhir/us/core/CodeSystem/us-core-category
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category`**Canonical URL**:http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/CodeSystem/us-core-provenance-participant-type`**Canonical URL**:http://hl7.org/fhir/us/core/CodeSystem/us-core-provenance-participant-type
* Metadata: Dependency
  * ?: **Resource**:[Vital Signs Profile](http://hl7.org/fhir/R4/vitalsigns.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/vitalsigns
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-vital-signs`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-vital-signs
* Metadata: Dependency
  * ?: **Resource**:[Common Languages](http://hl7.org/fhir/R4/valueset-languages.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/languages
* Metadata: Dependency
  * ?: **Description**: StructureDefinition Resource, 4.0.1**Resource**:[Resourceversion: null4.0.1)](http://hl7.org/fhir/R4/resource.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Resource|4.0.1
* Metadata: Dependency
  * ?: **Description**: StructureDefinition DomainResource, 4.0.1**Resource**:[DomainResourceversion: null4.0.1)](http://hl7.org/fhir/R4/domainresource.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/DomainResource|4.0.1
* Metadata: Dependency
  * ?: **Resource**:[Shareable ValueSet](http://hl7.org/fhir/R4/shareablevalueset.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/shareablevalueset
* Metadata: Dependency
  * ?: **Resource**:[AdministrativeGender](http://hl7.org/fhir/R4/codesystem-administrative-gender.html)**Canonical URL**:http://hl7.org/fhir/administrative-gender
* Metadata: Dependency
  * ?: **Description**: ValueSet AdministrativeGender, 4.0.1**Resource**:[AdministrativeGenderversion: null4.0.1)](http://hl7.org/fhir/R4/valueset-administrative-gender.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/administrative-gender|4.0.1
* Metadata: Dependency
  * ?: **Resource**:[MaritalStatus](http://hl7.org/fhir/R4/valueset-marital-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/marital-status
* Metadata: Dependency
  * ?: **Resource**:[Patient Contact Relationship](http://hl7.org/fhir/R4/valueset-patient-contactrelationship.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/patient-contactrelationship
* Metadata: Dependency
  * ?: **Resource**:[Organization](http://hl7.org/fhir/R4/organization.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Organization
* Metadata: Dependency
  * ?: **Resource**:[Practitioner](http://hl7.org/fhir/R4/practitioner.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Practitioner
* Metadata: Dependency
  * ?: **Resource**:[PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/PractitionerRole
* Metadata: Dependency
  * ?: **Description**: StructureDefinition Patient, 4.0.1**Resource**:[Patientversion: null4.0.1)](http://hl7.org/fhir/R4/patient.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Patient|4.0.1
* Metadata: Dependency
  * ?: **Resource**:[RelatedPerson](http://hl7.org/fhir/R4/relatedperson.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/RelatedPerson
* Metadata: Dependency
  * ?: **Resource**:[LinkType](http://hl7.org/fhir/R4/codesystem-link-type.html)**Canonical URL**:http://hl7.org/fhir/link-type
* Metadata: Dependency
  * ?: **Description**: ValueSet LinkType, 4.0.1**Resource**:[LinkTypeversion: null4.0.1)](http://hl7.org/fhir/R4/valueset-link-type.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/link-type|4.0.1
* Metadata: Dependency
  * ?: **Description**: StructureDefinition Element, 4.0.1**Resource**:[Elementversion: null4.0.1)](http://hl7.org/fhir/R4/datatypes.html#Element)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Element|4.0.1
* Metadata: Dependency
  * ?: **Description**: StructureDefinition Extension, 4.0.1**Resource**:[Extensionversion: null4.0.1)](http://hl7.org/fhir/R4/extensibility.html#Extension)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Extension|4.0.1
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/omb-race-category`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/omb-race-category
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/detailed-race`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/detailed-race
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Race Extension, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-race|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-race|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/omb-ethnicity-category`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/omb-ethnicity-category
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/detailed-ethnicity`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/detailed-ethnicity
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Ethnicity Extension, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[TribalEntityUS](http://terminology.hl7.org/6.5.0/ValueSet-v3-TribalEntityUS.html)**Canonical URL**:http://terminology.hl7.org/ValueSet/v3-TribalEntityUS
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Tribal Affiliation Extension, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/birthsex`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/birthsex
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Birth Sex Extension, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/computable-valueset-cqfm`**Canonical URL**:http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/computable-valueset-cqfm
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/publishable-valueset-cqfm`**Canonical URL**:http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/publishable-valueset-cqfm
* Metadata: Dependency
  * ?: **Resource**:`http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20240901`**Canonical URL**:http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20240901
* Metadata: Dependency
  * ?: **Description**: ValueSet Sex, 20240217**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.53|20240217`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.53|20240217
* Metadata: Dependency
  * ?: **Resource**:[DataAbsentReasonversion: null1.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html)**Canonical URL**:http://terminology.hl7.org/CodeSystem/data-absent-reason|1.0.0
* Metadata: Dependency
  * ?: **Description**: ValueSet Asked Declined Data Absent Reason, 20230628**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.4|20230628`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.4|20230628
* Metadata: Dependency
  * ?: **Description**: ValueSet Sex, 20230628**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.3|20230628`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.3|20230628
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Sex Extension, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-sex|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-sex|6.1.0
* Metadata: Dependency
  * ?: **Description**: ValueSet Gender Identity SCT, 20240215**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.101|20240215`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.101|20240215
* Metadata: Dependency
  * ?: **Resource**:[Shareable CodeSystem](http://hl7.org/fhir/R4/shareablecodesystem.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/shareablecodesystem
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/publishable-codesystem-cqfm`**Canonical URL**:http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/publishable-codesystem-cqfm
* Metadata: Dependency
  * ?: **Description**: CodeSystem NullFlavor, 3.0.0**Resource**:[NullFlavorversion: null3.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html)**Canonical URL**:http://terminology.hl7.org/CodeSystem/v3-NullFlavor|3.0.0
* Metadata: Dependency
  * ?: **Description**: ValueSet Other Unknown Nulls, 20231129**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.10|20231129`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.10|20231129
* Metadata: Dependency
  * ?: **Description**: ValueSet Gender Identity, 20240215**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.32|20240215`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.32|20240215
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Gender Identity Extension, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-genderIdentity|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-genderIdentity|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[ContactPointSystem](http://hl7.org/fhir/R4/valueset-contact-point-system.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/contact-point-system
* Metadata: Dependency
  * ?: **Resource**:[ContactPointUse](http://hl7.org/fhir/R4/valueset-contact-point-use.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/contact-point-use
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-usps-state`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-usps-state
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/simple-language`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/simple-language
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Patient Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Vital Signs Unitsversion: null4.0.1)](http://hl7.org/fhir/R4/valueset-ucum-vitals-common.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/ucum-vitals-common|4.0.1
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Vital Signs Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-vital-signs|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-vital-signs|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Pediatric Head Occipital Frontal Circumference Percentile Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/head-occipital-frontal-circumference-percentile|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/head-occipital-frontal-circumference-percentile|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Pediatric BMI for Age Observation Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/pediatric-bmi-for-age|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/pediatric-bmi-for-age|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Pediatric Weight for Height Observation Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/pediatric-weight-for-height|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/pediatric-weight-for-height|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[AllergyIntolerance](http://hl7.org/fhir/R4/allergyintolerance.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/AllergyIntolerance
* Metadata: Dependency
  * ?: **Resource**:[AllergyIntolerance Clinical Status Codes](http://hl7.org/fhir/R4/valueset-allergyintolerance-clinical.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/allergyintolerance-clinical
* Metadata: Dependency
  * ?: **Resource**:[AllergyIntolerance Verification Status Codes](http://hl7.org/fhir/R4/valueset-allergyintolerance-verification.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/allergyintolerance-verification
* Metadata: Dependency
  * ?: **Description**: ValueSet Medication drug class for allergen intolerance SCT, 20250723**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1114.14|20250723`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1114.14|20250723
* Metadata: Dependency
  * ?: **Description**: ValueSet Common refutations for substance causes for allergy and intolerance documentation, 20240606**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.5|20240606`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.5|20240606
* Metadata: Dependency
  * ?: **Description**: ValueSet Common environmental substances for allergy and intolerance documentation, 20240606**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.4|20240606`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.4|20240606
* Metadata: Dependency
  * ?: **Resource**:`http://www.nlm.nih.gov/research/umls/rxnorm|01062025`**Canonical URL**:http://www.nlm.nih.gov/research/umls/rxnorm|01062025
* Metadata: Dependency
  * ?: **Description**: ValueSet Common drug substances for allergy and intolerance documentation, 20240625**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.1|20240625`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.1|20240625
* Metadata: Dependency
  * ?: **Description**: ValueSet Common dietary substances for allergy and intolerance documentation, 20240625**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.3|20240625`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.3|20240625
* Metadata: Dependency
  * ?: **Description**: ValueSet Common substances for allergy and intolerance documentation including refutations, 20240625**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.8|20240625`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.8|20240625
* Metadata: Dependency
  * ?: **Resource**:[SNOMED CT Clinical Findings](http://hl7.org/fhir/R4/valueset-clinical-findings.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/clinical-findings
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core AllergyIntolerance Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Blood Pressure Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-blood-pressure|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-blood-pressure|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core BMI Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-bmi|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-bmi|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Body Length Unitsversion: null4.0.1)](http://hl7.org/fhir/R4/valueset-ucum-bodylength.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/ucum-bodylength|4.0.1
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Body Height Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-height|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-height|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Body Temperature Unitsversion: null4.0.1)](http://hl7.org/fhir/R4/valueset-ucum-bodytemp.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/ucum-bodytemp|4.0.1
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Body Temperature Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-temperature|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-temperature|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Body Weight Unitsversion: null4.0.1)](http://hl7.org/fhir/R4/valueset-ucum-bodyweight.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/ucum-bodyweight|4.0.1
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Body Weight Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-weight|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-weight|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[CarePlan](http://hl7.org/fhir/R4/careplan.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/CarePlan
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-narrative-status`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-narrative-status
* Metadata: Dependency
  * ?: **Resource**:[RequestStatus](http://hl7.org/fhir/R4/valueset-request-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/request-status
* Metadata: Dependency
  * ?: **Resource**:[Care Plan Intent](http://hl7.org/fhir/R4/valueset-care-plan-intent.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/care-plan-intent
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core CarePlan Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[CareTeam](http://hl7.org/fhir/R4/careteam.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/CareTeam
* Metadata: Dependency
  * ?: **Resource**:[CareTeamStatus](http://hl7.org/fhir/R4/valueset-care-team-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/care-team-status
* Metadata: Dependency
  * ?: **Description**: CodeSystem ParticipationFunction, 3.0.0**Resource**:[ParticipationFunctionversion: null3.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationFunction.html)**Canonical URL**:http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction|3.0.0
* Metadata: Dependency
  * ?: **Description**: ValueSet ParticipationFunction, 20240605**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.10267|20240605`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.10267|20240605
* Metadata: Dependency
  * ?: **Description**: ValueSet Care Team Member Function (SNOMEDCT), 20230706**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.27|20230706`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.27|20230706
* Metadata: Dependency
  * ?: **Description**: ValueSet Care Team Member Function, 20240605**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30|20240605`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30|20240605
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Practitioner Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Organization Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0
* Metadata: Dependency
  * ?: **Description**: CodeSystem NUCC Provider Taxonomy, 24.1**Resource**:`http://nucc.org/provider-taxonomy|24.1`**Canonical URL**:http://nucc.org/provider-taxonomy|24.1
* Metadata: Dependency
  * ?: **Description**: ValueSet Healthcare Provider Taxonomy, 20240606**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066|20240606`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066|20240606
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core PractitionerRole Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core CareTeam Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core RelatedPerson Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Condition](http://hl7.org/fhir/R4/condition.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Condition
* Metadata: Dependency
  * ?: **Description**: StructureDefinition Condition Asserted Date, 1.0.0**Resource**:[Condition Asserted Dateversion: null1.0.0)](http://hl7.org/fhir/extensions/1.0.0/StructureDefinition-condition-assertedDate.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/condition-assertedDate|1.0.0
* Metadata: Dependency
  * ?: **Resource**:[Condition Clinical Status Codes](http://hl7.org/fhir/R4/valueset-condition-clinical.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/condition-clinical
* Metadata: Dependency
  * ?: **Resource**:[ConditionVerificationStatus](http://hl7.org/fhir/R4/valueset-condition-ver-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/condition-ver-status
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code
* Metadata: Dependency
  * ?: **Resource**:[Encounter](http://hl7.org/fhir/R4/encounter.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Encounter
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-encounter-type`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-encounter-type
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-problem-or-health-concern`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-problem-or-health-concern
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-screening-assessment-condition-category`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-screening-assessment-condition-category
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Condition Problems and Health Concerns Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Condition Encounter Diagnosis Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Procedure](http://hl7.org/fhir/R4/procedure.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Procedure
* Metadata: Dependency
  * ?: **Resource**:[ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/ServiceRequest
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-servicerequest-category`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-servicerequest-category
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-procedure-code`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-procedure-code
* Metadata: Dependency
  * ?: **Resource**:[Device](http://hl7.org/fhir/R4/device.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Device
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core ServiceRequest Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[EventStatus](http://hl7.org/fhir/R4/valueset-event-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/event-status
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Procedure Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[DeviceRequest](http://hl7.org/fhir/R4/devicerequest.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/DeviceRequest
* Metadata: Dependency
  * ?: **Resource**:[ImmunizationRecommendation](http://hl7.org/fhir/R4/immunizationrecommendation.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation
* Metadata: Dependency
  * ?: **Resource**:[MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/MedicationRequest
* Metadata: Dependency
  * ?: **Resource**:[NutritionOrder](http://hl7.org/fhir/R4/nutritionorder.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/NutritionOrder
* Metadata: Dependency
  * ?: **Resource**:[MedicationAdministration](http://hl7.org/fhir/R4/medicationadministration.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/MedicationAdministration
* Metadata: Dependency
  * ?: **Resource**:[MedicationDispense](http://hl7.org/fhir/R4/medicationdispense.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/MedicationDispense
* Metadata: Dependency
  * ?: **Resource**:[MedicationStatement](http://hl7.org/fhir/R4/medicationstatement.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/MedicationStatement
* Metadata: Dependency
  * ?: **Resource**:[Immunization](http://hl7.org/fhir/R4/immunization.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Immunization
* Metadata: Dependency
  * ?: **Resource**:[ImagingStudy](http://hl7.org/fhir/R4/imagingstudy.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/ImagingStudy
* Metadata: Dependency
  * ?: **Resource**:[ObservationStatus](http://hl7.org/fhir/R4/codesystem-observation-status.html)**Canonical URL**:http://hl7.org/fhir/observation-status
* Metadata: Dependency
  * ?: **Description**: ValueSet ObservationStatus, 4.0.1**Resource**:[ObservationStatusversion: null4.0.1)](http://hl7.org/fhir/R4/valueset-observation-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/observation-status|4.0.1
* Metadata: Dependency
  * ?: **Resource**:[Observation Category Codes](http://hl7.org/fhir/R4/valueset-observation-category.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/observation-category
* Metadata: Dependency
  * ?: **Resource**:[LOINC Codes](http://hl7.org/fhir/R4/valueset-observation-codes.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/observation-codes
* Metadata: Dependency
  * ?: **Resource**:[Group](http://hl7.org/fhir/R4/group.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Group
* Metadata: Dependency
  * ?: **Resource**:[Location](http://hl7.org/fhir/R4/location.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Location
* Metadata: Dependency
  * ?: **Resource**:[DataAbsentReason](http://hl7.org/fhir/R4/valueset-data-absent-reason.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/data-absent-reason
* Metadata: Dependency
  * ?: **Resource**:[Observation Interpretation Codes](http://hl7.org/fhir/R4/valueset-observation-interpretation.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/observation-interpretation
* Metadata: Dependency
  * ?: **Resource**:[SNOMED CT Body Structures](http://hl7.org/fhir/R4/valueset-body-site.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/body-site
* Metadata: Dependency
  * ?: **Resource**:[Observation Methods](http://hl7.org/fhir/R4/valueset-observation-methods.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/observation-methods
* Metadata: Dependency
  * ?: **Resource**:[Specimen](http://hl7.org/fhir/R4/specimen.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Specimen
* Metadata: Dependency
  * ?: **Resource**:[DeviceMetric](http://hl7.org/fhir/R4/devicemetric.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/DeviceMetric
* Metadata: Dependency
  * ?: **Resource**:[QuantityComparator](http://hl7.org/fhir/R4/codesystem-quantity-comparator.html)**Canonical URL**:http://hl7.org/fhir/quantity-comparator
* Metadata: Dependency
  * ?: **Description**: ValueSet QuantityComparator, 4.0.1**Resource**:[QuantityComparatorversion: null4.0.1)](http://hl7.org/fhir/R4/valueset-quantity-comparator.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/quantity-comparator|4.0.1
* Metadata: Dependency
  * ?: **Description**: StructureDefinition Quantity, 4.0.1**Resource**:[Quantityversion: null4.0.1)](http://hl7.org/fhir/R4/datatypes.html#Quantity)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Quantity|4.0.1
* Metadata: Dependency
  * ?: **Description**: StructureDefinition SimpleQuantity, 4.0.1**Resource**:[SimpleQuantityversion: null4.0.1)](http://hl7.org/fhir/R4/datatypes.html#SimpleQuantity)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/SimpleQuantity|4.0.1
* Metadata: Dependency
  * ?: **Resource**:[Observation Reference Range Meaning Codes](http://hl7.org/fhir/R4/valueset-referencerange-meaning.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/referencerange-meaning
* Metadata: Dependency
  * ?: **Resource**:[Observation Reference Range Applies To Codes](http://hl7.org/fhir/R4/valueset-referencerange-appliesto.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/referencerange-appliesto
* Metadata: Dependency
  * ?: **Description**: StructureDefinition Observation, 4.0.1**Resource**:[Observationversion: null4.0.1)](http://hl7.org/fhir/R4/observation.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Observation|4.0.1
* Metadata: Dependency
  * ?: **Resource**:[QuestionnaireResponse](http://hl7.org/fhir/R4/questionnaireresponse.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse
* Metadata: Dependency
  * ?: **Resource**:[MolecularSequence](http://hl7.org/fhir/R4/molecularsequence.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/MolecularSequence
* Metadata: Dependency
  * ?: **Resource**:[DocumentReference](http://hl7.org/fhir/R4/documentreference.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/DocumentReference
* Metadata: Dependency
  * ?: **Resource**:[Media](http://hl7.org/fhir/R4/media.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Media
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-discharge-disposition`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-discharge-disposition
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Encounter Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Coverage](http://hl7.org/fhir/R4/coverage.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Coverage
* Metadata: Dependency
  * ?: **Resource**:`https://nahdo.org/sopt|9.2`**Canonical URL**:https://nahdo.org/sopt|9.2
* Metadata: Dependency
  * ?: **Description**: ValueSet Payer Type, 20250419**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591|20250419`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591|20250419
* Metadata: Dependency
  * ?: **Resource**:[SubscriberPolicyholder Relationship Codes](http://hl7.org/fhir/R4/valueset-subscriber-relationship.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/subscriber-relationship
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Coverage Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[DiagnosticReport](http://hl7.org/fhir/R4/diagnosticreport.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/DiagnosticReport
* Metadata: Dependency
  * ?: **Resource**:[DiagnosticReportStatus](http://hl7.org/fhir/R4/valueset-diagnostic-report-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/diagnostic-report-status
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-laboratory-test-codes`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-laboratory-test-codes
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-result-observation-category`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-result-observation-category
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Observation Clinical Result Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|6.1.0
* Metadata: Dependency
  * ?: **Description**: ValueSet Specimen type, 20240606**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.54|20240606`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.54|20240606
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Specimen Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-specimen|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-specimen|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Laboratory Result Observation Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core DiagnosticReport Profile for Laboratory Results Reporting, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-diagnosticreport-category`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-diagnosticreport-category
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-diagnosticreport-report-and-note-codes`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-diagnosticreport-report-and-note-codes
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core DiagnosticReport Profile for Report and Note Exchange, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Direct email Extension, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-direct|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-direct|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[DocumentReferenceStatus](http://hl7.org/fhir/R4/valueset-document-reference-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/document-reference-status
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-type`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-type
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-category`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-category
* Metadata: Dependency
  * ?: **Resource**:[DocumentReference Format Code Set](http://hl7.org/fhir/R4/valueset-formatcodes.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/formatcodes
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core DocumentReference Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Extension Questionnaire URI, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-extension-questionnaire-uri|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-extension-questionnaire-uri|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Goal](http://hl7.org/fhir/R4/goal.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Goal
* Metadata: Dependency
  * ?: **Resource**:[GoalLifecycleStatus](http://hl7.org/fhir/R4/valueset-goal-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/goal-status
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-goal-description`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-goal-description
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Goal Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Head Circumference Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-head-circumference|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-head-circumference|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Heart Rate Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-heart-rate|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-heart-rate|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Immunization Status Codes](http://hl7.org/fhir/R4/valueset-immunization-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/immunization-status
* Metadata: Dependency
  * ?: **Resource**:[Immunization Status Reason Codes](http://hl7.org/fhir/R4/valueset-immunization-status-reason.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/immunization-status-reason
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/sid/cvx|20241216`**Canonical URL**:http://hl7.org/fhir/sid/cvx|20241216
* Metadata: Dependency
  * ?: **Description**: ValueSet CVX Vaccines Administered Vaccine Set, 20250411**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.6|20250411`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.6|20250411
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Immunization Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-immunization|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-immunization|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[FHIR Device Types](http://hl7.org/fhir/R4/valueset-device-kind.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/device-kind
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Implantable Device Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Jurisdiction Extension, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-jurisdiction|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-jurisdiction|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Location Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Medication](http://hl7.org/fhir/R4/medication.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Medication
* Metadata: Dependency
  * ?: **Description**: ValueSet Medication Clinical Brand specific Drug, 20240627**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.5|20240627`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.5|20240627
* Metadata: Dependency
  * ?: **Description**: ValueSet Medication Clinical General Drug, 20240627**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.17|20240627`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.17|20240627
* Metadata: Dependency
  * ?: **Description**: ValueSet Medication Clinical Drug, 20240606**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4|20240606`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4|20240606
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Medication Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Medicationrequest status](http://hl7.org/fhir/R4/valueset-medicationrequest-status.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/medicationrequest-status
* Metadata: Dependency
  * ?: **Resource**:[Medication request intent](http://hl7.org/fhir/R4/valueset-medicationrequest-intent.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/medicationrequest-intent
* Metadata: Dependency
  * ?: **Resource**:[Medication request category codes](http://hl7.org/fhir/R4/valueset-medicationrequest-category.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/medicationrequest-category
* Metadata: Dependency
  * ?: **Resource**:[Common UCUM units](http://hl7.org/fhir/R4/valueset-ucum-common.html)**Canonical URL**:http://hl7.org/fhir/ValueSet/ucum-common
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core MedicationRequest Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[ActPharmacySupplyType](http://terminology.hl7.org/6.5.0/ValueSet-v3-ActPharmacySupplyType.html)**Canonical URL**:http://terminology.hl7.org/ValueSet/v3-ActPharmacySupplyType
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core MedicationDispense Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7901`**Canonical URL**:http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7901
* Metadata: Dependency
  * ?: **Resource**:`http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7900`**Canonical URL**:http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7900
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Observation Occupation Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-occupation|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-occupation|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-pregnancy-intent`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-pregnancy-intent
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Observation Pregnancy Intent Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancyintent|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancyintent|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-pregnancy-status`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-pregnancy-status
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Observation Pregnancy Status Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancystatus|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancystatus|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-screening-assessment-observation-category`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-screening-assessment-observation-category
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-survey-codes`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-survey-codes
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Observation Screening Assessment Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse`**Canonical URL**:http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core QuestionnaireResponse Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-questionnaireresponse|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-questionnaireresponse|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-sexual-orientation`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-sexual-orientation
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Observation Sexual Orientation Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-sexual-orientation|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-sexual-orientation|6.1.0
* Metadata: Dependency
  * ?: **Resource**:[Provenance](http://hl7.org/fhir/R4/provenance.html)**Canonical URL**:http://hl7.org/fhir/StructureDefinition/Provenance
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-provenance-participant-type`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-provenance-participant-type
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Provenance Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Pulse Oximetry Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-pulse-oximetry|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-pulse-oximetry|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Respiratory Rate Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-respiratory-rate|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-respiratory-rate|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-simple-observation-category`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-simple-observation-category
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Simple Observation Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-observation-smoking-status-status`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-observation-smoking-status-status
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-smoking-status-observation-codes`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-smoking-status-observation-codes
* Metadata: Dependency
  * ?: **Description**: ValueSet Smoking Status, 20240606**Resource**:`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.38|20240606`**Canonical URL**:http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.38|20240606
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core Smoking Status Observation Profile, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|6.1.0
* Metadata: Dependency
  * ?: **Description**: StructureDefinition US Core USCDI Requirement Extension, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement|6.1.0
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-note-type`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-note-type
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-observation-smokingstatus-max`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-observation-smokingstatus-max
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/us-core-observation-value-codes`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/us-core-observation-value-codes
* Metadata: Dependency
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ValueSet/simple-observation`**Canonical URL**:http://hl7.org/fhir/us/core/ValueSet/simple-observation
* Metadata: Dependency
  * ?: **Description**: CapabilityStatement US Core Client CapabilityStatement, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/CapabilityStatement/us-core-client|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/CapabilityStatement/us-core-client|6.1.0
* Metadata: Dependency
  * ?: **Description**: CapabilityStatement US Core Server CapabilityStatement, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server|6.1.0
* Metadata: Dependency
  * ?: **Description**: OperationDefinition US Core Fetch DocumentReference, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/OperationDefinition/docref|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/OperationDefinition/docref|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreAllergyintoleranceClinicalStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-clinical-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-clinical-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreAllergyintolerancePatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreCareplanCategory, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-category|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-category|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreCareplanDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreCareplanPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreCareplanStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreCareteamPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreCareTeamRole, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-role|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-role|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreCareteamStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreConditionAbatementDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-abatement-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-abatement-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreConditionAssertedDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-asserted-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-asserted-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreConditionCategory, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-category|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-category|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreConditionClinicalStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-clinical-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-clinical-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreConditionCode, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-code|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-code|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreConditionEncounter, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-encounter|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-encounter|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreConditionOnsetDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-onset-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-onset-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreConditionPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreConditionRecordedDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-recorded-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-recorded-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreCoveragePatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-coverage-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-coverage-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDevicePatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-device-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-device-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDeviceStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-device-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-device-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDeviceType, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-device-type|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-device-type|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDiagnosticreportCategory, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-category|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-category|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDiagnosticreportCode, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-code|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-code|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDiagnosticreportDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDiagnosticreportPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDiagnosticreportStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDocumentreferenceCategory, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-category|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-category|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDocumentreferenceDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDocumentreferenceId, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-id|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-id|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDocumentreferencePatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDocumentreferencePeriod, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-period|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-period|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDocumentreferenceStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreDocumentreferenceType, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-type|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-type|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEncounterClass, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-class|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-class|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEncounterDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEncounterDischargeDisposition, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-discharge-disposition|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-discharge-disposition|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEncounterId, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-id|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-id|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEncounterIdentifier, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-identifier|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-identifier|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEncounterLocation, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-location|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-location|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEncounterPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEncounterStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEncounterType, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-type|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-type|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreEthnicity, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-ethnicity|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-ethnicity|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreGoalDescription, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-description|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-description|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreGoalLifecycleStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-lifecycle-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-lifecycle-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreGoalPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreGoalTargetDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-target-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-target-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreImmunizationDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreImmunizationPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreImmunizationStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreLocationAddressCity, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-city|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-city|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreLocationAddressPostalcode, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-postalcode|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-postalcode|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreLocationAddressState, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-state|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-state|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreLocationAddress, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreLocationName, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-name|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-location-name|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreMedicationdispensePatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreMedicationdispenseStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreMedicationdispenseType, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-type|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-type|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreMedicationrequestAuthoredon, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-authoredon|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-authoredon|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreMedicationrequestEncounter, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-encounter|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-encounter|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreMedicationrequestIntent, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-intent|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-intent|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreMedicationrequestPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreMedicationrequestStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreObservationCategory, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-category|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-category|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreObservationCode, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-code|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-code|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreObservationDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreObservationPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreObservationStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreOrganizationAddress, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-address|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-address|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreOrganizationName, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-name|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-name|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePatientBirthdate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-birthdate|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-birthdate|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePatientDeathDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-death-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-death-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePatientFamily, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-family|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-family|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePatientGenderIdentity, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender-identity|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender-identity|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePatientGender, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePatientGiven, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-given|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-given|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePatientId, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-id|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-id|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePatientIdentifier, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-identifier|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-identifier|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePatientName, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-name|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-name|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePractitionerId, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-id|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-id|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePractitionerIdentifier, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-identifier|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-identifier|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePractitionerName, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-name|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-name|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePractitionerrolePractitioner, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-practitioner|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-practitioner|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCorePractitionerroleSpecialty, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-specialty|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-specialty|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreProcedureCode, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-code|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-code|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreProcedureDate, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-date|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-date|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreProcedurePatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreProcedureStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreQuestionnaireresponseAuthored, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-authored|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-authored|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreQuestionnaireresponseId, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-id|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-id|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreQuestionnaireresponsePatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreQuestionnaireresponseQuestionnaire, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-questionnaire|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-questionnaire|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreQuestionnaireresponseStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreRace, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-race|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-race|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreRelatedpersonId, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-id|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-id|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreRelatedpersonName, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-name|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-name|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreRelatedpersonPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreServicerequestAuthored, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-authored|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-authored|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreServicerequestCategory, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-category|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-category|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreServicerequestCode, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-code|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-code|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreServicerequestId, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-id|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-id|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreServicerequestPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-patient|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreServicerequestStatus, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-status|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-status|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreSpecimenId, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-id|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-id|6.1.0
* Metadata: Dependency
  * ?: **Description**: SearchParameter USCoreSpecimenPatient, 6.1.0**Resource**:`http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-patient|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-patient|6.1.0
* Metadata: Parameters
* Metadata: Parameter
  * ?: None
* Metadata: Expansion Parameters
* Metadata: 
  * ?: 
| | |
| :--- | :--- |
| **Name** | **Value** |
| system-version | SNOMEDCT, 2024-09`http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20240901` |
| system-version | ActCode, 9.0.0[ActCodeversion: null9.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html) |
| system-version | CDCREC, 1.2`urn:oid:2.16.840.1.113883.6.238|1.2` |
| system-version | CDT, 2023`http://www.ada.org/cdt|2023` |
| system-version | CPT, 2025`http://www.ama-assn.org/go/cpt|2025` |
| system-version | CVX, 2024-12-16`http://hl7.org/fhir/sid/cvx|20241216` |
| system-version | DataAbsentReason, 1.0.0[DataAbsentReasonversion: null1.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html) |
| system-version | HCPCS, 2025`http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets|2025` |
| system-version | HSLOC, 2022`https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html|2022` |
| system-version | ICD10CM, 2025`http://hl7.org/fhir/sid/icd-10-cm|2025` |
| system-version | ICD10PCS, 2025`http://www.cms.gov/Medicare/Coding/ICD10|2025` |
| system-version | ICD9CM, 2013`http://hl7.org/fhir/sid/icd-9-cm|2013` |
| system-version | LOINC, 2.78`http://loinc.org|2.78` |
| system-version | PresentOnAdmission, 2021`https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/HospitalAcqCond/Coding|2021` |
| system-version | RXNORM, 2025-01`http://www.nlm.nih.gov/research/umls/rxnorm|01062025` |
| system-version | SOP, 9.2`https://nahdo.org/sopt|9.2` |
| system-version | Task Codes, 4.0.1[Task Codesversion: null4.0.1)](http://hl7.org/fhir/R4/codesystem-task-code.html) |
| system-version | US Core Condition Category Extension Codes, 6.1.0`http://hl7.org/fhir/us/core/CodeSystem/condition-category|6.1.0` |
| system-version | AllergyIntolerance Clinical Status Codes, 1.0.0[AllergyIntolerance Clinical Status Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-allergyintolerance-clinical.html) |
| system-version | AllergyIntolerance Verification Status, 1.0.0[AllergyIntolerance Verification Statusversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-allergyintolerance-verification.html) |
| system-version | Condition Clinical Status Codes, 3.0.0[Condition Clinical Status Codesversion: null3.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html) |
| system-version | Condition Verification Status, 2.0.0[ConditionVerificationStatusversion: null2.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-condition-ver-status.html) |
| system-version | Diagnosis Role, 1.1.0[Diagnosis Roleversion: null1.1.0)](http://terminology.hl7.org/5.5.0/CodeSystem-diagnosis-role.html) |
| system-version | Example Diagnosis Type Codes, 1.0.0[Example Diagnosis Type Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-ex-diagnosistype.html) |
| system-version | Example Procedure Type Codes, 1.0.0[Example Procedure Type Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-ex-procedure-type.html) |
| system-version | Medication Request Category Codes, 1.0.0[MedicationRequest Category Codesversion: null1.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-medicationrequest-category.html) |
| system-version | Observation Category Codes, 1.0.0[Observation Category Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-observation-category.html) |
| canonicalVersion | StructureDefinition US Core Pediatric Head Occipital Frontal Circumference Percentile Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/head-occipital-frontal-circumference-percentile|6.1.0` |
| canonicalVersion | StructureDefinition US Core Vital Signs Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-vital-signs|6.1.0` |
| canonicalVersion | StructureDefinition US Core Patient Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0` |
| canonicalVersion | StructureDefinition Patient, 4.0.1[Patientversion: null4.0.1)](http://hl7.org/fhir/R4/patient.html) |
| canonicalVersion | StructureDefinition DomainResource, 4.0.1[DomainResourceversion: null4.0.1)](http://hl7.org/fhir/R4/domainresource.html) |
| canonicalVersion | StructureDefinition Resource, 4.0.1[Resourceversion: null4.0.1)](http://hl7.org/fhir/R4/resource.html) |
| canonicalVersion | StructureDefinition US Core Race Extension, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-race|6.1.0` |
| canonicalVersion | StructureDefinition Extension, 4.0.1[Extensionversion: null4.0.1)](http://hl7.org/fhir/R4/extensibility.html#Extension) |
| canonicalVersion | StructureDefinition Element, 4.0.1[Elementversion: null4.0.1)](http://hl7.org/fhir/R4/datatypes.html#Element) |
| canonicalVersion | StructureDefinition US Core Ethnicity Extension, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity|6.1.0` |
| canonicalVersion | StructureDefinition US Core Tribal Affiliation Extension, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation|6.1.0` |
| canonicalVersion | StructureDefinition US Core Birth Sex Extension, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex|6.1.0` |
| canonicalVersion | StructureDefinition US Core Sex Extension, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-sex|6.1.0` |
| canonicalVersion | ValueSet Sex, 20230628`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.3|20230628` |
| canonicalVersion | ValueSet Sex, 20240217`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.53|20240217` |
| canonicalVersion | ValueSet Asked Declined Data Absent Reason, 20230628`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.4|20230628` |
| canonicalVersion | StructureDefinition US Core Gender Identity Extension, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-genderIdentity|6.1.0` |
| canonicalVersion | ValueSet Gender Identity, 20240215`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.32|20240215` |
| canonicalVersion | ValueSet Gender Identity SCT, 20240215`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.101|20240215` |
| canonicalVersion | ValueSet Other Unknown Nulls, 20231129`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.10|20231129` |
| system-version | CodeSystem NullFlavor, 3.0.0[NullFlavorversion: null3.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-NullFlavor.html) |
| canonicalVersion | StructureDefinition US Core Pediatric BMI for Age Observation Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/pediatric-bmi-for-age|6.1.0` |
| canonicalVersion | StructureDefinition US Core Pediatric Weight for Height Observation Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/pediatric-weight-for-height|6.1.0` |
| canonicalVersion | StructureDefinition US Core AllergyIntolerance Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance|6.1.0` |
| canonicalVersion | ValueSet Common substances for allergy and intolerance documentation including refutations, 20240625`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.8|20240625` |
| canonicalVersion | ValueSet Medication drug class for allergen intolerance SCT, 20250723`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1114.14|20250723` |
| canonicalVersion | ValueSet Common refutations for substance causes for allergy and intolerance documentation, 20240606`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.5|20240606` |
| canonicalVersion | ValueSet Common environmental substances for allergy and intolerance documentation, 20240606`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.4|20240606` |
| canonicalVersion | ValueSet Common drug substances for allergy and intolerance documentation, 20240625`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.1|20240625` |
| canonicalVersion | ValueSet Common dietary substances for allergy and intolerance documentation, 20240625`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.3|20240625` |
| canonicalVersion | StructureDefinition US Core Blood Pressure Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-blood-pressure|6.1.0` |
| canonicalVersion | StructureDefinition US Core BMI Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-bmi|6.1.0` |
| canonicalVersion | StructureDefinition US Core Body Height Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-height|6.1.0` |
| canonicalVersion | StructureDefinition US Core Body Temperature Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-temperature|6.1.0` |
| canonicalVersion | StructureDefinition US Core Body Weight Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-weight|6.1.0` |
| canonicalVersion | StructureDefinition US Core CarePlan Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan|6.1.0` |
| canonicalVersion | StructureDefinition US Core CareTeam Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam|6.1.0` |
| canonicalVersion | ValueSet Care Team Member Function, 20240605`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30|20240605` |
| canonicalVersion | ValueSet ParticipationFunction, 20240605`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.10267|20240605` |
| system-version | CodeSystem ParticipationFunction, 3.0.0[ParticipationFunctionversion: null3.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationFunction.html) |
| canonicalVersion | ValueSet Care Team Member Function (SNOMEDCT), 20230706`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.27|20230706` |
| canonicalVersion | StructureDefinition US Core Practitioner Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0` |
| canonicalVersion | StructureDefinition US Core Organization Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0` |
| canonicalVersion | StructureDefinition US Core PractitionerRole Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|6.1.0` |
| canonicalVersion | ValueSet Healthcare Provider Taxonomy, 20240606`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066|20240606` |
| system-version | CodeSystem NUCC Provider Taxonomy, 24.1`http://nucc.org/provider-taxonomy|24.1` |
| canonicalVersion | StructureDefinition US Core RelatedPerson Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson|6.1.0` |
| canonicalVersion | StructureDefinition US Core Condition Encounter Diagnosis Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0` |
| canonicalVersion | StructureDefinition Condition Asserted Date, 1.0.0[Condition Asserted Dateversion: null1.0.0)](http://hl7.org/fhir/extensions/1.0.0/StructureDefinition-condition-assertedDate.html) |
| canonicalVersion | StructureDefinition US Core Encounter Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0` |
| canonicalVersion | StructureDefinition US Core Condition Problems and Health Concerns Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0` |
| canonicalVersion | StructureDefinition US Core Procedure Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|6.1.0` |
| canonicalVersion | StructureDefinition US Core ServiceRequest Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|6.1.0` |
| canonicalVersion | StructureDefinition Observation, 4.0.1[Observationversion: null4.0.1)](http://hl7.org/fhir/R4/observation.html) |
| canonicalVersion | StructureDefinition SimpleQuantity, 4.0.1[SimpleQuantityversion: null4.0.1)](http://hl7.org/fhir/R4/datatypes.html#SimpleQuantity) |
| canonicalVersion | StructureDefinition Quantity, 4.0.1[Quantityversion: null4.0.1)](http://hl7.org/fhir/R4/datatypes.html#Quantity) |
| canonicalVersion | StructureDefinition US Core Coverage Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage|6.1.0` |
| canonicalVersion | ValueSet Payer Type, 20250419`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591|20250419` |
| canonicalVersion | StructureDefinition US Core DiagnosticReport Profile for Laboratory Results Reporting, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|6.1.0` |
| canonicalVersion | StructureDefinition US Core Laboratory Result Observation Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0` |
| canonicalVersion | StructureDefinition US Core Observation Clinical Result Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|6.1.0` |
| canonicalVersion | StructureDefinition US Core Specimen Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-specimen|6.1.0` |
| canonicalVersion | ValueSet Specimen type, 20240606`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.54|20240606` |
| canonicalVersion | StructureDefinition US Core DiagnosticReport Profile for Report and Note Exchange, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|6.1.0` |
| canonicalVersion | StructureDefinition US Core Direct email Extension, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-direct|6.1.0` |
| canonicalVersion | StructureDefinition US Core DocumentReference Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|6.1.0` |
| canonicalVersion | StructureDefinition US Core Extension Questionnaire URI, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-extension-questionnaire-uri|6.1.0` |
| canonicalVersion | StructureDefinition US Core Goal Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|6.1.0` |
| canonicalVersion | StructureDefinition US Core Head Circumference Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-head-circumference|6.1.0` |
| canonicalVersion | StructureDefinition US Core Heart Rate Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-heart-rate|6.1.0` |
| canonicalVersion | StructureDefinition US Core Immunization Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-immunization|6.1.0` |
| canonicalVersion | ValueSet CVX Vaccines Administered Vaccine Set, 20250411`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.6|20250411` |
| canonicalVersion | StructureDefinition US Core Implantable Device Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|6.1.0` |
| canonicalVersion | StructureDefinition US Core Jurisdiction Extension, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-jurisdiction|6.1.0` |
| canonicalVersion | StructureDefinition US Core Location Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|6.1.0` |
| canonicalVersion | StructureDefinition US Core Medication Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication|6.1.0` |
| canonicalVersion | ValueSet Medication Clinical Drug, 20240606`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4|20240606` |
| canonicalVersion | ValueSet Medication Clinical Brand specific Drug, 20240627`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.5|20240627` |
| canonicalVersion | ValueSet Medication Clinical General Drug, 20240627`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.17|20240627` |
| canonicalVersion | StructureDefinition US Core MedicationDispense Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense|6.1.0` |
| canonicalVersion | StructureDefinition US Core MedicationRequest Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|6.1.0` |
| canonicalVersion | StructureDefinition US Core Observation Occupation Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-occupation|6.1.0` |
| canonicalVersion | StructureDefinition US Core Observation Pregnancy Intent Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancyintent|6.1.0` |
| canonicalVersion | StructureDefinition US Core Observation Pregnancy Status Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancystatus|6.1.0` |
| canonicalVersion | StructureDefinition US Core Observation Screening Assessment Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|6.1.0` |
| canonicalVersion | StructureDefinition US Core QuestionnaireResponse Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-questionnaireresponse|6.1.0` |
| canonicalVersion | StructureDefinition US Core Observation Sexual Orientation Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-sexual-orientation|6.1.0` |
| canonicalVersion | StructureDefinition US Core Provenance Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance|6.1.0` |
| canonicalVersion | StructureDefinition US Core Pulse Oximetry Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-pulse-oximetry|6.1.0` |
| canonicalVersion | StructureDefinition US Core Respiratory Rate Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-respiratory-rate|6.1.0` |
| canonicalVersion | StructureDefinition US Core Simple Observation Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|6.1.0` |
| canonicalVersion | StructureDefinition US Core Smoking Status Observation Profile, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|6.1.0` |
| canonicalVersion | ValueSet Smoking Status, 20240606`http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.38|20240606` |
| canonicalVersion | StructureDefinition US Core USCDI Requirement Extension, 6.1.0`http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement|6.1.0` |
| canonicalVersion | CapabilityStatement US Core Client CapabilityStatement, 6.1.0`http://hl7.org/fhir/us/core/CapabilityStatement/us-core-client|6.1.0` |
| canonicalVersion | CapabilityStatement US Core Server CapabilityStatement, 6.1.0`http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server|6.1.0` |
| canonicalVersion | OperationDefinition US Core Fetch DocumentReference, 6.1.0`http://hl7.org/fhir/us/core/OperationDefinition/docref|6.1.0` |
| canonicalVersion | SearchParameter USCoreAllergyintoleranceClinicalStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-clinical-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreAllergyintolerancePatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreCareplanCategory, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-category|6.1.0` |
| canonicalVersion | SearchParameter USCoreCareplanDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreCareplanPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreCareplanStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreCareteamPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreCareTeamRole, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-role|6.1.0` |
| canonicalVersion | SearchParameter USCoreCareteamStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreConditionAbatementDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-abatement-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreConditionAssertedDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-asserted-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreConditionCategory, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-category|6.1.0` |
| canonicalVersion | SearchParameter USCoreConditionClinicalStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-clinical-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreConditionCode, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-code|6.1.0` |
| canonicalVersion | SearchParameter USCoreConditionEncounter, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-encounter|6.1.0` |
| canonicalVersion | SearchParameter USCoreConditionOnsetDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-onset-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreConditionPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreConditionRecordedDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-recorded-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreCoveragePatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-coverage-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreDevicePatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-device-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreDeviceStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-device-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreDeviceType, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-device-type|6.1.0` |
| canonicalVersion | SearchParameter USCoreDiagnosticreportCategory, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-category|6.1.0` |
| canonicalVersion | SearchParameter USCoreDiagnosticreportCode, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-code|6.1.0` |
| canonicalVersion | SearchParameter USCoreDiagnosticreportDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreDiagnosticreportPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreDiagnosticreportStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreDocumentreferenceCategory, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-category|6.1.0` |
| canonicalVersion | SearchParameter USCoreDocumentreferenceDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreDocumentreferenceId, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-id|6.1.0` |
| canonicalVersion | SearchParameter USCoreDocumentreferencePatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreDocumentreferencePeriod, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-period|6.1.0` |
| canonicalVersion | SearchParameter USCoreDocumentreferenceStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreDocumentreferenceType, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-type|6.1.0` |
| canonicalVersion | SearchParameter USCoreEncounterClass, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-class|6.1.0` |
| canonicalVersion | SearchParameter USCoreEncounterDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreEncounterDischargeDisposition, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-discharge-disposition|6.1.0` |
| canonicalVersion | SearchParameter USCoreEncounterId, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-id|6.1.0` |
| canonicalVersion | SearchParameter USCoreEncounterIdentifier, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-identifier|6.1.0` |
| canonicalVersion | SearchParameter USCoreEncounterLocation, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-location|6.1.0` |
| canonicalVersion | SearchParameter USCoreEncounterPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreEncounterStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreEncounterType, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-type|6.1.0` |
| canonicalVersion | SearchParameter USCoreEthnicity, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-ethnicity|6.1.0` |
| canonicalVersion | SearchParameter USCoreGoalDescription, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-description|6.1.0` |
| canonicalVersion | SearchParameter USCoreGoalLifecycleStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-lifecycle-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreGoalPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreGoalTargetDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-target-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreImmunizationDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreImmunizationPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreImmunizationStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreLocationAddressCity, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-city|6.1.0` |
| canonicalVersion | SearchParameter USCoreLocationAddressPostalcode, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-postalcode|6.1.0` |
| canonicalVersion | SearchParameter USCoreLocationAddressState, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-state|6.1.0` |
| canonicalVersion | SearchParameter USCoreLocationAddress, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address|6.1.0` |
| canonicalVersion | SearchParameter USCoreLocationName, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-location-name|6.1.0` |
| canonicalVersion | SearchParameter USCoreMedicationdispensePatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreMedicationdispenseStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreMedicationdispenseType, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-type|6.1.0` |
| canonicalVersion | SearchParameter USCoreMedicationrequestAuthoredon, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-authoredon|6.1.0` |
| canonicalVersion | SearchParameter USCoreMedicationrequestEncounter, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-encounter|6.1.0` |
| canonicalVersion | SearchParameter USCoreMedicationrequestIntent, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-intent|6.1.0` |
| canonicalVersion | SearchParameter USCoreMedicationrequestPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreMedicationrequestStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreObservationCategory, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-category|6.1.0` |
| canonicalVersion | SearchParameter USCoreObservationCode, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-code|6.1.0` |
| canonicalVersion | SearchParameter USCoreObservationDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreObservationPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreObservationStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreOrganizationAddress, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-address|6.1.0` |
| canonicalVersion | SearchParameter USCoreOrganizationName, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-name|6.1.0` |
| canonicalVersion | SearchParameter USCorePatientBirthdate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-birthdate|6.1.0` |
| canonicalVersion | SearchParameter USCorePatientDeathDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-death-date|6.1.0` |
| canonicalVersion | SearchParameter USCorePatientFamily, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-family|6.1.0` |
| canonicalVersion | SearchParameter USCorePatientGenderIdentity, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender-identity|6.1.0` |
| canonicalVersion | SearchParameter USCorePatientGender, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender|6.1.0` |
| canonicalVersion | SearchParameter USCorePatientGiven, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-given|6.1.0` |
| canonicalVersion | SearchParameter USCorePatientId, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-id|6.1.0` |
| canonicalVersion | SearchParameter USCorePatientIdentifier, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-identifier|6.1.0` |
| canonicalVersion | SearchParameter USCorePatientName, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-name|6.1.0` |
| canonicalVersion | SearchParameter USCorePractitionerId, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-id|6.1.0` |
| canonicalVersion | SearchParameter USCorePractitionerIdentifier, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-identifier|6.1.0` |
| canonicalVersion | SearchParameter USCorePractitionerName, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-name|6.1.0` |
| canonicalVersion | SearchParameter USCorePractitionerrolePractitioner, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-practitioner|6.1.0` |
| canonicalVersion | SearchParameter USCorePractitionerroleSpecialty, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-specialty|6.1.0` |
| canonicalVersion | SearchParameter USCoreProcedureCode, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-code|6.1.0` |
| canonicalVersion | SearchParameter USCoreProcedureDate, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-date|6.1.0` |
| canonicalVersion | SearchParameter USCoreProcedurePatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreProcedureStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreQuestionnaireresponseAuthored, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-authored|6.1.0` |
| canonicalVersion | SearchParameter USCoreQuestionnaireresponseId, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-id|6.1.0` |
| canonicalVersion | SearchParameter USCoreQuestionnaireresponsePatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreQuestionnaireresponseQuestionnaire, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-questionnaire|6.1.0` |
| canonicalVersion | SearchParameter USCoreQuestionnaireresponseStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreRace, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-race|6.1.0` |
| canonicalVersion | SearchParameter USCoreRelatedpersonId, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-id|6.1.0` |
| canonicalVersion | SearchParameter USCoreRelatedpersonName, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-name|6.1.0` |
| canonicalVersion | SearchParameter USCoreRelatedpersonPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreServicerequestAuthored, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-authored|6.1.0` |
| canonicalVersion | SearchParameter USCoreServicerequestCategory, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-category|6.1.0` |
| canonicalVersion | SearchParameter USCoreServicerequestCode, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-code|6.1.0` |
| canonicalVersion | SearchParameter USCoreServicerequestId, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-id|6.1.0` |
| canonicalVersion | SearchParameter USCoreServicerequestPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-patient|6.1.0` |
| canonicalVersion | SearchParameter USCoreServicerequestStatus, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-status|6.1.0` |
| canonicalVersion | SearchParameter USCoreSpecimenId, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-id|6.1.0` |
| canonicalVersion | SearchParameter USCoreSpecimenPatient, 6.1.0`http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-patient|6.1.0` |

* Metadata: Input Parameters
* Metadata: 
  * ?: 
| | |
| :--- | :--- |
| **Name** | **Value** |
| system-version | SNOMEDCT, 2024-09`http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20240901` |
| system-version | ActCode, 9.0.0[ActCodeversion: null9.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html) |
| system-version | CDCREC, 1.2`urn:oid:2.16.840.1.113883.6.238|1.2` |
| system-version | CDT, 2023`http://www.ada.org/cdt|2023` |
| system-version | CPT, 2025`http://www.ama-assn.org/go/cpt|2025` |
| system-version | CVX, 2024-12-16`http://hl7.org/fhir/sid/cvx|20241216` |
| system-version | DataAbsentReason, 1.0.0[DataAbsentReasonversion: null1.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html) |
| system-version | HCPCS, 2025`http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets|2025` |
| system-version | HSLOC, 2022`https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html|2022` |
| system-version | ICD10CM, 2025`http://hl7.org/fhir/sid/icd-10-cm|2025` |
| system-version | ICD10PCS, 2025`http://www.cms.gov/Medicare/Coding/ICD10|2025` |
| system-version | ICD9CM, 2013`http://hl7.org/fhir/sid/icd-9-cm|2013` |
| system-version | LOINC, 2.78`http://loinc.org|2.78` |
| system-version | PresentOnAdmission, 2021`https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/HospitalAcqCond/Coding|2021` |
| system-version | RXNORM, 2025-01`http://www.nlm.nih.gov/research/umls/rxnorm|01062025` |
| system-version | SOP, 9.2`https://nahdo.org/sopt|9.2` |
| system-version | Task Codes, 4.0.1[Task Codesversion: null4.0.1)](http://hl7.org/fhir/R4/codesystem-task-code.html) |
| system-version | US Core Condition Category Extension Codes, 6.1.0`http://hl7.org/fhir/us/core/CodeSystem/condition-category|6.1.0` |
| system-version | AllergyIntolerance Clinical Status Codes, 1.0.0[AllergyIntolerance Clinical Status Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-allergyintolerance-clinical.html) |
| system-version | AllergyIntolerance Verification Status, 1.0.0[AllergyIntolerance Verification Statusversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-allergyintolerance-verification.html) |
| system-version | Condition Clinical Status Codes, 3.0.0[Condition Clinical Status Codesversion: null3.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html) |
| system-version | Condition Verification Status, 2.0.0[ConditionVerificationStatusversion: null2.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-condition-ver-status.html) |
| system-version | Diagnosis Role, 1.1.0[Diagnosis Roleversion: null1.1.0)](http://terminology.hl7.org/5.5.0/CodeSystem-diagnosis-role.html) |
| system-version | Example Diagnosis Type Codes, 1.0.0[Example Diagnosis Type Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-ex-diagnosistype.html) |
| system-version | Example Procedure Type Codes, 1.0.0[Example Procedure Type Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-ex-procedure-type.html) |
| system-version | Medication Request Category Codes, 1.0.0[MedicationRequest Category Codesversion: null1.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-medicationrequest-category.html) |
| system-version | Observation Category Codes, 1.0.0[Observation Category Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-observation-category.html) |

* Metadata: Generated using version 0.5.3-cibuild of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "uscore-vsp-6-1-0-release",
  "meta" : {
    "versionId" : "4",
    "lastUpdated" : "2025-10-14T14:23:42.281-06:00",
    "profile" : [
      "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-manifestlibrary"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Parameters",
      "id" : "exp-params",
      "parameter" : [
        {
          "name" : "system-version",
          "valueCanonical" : "http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20240901",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SNOMEDCT, 2024-09"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/v3-ActCode|9.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ActCode, 9.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "urn:oid:2.16.840.1.113883.6.238|1.2",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CDCREC, 1.2"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.ada.org/cdt|2023",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CDT, 2023"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.ama-assn.org/go/cpt|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CPT, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/cvx|20241216",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CVX, 2024-12-16"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/data-absent-reason|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "DataAbsentReason, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "HCPCS, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html|2022",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "HSLOC, 2022"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/icd-10-cm|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ICD10CM, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.cms.gov/Medicare/Coding/ICD10|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ICD10PCS, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/icd-9-cm|2013",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ICD9CM, 2013"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://loinc.org|2.78",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "LOINC, 2.78"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/HospitalAcqCond/Coding|2021",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "PresentOnAdmission, 2021"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.nlm.nih.gov/research/umls/rxnorm|01062025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "RXNORM, 2025-01"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://nahdo.org/sopt|9.2",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SOP, 9.2"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/CodeSystem/task-code|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Task Codes, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "US Core Condition Category Extension Codes, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "AllergyIntolerance Clinical Status Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "AllergyIntolerance Verification Status, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/condition-clinical|3.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Condition Clinical Status Codes, 3.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/condition-ver-status|2.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Condition Verification Status, 2.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/diagnosis-role|1.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Diagnosis Role, 1.1.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/ex-diagnosistype|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Example Diagnosis Type Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/ex-procedure-type|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Example Procedure Type Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Medication Request Category Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/observation-category|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Observation Category Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/head-occipital-frontal-circumference-percentile|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Pediatric Head Occipital Frontal Circumference Percentile Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-vital-signs|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Vital Signs Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Patient Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/Patient|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition Patient, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/DomainResource|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition DomainResource, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/Resource|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition Resource, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Race Extension, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/Extension|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition Extension, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/Element|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition Element, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Ethnicity Extension, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Tribal Affiliation Extension, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Birth Sex Extension, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-sex|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Sex Extension, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.3|20230628",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Sex, 20230628"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.53|20240217",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Sex, 20240217"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.4|20230628",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Asked Declined Data Absent Reason, 20230628"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-genderIdentity|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Gender Identity Extension, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.32|20240215",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Gender Identity, 20240215"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.101|20240215",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Gender Identity SCT, 20240215"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.10|20231129",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Other Unknown Nulls, 20231129"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor|3.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CodeSystem NullFlavor, 3.0.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/pediatric-bmi-for-age|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Pediatric BMI for Age Observation Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/pediatric-weight-for-height|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Pediatric Weight for Height Observation Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core AllergyIntolerance Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.8|20240625",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Common substances for allergy and intolerance documentation including refutations, 20240625"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1114.14|20250723",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Medication drug class for allergen intolerance SCT, 20250723"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.5|20240606",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Common refutations for substance causes for allergy and intolerance documentation, 20240606"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.4|20240606",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Common environmental substances for allergy and intolerance documentation, 20240606"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.1|20240625",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Common drug substances for allergy and intolerance documentation, 20240625"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.3|20240625",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Common dietary substances for allergy and intolerance documentation, 20240625"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-blood-pressure|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Blood Pressure Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-bmi|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core BMI Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-height|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Body Height Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-temperature|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Body Temperature Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-weight|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Body Weight Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core CarePlan Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core CareTeam Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30|20240605",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Care Team Member Function, 20240605"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.10267|20240605",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet ParticipationFunction, 20240605"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction|3.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CodeSystem ParticipationFunction, 3.0.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.27|20230706",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Care Team Member Function (SNOMEDCT), 20230706"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Practitioner Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Organization Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core PractitionerRole Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066|20240606",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Healthcare Provider Taxonomy, 20240606"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://nucc.org/provider-taxonomy|24.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CodeSystem NUCC Provider Taxonomy, 24.1"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core RelatedPerson Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Condition Encounter Diagnosis Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition Condition Asserted Date, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Encounter Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Condition Problems and Health Concerns Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Procedure Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core ServiceRequest Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/Observation|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition Observation, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/SimpleQuantity|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition SimpleQuantity, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/Quantity|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition Quantity, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Coverage Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591|20250419",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Payer Type, 20250419"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core DiagnosticReport Profile for Laboratory Results Reporting, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Laboratory Result Observation Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Observation Clinical Result Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-specimen|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Specimen Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.54|20240606",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Specimen type, 20240606"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core DiagnosticReport Profile for Report and Note Exchange, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-direct|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Direct email Extension, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core DocumentReference Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-extension-questionnaire-uri|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Extension Questionnaire URI, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Goal Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-head-circumference|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Head Circumference Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-heart-rate|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Heart Rate Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-immunization|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Immunization Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.6|20250411",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet CVX Vaccines Administered Vaccine Set, 20250411"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Implantable Device Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-jurisdiction|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Jurisdiction Extension, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Location Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Medication Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4|20240606",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Medication Clinical Drug, 20240606"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.5|20240627",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Medication Clinical Brand specific Drug, 20240627"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.17|20240627",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Medication Clinical General Drug, 20240627"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core MedicationDispense Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core MedicationRequest Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-occupation|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Observation Occupation Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancyintent|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Observation Pregnancy Intent Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancystatus|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Observation Pregnancy Status Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Observation Screening Assessment Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-questionnaireresponse|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core QuestionnaireResponse Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-sexual-orientation|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Observation Sexual Orientation Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Provenance Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-pulse-oximetry|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Pulse Oximetry Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-respiratory-rate|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Respiratory Rate Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Simple Observation Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core Smoking Status Observation Profile, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.38|20240606",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "ValueSet"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ValueSet Smoking Status, 20240606"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "StructureDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "StructureDefinition US Core USCDI Requirement Extension, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/CapabilityStatement/us-core-client|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "CapabilityStatement"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CapabilityStatement US Core Client CapabilityStatement, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "CapabilityStatement"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CapabilityStatement US Core Server CapabilityStatement, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/OperationDefinition/docref|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "OperationDefinition"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "OperationDefinition US Core Fetch DocumentReference, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-clinical-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreAllergyintoleranceClinicalStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreAllergyintolerancePatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-category|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreCareplanCategory, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreCareplanDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreCareplanPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreCareplanStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreCareteamPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-role|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreCareTeamRole, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreCareteamStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-abatement-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreConditionAbatementDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-asserted-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreConditionAssertedDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-category|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreConditionCategory, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-clinical-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreConditionClinicalStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-code|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreConditionCode, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-encounter|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreConditionEncounter, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-onset-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreConditionOnsetDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreConditionPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-recorded-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreConditionRecordedDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-coverage-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreCoveragePatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-device-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDevicePatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-device-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDeviceStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-device-type|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDeviceType, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-category|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDiagnosticreportCategory, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-code|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDiagnosticreportCode, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDiagnosticreportDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDiagnosticreportPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDiagnosticreportStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-category|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDocumentreferenceCategory, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDocumentreferenceDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-id|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDocumentreferenceId, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDocumentreferencePatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-period|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDocumentreferencePeriod, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDocumentreferenceStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-type|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreDocumentreferenceType, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-class|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEncounterClass, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEncounterDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-discharge-disposition|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEncounterDischargeDisposition, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-id|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEncounterId, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-identifier|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEncounterIdentifier, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-location|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEncounterLocation, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEncounterPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEncounterStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-type|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEncounterType, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-ethnicity|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreEthnicity, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-description|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreGoalDescription, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-lifecycle-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreGoalLifecycleStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreGoalPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-target-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreGoalTargetDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreImmunizationDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreImmunizationPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreImmunizationStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-city|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreLocationAddressCity, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-postalcode|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreLocationAddressPostalcode, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-state|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreLocationAddressState, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreLocationAddress, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-name|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreLocationName, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreMedicationdispensePatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreMedicationdispenseStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-type|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreMedicationdispenseType, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-authoredon|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreMedicationrequestAuthoredon, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-encounter|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreMedicationrequestEncounter, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-intent|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreMedicationrequestIntent, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreMedicationrequestPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreMedicationrequestStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-category|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreObservationCategory, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-code|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreObservationCode, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreObservationDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreObservationPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreObservationStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-address|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreOrganizationAddress, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-name|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreOrganizationName, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-birthdate|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePatientBirthdate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-death-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePatientDeathDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-family|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePatientFamily, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender-identity|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePatientGenderIdentity, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePatientGender, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-given|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePatientGiven, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-id|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePatientId, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-identifier|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePatientIdentifier, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-name|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePatientName, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-id|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePractitionerId, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-identifier|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePractitionerIdentifier, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-name|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePractitionerName, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-practitioner|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePractitionerrolePractitioner, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-specialty|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCorePractitionerroleSpecialty, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-code|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreProcedureCode, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-date|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreProcedureDate, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreProcedurePatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreProcedureStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-authored|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreQuestionnaireresponseAuthored, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-id|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreQuestionnaireresponseId, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreQuestionnaireresponsePatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-questionnaire|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreQuestionnaireresponseQuestionnaire, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreQuestionnaireresponseStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-race|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreRace, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-id|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreRelatedpersonId, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-name|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreRelatedpersonName, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreRelatedpersonPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-authored|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreServicerequestAuthored, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-category|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreServicerequestCategory, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-code|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreServicerequestCode, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-id|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreServicerequestId, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreServicerequestPatient, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-status|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreServicerequestStatus, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-id|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreSpecimenId, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "canonicalVersion",
          "valueCanonical" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-patient|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
                "valueCode" : "SearchParameter"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SearchParameter USCoreSpecimenPatient, 6.1.0"
              }
            ]
          }
        }
      ]
    },
    {
      "resourceType" : "Parameters",
      "id" : "endpoints",
      "parameter" : [
        {
          "name" : "artifactEndpointConfiguration",
          "part" : [
            {
              "name" : "artifactRoute",
              "valueUri" : "http://cts.nlm.nih.gov/fhir/"
            },
            {
              "name" : "endpointUri",
              "valueUri" : "https://cts.nlm.nih.gov/fhir/"
            }
          ]
        },
        {
          "name" : "artifactEndpointConfiguration",
          "part" : [
            {
              "name" : "artifactRoute",
              "valueUri" : "http://terminology.hl7.org/"
            },
            {
              "name" : "endpointUri",
              "valueUri" : "https://tx.fhir.org/r4/"
            }
          ]
        },
        {
          "name" : "artifactEndpointConfiguration",
          "part" : [
            {
              "name" : "artifactRoute",
              "valueUri" : "http://hl7.org/fhir/"
            },
            {
              "name" : "endpointUri",
              "valueUri" : "https://tx.fhir.org/r4/"
            }
          ]
        }
      ]
    },
    {
      "resourceType" : "Parameters",
      "id" : "input-exp-params",
      "parameter" : [
        {
          "name" : "system-version",
          "valueCanonical" : "http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20240901",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SNOMEDCT, 2024-09"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/v3-ActCode|9.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ActCode, 9.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "urn:oid:2.16.840.1.113883.6.238|1.2",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CDCREC, 1.2"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.ada.org/cdt|2023",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CDT, 2023"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.ama-assn.org/go/cpt|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CPT, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/cvx|20241216",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CVX, 2024-12-16"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/data-absent-reason|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "DataAbsentReason, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "HCPCS, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html|2022",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "HSLOC, 2022"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/icd-10-cm|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ICD10CM, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.cms.gov/Medicare/Coding/ICD10|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ICD10PCS, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/icd-9-cm|2013",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ICD9CM, 2013"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://loinc.org|2.78",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "LOINC, 2.78"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/HospitalAcqCond/Coding|2021",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "PresentOnAdmission, 2021"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.nlm.nih.gov/research/umls/rxnorm|01062025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "RXNORM, 2025-01"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://nahdo.org/sopt|9.2",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SOP, 9.2"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/CodeSystem/task-code|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Task Codes, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "US Core Condition Category Extension Codes, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "AllergyIntolerance Clinical Status Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "AllergyIntolerance Verification Status, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/condition-clinical|3.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Condition Clinical Status Codes, 3.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/condition-ver-status|2.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Condition Verification Status, 2.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/diagnosis-role|1.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Diagnosis Role, 1.1.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/ex-diagnosistype|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Example Diagnosis Type Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/ex-procedure-type|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Example Procedure Type Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Medication Request Category Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/observation-category|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Observation Category Codes, 1.0.0"
              }
            ]
          }
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters",
      "valueReference" : {
        "reference" : "#exp-params"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-endpointConfiguration",
      "valueReference" : {
        "reference" : "#endpoints"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-inputParameters",
      "valueReference" : {
        "reference" : "#input-exp-params"
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core-vsp/6.1.0/Library/hl7.fhir.us.core-vsp-6-1-0-release",
  "version" : "2025-09",
  "name" : "USCore610ValueSetPackageDefinition",
  "title" : "US Core 6.1.0 Draft Value Set Package Definition",
  "status" : "active",
  "experimental" : true,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "asset-collection"
      }
    ]
  },
  "date" : "2025-10-14T14:22:31-06:00",
  "publisher" : "Clinical Quality Framework",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://cqframework.org"
        }
      ]
    }
  ],
  "description" : "This is a released Value Set Refresh Package for the US Core 6.1.0 implementation guide. It contains expansions of any value sets defined or used in the US Core 6.1.0 implementation guide, but refreshed using the code systems versions specified in the input expansion parameters",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "approvalDate" : "2025-09-23",
  "lastReviewDate" : "2025-09-23",
  "relatedArtifact" : [
    {
      "type" : "composed-of",
      "display" : "ImplementationGuide US Core Implementation Guide, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core|6.1.0"
    },
    {
      "type" : "depends-on",
      "display" : "ImplementationGuide US Core Implementation Guide, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ImplementationGuide"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/CodeSystem/careplan-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "CodeSystem US Core Condition Category Extension Codes, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-provenance-participant-type",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/vitalsigns",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-vital-signs",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/languages",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition Resource, 4.0.1",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Resource|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition DomainResource, 4.0.1",
      "resource" : "http://hl7.org/fhir/StructureDefinition/DomainResource|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/shareablevalueset",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/administrative-gender",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet AdministrativeGender, 4.0.1",
      "resource" : "http://hl7.org/fhir/ValueSet/administrative-gender|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/marital-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/patient-contactrelationship",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Organization",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Practitioner",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition Patient, 4.0.1",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Patient|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/link-type",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet LinkType, 4.0.1",
      "resource" : "http://hl7.org/fhir/ValueSet/link-type|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition Element, 4.0.1",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Element|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition Extension, 4.0.1",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Extension|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/omb-race-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/detailed-race",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Race Extension, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/omb-ethnicity-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/detailed-ethnicity",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Ethnicity Extension, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://terminology.hl7.org/ValueSet/v3-TribalEntityUS",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Tribal Affiliation Extension, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/birthsex",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Birth Sex Extension, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/computable-valueset-cqfm",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/publishable-valueset-cqfm",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20240901",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Sex, 20240217",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.53|20240217",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://terminology.hl7.org/CodeSystem/data-absent-reason|1.0.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Asked Declined Data Absent Reason, 20230628",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.4|20230628",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Sex, 20230628",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.3|20230628",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Sex Extension, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-sex|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Gender Identity SCT, 20240215",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.101|20240215",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/shareablecodesystem",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/publishable-codesystem-cqfm",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "CodeSystem NullFlavor, 3.0.0",
      "resource" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor|3.0.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Other Unknown Nulls, 20231129",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1240.10|20231129",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Gender Identity, 20240215",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1021.32|20240215",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Gender Identity Extension, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-genderIdentity|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/contact-point-system",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/contact-point-use",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-usps-state",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/simple-language",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Patient Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/ucum-vitals-common|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Vital Signs Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-vital-signs|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Pediatric Head Occipital Frontal Circumference Percentile Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/head-occipital-frontal-circumference-percentile|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Pediatric BMI for Age Observation Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/pediatric-bmi-for-age|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Pediatric Weight for Height Observation Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/pediatric-weight-for-height|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/allergyintolerance-clinical",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/allergyintolerance-verification",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Medication drug class for allergen intolerance SCT, 20250723",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1114.14|20250723",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Common refutations for substance causes for allergy and intolerance documentation, 20240606",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.5|20240606",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Common environmental substances for allergy and intolerance documentation, 20240606",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.4|20240606",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://www.nlm.nih.gov/research/umls/rxnorm|01062025",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Common drug substances for allergy and intolerance documentation, 20240625",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.1|20240625",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Common dietary substances for allergy and intolerance documentation, 20240625",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.3|20240625",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Common substances for allergy and intolerance documentation including refutations, 20240625",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1186.8|20240625",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/clinical-findings",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core AllergyIntolerance Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Blood Pressure Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-blood-pressure|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core BMI Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-bmi|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/ucum-bodylength|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Body Height Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-height|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/ucum-bodytemp|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Body Temperature Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-temperature|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/ucum-bodyweight|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Body Weight Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-weight|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/CarePlan",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-narrative-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/request-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/care-plan-intent",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core CarePlan Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/CareTeam",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/care-team-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "CodeSystem ParticipationFunction, 3.0.0",
      "resource" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationFunction|3.0.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet ParticipationFunction, 20240605",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.1.11.10267|20240605",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Care Team Member Function (SNOMEDCT), 20230706",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.27|20230706",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Care Team Member Function, 20240605",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30|20240605",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Practitioner Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Organization Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "CodeSystem NUCC Provider Taxonomy, 24.1",
      "resource" : "http://nucc.org/provider-taxonomy|24.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Healthcare Provider Taxonomy, 20240606",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066|20240606",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core PractitionerRole Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core CareTeam Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core RelatedPerson Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Condition",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition Condition Asserted Date, 1.0.0",
      "resource" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate|1.0.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/condition-clinical",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/condition-ver-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Encounter",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-encounter-type",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-problem-or-health-concern",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-screening-assessment-condition-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Condition Problems and Health Concerns Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Condition Encounter Diagnosis Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Procedure",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/ServiceRequest",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-servicerequest-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-procedure-code",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Device",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core ServiceRequest Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/event-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Procedure Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/NutritionOrder",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Immunization",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/ImagingStudy",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/observation-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet ObservationStatus, 4.0.1",
      "resource" : "http://hl7.org/fhir/ValueSet/observation-status|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/observation-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/observation-codes",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Group",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Location",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/data-absent-reason",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/observation-interpretation",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/body-site",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/observation-methods",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Specimen",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/DeviceMetric",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/quantity-comparator",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet QuantityComparator, 4.0.1",
      "resource" : "http://hl7.org/fhir/ValueSet/quantity-comparator|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition Quantity, 4.0.1",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Quantity|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition SimpleQuantity, 4.0.1",
      "resource" : "http://hl7.org/fhir/StructureDefinition/SimpleQuantity|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/referencerange-meaning",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/referencerange-appliesto",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition Observation, 4.0.1",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Observation|4.0.1",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/MolecularSequence",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/DocumentReference",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Media",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-discharge-disposition",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Encounter Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Coverage",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "https://nahdo.org/sopt|9.2",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Payer Type, 20250419",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.3591|20250419",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/subscriber-relationship",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Coverage Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/diagnostic-report-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-laboratory-test-codes",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-result-observation-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Observation Clinical Result Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Specimen type, 20240606",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.54|20240606",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Specimen Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-specimen|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Laboratory Result Observation Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core DiagnosticReport Profile for Laboratory Results Reporting, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-diagnosticreport-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-diagnosticreport-report-and-note-codes",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core DiagnosticReport Profile for Report and Note Exchange, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Direct email Extension, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-direct|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/document-reference-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-type",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-documentreference-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/formatcodes",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core DocumentReference Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Extension Questionnaire URI, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-extension-questionnaire-uri|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Goal",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/goal-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-goal-description",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Goal Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Head Circumference Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-head-circumference|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Heart Rate Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-heart-rate|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/immunization-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/immunization-status-reason",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/sid/cvx|20241216",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CodeSystem"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet CVX Vaccines Administered Vaccine Set, 20250411",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.6|20250411",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Immunization Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-immunization|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/device-kind",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Implantable Device Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Jurisdiction Extension, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-jurisdiction|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Location Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Medication",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Medication Clinical Brand specific Drug, 20240627",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.5|20240627",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Medication Clinical General Drug, 20240627",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.17|20240627",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Medication Clinical Drug, 20240606",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4|20240606",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Medication Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/medicationrequest-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/medicationrequest-intent",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/medicationrequest-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/ValueSet/ucum-common",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core MedicationRequest Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://terminology.hl7.org/ValueSet/v3-ActPharmacySupplyType",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core MedicationDispense Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7901",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://phinvads.cdc.gov/fhir/ValueSet/2.16.840.1.114222.4.11.7900",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Observation Occupation Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-occupation|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-pregnancy-intent",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Observation Pregnancy Intent Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancyintent|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-pregnancy-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Observation Pregnancy Status Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancystatus|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-screening-assessment-observation-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-survey-codes",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Observation Screening Assessment Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core QuestionnaireResponse Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-questionnaireresponse|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-sexual-orientation",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Observation Sexual Orientation Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-sexual-orientation|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/StructureDefinition/Provenance",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-provenance-participant-type",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Provenance Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-provenance|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Pulse Oximetry Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-pulse-oximetry|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Respiratory Rate Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-respiratory-rate|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-simple-observation-category",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Simple Observation Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-observation-smoking-status-status",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-smoking-status-observation-codes",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "ValueSet Smoking Status, 20240606",
      "resource" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.11.20.9.38|20240606",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core Smoking Status Observation Profile, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "StructureDefinition US Core USCDI Requirement Extension, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "StructureDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-note-type",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-observation-smokingstatus-max",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/us-core-observation-value-codes",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "resource" : "http://hl7.org/fhir/us/core/ValueSet/simple-observation",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "ValueSet"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "CapabilityStatement US Core Client CapabilityStatement, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/CapabilityStatement/us-core-client|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CapabilityStatement"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "CapabilityStatement US Core Server CapabilityStatement, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "CapabilityStatement"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "OperationDefinition US Core Fetch DocumentReference, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/OperationDefinition/docref|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "OperationDefinition"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreAllergyintoleranceClinicalStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-clinical-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreAllergyintolerancePatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-allergyintolerance-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreCareplanCategory, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-category|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreCareplanDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreCareplanPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreCareplanStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careplan-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreCareteamPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreCareTeamRole, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-role|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreCareteamStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-careteam-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreConditionAbatementDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-abatement-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreConditionAssertedDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-asserted-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreConditionCategory, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-category|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreConditionClinicalStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-clinical-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreConditionCode, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-code|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreConditionEncounter, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-encounter|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreConditionOnsetDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-onset-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreConditionPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreConditionRecordedDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-condition-recorded-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreCoveragePatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-coverage-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDevicePatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-device-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDeviceStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-device-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDeviceType, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-device-type|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDiagnosticreportCategory, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-category|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDiagnosticreportCode, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-code|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDiagnosticreportDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDiagnosticreportPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDiagnosticreportStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-diagnosticreport-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDocumentreferenceCategory, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-category|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDocumentreferenceDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDocumentreferenceId, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-id|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDocumentreferencePatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDocumentreferencePeriod, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-period|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDocumentreferenceStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreDocumentreferenceType, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-documentreference-type|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEncounterClass, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-class|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEncounterDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEncounterDischargeDisposition, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-discharge-disposition|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEncounterId, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-id|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEncounterIdentifier, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-identifier|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEncounterLocation, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-location|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEncounterPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEncounterStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEncounterType, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-encounter-type|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreEthnicity, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-ethnicity|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreGoalDescription, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-description|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreGoalLifecycleStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-lifecycle-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreGoalPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreGoalTargetDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-goal-target-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreImmunizationDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreImmunizationPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreImmunizationStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-immunization-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreLocationAddressCity, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-city|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreLocationAddressPostalcode, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-postalcode|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreLocationAddressState, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address-state|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreLocationAddress, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-address|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreLocationName, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-location-name|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreMedicationdispensePatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreMedicationdispenseStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreMedicationdispenseType, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationdispense-type|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreMedicationrequestAuthoredon, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-authoredon|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreMedicationrequestEncounter, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-encounter|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreMedicationrequestIntent, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-intent|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreMedicationrequestPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreMedicationrequestStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-medicationrequest-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreObservationCategory, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-category|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreObservationCode, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-code|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreObservationDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreObservationPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreObservationStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-observation-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreOrganizationAddress, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-address|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreOrganizationName, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-organization-name|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePatientBirthdate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-birthdate|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePatientDeathDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-death-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePatientFamily, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-family|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePatientGenderIdentity, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender-identity|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePatientGender, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-gender|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePatientGiven, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-given|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePatientId, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-id|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePatientIdentifier, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-identifier|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePatientName, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-patient-name|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePractitionerId, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-id|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePractitionerIdentifier, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-identifier|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePractitionerName, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitioner-name|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePractitionerrolePractitioner, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-practitioner|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCorePractitionerroleSpecialty, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-practitionerrole-specialty|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreProcedureCode, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-code|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreProcedureDate, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-date|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreProcedurePatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreProcedureStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-procedure-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreQuestionnaireresponseAuthored, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-authored|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreQuestionnaireresponseId, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-id|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreQuestionnaireresponsePatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreQuestionnaireresponseQuestionnaire, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-questionnaire|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreQuestionnaireresponseStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-questionnaireresponse-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreRace, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-race|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreRelatedpersonId, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-id|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreRelatedpersonName, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-name|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreRelatedpersonPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-relatedperson-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreServicerequestAuthored, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-authored|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreServicerequestCategory, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-category|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreServicerequestCode, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-code|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreServicerequestId, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-id|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreServicerequestPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreServicerequestStatus, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-servicerequest-status|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreSpecimenId, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-id|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    },
    {
      "type" : "depends-on",
      "display" : "SearchParameter USCoreSpecimenPatient, 6.1.0",
      "resource" : "http://hl7.org/fhir/us/core/SearchParameter/us-core-specimen-patient|6.1.0",
      "_resource" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-resourceType",
            "valueCode" : "SearchParameter"
          }
        ]
      }
    }
  ]
}

```
