# US Core 6.1.0 Draft Value Set Package Definition - Value Set Packages v0.1.0-cibuild

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Core 6.1.0 Draft Value Set Package Definition**

## Library: US Core 6.1.0 Draft Value Set Package Definition (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/core-vsp/6.1.0/Library/hl7.fhir.us.core-vsp-6-1-0-draft | *Version*:2025-09 |
| Draft as of 2025-09-23 | *Computable Name*:USCore610ValueSetPackageDefinition |

 
This is a draft Value Set Refresh Package Definition for the US Core 6.1.0 implementation guide. It contains expansions of any value sets defined or used in the US Core 6.1.0 implementation guide, but refreshed using the code systems versions specified in the input expansion parameters. 

* Metadata: Title
  * ?: US Core 6.1.0 Draft Value Set Package Definition
* Metadata: Version
  * ?: 2025-09
* Metadata: Approval Date
  * ?: 2025-09-23
* Metadata: Last Review Date
  * ?: 2025-09-23
* Metadata: Status
  * ?: Draft
* Metadata: Experimental
  * ?: true
* Metadata: Jurisdiction
  * ?: 001 from[http://unstats.un.org/unsd/methods/m49/m49.htm](http://unstats.un.org/unsd/methods/m49/m49.htm)
* Metadata: Steward (Publisher)
  * ?: Clinical Quality Framework
* Metadata: Description
  * ?: This is a draft Value Set Refresh Package Definition for the US Core 6.1.0 implementation guide. It contains expansions of any value sets defined or used in the US Core 6.1.0 implementation guide, but refreshed using the code systems versions specified in the input expansion parameters.
* Metadata: Type
  * ?: Asset Collection
* Metadata: Component
  * ?: **Resource**:`http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core|6.1.0`**Canonical URL**:http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core|6.1.0
* Metadata: Parameters
* Metadata: Parameter
  * ?: None
* Metadata: Expansion Parameters
* Metadata: 
  * ?: 
| | |
| :--- | :--- |
| **Name** | **Value** |
| system-version | SNOMEDCT, 2024-09`http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20240901` |
| system-version | ActCode, 9.0.0[ActCodeversion: null9.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html) |
| system-version | CDCREC, 1.2`urn:oid:2.16.840.1.113883.6.238|1.2` |
| system-version | CDT, 2023`http://www.ada.org/cdt|2023` |
| system-version | CPT, 2025`http://www.ama-assn.org/go/cpt|2025` |
| system-version | CVX, 2024-12-16`http://hl7.org/fhir/sid/cvx|20241216` |
| system-version | DataAbsentReason, 1.0.0[DataAbsentReasonversion: null1.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html) |
| system-version | HCPCS, 2025`http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets|2025` |
| system-version | HSLOC, 2022`https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html|2022` |
| system-version | ICD10CM, 2025`http://hl7.org/fhir/sid/icd-10-cm|2025` |
| system-version | ICD10PCS, 2025`http://www.cms.gov/Medicare/Coding/ICD10|2025` |
| system-version | ICD9CM, 2013`http://hl7.org/fhir/sid/icd-9-cm|2013` |
| system-version | LOINC, 2.78`http://loinc.org|2.78` |
| system-version | PresentOnAdmission, 2021`https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/HospitalAcqCond/Coding|2021` |
| system-version | RXNORM, 2025-01`http://www.nlm.nih.gov/research/umls/rxnorm|01062025` |
| system-version | SOP, 9.2`https://nahdo.org/sopt|9.2` |
| system-version | Task Codes, 4.0.1[Task Codesversion: null4.0.1)](http://hl7.org/fhir/R4/codesystem-task-code.html) |
| system-version | US Core Condition Category Extension Codes, 6.1.0`http://hl7.org/fhir/us/core/CodeSystem/condition-category|6.1.0` |
| system-version | AllergyIntolerance Clinical Status Codes, 1.0.0[AllergyIntolerance Clinical Status Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-allergyintolerance-clinical.html) |
| system-version | AllergyIntolerance Verification Status, 1.0.0[AllergyIntolerance Verification Statusversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-allergyintolerance-verification.html) |
| system-version | Condition Clinical Status Codes, 3.0.0[Condition Clinical Status Codesversion: null3.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html) |
| system-version | Condition Verification Status, 2.0.0[ConditionVerificationStatusversion: null2.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-condition-ver-status.html) |
| system-version | Diagnosis Role, 1.1.0[Diagnosis Roleversion: null1.1.0)](http://terminology.hl7.org/5.5.0/CodeSystem-diagnosis-role.html) |
| system-version | Example Diagnosis Type Codes, 1.0.0[Example Diagnosis Type Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-ex-diagnosistype.html) |
| system-version | Example Procedure Type Codes, 1.0.0[Example Procedure Type Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-ex-procedure-type.html) |
| system-version | Medication Request Category Codes, 1.0.0[MedicationRequest Category Codesversion: null1.0.0)](http://terminology.hl7.org/6.5.0/CodeSystem-medicationrequest-category.html) |
| system-version | Observation Category Codes, 1.0.0[Observation Category Codesversion: null1.0.0)](http://terminology.hl7.org/5.5.0/CodeSystem-observation-category.html) |

* Metadata: Generated using version 0.5.3-cibuild of the sample-content-ig Liquid templates



## Resource Content

```json
{
  "resourceType" : "Library",
  "id" : "uscore-vsp-6-1-0-draft",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-manifestlibrary"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Parameters",
      "id" : "exp-params",
      "parameter" : [
        {
          "name" : "system-version",
          "valueCanonical" : "http://snomed.info/sct|http://snomed.info/sct/731000124108/version/20240901",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SNOMEDCT, 2024-09"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/v3-ActCode|9.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ActCode, 9.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "urn:oid:2.16.840.1.113883.6.238|1.2",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CDCREC, 1.2"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.ada.org/cdt|2023",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CDT, 2023"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.ama-assn.org/go/cpt|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CPT, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/cvx|20241216",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "CVX, 2024-12-16"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/data-absent-reason|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "DataAbsentReason, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.cms.gov/Medicare/Coding/HCPCSReleaseCodeSets|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "HCPCS, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://www.cdc.gov/nhsn/cdaportal/terminology/codesystem/hsloc.html|2022",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "HSLOC, 2022"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/icd-10-cm|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ICD10CM, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.cms.gov/Medicare/Coding/ICD10|2025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ICD10PCS, 2025"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/sid/icd-9-cm|2013",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "ICD9CM, 2013"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://loinc.org|2.78",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "LOINC, 2.78"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://www.cms.gov/Medicare/Medicare-Fee-for-Service-Payment/HospitalAcqCond/Coding|2021",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "PresentOnAdmission, 2021"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://www.nlm.nih.gov/research/umls/rxnorm|01062025",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "RXNORM, 2025-01"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "https://nahdo.org/sopt|9.2",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "SOP, 9.2"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/CodeSystem/task-code|4.0.1",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Task Codes, 4.0.1"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category|6.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "US Core Condition Category Extension Codes, 6.1.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "AllergyIntolerance Clinical Status Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "AllergyIntolerance Verification Status, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/condition-clinical|3.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Condition Clinical Status Codes, 3.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/condition-ver-status|2.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Condition Verification Status, 2.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/diagnosis-role|1.1.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Diagnosis Role, 1.1.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/ex-diagnosistype|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Example Diagnosis Type Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/ex-procedure-type|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Example Procedure Type Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Medication Request Category Codes, 1.0.0"
              }
            ]
          }
        },
        {
          "name" : "system-version",
          "valueCanonical" : "http://terminology.hl7.org/CodeSystem/observation-category|1.0.0",
          "_valueCanonical" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/display",
                "valueString" : "Observation Category Codes, 1.0.0"
              }
            ]
          }
        }
      ]
    },
    {
      "resourceType" : "Parameters",
      "id" : "endpoints",
      "parameter" : [
        {
          "name" : "artifactEndpointConfiguration",
          "part" : [
            {
              "name" : "artifactRoute",
              "valueUri" : "http://cts.nlm.nih.gov/fhir/"
            },
            {
              "name" : "endpointUri",
              "valueUri" : "https://cts.nlm.nih.gov/fhir/"
            }
          ]
        },
        {
          "name" : "artifactEndpointConfiguration",
          "part" : [
            {
              "name" : "artifactRoute",
              "valueUri" : "http://terminology.hl7.org/"
            },
            {
              "name" : "endpointUri",
              "valueUri" : "https://tx.fhir.org/r4/"
            }
          ]
        },
        {
          "name" : "artifactEndpointConfiguration",
          "part" : [
            {
              "name" : "artifactRoute",
              "valueUri" : "http://hl7.org/fhir/"
            },
            {
              "name" : "endpointUri",
              "valueUri" : "https://tx.fhir.org/r4/"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expansionParameters",
      "valueReference" : {
        "reference" : "#exp-params"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-endpointConfiguration",
      "valueReference" : {
        "reference" : "#endpoints"
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/core-vsp/6.1.0/Library/hl7.fhir.us.core-vsp-6-1-0-draft",
  "version" : "2025-09",
  "name" : "USCore610ValueSetPackageDefinition",
  "title" : "US Core 6.1.0 Draft Value Set Package Definition",
  "status" : "draft",
  "experimental" : true,
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/library-type",
        "code" : "asset-collection",
        "display" : "Asset Collection"
      }
    ]
  },
  "date" : "2025-09-23",
  "publisher" : "Clinical Quality Framework",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://cqframework.org"
        }
      ]
    }
  ],
  "description" : "This is a draft Value Set Refresh Package Definition for the US Core 6.1.0 implementation guide. It contains expansions of any value sets defined or used in the US Core 6.1.0 implementation guide, but refreshed using the code systems versions specified in the input expansion parameters.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "approvalDate" : "2025-09-23",
  "lastReviewDate" : "2025-09-23",
  "relatedArtifact" : [
    {
      "type" : "composed-of",
      "resource" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core|6.1.0"
    }
  ]
}

```
