# Home Page - Value Set Packages v0.1.0-cibuild

* [**Table of Contents**](toc.md)
* **Home Page**

## Home Page

| | |
| :--- | :--- |
| *Official URL*:http://fhir.org/guides/cqf/vsp/ImplementationGuide/fhir.cqf.vsp | *Version*:0.1.0-cibuild |
| Draft as of 2025-11-03 | *Computable Name*:VSP |

### Introduction

This implementation guide provides documentation and demonstration artifacts for Value Set Packages to enable IG/Publication authors and implementers to define and distribute updated terminology for any IG/Publication on a predictable basis.

Two primary use cases are documented:

1. Enable authors to define Value Set Packages that identify code system versions to be used to expand value sets used in the implementation guide.
1. Enable implementers to obtain Value Set Packages containing “refreshed” value sets expanded with the specified code system versions.

This capability will be provided through the use of the Value Set Manager, an existing open source implementation of the Canonical Resource Management Infrastructure (CRMI) IG that is being used to manage public health triggering value sets, as well as FHIR-based quality measure value sets.

### Overview

A **Value Set Package** is all the expanded value sets required for an implementation guide, refreshed using specified code system versions, so that implementers can obtain stable, predictable expansions that are consistent with author intent.

Value Set Packages are defined by IG/Publication authors as needed. For example, the US Core 6.1.0 Implementation Guide was initially published in June of 2023. At that time, some of the code system versions available were:

US Core 6.1.0 Initial Publication

* SNOMED, US Edition, 2023-03
* LOINC, 2.74, 2023-03
* RxNorm, 05012023, 2023-05

Since that time, many of the code systems used by value sets in the implementation guide have been updated, including at least SNOMED, LOINC, and RxNORM.

A **Value Set Package Definition** is used to specify the code system versions (i.e. input expansion parameters) to be used. For example:

US Core 6.1.0 2025 Refresh

* SNOMED, US Edition, 2025-03
* LOINC 2.80, 2025-04
* RXNORM 08042025, 2025-08
* …

This Value Set Package Definition is then **released**, a process that involves **pinning** all the dependencies used by the implementation guide. If the version of a dependency is not set by the input expansion parameters, then the latest known version is recorded.

With the released Value Set Package Definition, the Value Set Package can be **packaged** by using a terminology server to expand all the value sets using the code system versions specified in the released definition. These expanded value sets can then be provided as a Bundle.

### Contents

* **[Background](background.md)**
* **[Specification](specification.md)**
* **[Examples](examples.md)**
* **[Artifacts](artifacts.md)**
* **[Changes](changes.md)**

### Dependencies

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (fhir.cqf.vsp.r4)](package.r4.tgz) and [R4B (fhir.cqf.vsp.r4b)](package.r4b.tgz) are available.

### Global Profiles

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [LibraryType](http://terminology.hl7.org/6.5.0/CodeSystem-library-type.html): [CCDA300ValueSetPackageDefinition](Library-ccda-vsp-3-0-0-draft.md) and [USCore610ValueSetPackageDefinition](Library-uscore-vsp-6-1-0-release.md)


