# RwPatient Profile - Rwanda FHIR Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RwPatient Profile**

## Resource Profile: RwPatient Profile 

| | |
| :--- | :--- |
| *Official URL*:http://example.org/fhir/rwanda/StructureDefinition/rw-rwandacPatient | *Version*:0.1.0 |
| Draft as of 2025-10-17 | *Computable Name*:Rw-Patient |

 
Contains the base profile for a patient in the Rw FHIR implementation. This profile is used to define the structure and constraints for patient resources in the Rw system. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.rwanda.ig|current/StructureDefinition/rw-rwandacPatient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-rw-rwandacPatient.csv), [Excel](StructureDefinition-rw-rwandacPatient.xlsx), [Schematron](StructureDefinition-rw-rwandacPatient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rw-rwandacPatient",
  "url" : "http://example.org/fhir/rwanda/StructureDefinition/rw-rwandacPatient",
  "version" : "0.1.0",
  "name" : "Rw-Patient",
  "title" : "RwPatient Profile",
  "status" : "draft",
  "date" : "2025-10-17T10:49:48+00:00",
  "publisher" : "Rwanda Ministry of Health",
  "contact" : [
    {
      "name" : "Rwanda Ministry of Health",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://moh.gov.rw"
        }
      ]
    }
  ],
  "description" : "Contains the base profile for a patient in the Rw FHIR implementation. This profile is used to define the structure and constraints for patient resources in the Rw system.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.name.family",
        "path" : "Patient.name.family",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.name.given",
        "path" : "Patient.name.given",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
