# Gender ValueSet - Rwanda FHIR Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Gender ValueSet**

## ValueSet: Gender ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://example.org/fhir/rwanda/ValueSet/gender-vs | *Version*:0.1.0 |
| Draft as of 2025-10-17 | *Computable Name*:GenderVS |

 
ValueSet containing codesystem for gender 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include all codes defined in [`http://example.org/fhir/rwanda/CodeSystem/gender-cs`](CodeSystem-gender-cs.md)version 📦0.1.0

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "gender-vs",
  "url" : "http://example.org/fhir/rwanda/ValueSet/gender-vs",
  "version" : "0.1.0",
  "name" : "GenderVS",
  "title" : "Gender ValueSet",
  "status" : "draft",
  "date" : "2025-10-17T10:49:48+00:00",
  "publisher" : "Rwanda Ministry of Health",
  "contact" : [
    {
      "name" : "Rwanda Ministry of Health",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://moh.gov.rw"
        }
      ]
    }
  ],
  "description" : "ValueSet containing codesystem for gender",
  "compose" : {
    "include" : [
      {
        "system" : "http://example.org/fhir/rwanda/CodeSystem/gender-cs"
      }
    ]
  }
}

```
