/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import net.sourceforge.plantuml.klimt.Shadowable;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.USegmentType;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public enum BoxStyle {
    PLAIN(null, '\u0000', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            return URectangle.build(width, height).rounded(roundCorner);
        }
    }
    ,
    SDL_INPUT("input", '<', 10.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPolygon result = new UPolygon();
            result.addPoint(0.0, 0.0);
            result.addPoint(width + (double)DELTA_INPUT_OUTPUT, 0.0);
            result.addPoint(width, height / 2.0);
            result.addPoint(width + (double)DELTA_INPUT_OUTPUT, height);
            result.addPoint(0.0, height);
            return result;
        }
    }
    ,
    SDL_OUTPUT("output", '>', 10.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPolygon result = new UPolygon();
            result.addPoint(0.0, 0.0);
            result.addPoint(width, 0.0);
            result.addPoint(width + (double)DELTA_INPUT_OUTPUT, height / 2.0);
            result.addPoint(width, height);
            result.addPoint(0.0, height);
            return result;
        }
    }
    ,
    SDL_PROCEDURE("procedure", '|', 0.0){

        @Override
        protected void drawInternal(UGraphic ug, double width, double height, double shadowing, double roundCorner) {
            URectangle rect = URectangle.build(width, height);
            rect.setDeltaShadow(shadowing);
            ug.draw(rect);
            ULine vline = ULine.vline(height);
            ug.apply(UTranslate.dx(PADDING)).draw(vline);
            ug.apply(UTranslate.dx(width - (double)PADDING)).draw(vline);
        }
    }
    ,
    SDL_SAVE("load", '\\', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPolygon result = new UPolygon();
            result.addPoint(0.0, 0.0);
            result.addPoint(width - (double)DELTA_INPUT_OUTPUT, 0.0);
            result.addPoint(width, height);
            result.addPoint(DELTA_INPUT_OUTPUT, height);
            return result;
        }
    }
    ,
    SDL_ANTISAVE("save", '/', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPolygon result = new UPolygon();
            result.addPoint(DELTA_INPUT_OUTPUT, 0.0);
            result.addPoint(width, 0.0);
            result.addPoint(width - (double)DELTA_INPUT_OUTPUT, height);
            result.addPoint(0.0, height);
            return result;
        }
    }
    ,
    SDL_CONTINUOUS("continuous", '}', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            UPath result = UPath.none();
            double[] c1 = new double[]{DELTA_CONTINUOUS, 0.0};
            double[] c2 = new double[]{0.0, height / 2.0};
            double[] c3 = new double[]{DELTA_CONTINUOUS, height};
            result.add(c1, USegmentType.SEG_MOVETO);
            result.add(c2, USegmentType.SEG_LINETO);
            result.add(c3, USegmentType.SEG_LINETO);
            double[] c4 = new double[]{width - DELTA_CONTINUOUS, 0.0};
            double[] c5 = new double[]{width, height / 2.0};
            double[] c6 = new double[]{width - DELTA_CONTINUOUS, height};
            result.add(c4, USegmentType.SEG_MOVETO);
            result.add(c5, USegmentType.SEG_LINETO);
            result.add(c6, USegmentType.SEG_LINETO);
            return result;
        }
    }
    ,
    SDL_TASK("task", ']', 0.0){

        @Override
        protected Shadowable getShape(double width, double height, double roundCorner) {
            return URectangle.build(width, height);
        }
    };

    private final String stereotype;
    private final char style;
    private final double shield;
    private static int DELTA_INPUT_OUTPUT;
    private static double DELTA_CONTINUOUS;
    private static int PADDING;

    private BoxStyle(String stereotype, char style, double shield) {
        this.stereotype = stereotype;
        this.style = style;
        this.shield = shield;
    }

    public static BoxStyle fromString(String style) {
        if (style.length() == 1) {
            for (BoxStyle bs : BoxStyle.values()) {
                if (bs.style != style.charAt(0)) continue;
                return bs;
            }
        }
        style = style.replaceAll("\\W", "");
        for (BoxStyle bs : BoxStyle.values()) {
            if (!style.equalsIgnoreCase(bs.stereotype)) continue;
            return bs;
        }
        return PLAIN;
    }

    public final UDrawable getUDrawable(final double width, final double height, final double shadowing, final double roundCorner) {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                BoxStyle.this.drawInternal(ug, width - BoxStyle.this.getShield(), height, shadowing, roundCorner);
            }
        };
    }

    protected Shadowable getShape(double width, double height, double roundCorner) {
        return null;
    }

    protected void drawInternal(UGraphic ug, double width, double height, double shadowing, double roundCorner) {
        Shadowable s = this.getShape(width, height, roundCorner);
        s.setDeltaShadow(shadowing);
        ug.draw(s);
    }

    public final double getShield() {
        return this.shield;
    }

    static {
        DELTA_INPUT_OUTPUT = 10;
        DELTA_CONTINUOUS = 5.0;
        PADDING = 5;
    }
}

