/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.Position;

public class CommandNote
extends SingleLineCommand2<TimingDiagram> {
    public CommandNote() {
        super(CommandNote.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNote.class.getName(), RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(top|bottom)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("of"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([\\p{L}_][%pLN_.]*)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREO"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.+)"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String code = arg.get("CODE", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + code + "\"");
        }
        Display note = Display.getWithNewlines(diagram.getPragma(), arg.get("NOTE", 0));
        TimeTick now = diagram.getNow();
        String stereotypeString = arg.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereotypeString != null) {
            stereotype = Stereotype.build(stereotypeString);
        }
        player.addNote(now, note, Position.fromString(arg.get("POSITION", 0)), stereotype);
        return CommandExecutionResult.ok();
    }
}

