/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineList;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineWithYamlHeader;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import net.sourceforge.plantuml.preproc.Sub;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.PreprocessorIncludeStrategy;
import net.sourceforge.plantuml.preproc2.PreprocessorUtils;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.theme.Theme;
import net.sourceforge.plantuml.theme.ThemeUtils;
import net.sourceforge.plantuml.tim.EaterAffectationDefine;
import net.sourceforge.plantuml.tim.EaterAssert;
import net.sourceforge.plantuml.tim.EaterDumpMemory;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterFunctionCall;
import net.sourceforge.plantuml.tim.EaterImport;
import net.sourceforge.plantuml.tim.EaterInclude;
import net.sourceforge.plantuml.tim.EaterIncludeDef;
import net.sourceforge.plantuml.tim.EaterIncludeSprites;
import net.sourceforge.plantuml.tim.EaterIncludesub;
import net.sourceforge.plantuml.tim.EaterLog;
import net.sourceforge.plantuml.tim.EaterOption;
import net.sourceforge.plantuml.tim.EaterReturn;
import net.sourceforge.plantuml.tim.EaterTheme;
import net.sourceforge.plantuml.tim.EaterUndef;
import net.sourceforge.plantuml.tim.FunctionsSet;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.VariableManager;
import net.sourceforge.plantuml.tim.builtin.AlwaysFalse;
import net.sourceforge.plantuml.tim.builtin.AlwaysTrue;
import net.sourceforge.plantuml.tim.builtin.Backslash;
import net.sourceforge.plantuml.tim.builtin.BoolVal;
import net.sourceforge.plantuml.tim.builtin.Breakline;
import net.sourceforge.plantuml.tim.builtin.CallUserFunction;
import net.sourceforge.plantuml.tim.builtin.Chr;
import net.sourceforge.plantuml.tim.builtin.Darken;
import net.sourceforge.plantuml.tim.builtin.DateFunction;
import net.sourceforge.plantuml.tim.builtin.Dec2hex;
import net.sourceforge.plantuml.tim.builtin.Dirpath;
import net.sourceforge.plantuml.tim.builtin.Dollar;
import net.sourceforge.plantuml.tim.builtin.Eval;
import net.sourceforge.plantuml.tim.builtin.Feature;
import net.sourceforge.plantuml.tim.builtin.FileExists;
import net.sourceforge.plantuml.tim.builtin.Filedate;
import net.sourceforge.plantuml.tim.builtin.Filename;
import net.sourceforge.plantuml.tim.builtin.FilenameNoExtension;
import net.sourceforge.plantuml.tim.builtin.FunctionExists;
import net.sourceforge.plantuml.tim.builtin.GetAllStdlib;
import net.sourceforge.plantuml.tim.builtin.GetAllTheme;
import net.sourceforge.plantuml.tim.builtin.GetCurrentTheme;
import net.sourceforge.plantuml.tim.builtin.GetJsonKey;
import net.sourceforge.plantuml.tim.builtin.GetJsonType;
import net.sourceforge.plantuml.tim.builtin.GetStdlib;
import net.sourceforge.plantuml.tim.builtin.GetVariableValue;
import net.sourceforge.plantuml.tim.builtin.GetVersion;
import net.sourceforge.plantuml.tim.builtin.Getenv;
import net.sourceforge.plantuml.tim.builtin.Hex2dec;
import net.sourceforge.plantuml.tim.builtin.HslColor;
import net.sourceforge.plantuml.tim.builtin.IntVal;
import net.sourceforge.plantuml.tim.builtin.InvokeProcedure;
import net.sourceforge.plantuml.tim.builtin.IsDark;
import net.sourceforge.plantuml.tim.builtin.IsLight;
import net.sourceforge.plantuml.tim.builtin.JsonAdd;
import net.sourceforge.plantuml.tim.builtin.JsonKeyExists;
import net.sourceforge.plantuml.tim.builtin.JsonMerge;
import net.sourceforge.plantuml.tim.builtin.JsonRemove;
import net.sourceforge.plantuml.tim.builtin.JsonSet;
import net.sourceforge.plantuml.tim.builtin.LeftAlign;
import net.sourceforge.plantuml.tim.builtin.Lighten;
import net.sourceforge.plantuml.tim.builtin.LoadJson;
import net.sourceforge.plantuml.tim.builtin.LogicalAnd;
import net.sourceforge.plantuml.tim.builtin.LogicalNand;
import net.sourceforge.plantuml.tim.builtin.LogicalNor;
import net.sourceforge.plantuml.tim.builtin.LogicalNot;
import net.sourceforge.plantuml.tim.builtin.LogicalNxor;
import net.sourceforge.plantuml.tim.builtin.LogicalOr;
import net.sourceforge.plantuml.tim.builtin.LogicalXor;
import net.sourceforge.plantuml.tim.builtin.Lower;
import net.sourceforge.plantuml.tim.builtin.Modulo;
import net.sourceforge.plantuml.tim.builtin.Newline;
import net.sourceforge.plantuml.tim.builtin.NewlineShort;
import net.sourceforge.plantuml.tim.builtin.Now;
import net.sourceforge.plantuml.tim.builtin.Ord;
import net.sourceforge.plantuml.tim.builtin.Percent;
import net.sourceforge.plantuml.tim.builtin.RandomFunction;
import net.sourceforge.plantuml.tim.builtin.RetrieveProcedure;
import net.sourceforge.plantuml.tim.builtin.ReverseColor;
import net.sourceforge.plantuml.tim.builtin.ReverseHsluvColor;
import net.sourceforge.plantuml.tim.builtin.RightAlign;
import net.sourceforge.plantuml.tim.builtin.SetVariableValue;
import net.sourceforge.plantuml.tim.builtin.Size;
import net.sourceforge.plantuml.tim.builtin.SplitStr;
import net.sourceforge.plantuml.tim.builtin.SplitStrRegex;
import net.sourceforge.plantuml.tim.builtin.Str2Json;
import net.sourceforge.plantuml.tim.builtin.StringFunction;
import net.sourceforge.plantuml.tim.builtin.Strlen;
import net.sourceforge.plantuml.tim.builtin.Strpos;
import net.sourceforge.plantuml.tim.builtin.Substr;
import net.sourceforge.plantuml.tim.builtin.Tabulation;
import net.sourceforge.plantuml.tim.builtin.Upper;
import net.sourceforge.plantuml.tim.builtin.VariableExists;
import net.sourceforge.plantuml.tim.builtin.Xargs;
import net.sourceforge.plantuml.tim.expression.Knowledge;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.iterator.CodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorAffectation;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorForeach;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorIf;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorImpl;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorInnerComment;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorLegacyDefine;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorLongComment;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorProcedure;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorReturnFunction;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorShortComment;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorSub;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorWhile;
import net.sourceforge.plantuml.utils.LineLocation;

public class TContext {
    private final List<StringLocated> resultList = new ArrayList<StringLocated>();
    private final List<StringLocated> debug = new ArrayList<StringLocated>();
    public final FunctionsSet functionsSet = new FunctionsSet();
    private ImportedFiles importedFiles;
    private final Charset charset;
    private final Map<String, Sub> subs = new HashMap<String, Sub>();
    private final DefinitionsContainer definitionsContainer;
    private final Set<FileWithSuffix> filesUsedCurrent = new HashSet<FileWithSuffix>();
    private final PreprocessingArtifact preprocessingArtifact = new PreprocessingArtifact();
    private String pendingAdd = null;
    private JsonObject themeMetadata = new JsonObject();

    public Set<FileWithSuffix> getFilesUsedCurrent() {
        return Collections.unmodifiableSet(this.filesUsedCurrent);
    }

    private void addStandardFunctions(Defines defines) {
        this.functionsSet.addFunction(new AlwaysFalse());
        this.functionsSet.addFunction(new AlwaysTrue());
        this.functionsSet.addFunction(new Backslash());
        this.functionsSet.addFunction(new BoolVal());
        this.functionsSet.addFunction(new Breakline());
        this.functionsSet.addFunction(new CallUserFunction());
        this.functionsSet.addFunction(new Chr());
        this.functionsSet.addFunction(new Darken());
        this.functionsSet.addFunction(new DateFunction());
        this.functionsSet.addFunction(new Dec2hex());
        this.functionsSet.addFunction(new Dirpath(defines));
        this.functionsSet.addFunction(new Dollar());
        this.functionsSet.addFunction(new Eval());
        this.functionsSet.addFunction(new Feature());
        this.functionsSet.addFunction(new Filedate(defines));
        this.functionsSet.addFunction(new FileExists());
        this.functionsSet.addFunction(new Filename(defines));
        this.functionsSet.addFunction(new FilenameNoExtension(defines));
        this.functionsSet.addFunction(new FunctionExists());
        this.functionsSet.addFunction(new GetAllStdlib());
        this.functionsSet.addFunction(new GetAllTheme());
        this.functionsSet.addFunction(new GetCurrentTheme());
        this.functionsSet.addFunction(new GetJsonKey());
        this.functionsSet.addFunction(new GetJsonType());
        this.functionsSet.addFunction(new GetStdlib());
        this.functionsSet.addFunction(new GetVariableValue());
        this.functionsSet.addFunction(new GetVersion());
        this.functionsSet.addFunction(new Getenv());
        this.functionsSet.addFunction(new Hex2dec());
        this.functionsSet.addFunction(new HslColor());
        this.functionsSet.addFunction(new IntVal());
        this.functionsSet.addFunction(new InvokeProcedure());
        this.functionsSet.addFunction(new IsDark());
        this.functionsSet.addFunction(new IsLight());
        this.functionsSet.addFunction(new JsonAdd());
        this.functionsSet.addFunction(new JsonKeyExists());
        this.functionsSet.addFunction(new JsonMerge());
        this.functionsSet.addFunction(new JsonRemove());
        this.functionsSet.addFunction(new JsonSet());
        this.functionsSet.addFunction(new LeftAlign());
        this.functionsSet.addFunction(new Lighten());
        this.functionsSet.addFunction(new LoadJson());
        this.functionsSet.addFunction(new LogicalAnd());
        this.functionsSet.addFunction(new LogicalNand());
        this.functionsSet.addFunction(new LogicalNor());
        this.functionsSet.addFunction(new LogicalNot());
        this.functionsSet.addFunction(new LogicalNxor());
        this.functionsSet.addFunction(new LogicalOr());
        this.functionsSet.addFunction(new LogicalXor());
        this.functionsSet.addFunction(new Lower());
        this.functionsSet.addFunction(new Modulo());
        this.functionsSet.addFunction(new Newline());
        this.functionsSet.addFunction(new NewlineShort());
        this.functionsSet.addFunction(new Now());
        this.functionsSet.addFunction(new Ord());
        this.functionsSet.addFunction(new Percent());
        this.functionsSet.addFunction(new RandomFunction());
        this.functionsSet.addFunction(new RetrieveProcedure());
        this.functionsSet.addFunction(new ReverseColor());
        this.functionsSet.addFunction(new ReverseHsluvColor());
        this.functionsSet.addFunction(new RightAlign());
        this.functionsSet.addFunction(new SetVariableValue());
        this.functionsSet.addFunction(new Size());
        this.functionsSet.addFunction(new SplitStr());
        this.functionsSet.addFunction(new SplitStrRegex());
        this.functionsSet.addFunction(new Str2Json());
        this.functionsSet.addFunction(new StringFunction());
        this.functionsSet.addFunction(new Strlen());
        this.functionsSet.addFunction(new Strpos());
        this.functionsSet.addFunction(new Substr());
        this.functionsSet.addFunction(new Tabulation());
        this.functionsSet.addFunction(new Upper());
        this.functionsSet.addFunction(new VariableExists());
        this.functionsSet.addFunction(new Xargs());
    }

    public TContext(ImportedFiles importedFiles, Defines defines, Charset charset, DefinitionsContainer definitionsContainer) {
        this.definitionsContainer = definitionsContainer;
        this.importedFiles = importedFiles;
        this.charset = Objects.requireNonNull(charset);
        this.addStandardFunctions(defines);
    }

    public Knowledge asKnowledge(final TMemory memory, final LineLocation location) {
        return new Knowledge(){

            @Override
            public TValue getVariable(String name) throws EaterException {
                if (name.contains(".") || name.contains("[")) {
                    TValue result = TContext.this.fromJson(memory, name, location);
                    return result;
                }
                return memory.getVariable(name);
            }

            @Override
            public TFunction getFunction(TFunctionSignature name) {
                return TContext.this.functionsSet.getFunctionSmart(name);
            }
        };
    }

    private TValue fromJson(TMemory memory, String name, LineLocation location) throws EaterException {
        String result = this.applyFunctionsAndVariables(memory, new StringLocated(name, location));
        try {
            JsonValue json = Json.parse(result);
            return TValue.fromJson(json);
        }
        catch (Exception e) {
            return TValue.fromString(result);
        }
    }

    private CodeIterator buildCodeIterator(TMemory memory, List<StringLocated> body) {
        CodeIteratorAffectation it110;
        CodeIteratorImpl it10 = new CodeIteratorImpl(body);
        CodeIteratorLongComment it20 = new CodeIteratorLongComment(it10, this.debug);
        CodeIteratorShortComment it30 = new CodeIteratorShortComment(it20, this.debug);
        CodeIteratorInnerComment it40 = new CodeIteratorInnerComment(it30);
        CodeIteratorSub it50 = new CodeIteratorSub(it40, this.subs, this, memory);
        CodeIteratorReturnFunction it60 = new CodeIteratorReturnFunction(it50, this, memory, this.functionsSet, this.debug);
        CodeIteratorProcedure it61 = new CodeIteratorProcedure(it60, this, memory, this.functionsSet, this.debug);
        CodeIteratorIf it70 = new CodeIteratorIf(it61, this, memory, this.debug);
        CodeIteratorLegacyDefine it80 = new CodeIteratorLegacyDefine(it70, this, memory, this.functionsSet, this.debug);
        CodeIteratorWhile it90 = new CodeIteratorWhile(it80, this, memory, this.debug);
        CodeIteratorForeach it100 = new CodeIteratorForeach(it90, this, memory, this.debug);
        CodeIteratorAffectation it = it110 = new CodeIteratorAffectation(it100, this, memory, this.debug);
        return it;
    }

    public TValue executeLines(TMemory memory, List<StringLocated> body, TFunctionType ftype, boolean modeSpecial) throws EaterException {
        CodeIterator it = this.buildCodeIterator(memory, body);
        StringLocated s = null;
        while ((s = it.peek()) != null) {
            TValue result = this.executeOneLineSafe(memory, s, ftype, modeSpecial);
            if (result != null) {
                return result;
            }
            it.next();
        }
        return null;
    }

    private void executeLinesInternal(TMemory memory, List<StringLocated> body, TFunctionType ftype) throws EaterException {
        CodeIterator it = this.buildCodeIterator(memory, body);
        StringLocated s = null;
        while ((s = it.peek()) != null) {
            this.executeOneLineSafe(memory, s, ftype, false);
            it.next();
        }
    }

    private TValue executeOneLineSafe(TMemory memory, StringLocated s, TFunctionType ftype, boolean modeSpecial) throws EaterException {
        try {
            this.debug.add(s);
            return this.executeOneLineNotSafe(memory, s, ftype, modeSpecial);
        }
        catch (Exception e) {
            if (e instanceof EaterException) {
                throw (EaterException)e;
            }
            Logme.error(e);
            throw new EaterException("Fatal parsing error", s);
        }
    }

    private TValue executeOneLineNotSafe(TMemory memory, StringLocated s, TFunctionType ftype, boolean modeSpecial) throws EaterException {
        TLineType type = s.getType();
        if (type == TLineType.INCLUDESUB) {
            this.executeIncludesub(memory, s);
            return null;
        }
        if (type == TLineType.THEME) {
            this.executeTheme(memory, s);
            return null;
        }
        if (type == TLineType.INCLUDE) {
            this.executeInclude(memory, s);
            return null;
        }
        if (type == TLineType.INCLUDE_SPRITES) {
            this.executeIncludeSprites(memory, s);
            return null;
        }
        if (type == TLineType.INCLUDE_DEF) {
            this.executeIncludeDef(memory, s);
            return null;
        }
        if (type == TLineType.IMPORT) {
            this.executeImport(memory, s);
            return null;
        }
        if (type == TLineType.DUMP_MEMORY) {
            this.executeDumpMemory(memory, s.getTrimmed());
            return null;
        }
        if (type == TLineType.ASSERT) {
            this.executeAssert(memory, s.getTrimmed());
            return null;
        }
        if (type == TLineType.OPTION) {
            this.executeOption(memory, s.getTrimmed());
            return null;
        }
        if (type == TLineType.UNDEF) {
            this.executeUndef(memory, s);
            return null;
        }
        if (ftype != TFunctionType.RETURN_FUNCTION && type == TLineType.PLAIN) {
            this.addPlain(memory, s);
            return null;
        }
        if (ftype == TFunctionType.RETURN_FUNCTION && type == TLineType.RETURN) {
            if (modeSpecial) {
                EaterReturn eaterReturn = new EaterReturn(s);
                eaterReturn.analyze(this, memory);
                TValue result = eaterReturn.getValue2();
                return result;
            }
            return null;
        }
        if (ftype == TFunctionType.RETURN_FUNCTION && type == TLineType.PLAIN) {
            this.simulatePlain(memory, s);
            return null;
        }
        if (type == TLineType.AFFECTATION_DEFINE) {
            this.executeAffectationDefine(memory, s);
            return null;
        }
        if (ftype == null && type == TLineType.END_FUNCTION) {
            CommandExecutionResult.error("error endfunc");
            return null;
        }
        if (type == TLineType.LOG) {
            this.executeLog(memory, s);
            return null;
        }
        if (s.getString().matches("^\\s+$")) {
            return null;
        }
        throw new EaterException("Compile Error " + (Object)((Object)ftype) + " " + (Object)((Object)type), s);
    }

    private void addPlain(TMemory memory, StringLocated s) throws EaterException {
        StringLocated[] tmp = this.applyFunctionsAndVariablesInternal(memory, s);
        if (tmp != null) {
            if (this.pendingAdd != null) {
                tmp[0] = new StringLocated(this.pendingAdd + tmp[0].getString(), tmp[0].getLocation());
                this.pendingAdd = null;
            }
            for (StringLocated line : tmp) {
                this.addToResultList(line);
            }
        }
    }

    private boolean addToResultList(StringLocated line) {
        return this.resultList.add(line);
    }

    private void simulatePlain(TMemory memory, StringLocated s) throws EaterException {
        StringLocated[] ignored = this.applyFunctionsAndVariablesInternal(memory, s);
    }

    private void executeAffectationDefine(TMemory memory, StringLocated s) throws EaterException {
        new EaterAffectationDefine(s).analyze(this, memory);
    }

    private void executeDumpMemory(TMemory memory, StringLocated s) throws EaterException {
        EaterDumpMemory condition = new EaterDumpMemory(s);
        condition.analyze(this, memory);
    }

    private void executeAssert(TMemory memory, StringLocated s) throws EaterException {
        EaterAssert condition = new EaterAssert(s);
        condition.analyze(this, memory);
    }

    private void executeOption(TMemory memory, StringLocated s) throws EaterException {
        EaterOption condition = new EaterOption(s);
        condition.analyze(this, memory);
    }

    private void executeUndef(TMemory memory, StringLocated s) throws EaterException {
        EaterUndef undef = new EaterUndef(s);
        undef.analyze(this, memory);
    }

    private StringLocated[] applyFunctionsAndVariablesInternal(TMemory memory, StringLocated located) throws EaterException {
        if (memory.isEmpty() && this.functionsSet.size() == 0) {
            return new StringLocated[]{located};
        }
        String result = this.applyFunctionsAndVariables(memory, located);
        if (result == null) {
            return null;
        }
        if (Pragma.legacyReplaceBackslashNByNewline()) {
            String[] splited = result.split("\n");
            StringLocated[] tab = new StringLocated[splited.length];
            for (int i = 0; i < splited.length; ++i) {
                tab[i] = new StringLocated(splited[i], located.getLocation());
            }
            return tab;
        }
        if (result.contains("\n")) {
            throw new IllegalStateException(result);
        }
        return new StringLocated[]{new StringLocated(result, located.getLocation())};
    }

    public String applyFunctionsAndVariables(TMemory memory, StringLocated str) throws EaterException {
        if (memory.isEmpty() && this.functionsSet.size() == 0) {
            return str.getString();
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            String presentFunction = this.getFunctionNameAt(str.getString(), i);
            if (presentFunction != null) {
                String sub = str.getString().substring(i);
                EaterFunctionCall call = new EaterFunctionCall(new StringLocated(sub, str.getLocation()), this.isLegacyDefine(presentFunction), this.isUnquoted(presentFunction));
                call.analyze(this, memory);
                TFunctionSignature signature = new TFunctionSignature(presentFunction, call.getValues().size(), call.getNamedArguments().keySet());
                TFunction function = this.functionsSet.getFunctionSmart(signature);
                if (function == null) {
                    throw new EaterException("Function not found " + presentFunction, str);
                }
                if (function.getFunctionType() == TFunctionType.PROCEDURE) {
                    this.pendingAdd = result.toString();
                    this.executeVoid3(str, memory, function, call);
                    String remaining = str.getString().substring(i += call.getCurrentPosition());
                    if (remaining.length() > 0) {
                        this.appendToLastResult(remaining);
                    }
                    return null;
                }
                if (function.getFunctionType() == TFunctionType.LEGACY_DEFINELONG) {
                    this.pendingAdd = str.getString().substring(0, i);
                    this.executeVoid3(str, memory, function, call);
                    return null;
                }
                assert (function.getFunctionType() == TFunctionType.RETURN_FUNCTION || function.getFunctionType() == TFunctionType.LEGACY_DEFINE);
                TValue functionReturn = function.executeReturnFunction(this, memory, str, call.getValues(), call.getNamedArguments());
                String tmp = functionReturn.toString();
                result.append(tmp);
                i += call.getCurrentPosition() - 1;
                continue;
            }
            if (new VariableManager(this, memory, str).getVarnameAt(str.getString(), i) != null) {
                i = new VariableManager(this, memory, str).replaceVariables(str.getString(), i, result);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private void appendToLastResult(String remaining) {
        StringLocated last = this.resultList.get(this.resultList.size() - 1);
        this.resultList.set(this.resultList.size() - 1, last.append(remaining));
    }

    private void executeVoid3(StringLocated location, TMemory memory, TFunction function, EaterFunctionCall call) throws EaterException {
        function.executeProcedureInternal(this, memory, location, call.getValues(), call.getNamedArguments());
    }

    private void executeImport(TMemory memory, StringLocated s) throws EaterException {
        EaterImport _import = new EaterImport(s.getTrimmed());
        _import.analyze(this, memory);
        try {
            SFile file = FileSystem.getInstance().getFile(this.applyFunctionsAndVariables(memory, new StringLocated(_import.getWhat(), s.getLocation())));
            if (file.exists() && !file.isDirectory()) {
                this.importedFiles.add(file);
                return;
            }
        }
        catch (IOException e) {
            Logme.error(e);
            throw new EaterException("Cannot import " + e.getMessage(), s);
        }
        throw new EaterException("Cannot import", s);
    }

    private void executeLog(TMemory memory, StringLocated s) throws EaterException {
        EaterLog log = new EaterLog(s.getTrimmed());
        log.analyze(this, memory);
    }

    public FileWithSuffix getFileWithSuffix(String from, String realName) throws IOException {
        String s = ThemeUtils.getFullPath(from, realName);
        FileWithSuffix file = this.importedFiles.getFile(s, null);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeIncludesub(TMemory memory, StringLocated s) throws EaterException {
        ImportedFiles saveImportedFiles = null;
        try {
            Sub sub;
            String what;
            block13: {
                EaterIncludesub include = new EaterIncludesub(s.getTrimmed());
                include.analyze(this, memory);
                what = include.getWhat();
                int idx = what.indexOf(33);
                sub = null;
                if (idx != -1) {
                    String filename = what.substring(0, idx);
                    String blocname = what.substring(idx + 1);
                    try {
                        FileWithSuffix f2 = this.importedFiles.getFile(filename, null);
                        if (!f2.fileOk()) break block13;
                        saveImportedFiles = this.importedFiles;
                        this.importedFiles = this.importedFiles.withCurrentDir(f2.getParentFile());
                        Reader reader = f2.getReader(this.charset);
                        if (reader == null) {
                            throw new EaterException("cannot include " + what, s);
                        }
                        try {
                            ReadLine readerline = ReadLineReader.create(reader, what, s.getLocation());
                            readerline = new UncommentReadLine(readerline);
                            sub = Sub.fromFile(readerline, blocname, this, memory);
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        Logme.error(e);
                        throw new EaterException("cannot include " + what, s);
                    }
                }
            }
            if (sub == null) {
                sub = this.subs.get(what);
            }
            if (sub == null) {
                throw new EaterException("cannot include " + what, s);
            }
            this.executeLinesInternal(memory, sub.lines(), null);
        }
        finally {
            if (saveImportedFiles != null) {
                this.importedFiles = saveImportedFiles;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeIncludeDef(TMemory memory, StringLocated s) throws EaterException {
        EaterIncludeDef include = new EaterIncludeDef(s.getTrimmed());
        include.analyze(this, memory);
        String definitionName = include.getLocation();
        List<String> definition = this.definitionsContainer.getDefinition(definitionName);
        ReadLineList reader2 = new ReadLineList(definition, s.getLocation());
        try {
            ArrayList<StringLocated> body = new ArrayList<StringLocated>();
            while (true) {
                StringLocated sl;
                if ((sl = reader2.readLine()) == null) {
                    this.executeLinesInternal(memory, body, null);
                    return;
                }
                body.add(sl);
                continue;
                break;
            }
        }
        catch (IOException e) {
            Logme.error(e);
            throw new EaterException("" + e, s);
        }
        finally {
            try {
                reader2.close();
            }
            catch (IOException e) {
                Logme.error(e);
            }
        }
    }

    public JsonObject getThemeMetadata() {
        return this.themeMetadata;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeTheme(TMemory memory, StringLocated s) throws EaterException {
        EaterTheme eater = new EaterTheme(s.getTrimmed(), this.importedFiles);
        eater.analyze(this, memory);
        Theme theme = eater.getTheme();
        if (theme == null) {
            throw new EaterException("No such theme " + eater.getName(), s);
        }
        try {
            ArrayList<StringLocated> body = new ArrayList<StringLocated>();
            while (true) {
                StringLocated sl;
                if ((sl = theme.readLine()) == null) {
                    this.executeLines(memory, body, null, false);
                    return;
                }
                body.add(sl);
                continue;
                break;
            }
        }
        catch (IOException e) {
            Logme.error(e);
            throw new EaterException("Error reading theme " + e, s);
        }
        finally {
            this.themeMetadata = theme.getMetadata();
            try {
                theme.close();
            }
            catch (IOException e) {
                Logme.error(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeIncludeSprites(TMemory memory, StringLocated s) throws EaterException {
        EaterIncludeSprites include = new EaterIncludeSprites(s.getTrimmed());
        include.analyze(this, memory);
        String what = include.getWhat();
        if (!what.startsWith("<")) throw new EaterException("cannot include sprites from " + what, s);
        if (!what.endsWith(">")) throw new EaterException("cannot include sprites from " + what, s);
        Closeable reader = null;
        try {
            reader = PreprocessorUtils.getReaderStdlibIncludeSprites(s, what.substring(1, what.length() - 1));
            ArrayList<StringLocated> body = new ArrayList<StringLocated>();
            while (true) {
                StringLocated sl;
                if ((sl = reader.readLine()) == null) {
                    this.executeLines(memory, body, null, false);
                    return;
                }
                body.add(sl);
                continue;
                break;
            }
        }
        catch (IOException e) {
            Logme.error(e);
            throw new EaterException("cannot include " + e, s);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Logme.error(e);
                }
            }
        }
    }

    private void executeInclude(TMemory memory, StringLocated s) throws EaterException {
        EaterInclude include = new EaterInclude(s.getTrimmed());
        include.analyze(this, memory);
        String what = include.getWhat();
        PreprocessorIncludeStrategy strategy = include.getPreprocessorIncludeStrategy();
        int idx = what.lastIndexOf(33);
        String suf = null;
        if (idx != -1) {
            suf = what.substring(idx + 1);
            what = what.substring(0, idx);
        }
        Closeable reader = null;
        ImportedFiles saveImportedFiles = null;
        try {
            if (what.startsWith("http://") || what.startsWith("https://")) {
                SURL url = SURL.create(what);
                if (url == null) {
                    throw new EaterException("Cannot open URL", s);
                }
                reader = PreprocessorUtils.getReaderIncludeUrl(url, s, suf, this.charset);
            } else if (what.startsWith("<") && what.endsWith(">")) {
                reader = PreprocessorUtils.getReaderStdlibInclude(s, what.substring(1, what.length() - 1));
            } else if (what.startsWith("[") && what.endsWith("]")) {
                reader = PreprocessorUtils.getReaderNonstandardInclude(s, what.substring(1, what.length() - 1));
            } else {
                FileWithSuffix f2 = this.importedFiles.getFile(what, suf);
                if (f2.fileOk()) {
                    if (strategy == PreprocessorIncludeStrategy.DEFAULT && this.filesUsedCurrent.contains(f2)) {
                        return;
                    }
                    if (strategy == PreprocessorIncludeStrategy.ONCE && this.filesUsedCurrent.contains(f2)) {
                        throw new EaterException("This file has already been included", s);
                    }
                    if (StartDiagramExtractReader.containsStartDiagram(f2, s, this.charset)) {
                        reader = StartDiagramExtractReader.build(f2, s, this.charset);
                    } else {
                        Reader tmp = f2.getReader(this.charset);
                        if (tmp == null) {
                            throw new EaterException("Cannot include file", s);
                        }
                        reader = ReadLineReader.create(tmp, what, s.getLocation());
                    }
                    saveImportedFiles = this.importedFiles;
                    this.importedFiles = this.importedFiles.withCurrentDir(f2.getParentFile());
                    assert (reader != null);
                    this.filesUsedCurrent.add(f2);
                }
            }
            if (reader != null) {
                try {
                    ArrayList<StringLocated> body = new ArrayList<StringLocated>();
                    reader = new ReadLineWithYamlHeader((ReadLine)reader);
                    while (true) {
                        StringLocated sl;
                        if ((sl = reader.readLine()) == null) {
                            this.executeLines(memory, body, null, false);
                            return;
                        }
                        body.add(sl);
                    }
                }
                finally {
                    if (saveImportedFiles != null) {
                        this.importedFiles = saveImportedFiles;
                    }
                }
            }
        }
        catch (IOException e) {
            Logme.error(e);
            throw new EaterException("cannot include " + e, s);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Logme.error(e);
                }
            }
        }
        throw new EaterException("cannot include " + what, s);
    }

    public boolean isLegacyDefine(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functionsSet.functions().entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName) || !ent.getValue().getFunctionType().isLegacy()) continue;
            return true;
        }
        return false;
    }

    public boolean isUnquoted(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functionsSet.functions().entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName) || !ent.getValue().isUnquoted()) continue;
            return true;
        }
        return false;
    }

    public boolean doesFunctionExist(String functionName) {
        for (Map.Entry<TFunctionSignature, TFunction> ent : this.functionsSet.functions().entrySet()) {
            if (!ent.getKey().getFunctionName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    private String getFunctionNameAt(String s, int pos) {
        boolean justAfterALetter;
        boolean bl = justAfterALetter = pos > 0 && TLineType.isLetterOrUnderscoreOrDigit(s.charAt(pos - 1)) && !VariableManager.justAfterBackslashN(s, pos);
        if (justAfterALetter && s.charAt(pos) != '%' && s.charAt(pos) != '$') {
            return null;
        }
        String fname = this.functionsSet.getLonguestMatchStartingIn(s, pos);
        if (fname.length() == 0) {
            return null;
        }
        return fname.substring(0, fname.length() - 1);
    }

    public List<StringLocated> getResultList() {
        return this.resultList;
    }

    public List<StringLocated> getDebug() {
        return this.debug;
    }

    public String extractFromResultList(int n1) {
        StringBuilder sb = new StringBuilder();
        while (this.resultList.size() > n1) {
            sb.append(this.resultList.get(n1).getString());
            this.resultList.remove(n1);
            if (this.resultList.size() <= n1) continue;
            sb.append('\ue100');
        }
        return sb.toString();
    }

    public void appendEndOfLine(String endOfLine) {
        if (endOfLine.length() > 0) {
            int idx = this.resultList.size() - 1;
            StringLocated last = this.resultList.get(idx);
            last = last.append(endOfLine);
            this.resultList.set(idx, last);
        }
    }

    public TFunction getFunctionSmart(TFunctionSignature signature) {
        return this.functionsSet.getFunctionSmart(signature);
    }

    public Optional<String> getXargs() {
        if (this.resultList.size() == 0) {
            return Optional.empty();
        }
        String first = this.resultList.get(0).toString();
        int idx = first.indexOf(32);
        if (idx == -1) {
            return Optional.empty();
        }
        return Optional.of(first.substring(idx + 1).trim());
    }

    public PreprocessingArtifact getPreprocessingArtifact() {
        return this.preprocessingArtifact;
    }
}

