/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.Objects;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.version.Version;

public class ProtectedCommand<S extends Diagram>
implements Command<S> {
    private final Command<S> cmd;

    public ProtectedCommand(Command<S> cmd) {
        this.cmd = Objects.requireNonNull(cmd);
    }

    @Override
    public CommandExecutionResult execute(S system, BlocLines lines, ParserPass currentPass) {
        try {
            CommandExecutionResult result = this.cmd.execute(system, lines, currentPass);
            return result;
        }
        catch (Throwable t) {
            Log.error("Error " + t);
            Logme.error(t);
            String msg = "You should send a mail to plantuml@gmail.com or post to https://plantuml.com/qa with this log (V" + Version.versionString() + ")";
            Log.error(msg);
            msg = msg + " " + t.toString();
            return CommandExecutionResult.error(msg, t);
        }
    }

    @Override
    public CommandControl isValid(BlocLines lines) {
        return this.cmd.isValid(lines);
    }

    @Override
    public String[] getDescription() {
        return this.cmd.getDescription();
    }

    @Override
    public boolean isEligibleFor(ParserPass pass) {
        return this.cmd.isEligibleFor(pass);
    }
}

