/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.dot.ExeState;
import net.sourceforge.plantuml.dot.Graphviz;
import net.sourceforge.plantuml.dot.GraphvizFactory;
import net.sourceforge.plantuml.dot.GraphvizLinux;
import net.sourceforge.plantuml.dot.GraphvizWindowsLite;
import net.sourceforge.plantuml.dot.GraphvizWindowsOld;
import net.sourceforge.plantuml.dot.ProcessState;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.vizjs.GraphvizJs;
import net.sourceforge.plantuml.vizjs.VizJsEngine;

public class GraphvizUtils {
    public static final String VIZJS = "vizjs";
    private static int DOT_VERSION_LIMIT = 226;
    private static String dotExecutable;
    private static final ThreadLocal<Integer> limitSize;
    private static String dotVersion;

    private static boolean isWindows() {
        return SFile.separatorChar == '\\';
    }

    public static final String getDotExecutableForTest() {
        return dotExecutable;
    }

    public static final void setDotExecutable(String value) {
        dotExecutable = value == null ? null : value.trim();
    }

    public static Graphviz createForSystemDot(ISkinParam skinParam, String dotString, String ... type) {
        Graphviz result = GraphvizUtils.createWithFactory(skinParam, dotString, type);
        if (result != null) {
            return result;
        }
        if (GraphvizUtils.useVizJs(skinParam)) {
            Log.info("Using vizjs");
            return new GraphvizJs(dotString);
        }
        result = GraphvizUtils.isWindows() ? new GraphvizWindowsOld(skinParam, dotString, type) : new GraphvizLinux(skinParam, dotString, type);
        if (result.getExeState() != ExeState.OK && VizJsEngine.isOk()) {
            Log.info("Error with file " + result.getDotExe() + ": " + result.getExeState().getTextMessage());
            Log.info("Using vizjs");
            return new GraphvizJs(dotString);
        }
        return result;
    }

    public static Graphviz create(ISkinParam skinParam, String dotString, String ... type) {
        Graphviz result = GraphvizUtils.createWithFactory(skinParam, dotString, type);
        if (result != null) {
            return result;
        }
        if (GraphvizUtils.useVizJs(skinParam)) {
            Log.info("Using vizjs");
            return new GraphvizJs(dotString);
        }
        result = GraphvizUtils.isWindows() ? new GraphvizWindowsLite(skinParam, dotString, type) : new GraphvizLinux(skinParam, dotString, type);
        if (result.getExeState() != ExeState.OK && VizJsEngine.isOk()) {
            Log.info("Error with file " + result.getDotExe() + ": " + result.getExeState().getTextMessage());
            Log.info("Using vizjs");
            return new GraphvizJs(dotString);
        }
        return result;
    }

    private static Graphviz createWithFactory(ISkinParam skinParam, String dotString, String ... type) {
        for (GraphvizFactory factory : ServiceLoader.load(GraphvizFactory.class)) {
            Graphviz graphviz = factory.create(skinParam, dotString, type);
            if (graphviz == null) continue;
            Log.info("Using " + graphviz.getClass().getName() + " created by " + factory.getClass().getName());
            return graphviz;
        }
        return null;
    }

    private static boolean useVizJs(ISkinParam skinParam) {
        if (skinParam != null && skinParam.isUseVizJs() && VizJsEngine.isOk()) {
            return true;
        }
        return VIZJS.equalsIgnoreCase(GraphvizUtils.getenvGraphvizDot()) && VizJsEngine.isOk();
    }

    public static File getDotExe() {
        return GraphvizUtils.create(null, "png", new String[0]).getDotExe();
    }

    public static String getenvGraphvizDot() {
        if (StringUtils.isNotEmpty(dotExecutable)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(dotExecutable);
        }
        String env = System.getProperty("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(env)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env);
        }
        String getenv = System.getenv("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(getenv)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(getenv);
        }
        return null;
    }

    public static void removeLocalLimitSize() {
        limitSize.remove();
    }

    public static void setLocalImageLimit(int value) {
        limitSize.set(value);
    }

    public static int getenvImageLimit() {
        Integer local = limitSize.get();
        if (local != null) {
            return local;
        }
        String env = SecurityUtils.getenv("PLANTUML_LIMIT_SIZE");
        if (StringUtils.isNotEmpty(env) && env.matches("\\d+")) {
            return Integer.parseInt(env);
        }
        return 4096;
    }

    public static String getenvDefaultConfigFilename() {
        return SecurityUtils.getenv("PLANTUML_DEFAULT_CONFIG_FILENAME");
    }

    public static String getenvLogData() {
        return SecurityUtils.getenv("PLANTUML_LOGDATA");
    }

    public static String dotVersion() throws IOException, InterruptedException {
        if (dotVersion == null) {
            File dotExe = GraphvizUtils.getDotExe();
            ExeState exeState = ExeState.checkFile(dotExe);
            dotVersion = exeState == ExeState.OK ? GraphvizUtils.create(null, "png", new String[0]).dotVersion() : "Error:" + exeState.getTextMessage(dotExe);
        }
        return dotVersion;
    }

    public static boolean graphviz244onWindows() {
        try {
            return GraphvizUtils.create(null, "png", new String[0]).graphviz244onWindows();
        }
        catch (Exception e) {
            Logme.error(e);
            return false;
        }
    }

    public static int retrieveVersion(String s) {
        if (s == null) {
            return -1;
        }
        Pattern p = Pattern.compile("\\s(\\d+)\\.(\\d\\d?)\\D");
        Matcher m = p.matcher(s);
        if (!m.find()) {
            return -1;
        }
        return 100 * Integer.parseInt(m.group(1)) + Integer.parseInt(m.group(2));
    }

    public static int getDotVersion() throws IOException, InterruptedException {
        return GraphvizUtils.retrieveVersion(GraphvizUtils.dotVersion());
    }

    public static int addDotStatus(List<String> result, boolean withRichText) {
        int error;
        block16: {
            ExeState exeState;
            String red = "";
            String bold = "";
            if (withRichText) {
                red = "<b><color:red>";
                bold = "<b>";
            }
            error = 0;
            if (GraphvizUtils.useVizJs(null)) {
                result.add("VizJs library is used!");
                try {
                    String err = GraphvizUtils.getTestCreateSimpleFile();
                    if (err == null) {
                        result.add(bold + "Installation seems OK. File generation OK");
                    } else {
                        result.add(red + err);
                    }
                }
                catch (Exception e) {
                    result.add(red + e.toString());
                    Logme.error(e);
                    error = -1;
                }
                return error;
            }
            File dotExe = GraphvizUtils.getDotExe();
            if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
                String ent = GraphvizUtils.getenvGraphvizDot();
                if (ent == null) {
                    result.add("The environment variable GRAPHVIZ_DOT has not been set");
                } else {
                    result.add("The environment variable GRAPHVIZ_DOT has been set to " + ent);
                }
                result.add("Dot executable is " + dotExe);
            }
            if ((exeState = ExeState.checkFile(dotExe)) == ExeState.OK) {
                try {
                    String version = GraphvizUtils.dotVersion();
                    result.add("Dot version: " + version);
                    int v = GraphvizUtils.getDotVersion();
                    if (v == -1) {
                        result.add("Warning : cannot determine dot version");
                        error = -2;
                        break block16;
                    }
                    if (v < DOT_VERSION_LIMIT) {
                        result.add(bold + "Warning : Your dot installation seems old");
                        result.add(bold + "Some diagrams may have issues");
                        error = -3;
                        break block16;
                    }
                    String err = GraphvizUtils.getTestCreateSimpleFile();
                    if (err == null) {
                        result.add(bold + "Installation seems OK. File generation OK");
                        break block16;
                    }
                    result.add(red + err);
                    error = -4;
                }
                catch (Exception e) {
                    result.add(red + e.toString());
                    Logme.error(e);
                    error = -5;
                }
            } else {
                result.add(red + "Error: " + exeState.getTextMessage());
                result.add("Error: only sequence diagrams will be generated");
                error = -6;
            }
        }
        return error;
    }

    static String getTestCreateSimpleFile() throws IOException {
        ByteArrayOutputStream baos;
        Graphviz graphviz2 = GraphvizUtils.create(null, "digraph foo { test; }", "svg");
        ProcessState state = graphviz2.createFile3(baos = new ByteArrayOutputStream());
        if (state.differs(ProcessState.TERMINATED_OK())) {
            return "Error: timeout " + state;
        }
        byte[] data = baos.toByteArray();
        if (data.length == 0) {
            return "Error: dot generates empty file. Check you dot installation.";
        }
        String s = new String(data);
        if (s.indexOf("<svg") == -1) {
            return "Error: dot generates unreadable SVG file. Check you dot installation.";
        }
        return null;
    }

    static {
        limitSize = new ThreadLocal();
        dotVersion = null;
    }
}

