/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.draw.WeeklyHeaderStrategy;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandPrintScale
extends SingleLineCommand2<GanttDiagram> {
    public CommandPrintScale() {
        super(CommandPrintScale.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPrintScale.class.getName(), RegexLeaf.start(), new RegexOr(new RegexLeaf("projectscale"), new RegexLeaf("ganttscale"), new RegexLeaf("printscale")), RegexLeaf.spaceOneOrMore(), new RegexOr("SCALE", new RegexLeaf("yearly"), new RegexLeaf("quarterly"), new RegexLeaf("monthly"), new RegexLeaf("daily"), new RegexLeaf("weekly")), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexOr("OPTION", new RegexLeaf("(with\\s+calendar\\s+date)"), new RegexLeaf("(with\\s+week\\s+numbering\\s+from\\s+1)")))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("zoom"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("ZOOM", "([.\\d]+)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String option;
        String scaleString = arg.get("SCALE", 0);
        PrintScale scale = PrintScale.fromString(scaleString);
        diagram.setPrintScale(scale);
        String zoom = arg.get("ZOOM", 0);
        if (zoom != null) {
            diagram.setFactorScale(Double.parseDouble(zoom));
        }
        if ((option = arg.get("OPTION", 0)) != null) {
            if (option.contains("date")) {
                diagram.setWeeklyHeaderStrategy(WeeklyHeaderStrategy.DAY_OF_MONTH);
            } else if (option.contains("1")) {
                diagram.setWeeklyHeaderStrategy(WeeklyHeaderStrategy.FROM_1);
            }
        }
        return CommandExecutionResult.ok();
    }
}

