/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.Collections;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.ebnf.PSystemEbnf;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandEBnfSingleLine
extends SingleLineCommand2<PSystemEbnf> {
    public CommandEBnfSingleLine() {
        super(true, CommandEBnfSingleLine.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandEBnfSingleLine.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(\\*"), new RegexLeaf("COMMENTA", "(.*[^%s].*)"), new RegexLeaf("\\*\\)"), RegexLeaf.spaceZeroOrMore())), new RegexLeaf("ID", "([%pLN_][-%pLN_]*)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\(\\*"), new RegexLeaf("COMMENTB", "(.*[^%s].*)"), new RegexLeaf("\\*\\)"), RegexLeaf.spaceZeroOrMore())), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("EQUALS", "(=)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("LINE", "(.*;)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(PSystemEbnf diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String id = arg.get("ID", 0);
        String equals = arg.get("EQUALS", 0);
        String line = arg.get("LINE", 0);
        String full = id + equals + line;
        String commentAbove = arg.get("COMMENTA", 0);
        String commentBelow = arg.get("COMMENTB", 0);
        StringLocated string = new StringLocated(full, location);
        return diagram.addBlocLines(BlocLines.from(Collections.singletonList(string)), commentAbove, commentBelow);
    }
}

