/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public final class CommandFactoryNote
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(CommandFactoryNote.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREO"), ColorParser.exp1(), RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(CommandFactoryNote.class.getName() + "single", RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("[%g]"), new RegexLeaf("DISPLAY", "([^%g]+)"), new RegexLeaf("[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([%pLN_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREO"), ColorParser.exp1(), RegexLeaf.end());
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        return new SingleLineCommand2<AbstractEntityDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
                Display display = Display.getWithNewlines(diagram.getPragma(), arg.get("DISPLAY", 0));
                return CommandFactoryNote.this.executeInternal(location, diagram, arg, display);
            }
        };
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<AbstractEntityDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH){

            @Override
            public String getPatternEnd() {
                return "^[%s]*end[%s]?note$";
            }

            @Override
            protected CommandExecutionResult executeNow(AbstractEntityDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1).expandsNewline(false);
                lines = lines.removeEmptyColumns();
                Display display = lines.toDisplay();
                return CommandFactoryNote.this.executeInternal(lines.getLocation(), diagram, line0, display);
            }
        };
    }

    private CommandExecutionResult executeInternal(LineLocation location, AbstractEntityDiagram diagram, RegexResult arg, Display display) throws NoSuchColorException {
        String idShort = arg.get("CODE", 0);
        Quark<Entity> quark = diagram.quarkInContext(false, diagram.cleanId(idShort));
        if (quark.getData() != null) {
            return CommandExecutionResult.error("Note already created: " + quark.getName());
        }
        Entity entity = diagram.reallyCreateLeaf(location, quark, display, LeafType.NOTE, null);
        assert (entity != null);
        String s = arg.get("COLOR", 0);
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, s == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        String stereotypeString = arg.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereotypeString != null) {
            stereotype = Stereotype.build(stereotypeString);
            entity.setStereotype(stereotype);
        }
        CommandCreateClassMultilines.addTags(entity, arg.get("TAGS", 0));
        return CommandExecutionResult.ok();
    }
}

