# ans.fhir.fr.annuaire#1.1.0: Annuaire Santé

## Pages

* [Accueil](index.md)
* [Téléchargement du guide](downloads.md)
* [Problématiques connues](problematiques_connues.md)
* [Liste des profils par permission](liste_profils.md)
* [Artifacts Summary](artifacts.md)
* [Historique des changements](changes.md)

## Resources

### CodeSystems

* [AS CodeSystem OrganizationTypes](CodeSystem-as-cs-organization-types.md)
* [AS CodeSystem Type Etablissement](CodeSystem-as-cs-type-etablissement.md)
* [AS CodeSystem type de système d'information](CodeSystem-as-cs-type-systeme-information.md)

### ValueSets

* [AS ValueSet OrganizationTypes](ValueSet-as-vs-organization-types.md)
* [AS ValueSet type Etablissement](ValueSet-as-vs-type-etablissement.md)
* [AS ValueSet type de système d'information](ValueSet-as-vs-type-systeme-information.md)

### Complex-type Profiles

* [AS Address Extended Datatype Profile](StructureDefinition-as-address-extended.md)
* [AS CodeableConceptTimed Datatype Profile](StructureDefinition-as-codeableconcept-timed.md)
* [AS Mailbox MSS Datatype Profile](StructureDefinition-as-mailbox-mss.md)

### Resource Profiles

* [AS Device Profile](StructureDefinition-as-device.md)
* [AS Donnée Publique Device Profile](StructureDefinition-as-dp-device.md)
* [AS Donnée Publique HealthcareService Healthcare Activity Profile](StructureDefinition-as-dp-healthcareservice-healthcare-activity.md)
* [AS Donnée Publique HealthcareService Social Equipment Profile](StructureDefinition-as-dp-healthcareservice-social-equipment.md)
* [AS Donnée Publique Organization Profile](StructureDefinition-as-dp-organization.md)
* [AS Donnée Publique Practitioner Profile](StructureDefinition-as-dp-practitioner.md)
* [AS Donnée Publique PractitionerRole Profile](StructureDefinition-as-dp-practitionerrole.md)
* [AS Donnée Restreinte Device Profile](StructureDefinition-as-dr-device.md)
* [AS Donnée Restreinte HealthcareService Healthcare Activity Profile](StructureDefinition-as-dr-healthcareservice-healthcare-activity.md)
* [AS Donnée Restreinte HealthcareService Social Equipment Profile](StructureDefinition-as-dr-healthcareservice-social-equipment.md)
* [AS Donnée Restreinte Organization Profile](StructureDefinition-as-dr-organization.md)
* [AS Donnée Restreinte Person Profile](StructureDefinition-as-dr-person.md)
* [AS Donnée Restreinte Practitioner Profile](StructureDefinition-as-dr-practitioner.md)
* [AS Donnée Restreinte PractitionerRole Profile](StructureDefinition-as-dr-practitionerrole.md)
* [AS HealthcareService HealthCare Activity Profile](StructureDefinition-as-healthcareservice-healthcare-activity.md)
* [AS HealthcareService Social Equipment Profile](StructureDefinition-as-healthcareservice-social-equipment.md)
* [AS Organization Profile](StructureDefinition-as-organization.md)
* [AS Person Profile](StructureDefinition-as-person.md)
* [AS Practitioner Profile](StructureDefinition-as-practitioner.md)
* [AS PractitionerRole Profile](StructureDefinition-as-practitionerrole.md)

### Extensions

* [AS Authorization Extension](StructureDefinition-as-ext-authorization.md)
* [AS CodeableConceptTimed Metadata](StructureDefinition-as-ext-codeableconcept-timed-metadata.md)
* [AS Data Trace Extension](StructureDefinition-as-ext-data-trace.md)
* [AS Digital Certificate Extension](StructureDefinition-as-ext-digital-certificate.md)
* [AS Education Level Extension](StructureDefinition-as-ext-education-level.md)
* [AS Installation Extension](StructureDefinition-as-ext-installation.md)
* [AS Lieu Dit Extension](StructureDefinition-as-ext-lieu-dit.md)
* [AS Mailbox Metadata](StructureDefinition-as-ext-mailbox-mss-metadata.md)
* [AS Organization Authorization Deadline Extension](StructureDefinition-as-ext-organization-authorization-deadline.md)
* [AS Organization Budget Type Extension](StructureDefinition-as-ext-organization-budget-type.md)
* [AS Organization Closing Type Extension](StructureDefinition-as-ext-organization-closing-type.md)
* [AS Organization Pharmacy Licence Extension](StructureDefinition-as-ext-organization-pharmacy-licence.md)
* [AS Organization Pricing Model Extension](StructureDefinition-as-ext-organization-pricing-model.md)
* [AS Organization Types](StructureDefinition-as-ext-organization-types.md)
* [AS Patient Type Extension](StructureDefinition-as-ext-patient-type.md)
* [AS Person Birth Place Extension](StructureDefinition-as-ext-person-birth-place.md)
* [AS Person Deceased Date Time Extension](StructureDefinition-as-ext-person-deceased-date-time.md)
* [AS Practitioner Authorization Extension](StructureDefinition-as-ext-practitioner-authorization.md)
* [AS PractitionerRole Contracted](StructureDefinition-as-ext-practitionerrole-contracted.md)
* [AS PractitionerRole Has CAS](StructureDefinition-as-ext-practitionerrole-hascas.md)
* [AS PractitionerRole Vitale Accepted](StructureDefinition-as-ext-practitionerrole-vitale-accepted.md)
* [AS Registration Extension](StructureDefinition-as-ext-registration.md)
* [AS Smart Card Extension](StructureDefinition-as-ext-smartcard.md)
* [AS Supported Capacity Extension](StructureDefinition-as-ext-supported-capacity.md)

### CapabilityStatements

* [AsServerDPCapabilityStatement](CapabilityStatement-AsServerDPCapabilityStatement.md)

### ImplementationGuides

* [Annuaire Santé](index.md)

### SearchParameters

* [AsAddressLineSearchParameter](SearchParameter-as-sp-address-line.md)
* [AsDataInformationSystemSearchParameter](SearchParameter-as-sp-data-information-system.md)
* [AsDataRegistrationAuthoritySearchParameter](SearchParameter-as-sp-data-registration-authority.md)
* [AsInseeCode](SearchParameter-as-sp-insee-code.md)
* [AsMailboxMssSearchParameter](SearchParameter-as-sp-mailbox-mss.md)
* [AsNumberSmartCardSearchParameter](SearchParameter-as-sp-number-smartcard.md)
* [AsPharmacyLicenceSearchParameter](SearchParameter-as-sp-pharmacy-licence.md)
* [AsQualificationCodeSearchParameter](SearchParameter-as-sp-qualification-code.md)
* [AsTypeSmartCardSearchParameter](SearchParameter-as-sp-type-smartcard.md)

### Examples

* [CH EURE-SEINE (Organization)](Organization-158480.md)
* [CH EURE-SEINE (Organization)](Organization-158480DP.md)
* [PHARMACIE NOLOT (Organization)](Organization-481677.md)
* [PHARMACIE NOLOT (Organization)](Organization-481677DP.md)
* [CABINET SAINT ANTOINE (Organization)](Organization-548812.md)
* [CABINET SAINT ANTOINE (Organization)](Organization-548812DP.md)
* [Hôpital fictif (Organization)](Organization-example-organization-fictive.md)
* [CHRU NANCY - HOPITAUX DE BRABOIS (Organization)](Organization-example-organization-nancy.md)
* [pp16dr-person (Person)](Person-pp16dr-person.md)
* [pp19dr-person (Person)](Person-pp19dr-person.md)
* [334081 (Practitioner)](Practitioner-334081.md)
* [334081DP (Practitioner)](Practitioner-334081DP.md)
* [3719500 (Practitioner)](Practitioner-3719500.md)
* [3719500DP (Practitioner)](Practitioner-3719500DP.md)
* [1578230 (PractitionerRole)](PractitionerRole-1578230.md)
* [1578230DP (PractitionerRole)](PractitionerRole-1578230DP.md)
* [1738459 (PractitionerRole)](PractitionerRole-1738459.md)
* [1738459DP (PractitionerRole)](PractitionerRole-1738459DP.md)
* [5015602 (PractitionerRole)](PractitionerRole-5015602.md)
* [5015602DP (PractitionerRole)](PractitionerRole-5015602DP.md)
