/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.utils;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.text.StringLocated;

public class StartUtils {
    public static final Pattern2 patternFilename = MyPattern.cmpile("^[@\\\\]start[^%s{}%g]+[%s{][%s%g]*([^%g]*?)[%s}%g]*$");
    public static final String PAUSE_PATTERN = "((?:\\W|\\<[^<>]*\\>)*)[@\\\\]unpause";
    public static final String START_PATTERN = "((?:[^\\w~]|\\<[^<>]*\\>)*)[@\\\\]start";
    private static final Pattern2 append = MyPattern.cmpile("^\\W*[@\\\\](append|a)\\b");

    public static String beforeStartUml(String s) {
        boolean inside = false;
        for (int i = 0; i < s.length(); ++i) {
            String tmp = s.substring(i, s.length());
            if (StartUtils.startsWithSymbolAnd("start", tmp)) {
                return s.substring(0, i);
            }
            String single = s.substring(i, i + 1);
            if (inside) {
                if (!single.equals(">")) continue;
                inside = false;
                continue;
            }
            if (single.equals("<")) {
                inside = true;
                continue;
            }
            if (!single.matches("[\\w~]")) continue;
            return null;
        }
        return null;
    }

    public static boolean isArobaseStartDiagram(String s) {
        String s2 = StringUtils.trinNoTrace(s);
        if (!s2.startsWith("@") && !s2.startsWith("\\")) {
            return false;
        }
        return DiagramType.getTypeFromArobaseStart(s2) != DiagramType.UNKNOWN;
    }

    public static boolean startsWithSymbolAnd(String value, StringLocated tmp) {
        return tmp.getString().startsWith("@" + value) || tmp.getString().startsWith("\\" + value);
    }

    public static boolean startsWithSymbolAnd(String value, String tmp) {
        return tmp.startsWith("@" + value) || tmp.startsWith("\\" + value);
    }

    public static boolean startOrEnd(StringLocated s) {
        String s2 = StringUtils.trinNoTrace(s.getString());
        if (!s2.startsWith("@") && !s2.startsWith("\\")) {
            return false;
        }
        return StartUtils.startsWithSymbolAnd("end", s2) || DiagramType.getTypeFromArobaseStart(s2) != DiagramType.UNKNOWN;
    }

    public static boolean isArobaseEndDiagram(String s) {
        String s2 = StringUtils.trinNoTrace(s);
        return StartUtils.startsWithSymbolAnd("end", s2);
    }

    public static boolean isArobasePauseDiagram(String s) {
        String s2 = StringUtils.trinNoTrace(s);
        return StartUtils.startsWithSymbolAnd("pause", s2);
    }

    public static boolean isArobaseUnpauseDiagram(String s) {
        String s2 = StringUtils.trinNoTrace(s);
        return StartUtils.startsWithSymbolAnd("unpause", s2);
    }

    public static boolean isExit(CharSequence s) {
        String s2 = StringUtils.trinNoTrace(s);
        return s2.equals("!exit");
    }

    public static StringLocated getPossibleAppend(StringLocated cs) {
        String s = cs.getString();
        Matcher2 m = append.matcher(s);
        if (m.find()) {
            String tmp = s.substring(m.group(0).length(), s.length());
            return new StringLocated(StringUtils.trin(tmp), cs.getLocation(), cs.getPreprocessorError());
        }
        return null;
    }
}

