/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.quantization;

import java.util.Set;
import net.sourceforge.plantuml.quantization.Ditherer;
import net.sourceforge.plantuml.quantization.QColor;
import net.sourceforge.plantuml.quantization.QImage;

public final class FloydSteinbergDitherer
implements Ditherer {
    public static final FloydSteinbergDitherer INSTANCE = new FloydSteinbergDitherer();
    private static final ErrorComponent[] ERROR_DISTRIBUTION = new ErrorComponent[]{new ErrorComponent(1, 0, 0.4375), new ErrorComponent(-1, 1, 0.1875), new ErrorComponent(0, 1, 0.3125), new ErrorComponent(1, 1, 0.0625)};

    private FloydSteinbergDitherer() {
    }

    @Override
    public QImage dither(QImage image, Set<QColor> newColors) {
        int x;
        int y;
        int width = image.getWidth();
        int height = image.getHeight();
        QColor[][] colors = new QColor[height][width];
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                colors[y][x] = image.getColor(x, y);
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                QColor replacementColor;
                QColor originalColor = colors[y][x];
                colors[y][x] = replacementColor = originalColor.getNearestColor(newColors);
                QColor error = originalColor.minus(replacementColor);
                for (ErrorComponent component : ERROR_DISTRIBUTION) {
                    int siblingX = x + component.deltaX;
                    int siblingY = y + component.deltaY;
                    if (siblingX < 0 || siblingY < 0 || siblingX >= width || siblingY >= height) continue;
                    QColor errorComponent = error.scaled(component.errorFraction);
                    colors[siblingY][siblingX] = colors[siblingY][siblingX].plus(errorComponent);
                }
            }
        }
        return QImage.fromColors(colors);
    }

    private static final class ErrorComponent {
        final int deltaX;
        final int deltaY;
        final double errorFraction;

        ErrorComponent(int deltaX, int deltaY, double errorFraction) {
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.errorFraction = errorFraction;
        }
    }
}

