# FormatCode Home Page - IHE FormatCode Vocabulary v1.4.1-current

* [**Table of Contents**](toc.md)
* **FormatCode Home Page**

## FormatCode Home Page

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/fhir/ihe.formatcode.fhir/ImplementationGuide/ihe.formatcode.fhir | *Version*:1.4.1-current |
| Active as of 2026-02-19 | *Computable Name*:IHE_FORMATCODE |

This Implementation Guide publishes the IHE vocabulary for FormatCode and the IHE managed ValueSet for FormatCode. Given that the FormatCode is contributed to by many IHE domains, this IG is dedicated to the publication and management of the FormatCode vocabulary.

### Technical Overview

FormatCode is a metadata element for identifying the technical format that a document follows. This is related to mimeType, but is more specific to the content requirements than the encoding requirement. Therefore a document following a FormatCode may have many mimeType encodings. The FormatCode is also related to the document type (e.g. LOINC document type), but is more specific to the requirements (constraints) of the content.

The main sections of this IG are:

* [Background](background.md) - provides more detail on what a FormatCode is and how they are maintained
* [The IHE defined Codes](CodeSystem-formatcode.md) - the definition of the codes defined by IHE for use in FormatCode
* [The IHE defined ValueSet](ValueSet-formatcode.md) - the valueset of codes for FormatCode use.

### Download

* [this entire guide](full-ig.zip)
* The source code for this Implementation Guide can be found on [IHE GitHub repository for FormatCode](https://github.com/IHE/FormatCode)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (ihe.formatcode.fhir.r4)](package.r4.tgz) and [R4B (ihe.formatcode.fhir.r4b)](package.r4b.tgz) are available.

#### Dependency Table



#### IP Statements

This publication includes IP covered under the following statements.

* Some content from IHE® Copyright © 2015 [IHE International, Inc](http://www.ihe.net/Governance/#Intellectual_Property) .

* [IHE Format Code set for use with Document Sharing](CodeSystem-formatcode.md): [IHE_FormatCode_vs](ValueSet-formatcode.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Provenance participant type](http://terminology.hl7.org/7.0.1/CodeSystem-provenance-participant-type.html): [Bundle/history-IHE-formatcode.codesystem](Bundle-history-IHE-formatcode.codesystem.md) and [Bundle/history-IHE-formatcode.valueset](Bundle-history-IHE-formatcode.valueset.md)
* [ActReason](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActReason.html): [Bundle/history-IHE-formatcode.codesystem](Bundle-history-IHE-formatcode.codesystem.md) and [Bundle/history-IHE-formatcode.valueset](Bundle-history-IHE-formatcode.valueset.md)
* [DataOperation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-DataOperation.html): [Bundle/history-IHE-formatcode.codesystem](Bundle-history-IHE-formatcode.codesystem.md) and [Bundle/history-IHE-formatcode.valueset](Bundle-history-IHE-formatcode.valueset.md)
* [HL7 Document Format Codes](http://terminology.hl7.org/7.0.1/CodeSystem-v3-HL7DocumentFormatCodes.html): [IHE_FormatCode_codesystem](CodeSystem-formatcode.md) and [IHE_FormatCode_vs](ValueSet-formatcode.md)


#### Globals

*There are no Global profiles defined*

