# FormatCode CodeSystem - IHE FormatCode Vocabulary v1.4.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **FormatCode CodeSystem**

## CodeSystem: FormatCode CodeSystem 

| | |
| :--- | :--- |
| *Official URL*:http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode | *Version*:1.4.1-current |
| Active as of 2024-03-27 | *Computable Name*:IHE_FormatCode_codesystem |
| *Other Identifiers:*OID:1.3.6.1.4.1.19376.1.2.3 | |
| **Copyright/Legal**: Some content from IHE® Copyright © 2015 [IHE International, Inc](http://www.ihe.net/Governance/#Intellectual_Property). | |

 
The [IHE](http://www.ihe.net) FormatCode code system with canonical URI of http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode is defined to be the set of FormatCodes define by IHE, for use with [Document Sharing](https://profiles.ihe.net/ITI/HIE-Whitepaper/index.html). This code set additionally includes, as deprecated, format codes defined by [HL7 for some Implementation Guides](http://wiki.hl7.org/index.php?title=CDA_Format_Codes_for_IHE_XDS). The HL7 codes are now managed by HL7. The set of IHE FormatCode codes was listed in HITSP C80 Table 2-153 Format Code Value Set Definition, but since has been updated. The use of the FormatCode specifies the technical format of the document. The FormatCode tends to reference the IHE Content Profile (Implementation Guide) that defines the use-case and constraints. The FormatCode is a further specialization more detailed than the mime-type. The FormatCode provides sufficient metadata information to allow any potential document content consumer to know if it can process and/or display by identifying a document encoding, structure and template. The set of codes is intended to be preferred. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [IHE_FormatCode_vs](ValueSet-formatcode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "formatcode",
  "url" : "http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode",
  "identifier" : [{
    "system" : "urn:ietf:rfc:3986",
    "value" : "urn:oid:1.3.6.1.4.1.19376.1.2.3"
  }],
  "version" : "1.4.1-current",
  "name" : "IHE_FormatCode_codesystem",
  "title" : "IHE Format Code set for use with Document Sharing",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-03-27",
  "publisher" : "Integrating the Healthcare Enterprise (IHE)",
  "contact" : [{
    "name" : "IHE",
    "telecom" : [{
      "system" : "url",
      "value" : "http://ihe.net"
    }]
  },
  {
    "name" : "IHE Secretary",
    "telecom" : [{
      "system" : "email",
      "value" : "secretary@ihe.net"
    }]
  }],
  "description" : "The [IHE](http://www.ihe.net) FormatCode code system with canonical URI of http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode is defined to be the set of FormatCodes define by IHE, for use with [Document Sharing](https://profiles.ihe.net/ITI/HIE-Whitepaper/index.html). This code set additionally includes, as deprecated, format codes defined by [HL7 for some Implementation Guides](http://wiki.hl7.org/index.php?title=CDA_Format_Codes_for_IHE_XDS). The HL7 codes are now managed by HL7. The set of IHE FormatCode codes was listed in HITSP C80 Table 2-153 Format Code Value Set Definition, but since has been updated. The use of the FormatCode specifies the technical format of the document. The FormatCode tends to reference the IHE Content Profile (Implementation Guide) that defines the use-case and constraints. The FormatCode is a further specialization more detailed than the mime-type. The FormatCode provides sufficient metadata information to allow any potential document content consumer to know if it can process and/or display by identifying a document encoding, structure and template. The set of codes is intended to be preferred.",
  "jurisdiction" : [{
    "coding" : [{
      "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
      "code" : "001"
    }]
  }],
  "copyright" : "Some content from IHE® Copyright © 2015 [IHE International, Inc](http://www.ihe.net/Governance/#Intellectual_Property).",
  "caseSensitive" : true,
  "hierarchyMeaning" : "grouped-by",
  "content" : "complete",
  "property" : [{
    "code" : "status",
    "uri" : "http://hl7.org/fhir/concept-properties#status",
    "description" : "A property that indicates the status of the concept. Used to indicate Deprecated and Retired terms.",
    "type" : "code"
  },
  {
    "code" : "notSelectable",
    "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
    "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
    "type" : "boolean"
  },
  {
    "code" : "comment",
    "uri" : "http://hl7.org/fhir/concept-properties#comment",
    "description" : "Indicates the CDA-Template to use with the given formatCode, when CDA mime-type is used.",
    "type" : "string"
  }],
  "concept" : [{
    "code" : "urn:ihe:pcc",
    "display" : "PCC Domain",
    "definition" : "Ontology group for all PCC defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:pcc:xphr:2007",
      "display" : "PCC XPHR",
      "definition" : "Personal Health Records. Also known as HL7 CCD and HITSP C32",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.5"
      },
      {
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.6"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:aps:2007",
      "display" : "PCC APS",
      "definition" : "IHE Antepartum Summary",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.11.2"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:xds-ms:2007",
      "display" : "PCC XDS-MS",
      "definition" : "XDS Medical Summaries",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.3"
      },
      {
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.4"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:edr:2007",
      "display" : "PCC EDR",
      "definition" : "Emergency Department Referral (EDR)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.10"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:edes:2007",
      "display" : "PCC EDES",
      "definition" : "Emergency Department Encounter Summary (EDES)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.13.1.1"
      },
      {
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.13.1.2"
      },
      {
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.13.1.3"
      },
      {
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.13.1.4"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:apr:handp:2008",
      "display" : "PCC APR HANDP",
      "definition" : "Antepartum Record (APR) - History and Physical",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.16.1.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:apr:lab:2008",
      "display" : "PCC APR LAB",
      "definition" : "Antepartum Record (APR) - Laboratory",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.16.1.2"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:apr:edu:2008",
      "display" : "PCC APR EDU",
      "definition" : "Antepartum Record (APR) - Education",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.16.1.3"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:crc:2008",
      "display" : "PCC CRC",
      "definition" : "Cancer Registry Content (CRC)",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:cm:2008",
      "display" : "Care Management (CM)",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:ic:2008",
      "display" : "Immunization Registry Content (IRC)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.18.1.2"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:ic:2009",
      "display" : "Immunization Registry Content (IRC)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.18.1.2"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:pcc:tn:2007",
      "display" : "PCC TN",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:nn:2007",
      "display" : "PCC NN",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:ctn:2007",
      "display" : "PCC CTN",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:edpn:2007",
      "display" : "PCC EDPN",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:hp:2008",
      "display" : "PCC HP",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:ldhp:2009",
      "display" : "PCC LDHP",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:lds:2009",
      "display" : "PCC LDS",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:mds:2009",
      "display" : "PCC MDS",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:nds:2010",
      "display" : "PCC NDS",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:ppvs:2010",
      "display" : "PCC PPVS",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:trs:2011",
      "display" : "PCC TRS",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:ets:2011",
      "display" : "PCC ETS",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:its:2011",
      "display" : "PCC ITS",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:ript:2017",
      "display" : "PCC RIPT",
      "definition" : "Routine Interfacility Patient Transport (RIPT)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.28.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:pcs-cs:2018",
      "display" : "PCC PCS-CS",
      "definition" : "Paramedicine Care Summary - Clinical Subset (PCS-CS)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.29.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:pcs-cr:2018",
      "display" : "PCC PCS-CR",
      "definition" : "Paramedicine Care Summary - Complete Report (PCS-CR)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.30.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:ips:2020",
      "display" : "PCC IPS",
      "definition" : "International Patient Summary (IPS)",
      "property" : [{
        "code" : "comment",
        "valueString" : "2.16.840.1.113883.10.22.1.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:360x:hl7:OMG:O19:2017",
      "display" : "PCC 360X Referral Request",
      "definition" : "HL7v2 OMG^O19 message used for 360X referral request",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:360x:hl7:OSU:O51:2017",
      "display" : "PCC 360X Referral Status Update",
      "definition" : "HL7v2 OSU^O51 message used for 360X referral status",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:360x:hl7:SIU:S12:2017",
      "display" : "PCC 360X Appointment Notification",
      "definition" : "HL7v2 SIU^S12 message used for 360X appointment notification",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:360x:hl7:SIU:S13:2017",
      "display" : "PCC 360X Appointment Reschedule Notification",
      "definition" : "HL7v2 SIU^S13 message used for 360X appointment reschedule notification",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:360x:hl7:SIU:S15:2017",
      "display" : "PCC 360X Appointment Cancel Notification",
      "definition" : "HL7v2 SIU^S15 message used for 360X appointment cancel notification",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pcc:360x:hl7:SIU:S26:2017",
      "display" : "PCC 360X Appointment No-show Notification",
      "definition" : "HL7v2 SIU^S26 message used for 360X appointment no-show notification",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  },
  {
    "code" : "urn:ihe:iti",
    "display" : "IT-Infrastructure Domain",
    "definition" : "Ontology group for all ITI defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:iti:bppc:2007",
      "display" : "ITI BPPC",
      "definition" : "Basic Patient Privacy Consents",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.7"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:iti:bppc-sd:2007",
      "display" : "ITI BPPC-SD",
      "definition" : "Basic Patient Privacy Consents with Scanned Document",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.5.3.1.1.7.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:iti:xds-sd:pdf:2008",
      "display" : "ITI XDS-SD PDF",
      "definition" : "PDF embedded in CDA per XDS-SD profile",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.2.20"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:iti:xds-sd:text:2008",
      "display" : "ITI XDS-SD TEXT",
      "definition" : "Text embedded in CDA per XDS-SD profile",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.2.20"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:iti:xdw:2011:workflowDoc",
      "display" : "ITI XDW",
      "definition" : "XDW Workflow Document",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:iti:dsg:detached:2014",
      "display" : "ITI DSG Detached",
      "definition" : "DSG Detached Document",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:iti:dsg:enveloping:2014",
      "display" : "ITI DSG Enveloping",
      "definition" : "DSG Enveloping Document",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:iti:appc:2016:consent",
      "display" : "ITI APPC",
      "definition" : "Advanced Patient Privacy Consents",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:iti:xds:2017:mimeTypeSufficient",
      "display" : "mimeType Sufficient",
      "definition" : "Code to be used when the mimeType is sufficient to understanding the technical format. May be used when no more specific FormatCode is available and the mimeType is sufficient to identify the technical format",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  },
  {
    "code" : "urn:ihe:lab",
    "display" : "Lab Domain",
    "definition" : "Ontology group for all LAB defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:lab:xd-lab:2008",
      "display" : "LAB XD-LAB",
      "definition" : "CDA Laboratory Report",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.3.3"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  },
  {
    "code" : "urn:ihe:rad",
    "display" : "Radiology Domain",
    "definition" : "Ontology group for all Radiology defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:rad:TEXT",
      "display" : "RAD TEXT",
      "definition" : "Radiology XDS-I Text",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:rad:PDF",
      "display" : "RAD PDF",
      "definition" : "Radiology XDS-I PDF",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:rad:CDA:ImagingReportStructuredHeadings:2013",
      "display" : "RAD CDA",
      "definition" : "Radiology XDS-I Structured CDA",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  },
  {
    "code" : "urn:ihe:card",
    "display" : "Cardiology Domain",
    "definition" : "Ontology group for all Cardiology defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:card:imaging:2011",
      "display" : "CARD Imaging",
      "definition" : "Cardiac Imaging Report (CRC)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.4.1.1.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:card:CRC:2012",
      "display" : "CARD CRC",
      "definition" : "Cardiology Cardiology Cath Report Content (CRC)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.4.1.1.2"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:card:EPRC-IE:2014",
      "display" : "CARD EPRC-IE",
      "definition" : "Cardiology Electrophysiology Implant/Explant Report Content (EPRC-IE)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.4.1.1.3"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:card:CPN:2017",
      "display" : "CARD CPN",
      "definition" : "Cardiology Procedure Note (CPN)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.4.1.1.4"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  },
  {
    "code" : "urn:ihe:dent",
    "display" : "Dental Domain",
    "definition" : "Ontology group for all Dental defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:dent:TEXT",
      "display" : "DENT TEXT",
      "definition" : "Dental CDA Wrapped Text Report (DENT)",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:dent:PDF",
      "display" : "DENT PDF",
      "definition" : "Dental PDF (DENT)",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:dent:CDA:ImagingReportStructuredHeadings:2013",
      "display" : "DENT CDA",
      "definition" : "Dental Imaging Report with Structured Headings (DENT)",
      "property" : [{
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  },
  {
    "code" : "urn:ihe:palm",
    "display" : "Pathology Domain",
    "definition" : "Ontology group for all Pathology defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:palm:apsr:2016",
      "display" : "PALM APSR",
      "definition" : "Anatomic Pathology Structured Report",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.8.1.1.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  },
  {
    "code" : "urn:ihe:pharm",
    "display" : "Pharmacy Domain",
    "definition" : "Ontology group for all Pharmacy defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:pharm:pre:2010",
      "display" : "Pharmacy PRE",
      "definition" : "Community Prescription (PRE)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.9.1.1.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pharm:padv:2010",
      "display" : "Pharmacy PADV",
      "definition" : "Community Pharmaceutical Advice (PADV)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.9.1.1.2"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pharm:dis:2010",
      "display" : "Pharmacy DIS",
      "definition" : "Community Dispense (DIS)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.9.1.1.3"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pharm:pml:2013",
      "display" : "Pharmacy PML",
      "definition" : "Community Medication List (PML)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.9.1.1.5"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pharm:mtp:2015",
      "display" : "Pharmacy MTP",
      "definition" : "Medication Treatment Plan (MTP)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.9.1.1.6"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:pharm:cma:2017",
      "display" : "Pharmacy CMA",
      "definition" : "Community Medication Administration (CMA)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.9.1.1.4"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  },
  {
    "code" : "urn:ihe:qrph",
    "display" : "QRPH Domain",
    "definition" : "Ontology group for all QRPH defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:qrph:crd:2008",
      "display" : "QRPH CRD",
      "definition" : "Clinical Research Document (CRD)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.10"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:dsc:2008",
      "display" : "QRPH DSC",
      "definition" : "Drug Safety Content (DSC)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.11"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:mch:2009",
      "display" : "QRPH MCH",
      "definition" : "Mother and Child Health (MCH)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.13"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:qrph:hbs:2009",
      "display" : "QRPH HBS",
      "definition" : "Health Birth Summary (HBS)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.13.1"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:qrph:prph:2009",
      "display" : "QRPH PRPH-Ca",
      "definition" : "Physician Reporting to a Public Health Repository - Cancer Registry (PRPH-Ca)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.14"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:ehcp:2010",
      "display" : "QRPH EHCP",
      "definition" : "Early Hearing Care Plan (EHCP)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.15"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:qrph:qmd-eh:2010",
      "display" : "QRPH QMD-EH",
      "definition" : "Quality Measure Definition - Early Hearing (QMD-EH)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.17"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:qrph:qme-eh:2010",
      "display" : "QRPH QME-EH",
      "definition" : "Quality Measure Execution - Early Hearing (QME-EH)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.18"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:qrph:bfdr:2011",
      "display" : "QRPH BFDR",
      "definition" : "Birth and Fetal Death Report (BFDR)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.19"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:qrph:LDS-VR:2013",
      "display" : "QRPH LDS-VR",
      "definition" : "Birth and Fetal Death Reporting - LDS-VR",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.19.1.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:BFDR-Birth:2014",
      "display" : "QRPH BFDR Birth CDA document",
      "definition" : "BFDR Birth CDA document",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.19.2"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:BFDR-FDeath:2014",
      "display" : "QRPH BFDR Death CDA document",
      "definition" : "BFDR Death CDA document",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.19.3"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:crpc:2012",
      "display" : "QRPH CRPC",
      "definition" : "Clinical Research Process Content (CRPC)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.21"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:qrph:vrdr:2013",
      "display" : "QRPH VRDR",
      "definition" : "Vital Records Death Reporting (VRDR)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.23.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:ms-vrdr:2013",
      "display" : "QRPH MS-VRDR",
      "definition" : "Medical Summary for VRDR Pre-pop (VRDR)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.23.2"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:hw:2013",
      "display" : "QRPH HW",
      "definition" : "Healthy Weight (HW)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.24.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:ehdi:2014",
      "display" : "QRPH EHDI",
      "definition" : "Early Hearing Detection Intervention (EHDI)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.26"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:qrph:NHS-Catl-UV:2015",
      "display" : "QRPH EHDI NHS Cat I",
      "definition" : "Early Hearing Detection Intervention (EHDI) NHS QRDA Category I Report UV",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.26"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:NHS-CatIII-UV:2015",
      "display" : "QRPH EHDI NHS Cat III",
      "definition" : "Early Hearing Detection Intervention (EHDI) NHS QRDA Category III Report UV",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.26"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:HPoCUS:2014",
      "display" : "QRPH HPoC US",
      "definition" : "Hearing Plan of Care (HPoC) - US Realm",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.26"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:HPoCUV:2014",
      "display" : "QRPH HPoC UV",
      "definition" : "Hearing Plan of Care (HPoC) - UV Realm",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.26"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:fp:2014",
      "display" : "QRPH FP",
      "definition" : "Family Planning (FP)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.27"
      },
      {
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "code" : "urn:ihe:qrph:fp:2017",
      "display" : "QRPH FP V2",
      "definition" : "Family Planning (FP V2)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.27.1"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:ehdiwd:2013",
      "display" : "QRPH EHDI-WD",
      "definition" : "Early Hearing Detection and Intervention – Workflow Document (EHDI-WD)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.28"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:qrph:prq:2019",
      "display" : "QRPH PRQ",
      "definition" : "Prescription Repository Query (PRQ)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.7.3.1.1.30"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  },
  {
    "code" : "urn:hl7",
    "display" : "HL7 Organization",
    "definition" : "Ontology group for all legacy HL7 defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    },
    {
      "code" : "status",
      "valueCode" : "deprecated"
    }],
    "concept" : [{
      "extension" : [{
        "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby",
        "valueCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes",
          "code" : "urn:hl7-org:sdwg:ccda-structuredBody:1.1"
        }
      }],
      "code" : "urn:hl7-org:sdwg:ccda-structuredBody:1.1",
      "display" : "For documents following C-CDA 1.1 constraints using a structured body.",
      "definition" : "Now available in HL7 CodeSystem v3-HL7DocumentFormatCodes.",
      "property" : [{
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "extension" : [{
        "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby",
        "valueCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes",
          "code" : "urn:hl7-org:sdwg:ccda-nonXMLBody:1.1"
        }
      }],
      "code" : "urn:hl7-org:sdwg:ccda-nonXMLBody:1.1",
      "display" : "For documents following C-CDA 1.1 constraints using a non structured body.",
      "definition" : "Now available in HL7 CodeSystem v3-HL7DocumentFormatCodes.",
      "property" : [{
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "extension" : [{
        "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby",
        "valueCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes",
          "code" : "urn:hl7-org:sdwg:ccda-structuredBody:2.1"
        }
      }],
      "code" : "urn:hl7-org:sdwg:ccda-structuredBody:2.1",
      "display" : "For documents following C-CDA 2.1 constraints using a structured body.",
      "definition" : "Now available in HL7 CodeSystem v3-HL7DocumentFormatCodes.",
      "property" : [{
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    },
    {
      "extension" : [{
        "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby",
        "valueCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-HL7DocumentFormatCodes",
          "code" : "urn:hl7-org:sdwg:ccda-nonXMLBody:2.1"
        }
      }],
      "code" : "urn:hl7-org:sdwg:ccda-nonXMLBody:2.1",
      "display" : "For documents following C-CDA 2.1 constraints using a non structured body.",
      "definition" : "Now available in HL7 CodeSystem v3-HL7DocumentFormatCodes.",
      "property" : [{
        "code" : "status",
        "valueCode" : "deprecated"
      }]
    }]
  },
  {
    "code" : "urn:ihe:eyecare",
    "display" : "Eye Care Domain",
    "definition" : "Ontology group for all Eye Care defined FormatCodes",
    "property" : [{
      "code" : "notSelectable",
      "valueBoolean" : true
    }],
    "concept" : [{
      "code" : "urn:ihe:eyecare:geneyeevalpn:2014",
      "display" : "EYECARE GEE",
      "definition" : "General Eye Evaluation(GEE) C-CDA Progress Note",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.12.1.1.2"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:eyecare:geneyeevalcn:2014",
      "display" : "EYECARE GEE",
      "definition" : "General Eye Evaluation(GEE) C-CDA Consultation Note",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.12.1.1.3"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    },
    {
      "code" : "urn:ihe:eyecare:summary:2015",
      "display" : "EYECARE EC-SUMMARY",
      "definition" : "Eye Care Summary Record (EC-Summary)",
      "property" : [{
        "code" : "comment",
        "valueString" : "1.3.6.1.4.1.19376.1.12.1.1.4"
      },
      {
        "code" : "status",
        "valueCode" : "active"
      }]
    }]
  }]
}

```
