# Australian States and Territories - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Australian States and Territories**

## ValueSet: Australian States and Territories 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2 | *Version*:2.0.2 | |
| Active as of 2020-05-31 | *Responsible:*Australian Digital Health Agency | *Computable Name*:AustralianStatesAndTerritories |
| *Other Identifiers:*OID:1.2.36.1.2001.1004.201.10026 | | |
| **Copyright/Legal**: Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/.This resource includes material that is based on Australian Institute of Health and Welfare material.All copies of this resource must include this copyright statement and all information contained in this statement. | | |

 
The Australian States and Territories value set includes values that represent the Australian states and territories. 

 **References** 

* [Australian Address](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-au-address.html)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "australian-states-territories-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablevalueset",
      "https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4"
    ]
  },
  "url" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:1.2.36.1.2001.1004.201.10026"
    }
  ],
  "version" : "2.0.2",
  "name" : "AustralianStatesAndTerritories",
  "title" : "Australian States and Territories",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-31",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    }
  ],
  "description" : "The Australian States and Territories value set includes values that represent the Australian states and territories.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. \n\nThis resource includes material that is based on Australian Institute of Health and Welfare material. \n\nAll copies of this resource must include this copyright statement and all information contained in this statement.",
  "compose" : {
    "include" : [
      {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
        "concept" : [
          {
            "code" : "ACT"
          },
          {
            "code" : "NSW"
          },
          {
            "code" : "NT"
          },
          {
            "code" : "OTHER"
          },
          {
            "code" : "QLD"
          },
          {
            "code" : "SA"
          },
          {
            "code" : "TAS"
          },
          {
            "code" : "VIC"
          },
          {
            "code" : "WA"
          }
        ]
      }
    ]
  }
}

```
