# Australian Pronouns - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Australian Pronouns**

## ValueSet: Australian Pronouns 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://healthterminologies.gov.au/fhir/ValueSet/australian-pronouns-1 | *Version*:1.0.0 | |
| Active as of 2024-02-29 | *Responsible:*Australian Digital Health Agency | *Computable Name*:AustralianPronouns |
| *Other Identifiers:*OID:1.2.36.1.2001.1004.201.10284 | | |
| **Copyright/Legal**: Copyright © 2024 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/.This material contains content from LOINC (http://loinc.org). LOINC is copyright 1995-2024, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.This material contains information which is protected by copyright. You may download, display, print and reproduce any material for your personal, non-commercial use or use within your organisation subject to the following terms and conditions:This resource also includes all or a portion of material from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license. | | |

 
The Australian Pronouns value set includes values that indicate the pronouns to be used when communicating with or about an individual. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "australian-pronouns-1",
  "url" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-pronouns-1",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:1.2.36.1.2001.1004.201.10284"
    }
  ],
  "version" : "1.0.0",
  "name" : "AustralianPronouns",
  "title" : "Australian Pronouns",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-02-29",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    }
  ],
  "description" : "The Australian Pronouns value set includes values that indicate the pronouns to be used when communicating with or about an individual.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2024 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. \n\nThis material contains content from LOINC (http://loinc.org). LOINC is copyright 1995-2024, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.\n\nThis material contains information which is protected by copyright. You may download, display, print and reproduce any material for your personal, non-commercial use or use within your organisation subject to the following terms and conditions: \n\nThis resource also includes all or a portion of material from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "LA29518-0",
            "display" : "he/him/his/his/himself"
          },
          {
            "code" : "LA29519-8",
            "display" : "she/her/her/hers/herself"
          },
          {
            "code" : "LA29520-6",
            "display" : "they/them/their/theirs/themselves"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
        "concept" : [
          {
            "code" : "unknown"
          },
          {
            "code" : "asked-declined"
          },
          {
            "code" : "not-asked"
          },
          {
            "code" : "asked-unknown"
          }
        ]
      }
    ]
  }
}

```
