# Smart Health Checks Patch AllergyIntolerance Element Name - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Patch AllergyIntolerance Element Name**

## ValueSet: Smart Health Checks Patch AllergyIntolerance Element Name 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/ValueSet/SHCPatchAllergyIntoleranceElementName | *Version*:0.4.0 |
| Draft as of 2025-12-18 | *Computable Name*:SHCPatchAllergyIntoleranceElementName |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The Smart Health Checks Patch AllergyIntolerance Element Name value set includes values that can be used to identify the element names in the AllergyIntolerance resource that are the target of a patch operation for Smart Health Checks. 

 **References** 

* [Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SHCPatchAllergyIntoleranceElementName",
  "url" : "https://smartforms.csiro.au/ig/ValueSet/SHCPatchAllergyIntoleranceElementName",
  "version" : "0.4.0",
  "name" : "SHCPatchAllergyIntoleranceElementName",
  "title" : "Smart Health Checks Patch AllergyIntolerance Element Name",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-18T05:29:19+00:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "The Smart Health Checks Patch AllergyIntolerance Element Name value set includes values that can be used to identify the element names in the AllergyIntolerance resource that are the target of a patch operation for Smart Health Checks.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "compose" : {
    "include" : [
      {
        "system" : "https://smartforms.csiro.au/ig/CodeSystem/SHCPatchElementNameCodes",
        "concept" : [
          {
            "code" : "clinicalStatus"
          },
          {
            "code" : "text"
          },
          {
            "code" : "note"
          }
        ]
      }
    ]
  }
}

```
