# AU Core Head Circumference - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AU Core Head Circumference**

## Resource Profile: AU Core Head Circumference 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/StructureDefinition/au-core-headcircum | *Version*:0.2.2-preview | | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Responsible:*[HL7 Australia](https://confluence.hl7.org/display/HAFWG) | *Computable Name*:AUCoreHeadCircumference |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.This resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO. The rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material. No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted.This material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2021, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.All copies of this resource must include this copyright statement and all information contained in this statement. | | | |

 
This profile sets minimum expectations for an Observation resource to record, search, and fetch head circumference observations with standard coding and units of measure. It is based on the[FHIR Head Circumference Profile](http://hl7.org/fhir/R4/headcircum.html)and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets that**SHALL**be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. 

**Usages:**

* Derived from this Profile: [Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/au-core-headcircum)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-core-headcircum.csv), [Excel](StructureDefinition-au-core-headcircum.xlsx), [Schematron](StructureDefinition-au-core-headcircum.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-core-headcircum",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-headcircum",
  "version" : "0.2.2-preview",
  "name" : "AUCoreHeadCircumference",
  "title" : "AU Core Head Circumference",
  "status" : "draft",
  "date" : "2023-11-16T10:32:02+11:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch head circumference observations with standard coding and units of measure. It is based on the [FHIR Head Circumference Profile](http://hl7.org/fhir/R4/headcircum.html) and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.\n\nThis resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO. The rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material.  No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted. \n\nThis material contains content from LOINC (http://loinc.org). LOINC is copyright © 1995-2021, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.\n\nAll copies of this resource must include this copyright statement and all information contained in this statement.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/headcircum",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Head circumference",
        "definition" : "Measurement of a patient's head circumference at a point in time.",
        "comment" : "Head circumference observation using a LOINC code, a SNOMED CT code and a metric UCUM unit of measure.",
        "constraint" : [
          {
            "key" : "au-core-obs-02",
            "severity" : "error",
            "human" : "At least value or data absent reason shall be present",
            "expression" : "dataAbsentReason.exists() or value.exists()",
            "xpath" : "exists(f:*[starts-with(local-name(.), 'value')]) or exists(f:dataAbsentReason)",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-headcircum"
          }
        ]
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "fixedCode" : "final"
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "min" : 2
      },
      {
        "id" : "Observation.code.coding:snomedHeadCircumCode",
        "path" : "Observation.code.coding",
        "sliceName" : "snomedHeadCircumCode",
        "short" : "SNOMED CT Head Circumference",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Observation.code.coding:snomedHeadCircumCode.system",
        "path" : "Observation.code.coding.system",
        "min" : 1,
        "fixedUri" : "http://snomed.info/sct"
      },
      {
        "id" : "Observation.code.coding:snomedHeadCircumCode.code",
        "path" : "Observation.code.coding.code",
        "min" : 1,
        "fixedCode" : "363812007"
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
            ]
          }
        ]
      },
      {
        "id" : "Observation.encounter",
        "path" : "Observation.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "Date, and optionally time, the observation was performed",
        "definition" : "Date, and optionally time, the observation was performed.",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "condition" : ["au-core-obs-01"],
        "constraint" : [
          {
            "key" : "au-core-obs-01",
            "severity" : "error",
            "human" : "Date shall be at least to day",
            "expression" : "$this is DateTime implies $this.toString().length() >= 10",
            "xpath" : "f:matches(effectiveDateTime,/\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d([+-][0-2]\\d:[0-5]\\d|Z)/)",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-headcircum"
          }
        ]
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "short" : "Head circumference",
        "condition" : ["au-core-obs-02"]
      },
      {
        "id" : "Observation.value[x]:valueQuantity.code",
        "path" : "Observation.value[x].code",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/metric-body-length-units-1"
        }
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "condition" : ["au-core-obs-02"],
        "mustSupport" : true
      },
      {
        "id" : "Observation.bodySite",
        "path" : "Observation.bodySite",
        "condition" : ["au-core-obs-04"],
        "constraint" : [
          {
            "key" : "au-core-obs-04",
            "severity" : "error",
            "human" : "If a coded body site is provided, at least one code shall be from SNOMED CT",
            "expression" : "coding.exists() implies coding.where(system='http://snomed.info/sct').exists()",
            "xpath" : "not(exists(f:coding/f:system)) or exists(f:coding/f:system[@value='http://snomed.info/sct'])",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-headcircum"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/body-site-1"
        }
      }
    ]
  }
}

```
