# Template Extract Extension Patch Request URL - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Template Extract Extension Patch Request URL**

## Extension: Template Extract Extension Patch Request URL 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/TemplateExtractExtensionPatchRequestUrl | *Version*:0.4.0 |
| Draft as of 2025-12-18 | *Computable Name*:TemplateExtractExtensionPatchRequestUrl |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

This extension is used to specify the value of the request URL for a bundle entry containing a Parameters resource for a PATCH method. It identifies the resource instance being patched and will specify both the resource type and the resource Id. It is to be used as a sub-extension of the [Extract Template - Resource](https://build.fhir.org/ig/HL7/sdc/StructureDefinition-sdc-questionnaire-templateExtract.html) extension.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [AboriginalTorresStraitIslanderHealthCheck](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.md), [AllergiesAdverseReactions](Questionnaire-AllergiesAdverseReactions.md), [MedicalHistoryCurrentProblems](Questionnaire-MedicalHistoryCurrentProblems.md) and [RegularMedications](Questionnaire-RegularMedications.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/TemplateExtractExtensionPatchRequestUrl)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.csv), [Excel](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.xlsx), [Schematron](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TemplateExtractExtensionPatchRequestUrl",
  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/TemplateExtractExtensionPatchRequestUrl",
  "version" : "0.4.0",
  "name" : "TemplateExtractExtensionPatchRequestUrl",
  "title" : "Template Extract Extension Patch Request URL",
  "status" : "draft",
  "date" : "2025-12-18T05:29:19+00:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This extension is used to specify the value of the request URL for a bundle entry containing a Parameters resource for a PATCH method. It identifies the resource instance being patched and will specify both the resource type and the resource Id. It is to be used as a sub-extension of the [Extract Template - Resource](https://build.fhir.org/ig/HL7/sdc/StructureDefinition-sdc-questionnaire-templateExtract.html) extension.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "extension",
      "expression" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "A FHIRPath expression to evaluate the bundle entry request URL for a PATCH entry (string result). E.g. 'AllergyIntolerance/' + item.where(linkId='allergyIntoleranceId').answer.value",
        "definition" : "This extension is used to specify the value of the request URL for a bundle entry containing a Parameters resource for a PATCH method. It identifies the resource instance being patched and will specify both the resource type and the resource Id. It is to be used as a sub-extension of the [Extract Template - Resource](https://build.fhir.org/ig/HL7/sdc/StructureDefinition-sdc-questionnaire-templateExtract.html) extension."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://smartforms.csiro.au/ig/StructureDefinition/TemplateExtractExtensionPatchRequestUrl"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
