# Smart Health Checks Patch MedicationStatement - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Patch MedicationStatement**

## Resource Profile: Smart Health Checks Patch MedicationStatement 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement | *Version*:0.4.0 |
| Draft as of 2025-12-18 | *Computable Name*:SmartHealthChecksPatchMedicationStatement |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the expectations for a Parameters resource when used to patch MedicationStatement resources within Smart Health Checks. 

### Usage Scenarios

This profile supports updating MedicationStatement resource elements that are applicable to Smart Health Checks using the FHIRPath patch method. FHIRPath patch uses the Parameters resource to describe how a patch operation should be performed.

The elements that can be updated using this profile are as follows:

* Profile: [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md)
  * Element path: * `MedicationStatement.status`
* `MedicationStatement.dosage[0].text`
* `MedicationStatement.note[0].text`


### Profile Specific Implementation Guidance

* `Parameters.parameter.part:path.value[x]:valueString` **SHALL** identify one of the relevant MedicationStatement element paths included in the [Smart Health Checks Patch MedicationStatement Element Path value set](ValueSet-SHCPatchMedicationStatementElementPath.md): `MedicationStatement`, `MedicationStatement.dosage[0]`, or `MedicationStatement.note[0]`.
* `Parameters.parameter.part:name.value[x]:valueString` **SHALL** identify one of the relevant MedicationStatement element paths included in the [Smart Health Checks Patch MedicationStatement Element Name value set](ValueSet-SHCPatchMedicationStatementElementName.md): `status`, `text`, `dosage` or `note`.
* When the path value is `MedicationStatement` and the name value is `status`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `code`
* `Parameters.parameter.part:value.value[x]:valueCode` **SHALL** have a value from the [Medication Statement Status Limited value set](ValueSet-MedicationStatementStatusLimited.md).
 
* When the path value is `MedicationStatement` and the name value is `dosage`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `Dosage`.
 
* When the path value is `MedicationStatement.dosage[0]` and the name value is `text`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `string`.
 
* When the path value is `MedicationStatement` and the name value is `note`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `Annotation`.
 
* When the path value is `MedicationStatement.note[0]` and the name value is `text`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `markdown`.
 

Illustrative examples are provided.

`Parameters.parameter.part:value.value[x]` has **Must Support** obligations on each of the allowed data types. Due to a validation issue, it is not currently possible to have slices defined for both `valueCode` and `valueString`. For this reason, `valueString` is not currently defined as a slice and does not have **Must Support** obligations included in the StructureDefinition.

`valueString` is to be considered a **Must Support** data type with the same obligations as the other allowed data types (as below).

| | |
| :--- | :--- |
| `SHALL:process` | SHC Host FHIR Server |
| `SHALL:populate-if-known` | SHC App |

**Usages:**

* Use this Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)
* Examples for this Profile: [Parameters/SHCPatchMedicationStatement1](Parameters-SHCPatchMedicationStatement1.md), [Parameters/SHCPatchMedicationStatement2](Parameters-SHCPatchMedicationStatement2.md), [Parameters/SHCPatchMedicationStatement3](Parameters-SHCPatchMedicationStatement3.md) and [Parameters/SHCPatchMedicationStatement4](Parameters-SHCPatchMedicationStatement4.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCPatchMedicationStatement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SHCPatchMedicationStatement.csv), [Excel](StructureDefinition-SHCPatchMedicationStatement.xlsx), [Schematron](StructureDefinition-SHCPatchMedicationStatement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SHCPatchMedicationStatement",
  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement",
  "version" : "0.4.0",
  "name" : "SmartHealthChecksPatchMedicationStatement",
  "title" : "Smart Health Checks Patch MedicationStatement",
  "status" : "draft",
  "date" : "2025-12-18T05:29:19+00:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This profile sets the expectations for a Parameters resource when used to patch MedicationStatement resources within Smart Health Checks.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Parameters",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Parameters",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Parameters",
        "path" : "Parameters",
        "short" : "Parameters for patching MedicationStatement resource elements supported in Smart Health Checks",
        "constraint" : [
          {
            "key" : "shc-patch-medication-statement-01",
            "severity" : "error",
            "human" : "When the part parameter named 'path' has a value of 'MedicationStatement' and the part parameter named 'name' has a value of 'status', the part parameter named 'value' SHALL have a value from the 'Medication Statement Status Limited' value set.",
            "expression" : "parameter.where(part.where(name='path').value = 'MedicationStatement' and part.where(name='name').value = 'status').exists() implies parameter.where(part.where(name='path').value = 'MedicationStatement' and part.where(name='name').value = 'status').part.where(name='value').value.memberOf('https://smartforms.csiro.au/ig/ValueSet/MedicationStatementStatusLimited')",
            "source" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          },
          {
            "key" : "shc-patch-medication-statement-02",
            "severity" : "error",
            "human" : "When the part parameter named 'path' has a value of 'MedicationStatement' and the part parameter named 'name' has a value of 'dosage', the part parameter named 'value' SHALL have a value of type Dosage.",
            "expression" : "parameter.where(part.where(name='path').value = 'MedicationStatement' and part.where(name='name').value = 'dosage').exists() implies parameter.where(part.where(name='path').value = 'MedicationStatement' and part.where(name='name').value = 'dosage').part.where(name='value').value is Dosage",
            "source" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          },
          {
            "key" : "shc-patch-medication-statement-03",
            "severity" : "error",
            "human" : "When the part parameter named 'path' has a value of 'MedicationStatement.dosage[0]' and the part parameter named 'name' has a value of 'text', the part parameter named 'value' SHALL have a value of type string.",
            "expression" : "parameter.where(part.where(name='path').value = 'MedicationStatement.dosage[0]' and part.where(name='name').value = 'text').exists() implies parameter.where(part.where(name='path').value = 'MedicationStatement.dosage[0]' and part.where(name='name').value = 'text').part.where(name='value').value is string",
            "source" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          },
          {
            "key" : "shc-patch-medication-statement-04",
            "severity" : "error",
            "human" : "When the part parameter named 'path' has a value of 'MedicationStatement' and the part parameter named 'name' has a value of 'note', the part parameter named 'value' SHALL have a value of type Annotation.",
            "expression" : "parameter.where(part.where(name='path').value = 'MedicationStatement' and part.where(name='name').value = 'note').exists() implies parameter.where(part.where(name='path').value = 'MedicationStatement' and part.where(name='name').value = 'note').part.where(name='value').value is Annotation",
            "source" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          },
          {
            "key" : "shc-patch-medication-statement-05",
            "severity" : "error",
            "human" : "When the part parameter named 'path' has a value of 'MedicationStatement.note[0]' and the part parameter named 'name' has a value of 'text', the part parameter named 'value' SHALL have a value of type markdown.",
            "expression" : "parameter.where(part.where(name='path').value = 'MedicationStatement.note[0]' and part.where(name='name').value = 'text').exists() implies parameter.where(part.where(name='path').value = 'MedicationStatement.note[0]' and part.where(name='name').value = 'text').part.where(name='value').value is markdown",
            "source" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          }
        ]
      },
      {
        "id" : "Parameters.parameter",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.name",
        "fixedString" : "operation",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part",
        "path" : "Parameters.parameter.part",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 4
      },
      {
        "id" : "Parameters.parameter.part:type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part",
        "sliceName" : "type",
        "short" : "Patch operation to perform",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:type.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "type",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:type.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "add",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:path",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part",
        "sliceName" : "path",
        "short" : "Where to perform the operation",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:path.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "path",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:path.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://smartforms.csiro.au/ig/ValueSet/SHCPatchMedicationStatementElementPath"
        }
      },
      {
        "id" : "Parameters.parameter.part:name",
        "path" : "Parameters.parameter.part",
        "sliceName" : "name",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Parameters.parameter.part:name.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "name",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:name.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://smartforms.csiro.au/ig/ValueSet/SHCPatchMedicationStatementElementName"
        }
      },
      {
        "id" : "Parameters.parameter.part:value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part",
        "sliceName" : "value",
        "short" : "Replacement value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "value",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1,
        "type" : [
          {
            "code" : "code"
          },
          {
            "code" : "markdown"
          },
          {
            "code" : "string"
          },
          {
            "code" : "Annotation"
          },
          {
            "code" : "Dosage"
          }
        ],
        "condition" : [
          "shc-patch-medication-statement-01",
          "shc-patch-medication-statement-02",
          "shc-patch-medication-statement-03",
          "shc-patch-medication-statement-04",
          "shc-patch-medication-statement-05"
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueCode",
        "path" : "Parameters.parameter.part.value[x]",
        "sliceName" : "valueCode",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://smartforms.csiro.au/ig/ValueSet/MedicationStatementStatusLimited"
        }
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueDosage",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "sliceName" : "valueDosage",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Dosage"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueDosage.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x].text",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueMarkdown",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "sliceName" : "valueMarkdown",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "markdown"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueAnnotation",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "sliceName" : "valueAnnotation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Annotation"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueAnnotation.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x].text",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:pathLabel",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part",
        "sliceName" : "pathLabel",
        "short" : "Human readable representation of the path. Typically this is the relevant item text from the Questionnaire.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:pathLabel.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "pathLabel",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:pathLabel.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
