# Smart Health Checks AllergyIntolerance - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks AllergyIntolerance**

## Resource Profile: Smart Health Checks AllergyIntolerance 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCAllergyIntolerance | *Version*:0.4.0 |
| Draft as of 2025-12-18 | *Computable Name*:SmartHealthChecksAllergyIntolerance |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the minimum expectations for an AllergyIntolerance resource to record, search and save allergy or intolerance information when used within Smart Health Checks. 

**Usages:**

* Use this Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)
* Examples for this Profile: [AllergyIntolerance/604a-pat-sf](AllergyIntolerance-604a-pat-sf.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCAllergyIntolerance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SHCAllergyIntolerance.csv), [Excel](StructureDefinition-SHCAllergyIntolerance.xlsx), [Schematron](StructureDefinition-SHCAllergyIntolerance.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SHCAllergyIntolerance",
  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCAllergyIntolerance",
  "version" : "0.4.0",
  "name" : "SmartHealthChecksAllergyIntolerance",
  "title" : "Smart Health Checks AllergyIntolerance",
  "status" : "draft",
  "date" : "2025-12-18T05:29:19+00:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This profile sets the minimum expectations for an AllergyIntolerance resource to record, search and save allergy or intolerance information when used within Smart Health Checks.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance"
      },
      {
        "id" : "AllergyIntolerance.id",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "AllergyIntolerance.id",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.clinicalStatus",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "AllergyIntolerance.clinicalStatus",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://smartforms.csiro.au/ig/ValueSet/AllergyIntoleranceClinicalStatusMinimal"
        }
      },
      {
        "id" : "AllergyIntolerance.verificationStatus",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "AllergyIntolerance.verificationStatus"
      },
      {
        "id" : "AllergyIntolerance.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "AllergyIntolerance.code"
      },
      {
        "id" : "AllergyIntolerance.code.text",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable",
            "valueBoolean" : true
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "AllergyIntolerance.code.text",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.patient",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "AllergyIntolerance.patient"
      },
      {
        "id" : "AllergyIntolerance.note",
        "path" : "AllergyIntolerance.note",
        "max" : "1"
      },
      {
        "id" : "AllergyIntolerance.note.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "AllergyIntolerance.note.text",
        "mustSupport" : true
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "AllergyIntolerance.reaction.manifestation"
      }
    ]
  }
}

```
