# Aboriginal and Torres Strait Islander Health Check - Finalising the Health Check - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Aboriginal and Torres Strait Islander Health Check - Finalising the Health Check**

## Questionnaire: Aboriginal and Torres Strait Islander Health Check - Finalising the Health Check 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715/FinalisingHealthCheck | *Version*:0.4.0 |
| Draft as of 2025-03-14 | *Computable Name*:FinalisingHealthCheck |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "FinalisingHealthCheck",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-render",
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-modular"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assemble-expectation",
      "valueCode" : "assemble-child"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "patient"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Patient"
        },
        {
          "url" : "description",
          "valueString" : "The patient that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "user"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Practitioner"
        },
        {
          "url" : "description",
          "valueString" : "The practitioner user that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "encounter"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Encounter"
        },
        {
          "url" : "description",
          "valueString" : "The encounter that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembleContext",
      "valueString" : "age"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Questionnaire.versionAlgorithm[x]",
      "valueCoding" : {
        "system" : "http://hl7.org/fhir/version-algorithm",
        "code" : "semver"
      }
    }
  ],
  "url" : "http://www.health.gov.au/assessments/mbs/715/FinalisingHealthCheck",
  "version" : "0.4.0",
  "name" : "FinalisingHealthCheck",
  "title" : "Aboriginal and Torres Strait Islander Health Check - Finalising the Health Check",
  "status" : "draft",
  "experimental" : false,
  "subjectType" : ["Patient"],
  "date" : "2025-03-14",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%age.exists()"
          }
        }
      ],
      "linkId" : "16971bd2-5494-483d-9713-eda182c47f02",
      "text" : "Finalising the health check",
      "type" : "group",
      "repeats" : false,
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-31').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-31').answer.value.empty()"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-in-progress-31",
          "text" : "In progress",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-31').answer.value = 'Complete'"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-complete-31",
          "text" : "Complete",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-31').answer.value = 'Attention required'"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-attention-31",
          "text" : "Attention required",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 5"
              }
            }
          ],
          "linkId" : "30532ad8-3465-4bdd-97ed-ec5664f9d733",
          "text" : "Patient priorities and goals: What does the parent/carer say are the important things that have come out of this health check?",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "(%age <= 12) and (%age > 5)"
              }
            }
          ],
          "linkId" : "6aa0a113-4d33-4f6b-9899-fa249674075a",
          "text" : "Patient priorities and goals: What does the parent/carer and child say are the important things that have come out of this health check?",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age > 12"
              }
            }
          ],
          "linkId" : "71c19d58-a8ae-43ba-8b96-463c108c75dc",
          "text" : "Patient priorities and goals: What does the patient say are the important things that have come out of this health check?",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 5"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "check-box"
                  }
                ]
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
              "valueString" : "Other"
            }
          ],
          "linkId" : "d0e58402-a08a-49ca-b2ca-9f4bbdb89da0",
          "text" : "Brief intervention: advice and information provided during health check",
          "type" : "open-choice",
          "repeats" : true,
          "answerOption" : [
            {
              "valueString" : "Sugary drinks"
            },
            {
              "valueString" : "Screen use"
            },
            {
              "valueString" : "Healthy eating, including breastfeeding"
            },
            {
              "valueString" : "Environmental exposure to harmful elements eg tobacco smoke"
            },
            {
              "valueString" : "Physical activity and exercise"
            },
            {
              "valueString" : "Sun protection"
            },
            {
              "valueString" : "Parenting advice"
            },
            {
              "valueString" : "Safe sleeping practices"
            },
            {
              "valueString" : "Developmental milestones - including language and hearing"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "(%age <= 12) and (%age > 5)"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "check-box"
                  }
                ]
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
              "valueString" : "Other"
            }
          ],
          "linkId" : "0f70dec3-c1f2-4b36-b1f6-bd7f5743d5f8",
          "text" : "Brief intervention: advice and information provided during health check",
          "type" : "open-choice",
          "repeats" : true,
          "answerOption" : [
            {
              "valueString" : "Healthy eating"
            },
            {
              "valueString" : "Screen use"
            },
            {
              "valueString" : "Sun protection"
            },
            {
              "valueString" : "Environmental exposure to harmful elements (e.g. tobacco smoke)"
            },
            {
              "valueString" : "Sugary drinks"
            },
            {
              "valueString" : "Physical activity and exercise"
            },
            {
              "valueString" : "Parenting advice"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "(%age <= 24) and (%age > 12)"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "check-box"
                  }
                ]
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
              "valueString" : "Other"
            }
          ],
          "linkId" : "eaed9770-95f4-4c6a-b06c-d573427a2616",
          "text" : "Brief intervention: advice and information provided during health check",
          "type" : "open-choice",
          "repeats" : true,
          "answerOption" : [
            {
              "valueString" : "Healthy eating"
            },
            {
              "valueString" : "Screen use"
            },
            {
              "valueString" : "Physical activity and exercise"
            },
            {
              "valueString" : "Mental health and wellbeing"
            },
            {
              "valueString" : "Safety/risky behaviours"
            },
            {
              "valueString" : "Smoking cessation"
            },
            {
              "valueString" : "Substance use/harm minimisation"
            },
            {
              "valueString" : "Safe sex/contraception"
            },
            {
              "valueString" : "Care of teeth and gums"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "(%age <= 49) and (%age > 24)"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "check-box"
                  }
                ]
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
              "valueString" : "Other"
            }
          ],
          "linkId" : "25f27e83-fcf0-49c8-86c1-e285e201a043",
          "text" : "Brief intervention: advice and information provided during health check",
          "type" : "open-choice",
          "repeats" : true,
          "answerOption" : [
            {
              "valueString" : "Healthy eating"
            },
            {
              "valueString" : "Screen use"
            },
            {
              "valueString" : "Physical activity and exercise"
            },
            {
              "valueString" : "Mental health and wellbeing"
            },
            {
              "valueString" : "Carer support"
            },
            {
              "valueString" : "Safety/risky behaviours"
            },
            {
              "valueString" : "Smoking cessation"
            },
            {
              "valueString" : "Substance use/harm minimisation"
            },
            {
              "valueString" : "Safe sex/contraception"
            },
            {
              "valueString" : "Oral and dental health"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age > 49"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "check-box"
                  }
                ]
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
              "valueString" : "Other"
            }
          ],
          "linkId" : "2657da9c-a27e-4939-af7a-08a19b9ab6f7",
          "text" : "Brief intervention: advice and information provided during health check",
          "type" : "open-choice",
          "repeats" : true,
          "answerOption" : [
            {
              "valueString" : "Healthy eating"
            },
            {
              "valueString" : "Physical activity and exercise"
            },
            {
              "valueString" : "Mental health and wellbeing"
            },
            {
              "valueString" : "Carer support"
            },
            {
              "valueString" : "Smoking cessation"
            },
            {
              "valueString" : "Substance use/harm minimisation"
            },
            {
              "valueString" : "Social support and services"
            },
            {
              "valueString" : "Oral and dental health"
            }
          ]
        },
        {
          "linkId" : "afbadad6-bef9-4fad-b5f4-111f666ccf11",
          "text" : "Care provided as part of the health check (eg immunisations, medication review, investigations requested)",
          "type" : "text"
        },
        {
          "linkId" : "4b3015f6-5b0a-4dfa-9791-994e4059f921",
          "text" : "Identified needs and plan (including new diagnoses)",
          "type" : "text"
        },
        {
          "linkId" : "5760a1f9-d725-4b9e-b74d-50800615a689",
          "text" : "Follow-up",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-display-category",
                        "code" : "instructions"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "b4110a63-8547-4aa2-84c6-c1f64f0d24da",
              "text" : "Consider what follow-up appointments can be made at the time of the health check.",
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-display-category",
                        "code" : "instructions"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "c47cfd7e-0f15-4dd9-bd53-bb62851b677c",
              "text" : "Reminder: MBS follow up items for clients at risk of or with chronic disease are available to support follow-up of health checks",
              "type" : "display"
            },
            {
              "linkId" : "1be25c55-2a2d-4b94-b826-bd17d9e35e92",
              "text" : "Referrals and appointments",
              "type" : "group",
              "repeats" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age <= 5"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "drop-down"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "4044d0b4-94b2-4a89-b826-a14614298511",
                  "text" : "Who",
                  "type" : "open-choice",
                  "repeats" : false,
                  "answerOption" : [
                    {
                      "valueString" : "GP follow-up"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                    },
                    {
                      "valueString" : "Practice nurse follow-up"
                    },
                    {
                      "valueString" : "Child health nurse"
                    },
                    {
                      "valueString" : "Dentist"
                    },
                    {
                      "valueString" : "Paediatrician"
                    },
                    {
                      "valueString" : "Audiology"
                    },
                    {
                      "valueString" : "Speech pathology"
                    },
                    {
                      "valueString" : "Mental health"
                    },
                    {
                      "valueString" : "Early intervention (development) services"
                    },
                    {
                      "valueString" : "Parenting programs/support services"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "(%age <= 12) and (%age > 5)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "drop-down"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "f97f211a-ef2a-49a3-aef7-c4e9cd08aa2a",
                  "text" : "Who",
                  "type" : "open-choice",
                  "repeats" : false,
                  "answerOption" : [
                    {
                      "valueString" : "GP follow-up"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                    },
                    {
                      "valueString" : "Practice nurse follow-up"
                    },
                    {
                      "valueString" : "Dentist"
                    },
                    {
                      "valueString" : "Paediatrician"
                    },
                    {
                      "valueString" : "Audiology"
                    },
                    {
                      "valueString" : "Speech pathology"
                    },
                    {
                      "valueString" : "Mental health"
                    },
                    {
                      "valueString" : "Parenting programs/support services"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "(%age <= 24) and (%age > 12)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "drop-down"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "07cfe077-ba93-4f93-b2a5-027023faa33b",
                  "text" : "Who",
                  "type" : "open-choice",
                  "repeats" : false,
                  "answerOption" : [
                    {
                      "valueString" : "GP follow-up"
                    },
                    {
                      "valueString" : "GP review of results of investigations"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                    },
                    {
                      "valueString" : "Practice nurse follow-up"
                    },
                    {
                      "valueString" : "Dentist"
                    },
                    {
                      "valueString" : "Paediatrician"
                    },
                    {
                      "valueString" : "Audiology"
                    },
                    {
                      "valueString" : "Speech pathology"
                    },
                    {
                      "valueString" : "Parenting programs/support services"
                    },
                    {
                      "valueString" : "Social and emotional wellbeing/mental health"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "(%age <= 49) and (%age > 24)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "drop-down"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "a525c370-d8c3-4764-ab3a-bf62081725e0",
                  "text" : "Who",
                  "type" : "open-choice",
                  "repeats" : false,
                  "answerOption" : [
                    {
                      "valueString" : "GP follow-up"
                    },
                    {
                      "valueString" : "GP review of results of investigations"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                    },
                    {
                      "valueString" : "Practice nurse follow-up"
                    },
                    {
                      "valueString" : "Dentist"
                    },
                    {
                      "valueString" : "Medication review"
                    },
                    {
                      "valueString" : "Smoking cessation"
                    },
                    {
                      "valueString" : "Audiology"
                    },
                    {
                      "valueString" : "Dietician"
                    },
                    {
                      "valueString" : "Physiotherapist or exercise program"
                    },
                    {
                      "valueString" : "Parenting programs/support services"
                    },
                    {
                      "valueString" : "Social and emotional wellbeing/mental health"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age > 49"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "drop-down"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "d68d9693-48d3-4663-9dbb-dd3a7aec5278",
                  "text" : "Who",
                  "type" : "open-choice",
                  "repeats" : false,
                  "answerOption" : [
                    {
                      "valueString" : "GP follow-up"
                    },
                    {
                      "valueString" : "GP review of results of investigations"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                    },
                    {
                      "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                    },
                    {
                      "valueString" : "Practice nurse follow-up"
                    },
                    {
                      "valueString" : "Dentist"
                    },
                    {
                      "valueString" : "Medication review"
                    },
                    {
                      "valueString" : "Geriatrician"
                    },
                    {
                      "valueString" : "Smoking cessation"
                    },
                    {
                      "valueString" : "Audiologist"
                    },
                    {
                      "valueString" : "Dietician"
                    },
                    {
                      "valueString" : "Physiotherapist or exercise program"
                    },
                    {
                      "valueString" : "Optometrist"
                    },
                    {
                      "valueString" : "Podiatrist"
                    },
                    {
                      "valueString" : "Social and emotional wellbeing/mental health"
                    },
                    {
                      "valueString" : "Social support and services"
                    }
                  ]
                },
                {
                  "linkId" : "0ef84b09-ca34-44c2-96d1-fcbbea0bae66",
                  "text" : "When",
                  "type" : "date",
                  "enableWhen" : [
                    {
                      "question" : "4044d0b4-94b2-4a89-b826-a14614298511",
                      "operator" : "exists",
                      "answerBoolean" : true
                    },
                    {
                      "question" : "f97f211a-ef2a-49a3-aef7-c4e9cd08aa2a",
                      "operator" : "exists",
                      "answerBoolean" : true
                    },
                    {
                      "question" : "07cfe077-ba93-4f93-b2a5-027023faa33b",
                      "operator" : "exists",
                      "answerBoolean" : true
                    },
                    {
                      "question" : "a525c370-d8c3-4764-ab3a-bf62081725e0",
                      "operator" : "exists",
                      "answerBoolean" : true
                    },
                    {
                      "question" : "d68d9693-48d3-4663-9dbb-dd3a7aec5278",
                      "operator" : "exists",
                      "answerBoolean" : true
                    }
                  ],
                  "enableBehavior" : "any",
                  "repeats" : false
                }
              ]
            }
          ]
        },
        {
          "linkId" : "a400fe69-c99f-47ed-bee1-083c3e4be467",
          "text" : "Recalls",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-display-category",
                        "code" : "instructions"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "b0c69e16-5dc3-481f-8e8f-fc0a93627184",
              "text" : "e.g. clinical review, investigations, influenza vaccination, asthma plan/cycle of care, diabetes cycle of care, care plan review, cervical screening, investigations",
              "type" : "display"
            },
            {
              "linkId" : "fece6a3c-f8f1-4592-a166-5ea5a3c60c8e",
              "text" : "Recall entered",
              "type" : "string",
              "repeats" : true
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 5"
              }
            }
          ],
          "linkId" : "5a0c98f8-5349-4045-9ba0-27a4f35630b9",
          "text" : "Parent/carer actions",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "(%age <= 12) and (%age > 5)"
              }
            }
          ],
          "linkId" : "cde03bf0-182a-4998-a37e-7b3f22786617",
          "text" : "Parent/patient actions",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age > 12"
              }
            }
          ],
          "linkId" : "51ff0c15-312a-45ce-a25a-6c6a4bf0e17e",
          "text" : "Patient actions",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "radio-button"
                  }
                ]
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
              "valueString" : "Copy of health check"
            }
          ],
          "linkId" : "8176151f-6d86-45eb-91b1-12458d75a181",
          "text" : "A copy of this health check has been offered - including details of follow-up and future appointments",
          "type" : "choice",
          "repeats" : false,
          "answerOption" : [
            {
              "valueString" : "Yes, copy taken"
            },
            {
              "valueString" : "Yes, but declined"
            },
            {
              "valueString" : "Not offered. Plan to follow up and offer at a later date"
            }
          ]
        },
        {
          "linkId" : "finalising-section-end-divider",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                "valueString" : "border-top: 1px solid #ccc;"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "radio-button"
                  }
                ]
              }
            }
          ],
          "linkId" : "MarkComplete-31",
          "text" : "Section completion status",
          "type" : "choice",
          "repeats" : false,
          "answerOption" : [
            {
              "valueString" : "Complete"
            },
            {
              "valueString" : "In progress"
            },
            {
              "valueString" : "Attention required"
            }
          ]
        }
      ]
    }
  ]
}

```
