# Aboriginal and Torres Strait Islander Health Check - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Aboriginal and Torres Strait Islander Health Check**

## Questionnaire: Aboriginal and Torres Strait Islander Health Check 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715 | *Version*:0.4.0-assembled |
| Draft as of 2025-03-14 | *Computable Name*:AboriginalTorresStraitIslanderHealthCheck |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

### Background

The long-term vision for effective Aboriginal and Torres Strait Islander health checks is of a standards-based health check template that is consistent and interoperable across different systems and applications whilst allowing for local adaptation.

The NACCHO and RACGP established a working group to review the Aboriginal and Torres Strait Islander annual health check templates and have produced five new templates that span the life course:

1. Infants and preschool (birth-5 years)
1. Primary school age (5-12 years)
1. Adolescents and young people (12-24 years)
1. Adults (25-49 years)
1. Older people (50+ years)

These example templates can be downloaded from the [RACGP](https://www.racgp.org.au/the-racgp/faculties/aboriginal-and-torres-strait-islander-health/guides/resources/2019-mbs-item-715-health-check-templates).

This resource is FHIR Questionnaire representation of the templates above.



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "AboriginalTorresStraitIslanderHealthCheck",
  "contained" : [
    {
      "resourceType" : "ValueSet",
      "id" : "YesNoNA",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/valueset-supplement",
          "valueCanonical" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksExpandedYesNoIndicatorSupplement|0.4.0"
        }
      ],
      "url" : "https://smartforms.csiro.au/ig/ValueSet/YesNoNA",
      "name" : "YesNoNA",
      "title" : "Yes/No/NA",
      "status" : "draft",
      "experimental" : false,
      "description" : "Concepts for Yes, No and Not applicable",
      "compose" : {
        "include" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "concept" : [
              {
                "code" : "Y",
                "display" : "Yes"
              },
              {
                "code" : "N",
                "display" : "No"
              },
              {
                "code" : "NA",
                "display" : "N/A"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:e9020f5b-3df2-4fcb-9f8f-9aa20ef6f181",
        "timestamp" : "2025-10-29T16:30:17+10:00",
        "total" : 3,
        "parameter" : [
          {
            "name" : "used-supplement",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksExpandedYesNoIndicatorSupplement|0.4.0"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v2-0532|2.0.0"
          },
          {
            "name" : "version",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v2-0532|2.0.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksExpandedYesNoIndicatorSupplement|0.4.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/ValueSet/YesNoNA|0.4.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "code" : "Y",
            "display" : "Yes"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "code" : "N",
            "display" : "No"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "code" : "NA",
            "display" : "N/A"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "AboriginalTorresStraitIslander",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/valueset-supplement",
          "valueCanonical" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksAustralianIndigenousStatusSupplement|0.4.0"
        }
      ],
      "url" : "https://smartforms.csiro.au/ig/ValueSet/AboriginalTorresStraitIslander",
      "name" : "AboriginalTorresStraitIslander",
      "title" : "Aboriginal and/or Torres Strait Islander",
      "status" : "draft",
      "experimental" : false,
      "description" : "The Aboriginal and/or Torres Strait Islander value set includes the Australian Indigenous statuses for Indigenous people.",
      "compose" : {
        "include" : [
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
            "version" : "1.0.5",
            "concept" : [
              {
                "code" : "1",
                "display" : "Aboriginal"
              },
              {
                "code" : "2",
                "display" : "Torres Strait Islander"
              },
              {
                "code" : "3",
                "display" : "Aboriginal and Torres Strait Islander"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:99d3428a-7ac4-47ff-b2b7-e50ccf5e1b49",
        "timestamp" : "2025-10-29T16:34:14+10:00",
        "total" : 3,
        "parameter" : [
          {
            "name" : "used-supplement",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksAustralianIndigenousStatusSupplement|0.4.0"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1|1.0.5"
          },
          {
            "name" : "version",
            "valueUri" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1|1.0.5"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/ValueSet/AboriginalTorresStraitIslander|0.4.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksAustralianIndigenousStatusSupplement|0.4.0"
          }
        ],
        "contains" : [
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
            "version" : "1.0.5",
            "code" : "1",
            "display" : "Aboriginal"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
            "version" : "1.0.5",
            "code" : "2",
            "display" : "Torres Strait Islander"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
            "version" : "1.0.5",
            "code" : "3",
            "display" : "Aboriginal and Torres Strait Islander"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "PrimaryCarerParentGrandparent",
      "url" : "https://smartforms.csiro.au/ig/ValueSet/PrimaryCarerParentGrandparent",
      "name" : "PrimaryCarerParentGrandparent",
      "title" : "Primary Carer Of Parent Or Grandparent",
      "status" : "draft",
      "experimental" : false,
      "description" : "The Primary Carer Of Parent Or Grandparent value set includes values that can indicate whether a primary carer is one of the parents or a grandparent.",
      "compose" : {
        "include" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
            "concept" : [
              {
                "code" : "MTH"
              },
              {
                "code" : "FTH"
              },
              {
                "code" : "GRPRN"
              }
            ]
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
            "concept" : [
              {
                "code" : "NA"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:f8e7efc2-94d6-403e-9e40-3a3a4e9fffb4",
        "timestamp" : "2025-05-01T10:00:56+10:00",
        "total" : 4,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en-US"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode|3.0.0"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor|3.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
            "code" : "MTH",
            "display" : "mother"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
            "code" : "FTH",
            "display" : "father"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
            "code" : "GRPRN",
            "display" : "grandparent"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
            "code" : "NA",
            "display" : "not applicable"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "administrative-gender",
      "meta" : {
        "profile" : ["http://hl7.org/fhir/StructureDefinition/shareablevalueset"]
      },
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
          "valueCode" : "pa"
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "normative"
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
          "valueInteger" : 5
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version",
          "valueCode" : "4.0.0"
        }
      ],
      "url" : "http://hl7.org/fhir/ValueSet/administrative-gender",
      "identifier" : [
        {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:2.16.840.1.113883.4.642.3.1"
        }
      ],
      "version" : "4.0.1",
      "name" : "AdministrativeGender",
      "title" : "AdministrativeGender",
      "status" : "active",
      "experimental" : false,
      "date" : "2019-11-01T09:29:23+11:00",
      "publisher" : "HL7 (FHIR Project)",
      "contact" : [
        {
          "telecom" : [
            {
              "system" : "url",
              "value" : "http://hl7.org/fhir"
            },
            {
              "system" : "email",
              "value" : "fhir@lists.hl7.org"
            }
          ]
        }
      ],
      "description" : "The gender of a person used for administrative purposes.",
      "immutable" : true,
      "copyright" : "Copyright © 2011+ HL7. Licensed under Creative Commons \"No Rights Reserved\".",
      "compose" : {
        "include" : [
          {
            "system" : "http://hl7.org/fhir/administrative-gender"
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:31c9098a-778c-4de6-9c2b-4f1e2db26179",
        "timestamp" : "2025-05-01T10:00:55+10:00",
        "total" : 4,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en-US"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://hl7.org/fhir/administrative-gender|4.0.1"
          }
        ],
        "contains" : [
          {
            "system" : "http://hl7.org/fhir/administrative-gender",
            "code" : "male",
            "display" : "Male"
          },
          {
            "system" : "http://hl7.org/fhir/administrative-gender",
            "code" : "female",
            "display" : "Female"
          },
          {
            "system" : "http://hl7.org/fhir/administrative-gender",
            "code" : "other",
            "display" : "Other"
          },
          {
            "system" : "http://hl7.org/fhir/administrative-gender",
            "code" : "unknown",
            "display" : "Unknown"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "australian-pronouns-1",
      "url" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-pronouns-1",
      "identifier" : [
        {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:1.2.36.1.2001.1004.201.10284"
        }
      ],
      "version" : "1.0.0",
      "name" : "AustralianPronouns",
      "title" : "Australian Pronouns",
      "status" : "active",
      "experimental" : false,
      "date" : "2024-02-29",
      "publisher" : "Australian Digital Health Agency",
      "contact" : [
        {
          "telecom" : [
            {
              "system" : "email",
              "value" : "help@digitalhealth.gov.au"
            }
          ]
        }
      ],
      "description" : "The Australian Pronouns value set includes values that indicate the pronouns to be used when communicating with or about an individual.",
      "copyright" : "Copyright © 2024 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. \n\nThis material contains content from LOINC (http://loinc.org). LOINC is copyright 1995-2024, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.\n\nThis material contains information which is protected by copyright. You may download, display, print and reproduce any material for your personal, non-commercial use or use within your organisation subject to the following terms and conditions: \n\nThis resource also includes all or a portion of material from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.",
      "compose" : {
        "include" : [
          {
            "system" : "http://loinc.org",
            "concept" : [
              {
                "code" : "LA29518-0",
                "display" : "he/him/his/his/himself"
              },
              {
                "code" : "LA29519-8",
                "display" : "she/her/her/hers/herself"
              },
              {
                "code" : "LA29520-6",
                "display" : "they/them/their/theirs/themselves"
              }
            ]
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "concept" : [
              {
                "code" : "unknown"
              },
              {
                "code" : "asked-declined"
              },
              {
                "code" : "not-asked"
              },
              {
                "code" : "asked-unknown"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:1bc98e8c-511f-4014-a4d9-a48a8db0923d",
        "timestamp" : "2025-05-01T10:00:56+10:00",
        "total" : 7,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en-US"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://loinc.org|2.80"
          },
          {
            "name" : "version",
            "valueUri" : "http://loinc.org|2.80"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/data-absent-reason|1.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA29518-0",
            "display" : "he/him/his/his/himself"
          },
          {
            "system" : "http://loinc.org",
            "code" : "LA29519-8",
            "display" : "she/her/her/hers/herself"
          },
          {
            "system" : "http://loinc.org",
            "code" : "LA29520-6",
            "display" : "they/them/their/theirs/themselves"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "unknown",
            "display" : "Unknown"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "asked-declined",
            "display" : "Asked But Declined"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "not-asked",
            "display" : "Not Asked"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "asked-unknown",
            "display" : "Asked But Unknown"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "gender-identity-response-1",
      "url" : "https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1",
      "identifier" : [
        {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:1.2.36.1.2001.1004.201.10271"
        }
      ],
      "version" : "1.1.0",
      "name" : "GenderIdentityResponse",
      "title" : "Gender Identity Response",
      "status" : "active",
      "experimental" : false,
      "date" : "2024-02-29",
      "publisher" : "Australian Digital Health Agency",
      "contact" : [
        {
          "telecom" : [
            {
              "system" : "email",
              "value" : "help@digitalhealth.gov.au"
            }
          ]
        }
      ],
      "description" : "The Gender Identity Response value set includes values that may be used to represent a response for an individual's gender. A person's gender is a social and cultural identity, expression and experience.",
      "copyright" : "Copyright © 2022 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/.\n\n\"This resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO. \n\nThe rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material.  No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted. \n\nThis resource includes material that is based on Australian Institute of Health and Welfare material. This resource includes material that is based on Australian Bureau of Statistics data. \n\nThis resource also includes all or a portion of material from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "concept" : [
              {
                "code" : "446151000124109"
              },
              {
                "code" : "446141000124107"
              },
              {
                "code" : "33791000087105"
              }
            ]
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "concept" : [
              {
                "code" : "unknown"
              },
              {
                "code" : "asked-declined"
              },
              {
                "code" : "not-asked"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:5cd85856-1ce5-43f2-afff-063f748c2c7d",
        "timestamp" : "2025-10-28T16:39:25+10:00",
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "system-version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/data-absent-reason|1.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "446151000124109",
            "display" : "Identifies as male gender"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "446141000124107",
            "display" : "Identifies as female gender"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "33791000087105",
            "display" : "Identifies as nonbinary gender"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "unknown",
            "display" : "Unknown"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "asked-declined",
            "display" : "Asked But Declined"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "not-asked",
            "display" : "Not Asked"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "biological-sex-1",
      "meta" : {
        "profile" : [
          "http://hl7.org/fhir/StructureDefinition/shareablevalueset",
          "https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4"
        ]
      },
      "url" : "https://healthterminologies.gov.au/fhir/ValueSet/biological-sex-1",
      "identifier" : [
        {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:1.2.36.1.2001.1004.201.10198"
        }
      ],
      "version" : "1.1.0",
      "name" : "BiologicalSex",
      "title" : "Biological Sex",
      "status" : "active",
      "experimental" : false,
      "date" : "2024-11-30",
      "publisher" : "Australian Digital Health Agency",
      "contact" : [
        {
          "telecom" : [
            {
              "system" : "email",
              "value" : "help@digitalhealth.gov.au"
            }
          ]
        }
      ],
      "description" : "The Biological Sex value set includes values that represent the biological sex of an individual.",
      "copyright" : "Copyright © 2020 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. \n\nThis resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO. \n\nThe rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material.  No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted. \n\nAll copies of this resource must include this copyright statement and all information contained in this statement.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "filter" : [
              {
                "property" : "constraint",
                "op" : "=",
                "value" : "^ 32570631000036107|Sex reference set|"
              }
            ]
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "concept" : [
              {
                "code" : "asked-unknown"
              },
              {
                "code" : "unknown"
              },
              {
                "code" : "asked-declined"
              },
              {
                "code" : "not-asked"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:3491de0c-49f2-4913-8909-a63c92d14c9d",
        "timestamp" : "2025-10-28T16:39:14+10:00",
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "system-version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/data-absent-reason|1.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "248152002",
            "display" : "Female"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "32570681000036106",
            "display" : "Indeterminate sex"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "32570691000036108",
            "display" : "Intersex"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "248153007",
            "display" : "Male"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "asked-unknown",
            "display" : "Asked But Unknown"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "unknown",
            "display" : "Unknown"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "asked-declined",
            "display" : "Asked But Declined"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "not-asked",
            "display" : "Not Asked"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "australian-states-territories-2",
      "meta" : {
        "profile" : [
          "http://hl7.org/fhir/StructureDefinition/shareablevalueset",
          "https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4"
        ]
      },
      "url" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2",
      "identifier" : [
        {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:1.2.36.1.2001.1004.201.10026"
        }
      ],
      "version" : "2.0.2",
      "name" : "AustralianStatesAndTerritories",
      "title" : "Australian States and Territories",
      "status" : "active",
      "experimental" : false,
      "date" : "2020-05-31",
      "publisher" : "Australian Digital Health Agency",
      "contact" : [
        {
          "telecom" : [
            {
              "system" : "email",
              "value" : "help@digitalhealth.gov.au"
            }
          ]
        }
      ],
      "description" : "The Australian States and Territories value set includes values that represent the Australian states and territories.",
      "copyright" : "Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. \n\nThis resource includes material that is based on Australian Institute of Health and Welfare material. \n\nAll copies of this resource must include this copyright statement and all information contained in this statement.",
      "compose" : {
        "include" : [
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "concept" : [
              {
                "code" : "ACT"
              },
              {
                "code" : "NSW"
              },
              {
                "code" : "NT"
              },
              {
                "code" : "OTHER"
              },
              {
                "code" : "QLD"
              },
              {
                "code" : "SA"
              },
              {
                "code" : "TAS"
              },
              {
                "code" : "VIC"
              },
              {
                "code" : "WA"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:148e9412-a321-4a6f-b911-7e7908be82af",
        "timestamp" : "2025-05-01T10:00:57+10:00",
        "total" : 9,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en-US"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1|1.1.3"
          }
        ],
        "contains" : [
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "code" : "ACT",
            "display" : "Australian Capital Territory"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "code" : "NSW",
            "display" : "New South Wales"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "code" : "NT",
            "display" : "Northern Territory"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "code" : "OTHER",
            "display" : "Other territories"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "code" : "QLD",
            "display" : "Queensland"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "code" : "SA",
            "display" : "South Australia"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "code" : "TAS",
            "display" : "Tasmania"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "code" : "VIC",
            "display" : "Victoria"
          },
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1",
            "code" : "WA",
            "display" : "Western Australia"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "YesNo",
      "url" : "https://smartforms.csiro.au/ig/ValueSet/YesNo",
      "name" : "YesNo",
      "title" : "Yes/No",
      "status" : "draft",
      "experimental" : false,
      "description" : "Concepts for Yes and No",
      "compose" : {
        "include" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "concept" : [
              {
                "code" : "Y",
                "display" : "Yes"
              },
              {
                "code" : "N",
                "display" : "No"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:5d9dbf1e-e156-4961-bb02-051dfc831832",
        "timestamp" : "2025-09-18T16:28:54+10:00",
        "total" : 2,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v2-0532|2.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "Y",
            "display" : "Yes"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "N",
            "display" : "No"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "condition-clinical",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
          "valueCode" : "pc"
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "trial-use"
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
          "valueInteger" : 3
        }
      ],
      "url" : "http://hl7.org/fhir/ValueSet/condition-clinical",
      "identifier" : [
        {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:2.16.840.1.113883.4.642.3.164"
        }
      ],
      "version" : "4.0.1",
      "name" : "ConditionClinicalStatusCodes",
      "title" : "Condition Clinical Status Codes",
      "status" : "draft",
      "experimental" : false,
      "date" : "2019-11-01T09:29:23+11:00",
      "publisher" : "FHIR Project team",
      "contact" : [
        {
          "telecom" : [
            {
              "system" : "url",
              "value" : "http://hl7.org/fhir"
            }
          ]
        }
      ],
      "description" : "Preferred value set for Condition Clinical Status.",
      "copyright" : "Copyright © 2011+ HL7. Licensed under Creative Commons \"No Rights Reserved\".",
      "compose" : {
        "include" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical"
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:7b100d21-fde9-4fd8-bded-80f345db777d",
        "timestamp" : "2025-05-01T10:00:56+10:00",
        "total" : 7,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en-US"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/condition-clinical|3.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
            "code" : "active",
            "display" : "Active",
            "contains" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
                "code" : "recurrence",
                "display" : "Recurrence"
              },
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
                "code" : "relapse",
                "display" : "Relapse"
              }
            ]
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
            "code" : "inactive",
            "display" : "Inactive",
            "contains" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
                "code" : "remission",
                "display" : "Remission"
              },
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
                "code" : "resolved",
                "display" : "Resolved"
              }
            ]
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
            "code" : "unknown",
            "display" : "Unknown"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "clinical-condition-1",
      "meta" : {
        "profile" : [
          "http://hl7.org/fhir/StructureDefinition/shareablevalueset",
          "https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4"
        ]
      },
      "url" : "https://healthterminologies.gov.au/fhir/ValueSet/clinical-condition-1",
      "identifier" : [
        {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:1.2.36.1.2001.1004.201.10035"
        }
      ],
      "version" : "1.0.2",
      "name" : "ClinicalCondition",
      "title" : "Clinical Condition",
      "status" : "active",
      "experimental" : false,
      "date" : "2020-05-31",
      "publisher" : "Australian Digital Health Agency",
      "contact" : [
        {
          "telecom" : [
            {
              "system" : "email",
              "value" : "help@digitalhealth.gov.au"
            }
          ]
        }
      ],
      "description" : "The Clinical Condition value set includes values that cover a broad range of clinical concepts to support the representation of conditions, including problems, diagnoses and disorders.",
      "copyright" : "Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. \n\nThis resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO. \n\nThe rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material.  No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted. \n\nAll copies of this resource must include this copyright statement and all information contained in this statement.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "filter" : [
              {
                "property" : "concept",
                "op" : "in",
                "value" : "32570581000036105"
              }
            ]
          }
        ]
      }
    },
    {
      "resourceType" : "Condition",
      "id" : "ConditionTemplate",
      "clinicalStatus" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
            "code" : "active"
          }
        ]
      },
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
              "code" : "problem-list-item"
            }
          ]
        }
      ],
      "code" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractContext",
            "valueString" : "item.where(linkId='2da85994-2d5e-42f1-8a81-abf44f397468').answer.value"
          }
        ],
        "coding" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "ofType(Coding)"
              }
            ]
          }
        ],
        "_text" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "ofType(string)"
            }
          ]
        }
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_onsetDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "item.where(linkId='4d55bffb-3286-4a23-a785-3b9c346d464d').answer.value.toDateTime()"
          }
        ]
      },
      "note" : [
        {
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "item.where(linkId='newdiagnosis-comment').answer.value"
              }
            ]
          }
        }
      ]
    },
    {
      "resourceType" : "Parameters",
      "id" : "ConditionPatchTemplate",
      "parameter" : [
        {
          "name" : "operation",
          "part" : [
            {
              "name" : "type",
              "valueCode" : "add"
            },
            {
              "name" : "path",
              "valueString" : "Condition"
            },
            {
              "name" : "name",
              "valueString" : "clinicalStatus"
            },
            {
              "name" : "value",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                        "valueString" : "item.where(linkId='88bcfad7-386b-4d87-b34b-2e50482e4d2c').answer.value.first()"
                      }
                    ]
                  }
                ]
              }
            },
            {
              "name" : "pathLabel",
              "valueString" : "Clinical status"
            }
          ]
        },
        {
          "name" : "operation",
          "part" : [
            {
              "name" : "type",
              "valueCode" : "add"
            },
            {
              "name" : "path",
              "valueString" : "Condition"
            },
            {
              "name" : "name",
              "valueString" : "abatement"
            },
            {
              "name" : "value",
              "_valueDateTime" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "item.where(linkId='e4524654-f6de-4717-b288-34919394d46b').answer.value.first()"
                  }
                ]
              }
            },
            {
              "name" : "pathLabel",
              "valueString" : "Abatement date"
            }
          ]
        }
      ]
    },
    {
      "resourceType" : "ValueSet",
      "id" : "smart-health-checks-medicine-products",
      "url" : "https://smartforms.csiro.au/ig/ValueSet/smart-health-checks-medicine-products",
      "name" : "SmartHealthChecksMedicineProducts",
      "title" : "Smart Health Checks Medicine Products",
      "status" : "draft",
      "experimental" : false,
      "description" : "The Smart Health Checks Medicine Products value set includes Australian Medicines Terminology (AMT) product concepts that may be used for the identification of a medicine with form, ingredient and unit of measure details.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107",
            "filter" : [
              {
                "property" : "constraint",
                "op" : "=",
                "value" : "^ 929360081000036101|Medicinal product pack reference set| OR ^ 929360071000036103|Medicinal product unit of use reference set| OR ^ 929360041000036105|Trade product pack reference set| OR ^ 929360031000036100|Trade product unit of use reference set| OR ^ 929360051000036108|Containered trade product pack reference set|"
              }
            ]
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "medication-reason-taken-1",
      "meta" : {
        "profile" : [
          "http://hl7.org/fhir/StructureDefinition/shareablevalueset",
          "https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4"
        ]
      },
      "url" : "https://healthterminologies.gov.au/fhir/ValueSet/medication-reason-taken-1",
      "identifier" : [
        {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:1.2.36.1.2001.1004.201.10048"
        }
      ],
      "version" : "1.1.0",
      "name" : "MedicationReasonTaken",
      "title" : "Medication Reason Taken",
      "status" : "active",
      "experimental" : false,
      "date" : "2020-07-31",
      "publisher" : "Australian Digital Health Agency",
      "contact" : [
        {
          "telecom" : [
            {
              "system" : "email",
              "value" : "help@digitalhealth.gov.au"
            }
          ]
        }
      ],
      "description" : "The Medication Reason Taken value set includes values that identify a reason why a medication has been or is being taken.",
      "copyright" : "Copyright © 2020 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. \n\nThis resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO. \n\nThe rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material.  No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted.\n\nAll copies of this resource must include this copyright statement and all information contained in this statement.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "filter" : [
              {
                "property" : "constraint",
                "op" : "=",
                "value" : "^32570581000036105|Problem/Diagnosis reference set| OR ^1184831000168105|Drug prophylaxis reference set| OR <<399097000|Administration of anaesthesia| OR 169443000|Preventive procedure|"
              }
            ]
          }
        ]
      }
    },
    {
      "resourceType" : "MedicationStatement",
      "id" : "MedicationStatementTemplate",
      "status" : "active",
      "medicationCodeableConcept" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractContext",
            "valueString" : "item.where(linkId='regularmedications-summary-new-medication').answer.value"
          }
        ],
        "coding" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "ofType(Coding)"
              }
            ]
          }
        ],
        "_text" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "ofType(string)"
            }
          ]
        }
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_dateAsserted" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "now()"
          }
        ]
      },
      "reasonCode" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractContext",
              "valueString" : "item.where(linkId='regularmedications-summary-new-reasoncode').answer.value.ofType(Coding)"
            }
          ],
          "coding" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                  "valueString" : "$this"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractContext",
              "valueString" : "item.where(linkId='regularmedications-summary-new-reasoncode').answer.value.ofType(string)"
            }
          ],
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "$this"
              }
            ]
          }
        }
      ],
      "note" : [
        {
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "item.where(linkId='regularmedications-summary-new-comment').answer.value"
              }
            ]
          }
        }
      ],
      "dosage" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractContext",
              "valueString" : "item.where(linkId='regularmedications-summary-new-dosage').answer.value"
            }
          ],
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "$this"
              }
            ]
          }
        }
      ]
    },
    {
      "resourceType" : "Parameters",
      "id" : "MedicationStatementPatchTemplate",
      "parameter" : [
        {
          "name" : "operation",
          "part" : [
            {
              "name" : "type",
              "valueCode" : "add"
            },
            {
              "name" : "path",
              "valueString" : "MedicationStatement"
            },
            {
              "name" : "name",
              "valueString" : "status"
            },
            {
              "name" : "value",
              "_valueCode" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "item.where(linkId='regularmedications-summary-current-status').answer.value.code.first()"
                  }
                ]
              }
            },
            {
              "name" : "pathLabel",
              "valueString" : "Status"
            }
          ]
        },
        {
          "name" : "operation",
          "part" : [
            {
              "name" : "type",
              "valueCode" : "add"
            },
            {
              "name" : "path",
              "_valueString" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-dosage-hidden').answer.value.exists(), 'MedicationStatement.dosage[0]', 'MedicationStatement')"
                  }
                ]
              }
            },
            {
              "name" : "name",
              "_valueString" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-dosage-hidden').answer.value.exists(), 'text', 'dosage')"
                  }
                ]
              }
            },
            {
              "_name" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-dosage-hidden').answer.value.exists(), 'value')"
                  }
                ]
              },
              "_valueString" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-dosage-hidden').answer.value.exists(), item.where(linkId='regularmedications-summary-current-dosage').answer.value.first())"
                  }
                ]
              }
            },
            {
              "_name" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-dosage-hidden').answer.value.empty(), 'value')"
                  }
                ]
              },
              "valueDosage" : {
                "_text" : {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                      "valueString" : "iif(item.where(linkId='regularmedications-summary-current-dosage-hidden').answer.value.empty(), item.where(linkId='regularmedications-summary-current-dosage').answer.value.first())"
                    }
                  ]
                }
              }
            },
            {
              "name" : "pathLabel",
              "valueString" : "Dosage"
            }
          ]
        },
        {
          "name" : "operation",
          "part" : [
            {
              "name" : "type",
              "valueCode" : "add"
            },
            {
              "name" : "path",
              "_valueString" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-comment-hidden').answer.value.exists(), 'MedicationStatement.note[0]', 'MedicationStatement')"
                  }
                ]
              }
            },
            {
              "name" : "name",
              "_valueString" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-comment-hidden').answer.value.exists(), 'text', 'note')"
                  }
                ]
              }
            },
            {
              "_name" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-comment-hidden').answer.value.exists(), 'value')"
                  }
                ]
              },
              "_valueMarkdown" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-comment-hidden').answer.value.exists(), item.where(linkId='regularmedications-summary-current-comment').answer.value.first())"
                  }
                ]
              }
            },
            {
              "_name" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='regularmedications-summary-current-comment-hidden').answer.value.empty(), 'value')"
                  }
                ]
              },
              "valueAnnotation" : {
                "_text" : {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                      "valueString" : "iif(item.where(linkId='regularmedications-summary-current-comment-hidden').answer.value.empty(), item.where(linkId='regularmedications-summary-current-comment').answer.value.first())"
                    }
                  ]
                }
              }
            },
            {
              "name" : "pathLabel",
              "valueString" : "Comment"
            }
          ]
        }
      ]
    },
    {
      "resourceType" : "ValueSet",
      "id" : "MedicationStatementStatusLimited",
      "url" : "https://smartforms.csiro.au/ig/ValueSet/MedicationStatementStatusLimited",
      "name" : "MedicationStatementStatusLimited",
      "title" : "Medication Statement Status Limited",
      "status" : "draft",
      "experimental" : false,
      "description" : "This value set includes the minimal set of codes to represent the status of a medication statement (i.e., active, completed, stopped and on-hold).",
      "compose" : {
        "include" : [
          {
            "system" : "http://hl7.org/fhir/CodeSystem/medication-statement-status",
            "concept" : [
              {
                "code" : "active"
              },
              {
                "code" : "completed"
              },
              {
                "code" : "stopped"
              },
              {
                "code" : "on-hold"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:59fe5ac1-65bf-4606-8c2a-0a55fba1d064",
        "timestamp" : "2025-08-25T15:53:32+10:00",
        "total" : 4,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://hl7.org/fhir/CodeSystem/medication-statement-status|4.0.1"
          }
        ],
        "contains" : [
          {
            "system" : "http://hl7.org/fhir/CodeSystem/medication-statement-status",
            "code" : "active",
            "display" : "Active"
          },
          {
            "system" : "http://hl7.org/fhir/CodeSystem/medication-statement-status",
            "code" : "completed",
            "display" : "Completed"
          },
          {
            "system" : "http://hl7.org/fhir/CodeSystem/medication-statement-status",
            "code" : "stopped",
            "display" : "Stopped"
          },
          {
            "system" : "http://hl7.org/fhir/CodeSystem/medication-statement-status",
            "code" : "on-hold",
            "display" : "On Hold"
          }
        ]
      }
    },
    {
      "resourceType" : "AllergyIntolerance",
      "id" : "AllergyIntoleranceTemplate",
      "clinicalStatus" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
            "code" : "active"
          }
        ]
      },
      "code" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractContext",
            "valueString" : "item.where(linkId='allergynew-substance').answer.value"
          }
        ],
        "coding" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "ofType(Coding)"
              }
            ]
          }
        ],
        "_text" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "ofType(string)"
            }
          ]
        }
      },
      "patient" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "note" : [
        {
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "item.where(linkId='allergynew-comment').answer.value"
              }
            ]
          }
        }
      ],
      "reaction" : [
        {
          "manifestation" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractContext",
                  "valueString" : "item.where(linkId='allergynew-manifestation').answer.value.ofType(Coding)"
                }
              ],
              "coding" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                      "valueString" : "$this"
                    }
                  ]
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractContext",
                  "valueString" : "item.where(linkId='allergynew-manifestation').answer.value.ofType(string)"
                }
              ],
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "$this"
                  }
                ]
              }
            }
          ]
        }
      ]
    },
    {
      "resourceType" : "Parameters",
      "id" : "AllergyIntolerancePatchTemplate",
      "parameter" : [
        {
          "name" : "operation",
          "part" : [
            {
              "name" : "type",
              "valueCode" : "add"
            },
            {
              "name" : "path",
              "valueString" : "AllergyIntolerance"
            },
            {
              "name" : "name",
              "valueString" : "clinicalStatus"
            },
            {
              "name" : "value",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                        "valueString" : "item.where(linkId='allergysummary-status').answer.value.first()"
                      }
                    ]
                  }
                ]
              }
            },
            {
              "name" : "pathLabel",
              "valueString" : "Clinical status"
            }
          ]
        },
        {
          "name" : "operation",
          "part" : [
            {
              "name" : "type",
              "valueCode" : "add"
            },
            {
              "name" : "path",
              "_valueString" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='allergysummary-comment-hidden').answer.value.exists(), 'AllergyIntolerance.note[0]', 'AllergyIntolerance')"
                  }
                ]
              }
            },
            {
              "name" : "name",
              "_valueString" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='allergysummary-comment-hidden').answer.value.exists(), 'text', 'note')"
                  }
                ]
              }
            },
            {
              "_name" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='allergysummary-comment-hidden').answer.value.exists(), 'value')"
                  }
                ]
              },
              "_valueMarkdown" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='allergysummary-comment-hidden').answer.value.exists(), item.where(linkId='allergysummary-comment').answer.value.first())"
                  }
                ]
              }
            },
            {
              "_name" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                    "valueString" : "iif(item.where(linkId='allergysummary-comment-hidden').answer.value.empty(), 'value')"
                  }
                ]
              },
              "valueAnnotation" : {
                "_text" : {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                      "valueString" : "iif(item.where(linkId='allergysummary-comment-hidden').answer.value.empty(), item.where(linkId='allergysummary-comment').answer.value.first())"
                    }
                  ]
                }
              }
            },
            {
              "name" : "pathLabel",
              "valueString" : "Comment"
            }
          ]
        }
      ]
    },
    {
      "resourceType" : "ValueSet",
      "id" : "AllergyIntoleranceClinicalStatusMinimal",
      "url" : "https://smartforms.csiro.au/ig/ValueSet/AllergyIntoleranceClinicalStatusMinimal",
      "name" : "AllergyIntoleranceClinicalStatusMinimal",
      "title" : "Allergy Intolerance Clinical Status Minimal",
      "status" : "draft",
      "experimental" : false,
      "description" : "This value set includes the minimal set of codes to represent the clinical status of an allergy intolerance (i.e., active and inactive).",
      "compose" : {
        "include" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
            "concept" : [
              {
                "code" : "active"
              },
              {
                "code" : "inactive"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:40f0c59e-9fa5-4322-bc1d-5fde644a076c",
        "timestamp" : "2025-08-25T15:52:50+10:00",
        "total" : 2,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical|1.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
            "code" : "active",
            "display" : "Active"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
            "code" : "inactive",
            "display" : "Inactive"
          }
        ]
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "SmokingStatusTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "social-history"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "1747861000168109"
          },
          {
            "system" : "http://loinc.org",
            "code" : "72166-2"
          }
        ],
        "text" : "Smoking status"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='substanceuse-smoking-smokingstatus-group-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "$this.answer.value"
              }
            ]
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "SmokingQuitStatus-1",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/valueset-supplement",
          "valueCanonical" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement|0.4.0"
        }
      ],
      "url" : "https://smartforms.csiro.au/ig/ValueSet/SmokingQuitStatus-1",
      "name" : "SmokingQuitStatus",
      "title" : "Smoking Quit Status",
      "status" : "draft",
      "experimental" : false,
      "description" : "The Smoking Quit Status value set includes values that can indicate how long ago an individual quit smoking.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "concept" : [
              {
                "code" : "48031000119106",
                "display" : "Quit >12 months"
              },
              {
                "code" : "735128000",
                "display" : "Quit <12 months"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:ee67ad1e-7faa-4fe8-ab3e-1995de4fcd26",
        "timestamp" : "2025-10-29T09:44:35+10:00",
        "parameter" : [
          {
            "name" : "used-codesystem",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "used-supplement",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement|0.4.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement|0.4.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/ValueSet/SmokingQuitStatus-1|0.4.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "48031000119106",
            "display" : "Quit >12 months"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "735128000",
            "display" : "Quit <12 months"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "TobaccoUseStatus-1",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/valueset-supplement",
          "valueCanonical" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement|0.4.0"
        }
      ],
      "url" : "https://smartforms.csiro.au/ig/ValueSet/TobaccoUseStatus-1",
      "name" : "TobaccoUseStatus",
      "title" : "Tobacco Use Status",
      "status" : "draft",
      "experimental" : false,
      "description" : "The Tobacco Use Status value set includes values that may be used to represent an individual's current tobacco use and exposure status.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "concept" : [
              {
                "code" : "266919005",
                "display" : "Never smoked"
              },
              {
                "code" : "77176002",
                "display" : "Current smoker"
              },
              {
                "code" : "8517006",
                "display" : "Ex-smoker"
              },
              {
                "code" : "16090371000119103",
                "display" : "Exposure to second hand tobacco smoke"
              },
              {
                "code" : "394872000",
                "display" : "Wants to quit"
              },
              {
                "code" : "713914004",
                "display" : "Other tobacco use"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:a7d04dc0-077c-4744-8e21-da8ce4cba135",
        "timestamp" : "2025-10-29T09:46:14+10:00",
        "parameter" : [
          {
            "name" : "used-codesystem",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "used-supplement",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement|0.4.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement|0.4.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/ValueSet/TobaccoUseStatus-1|0.4.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "266919005",
            "display" : "Never smoked"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "77176002",
            "display" : "Current smoker"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "8517006",
            "display" : "Ex-smoker"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "16090371000119103",
            "display" : "Exposure to second hand tobacco smoke"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "394872000",
            "display" : "Wants to quit"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "713914004",
            "display" : "Other tobacco use"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "YesNoNotAskedDeclined",
      "url" : "https://smartforms.csiro.au/ig/ValueSet/YesNoNotAskedDeclined",
      "name" : "YesNoNotAskedDeclined",
      "title" : "Yes/No/Not Asked/Asked But Declined",
      "status" : "draft",
      "experimental" : false,
      "description" : "Concepts for Yes, No, Not Asked and Asked But Declined",
      "compose" : {
        "include" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "concept" : [
              {
                "code" : "Y",
                "display" : "Yes"
              },
              {
                "code" : "N",
                "display" : "No"
              },
              {
                "code" : "NASK",
                "display" : "Not Asked"
              }
            ]
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "version" : "1.0.0",
            "concept" : [
              {
                "code" : "asked-declined",
                "display" : "Asked But Declined"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:9c63f3f7-c471-451d-aad3-d84bca7a3c8c",
        "timestamp" : "2025-09-18T16:28:54+10:00",
        "total" : 4,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v2-0532|2.0.0"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/data-absent-reason|1.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "Y",
            "display" : "Yes"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "N",
            "display" : "No"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "NASK",
            "display" : "Not Asked"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "asked-declined",
            "display" : "Asked But Declined"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "CervicalScreeningStatus-1",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/valueset-supplement",
          "valueCanonical" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement|0.4.0"
        }
      ],
      "url" : "https://smartforms.csiro.au/ig/ValueSet/CervicalScreeningStatus-1",
      "name" : "CervicalScreeningStatus",
      "title" : "Cervical Screening Status",
      "status" : "draft",
      "experimental" : false,
      "description" : "The Cervical Screening Status value set includes values that can be used to represent the status of an individual's participation in a cervical screening program.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "concept" : [
              {
                "code" : "736595007",
                "display" : "Declined"
              },
              {
                "code" : "410527000",
                "display" : "Offered"
              },
              {
                "code" : "171154002",
                "display" : "Not required"
              },
              {
                "code" : "171155001",
                "display" : "Up to date"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:66e5ae5e-d111-45a0-b6b1-e433ec6edbe7",
        "timestamp" : "2025-10-29T09:42:14+10:00",
        "parameter" : [
          {
            "name" : "used-codesystem",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "used-supplement",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement|0.4.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement|0.4.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/ValueSet/CervicalScreeningStatus-1|0.4.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "736595007",
            "display" : "Declined"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "410527000",
            "display" : "Offered"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "171154002",
            "display" : "Not required"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/32506021000036107/version/20251031",
            "code" : "171155001",
            "display" : "Up to date"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "amt-vaccine-1",
      "meta" : {
        "profile" : [
          "http://hl7.org/fhir/StructureDefinition/shareablevalueset",
          "https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4"
        ]
      },
      "url" : "https://healthterminologies.gov.au/fhir/ValueSet/amt-vaccine-1",
      "identifier" : [
        {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:1.2.36.1.2001.1004.201.10042"
        }
      ],
      "version" : "1.0.2",
      "name" : "AustralianMedicinesTerminologyVaccine",
      "title" : "Australian Medicines Terminology Vaccine",
      "status" : "active",
      "experimental" : false,
      "date" : "2020-05-31",
      "publisher" : "Australian Digital Health Agency",
      "contact" : [
        {
          "telecom" : [
            {
              "system" : "email",
              "value" : "help@digitalhealth.gov.au"
            }
          ]
        }
      ],
      "description" : "The Australian Medicines Terminology (AMT) Vaccine value set includes AMT product concepts that may be used to record a vaccine product.",
      "copyright" : "Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. \n\n This resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO. \n\nThe rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material.  No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted. \n\nAll copies of this resource must include this copyright statement and all information contained in this statement.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "filter" : [
              {
                "property" : "concept",
                "op" : "in",
                "value" : "1156291000168106"
              }
            ]
          }
        ]
      }
    },
    {
      "resourceType" : "Immunization",
      "id" : "ImmunizationTemplate",
      "status" : "completed",
      "vaccineCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractContext",
            "valueString" : "item.where(linkId='vaccinestoday-vaccine').answer.value"
          }
        ],
        "coding" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "ofType(Coding)"
              }
            ]
          }
        ],
        "_text" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "ofType(string)"
            }
          ]
        }
      },
      "patient" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_occurrenceDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "item.where(linkId='vaccinestoday-date').answer.value.toDateTime()"
          }
        ]
      },
      "_lotNumber" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "item.where(linkId='vaccinestoday-batch').answer.value"
          }
        ]
      },
      "note" : [
        {
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "item.where(linkId='vaccinestoday-comment').answer.value"
              }
            ]
          }
        }
      ]
    },
    {
      "resourceType" : "ValueSet",
      "id" : "heart-rhythm-1",
      "url" : "https://smartforms.csiro.au/ig/ValueSet/heart-rhythm-1",
      "name" : "HeartRhythm",
      "title" : "Heart Rhythm",
      "status" : "draft",
      "experimental" : false,
      "description" : "The Heart Rhythm value set includes values that may be used to represent the heart rhythm of an individual.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "concept" : [
              {
                "code" : "933506231000036108",
                "display" : "Regular heart rhythm"
              },
              {
                "code" : "361137007",
                "display" : "Irregular heart rhythm"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:7743ad1f-02f2-4977-b7a4-ea993b57023b",
        "timestamp" : "2025-10-28T16:39:30+10:00",
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "system-version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          }
        ],
        "contains" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "933506231000036108",
            "display" : "Regular heart rhythm"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "361137007",
            "display" : "Irregular heart rhythm"
          }
        ]
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "BodyHeightTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8302-2"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "50373000"
          }
        ],
        "text" : "Height"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-height-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "cm",
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "BodyHeightLengthTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8302-2"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "50373000"
          }
        ],
        "text" : "Height"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-lengthheight-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "cm",
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "BodyWeightTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "29463-7"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "27113001"
          }
        ],
        "text" : "Weight"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-weight-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "kg",
        "system" : "http://unitsofmeasure.org",
        "code" : "kg"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "WaistCircumferenceTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8280-0"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "276361009"
          }
        ],
        "text" : "Waist circumference"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-waistcircumference-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "cm",
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "HeadCircumferenceTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "9843-4"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "363812007"
          }
        ],
        "text" : "Head circumference"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-headcircumference-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "cm",
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "HeartRateTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8867-4"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "364075005"
          }
        ],
        "text" : "Heart rate"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-heartrate-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value.toDecimal()"
            }
          ]
        },
        "unit" : "/min",
        "system" : "http://unitsofmeasure.org",
        "code" : "/min"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "HeartRhythmTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8884-9"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "364074009"
          }
        ],
        "text" : "Heart rhythm"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-heartrhythm-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "$this.answer.value"
              }
            ]
          }
        ]
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "BloodPressureTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "85354-9"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "75367002"
          }
        ],
        "text" : "Blood pressure"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='bp-newbp-date').answer.value.toDateTime()"
          }
        ]
      },
      "component" : [
        {
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "8480-6"
              },
              {
                "system" : "http://snomed.info/sct",
                "code" : "271649006"
              }
            ],
            "text" : "Systolic"
          },
          "valueQuantity" : {
            "_value" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                  "valueString" : "$this.answer.value.toDecimal()"
                }
              ]
            },
            "unit" : "mm[Hg]",
            "system" : "http://unitsofmeasure.org",
            "code" : "mm[Hg]"
          }
        },
        {
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "8462-4"
              },
              {
                "system" : "http://snomed.info/sct",
                "code" : "271650006"
              }
            ],
            "text" : "Diastolic"
          },
          "valueQuantity" : {
            "_value" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                  "valueString" : "%resource.repeat(item).where(linkId='bp-newbp-diastolic').answer.value.toDecimal()"
                }
              ]
            },
            "unit" : "mm[Hg]",
            "system" : "http://unitsofmeasure.org",
            "code" : "mm[Hg]"
          }
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "Condition",
        "language" : "application/x-fhir-query",
        "expression" : "Condition?patient={{%patient.id}}&category=http://terminology.hl7.org/CodeSystem/condition-category|problem-list-item"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBloodPressure",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=85354-9&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsTobaccoSmokingStatus",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=72166-2&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "SexAtBirthCoding",
        "language" : "text/fhirpath",
        "expression" : "%patient.extension.where(exists(url='http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender' and extension.where(exists(url='type' and value.coding.code='1515311000168102')) and extension.where(url='effectivePeriod').value.end.empty())).extension.where(url='value').value.coding"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBloodPressureLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsBloodPressure.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsTobaccoSmokingStatusLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsTobaccoSmokingStatus.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Questionnaire.versionAlgorithm[x]",
      "valueCoding" : {
        "system" : "http://hl7.org/fhir/version-algorithm",
        "code" : "semver"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#YesNoNA"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#YesNo"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#YesNoNotAskedDeclined"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#clinical-condition-1"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#administrative-gender"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#condition-clinical"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#AboriginalTorresStraitIslander"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#PrimaryCarerParentGrandparent"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#australian-pronouns-1"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#australian-states-territories-2"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#gender-identity-response-1"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#biological-sex-1"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#SmokingQuitStatus-1"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#TobaccoUseStatus-1"
      }
    },
    {
      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
      "valueReference" : {
        "reference" : "#CervicalScreeningStatus-1"
      }
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "patient"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Patient"
        },
        {
          "url" : "description",
          "valueString" : "The patient that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "user"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Practitioner"
        },
        {
          "url" : "description",
          "valueString" : "The practitioner user that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "encounter"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Encounter"
        },
        {
          "url" : "description",
          "valueString" : "The encounter that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/AboutTheHealthCheck|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/Consent|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/PatientDetails|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/CurrentPriorities|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/MedicalHistoryCurrentProblems|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/RegularMedications|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/AllergiesAdverseReactions|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/FamilyHistory|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/SocialAndEmotionalWellbeing|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/SocialHistoryChild|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/HomeAndFamily|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/LearningAndDevelopment|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/LearningAndWork|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/Mood|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/MemoryAndThinking|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/ChronicDiseaseAgeing|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/ScreeningPrograms|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/HealthyEating|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/PhysicalActivityAndScreenTime|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/RedFlagsEarlyIdentificationGuide|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/SubstanceUse|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/Gambling|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/SexualHealth|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/EyeHealth|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/EarHealthAndHearing|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/OralAndDentalHealth|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/Skin|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/Immunisation|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/Examination|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/AbsoluteCVDRiskCalculation|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/Investigations|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/HealthPrioritiesSummary|0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembledFrom",
      "valueCanonical" : "http://www.health.gov.au/assessments/mbs/715/FinalisingHealthCheck|0.4.0"
    }
  ],
  "url" : "http://www.health.gov.au/assessments/mbs/715",
  "version" : "0.4.0-assembled",
  "name" : "AboriginalTorresStraitIslanderHealthCheck",
  "title" : "Aboriginal and Torres Strait Islander Health Check",
  "status" : "draft",
  "experimental" : false,
  "subjectType" : ["Patient"],
  "date" : "2025-03-14",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                "code" : "tab-container"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "age",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='5b224753-9365-44e3-823b-9c17e7394005').item.where(linkId='e2a16e4d-2765-4b61-b286-82cfc6356b30').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "postcode",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='5b224753-9365-44e3-823b-9c17e7394005').item.where(linkId='f1262ade-843c-4eba-a86d-51a9c97d134b').item.where(linkId='4e0dc185-f83e-4027-b7a8-ecb543d42c6d').item.where(linkId='3f61a1ea-1c74-4f52-8519-432ce861a74f').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryCurrentPriorities",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='b3a3eee2-f340-452e-9d05-d1f54f677b81').item.where(linkId='7cd424e5-7672-4e99-8a99-30b1fb3043fd').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryMedicalHistory",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='28d5dbe4-1e65-487c-847a-847f544a6a91').item.where(linkId='62774152-8a6e-4449-af9f-87bdce8b9bf5').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryRegularMedications",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='7dfe7c6a-ca7f-4ddf-9241-a7b918a9695a').item.where(linkId='aa9ff2ed-bcd2-406d-a9ff-89c201df2605').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryAllergiesAdverseReactions",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='d4e4db07-a795-4a30-bd0f-9c109f96a22b').item.where(linkId='3e689aeb-69a1-4a9b-93bd-50377511dd9b').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryFamilyHistory",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='01f67f0b-e3be-48d8-a2ad-4c54f469cd13').item.where(linkId='49ee4583-c608-41d4-a1e9-c06cf4292369').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummarySocialEmotionalWellbeing",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='0a3c9c93-5836-4a5b-93e5-d7de559e053a').item.where(linkId='b5a00aad-2a8b-4ac3-87b2-4a5920ca22ee').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummarySocialHistory",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='a5cc8a8f-89cf-470c-a6bd-ce9da2f64ee9').item.where(linkId='76d51512-b94a-4092-b3ae-a656fbb9c360').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryHomeFamily",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='819b3305-bf93-4502-9986-242ea2ae5f43').item.where(linkId='08d2e80e-3bb4-4f67-8b1c-090b1ace225a').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryLearningDevelopment",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='3e7d7246-98f8-4803-b063-8405ac30b086').item.where(linkId='5ab80929-5901-431d-bf68-67d532f5fa58').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryLearningWorkAdults",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='5437e30d-8a0a-4785-974e-00a10d2a1df0').item.where(linkId='3569e514-a74b-4343-b31b-3395e58d991a').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryLearningWorkOlder",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='dec713ae-246a-4961-95c9-0626bfebfed2').item.where(linkId='ed6f7800-e22a-4639-9d11-faf845513500').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryMood",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='9559242e-9ffe-4e1f-a9fc-86d1fa62c4b9').item.where(linkId='db9a8650-42a2-4bd3-8066-7e09394120d5').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryMemoryThinking",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='1bd58e7b-2cb7-45fb-965f-d5fa33d0bb4c').item.where(linkId='1f0e7fde-e964-4f36-9151-dbdc5e145f94').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryChronicDiseaseAgeing",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='c5da020c-c4f3-437c-b658-ea7e7667514d').item.where(linkId='7292070b-8944-4a40-bcf6-9aaf1721e986').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryScreeningPrograms",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='9674ffa0-2ad9-4ca3-80e6-e8bb0670a802').item.where(linkId='70f82c4b-d1f9-44d5-9903-bd7097799c05').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryHealthyEating",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='ae7a3801-9491-4b1f-820c-678236d18f56').item.where(linkId='301789b0-8c6a-470d-8787-0ac6597e3bea').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryPhysicalActivityScreenTimeNotOlder",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='74736baa-455b-41d2-af98-fb65cd463e97').item.where(linkId='ccbd7fbf-0d40-4cb3-82b3-ad2c7cc7bba2').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryPhysicalActivityScreenTimeOlder",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='d56234a0-aafd-4c22-96c9-00ead8424f0b').item.where(linkId='25b8b8fd-adb1-48ab-aeae-528603668c4b').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummarySubstanceUse",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='14a9fb5f-5b0e-4862-b143-08a11cd3ebf0').item.where(linkId='f8e1cc1f-f1a1-4eb3-8255-77d600f52831').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryGambling",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='a7bb0dd2-4b2d-49c2-9da6-3cb0a4dd9240').item.where(linkId='2ab74c97-55d9-4fd9-968f-8962d62ea573').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummarySexualHealthAdolescents",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='4b49c291-6e93-4b7e-be3b-15ef8bc207ad').item.where(linkId='b41572ba-cf36-4cec-addf-cb0b47fea63f').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummarySexualHealthAdults",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='589b53a4-ceb2-41c0-850a-69438f9fd1cc').item.where(linkId='efd0735c-c379-471f-83bb-93b0392093aa').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummarySexualHealthOlder",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='02048954-e9d7-424e-8c7b-6a3c495d7ce4').item.where(linkId='e9936322-e6fe-4cf7-ab61-22846a8fbb95').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryEyeHealth",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='961da481-1698-4a1d-962b-a9c2185e335a').item.where(linkId='8dcdc04c-7655-4b47-88eb-8425f0cdc0d0').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryEarHealthHearing",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='de71bbd0-178c-4974-9c75-55d5a48c66f7').item.where(linkId='ac87b23a-b022-4d62-9e82-1c56583bca34').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryOralDentalHealth",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='bde9ab00-a20f-4a7c-9266-11f53f60c65f').item.where(linkId='875574fa-9769-42ca-8381-9e80c3e5233d').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummarySkin",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='7d4772cb-a1cd-49d9-853f-883ccd8343a6').item.where(linkId='88d23fa4-df88-43ab-a1d0-69315d55c3bf').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryImmunisation",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='205677d6-17c7-4285-a7c4-61aa02b6c816').item.where(linkId='bcd1c9f2-889e-41e5-8c2b-a70221c5cec5').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryExamination",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='c587e3b6-b91a-40dc-9a16-179342d001e9').item.where(linkId='fcbfa6e1-c101-4675-969d-aa11027859c2').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryAbsoluteCVDRisk",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='d95abe99-8ef2-4b97-bc88-a2901e2ebc9c').item.where(linkId='f8022f3f-21fe-42c0-8abd-95f24e2e37e5').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "HealthPrioritiesSummaryInvestigations",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='918f7f32-cdaf-4742-b33a-8254eda2d8bd').item.where(linkId='96a8d946-6078-4c85-9de8-3bf18d2c8150').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "QuestionnaireResponseLatestCompleted",
            "language" : "application/x-fhir-query",
            "expression" : "QuestionnaireResponse?questionnaire=http://www.health.gov.au/assessments/mbs/715&status=completed&_count=1&_sort=-authored&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "QuestionnaireResponseLatest",
            "language" : "application/x-fhir-query",
            "expression" : "QuestionnaireResponse?questionnaire=http://www.health.gov.au/assessments/mbs/715&_count=1&_sort=-authored&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "PostalAddress",
            "language" : "text/fhirpath",
            "expression" : "%patient.address.where(type='postal')"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "MedicationStatement",
            "language" : "application/x-fhir-query",
            "expression" : "MedicationStatement?patient={{%patient.id}}&status=active&_include=MedicationStatement:medication"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "medicationsFromContained",
            "language" : "text/fhirpath",
            "expression" : "%MedicationStatement.entry.resource.contained.ofType(Medication).where(id in %MedicationStatement.entry.resource.medication.select(reference.replace('#', '')))"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "medicationsFromRef",
            "language" : "text/fhirpath",
            "expression" : "%MedicationStatement.entry.resource.ofType(Medication).where(id in %MedicationStatement.entry.resource.medication.select(reference.replace('Medication/', '')))"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "AllergyIntolerance",
            "language" : "application/x-fhir-query",
            "expression" : "AllergyIntolerance?patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsTobaccoSmokingStatusValue",
            "language" : "text/fhirpath",
            "expression" : "%ObsTobaccoSmokingStatusLatest.value.coding.where(system='http://snomed.info/sct').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsTobaccoSmokingStatusDateString",
            "language" : "text/fhirpath",
            "expression" : "%ObsTobaccoSmokingStatusLatest.effective.toDate().toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsTobaccoSmokingStatusDateFormatted",
            "language" : "text/fhirpath",
            "expression" : "%ObsTobaccoSmokingStatusDateString.substring(8,2).toInteger().toString() + ' ' + %ObsTobaccoSmokingStatusDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsTobaccoSmokingStatusDateString.substring(0,4)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "Immunization",
            "language" : "application/x-fhir-query",
            "expression" : "Immunization?patient={{%patient.id}}&status=completed"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsWaistCircumference",
            "language" : "application/x-fhir-query",
            "expression" : "Observation?code=8280-0&_sort=-date&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRate",
            "language" : "application/x-fhir-query",
            "expression" : "Observation?code=8867-4&_sort=-date&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRhythm",
            "language" : "application/x-fhir-query",
            "expression" : "Observation?code=364074009&_sort=-date&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyHeight",
            "language" : "application/x-fhir-query",
            "expression" : "Observation?code=8302-2&_sort=-date&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyWeight",
            "language" : "application/x-fhir-query",
            "expression" : "Observation?code=29463-7&_sort=-date&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeadCircumference",
            "language" : "application/x-fhir-query",
            "expression" : "Observation?code=9843-4&_sort=-date&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsWaistCircumferenceLatest",
            "language" : "text/fhirpath",
            "expression" : "%ObsWaistCircumference.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRateLatest",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeartRate.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRhythmLatest",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeartRhythm.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyHeightLatest",
            "language" : "text/fhirpath",
            "expression" : "%ObsBodyHeight.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyWeightLatest",
            "language" : "text/fhirpath",
            "expression" : "%ObsBodyWeight.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeadCircumferenceLatest",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeadCircumference.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyHeightValue",
            "language" : "text/fhirpath",
            "expression" : "%ObsBodyHeightLatest.value.where(exists(system='http://unitsofmeasure.org' and code='cm')).value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyHeightDateString",
            "language" : "text/fhirpath",
            "expression" : "%ObsBodyHeightLatest.effective.toDate().toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyHeightDateFormatted",
            "language" : "text/fhirpath",
            "expression" : "%ObsBodyHeightDateString.substring(8,2).toInteger().toString() + ' ' + %ObsBodyHeightDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsBodyHeightDateString.substring(0,4)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyWeightValue",
            "language" : "text/fhirpath",
            "expression" : "%ObsBodyWeightLatest.value.where(exists(system='http://unitsofmeasure.org' and code='kg')).value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyWeightDateString",
            "language" : "text/fhirpath",
            "expression" : "%ObsBodyWeightLatest.effective.toDate().toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBodyWeightDateFormatted",
            "language" : "text/fhirpath",
            "expression" : "%ObsBodyWeightDateString.substring(8,2).toInteger().toString() + ' ' + %ObsBodyWeightDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsBodyWeightDateString.substring(0,4)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeadCircumferenceValue",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeadCircumferenceLatest.value.where(exists(system='http://unitsofmeasure.org' and code='cm')).value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeadCircumferenceDateString",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeadCircumferenceLatest.effective.toDate().toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeadCircumferenceDateFormatted",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeadCircumferenceDateString.substring(8,2).toInteger().toString() + ' ' + %ObsHeadCircumferenceDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsHeadCircumferenceDateString.substring(0,4)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsWaistCircumferenceValue",
            "language" : "text/fhirpath",
            "expression" : "%ObsWaistCircumferenceLatest.value.where(exists(system='http://unitsofmeasure.org' and code='cm')).value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsWaistCircumferenceDateString",
            "language" : "text/fhirpath",
            "expression" : "%ObsWaistCircumferenceLatest.effective.toDate().toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsWaistCircumferenceDateFormatted",
            "language" : "text/fhirpath",
            "expression" : "%ObsWaistCircumferenceDateString.substring(8,2).toInteger().toString() + ' ' + %ObsWaistCircumferenceDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsWaistCircumferenceDateString.substring(0,4)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRateValue",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeartRateLatest.value.where(exists(system='http://unitsofmeasure.org' and code='/min')).value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRateDateString",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeartRateLatest.effective.toDate().toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRateDateFormatted",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeartRateDateString.substring(8,2).toInteger().toString() + ' ' + %ObsHeartRateDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsHeartRateDateString.substring(0,4)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRhythmValue",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeartRhythmLatest.value.coding.where(system='http://snomed.info/sct').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRhythmDateString",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeartRhythmLatest.effective.toDate().toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHeartRhythmDateFormatted",
            "language" : "text/fhirpath",
            "expression" : "%ObsHeartRhythmDateString.substring(8,2).toInteger().toString() + ' ' + %ObsHeartRhythmDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsHeartRhythmDateString.substring(0,4)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBloodPressureValue",
            "language" : "text/fhirpath",
            "expression" : "%ObsBloodPressureLatest.component.where(code.coding.exists(code='8480-6')).value.value.round(0).toString() + ' / ' + %ObsBloodPressureLatest.component.where(code.coding.exists(code='8462-4')).value.value.round(0).toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBloodPressureDateString",
            "language" : "text/fhirpath",
            "expression" : "%ObsBloodPressureLatest.effective.toDate().toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsBloodPressureDateFormatted",
            "language" : "text/fhirpath",
            "expression" : "%ObsBloodPressureDateString.substring(8,2).toInteger().toString() + ' ' + %ObsBloodPressureDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsBloodPressureDateString.substring(0,4)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "weight",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='c587e3b6-b91a-40dc-9a16-179342d001e9').item.where(linkId='53d5d5a6-3198-4bec-92ac-03fe7d77fb68').item.where(linkId='97ed4c86-8820-4e4d-9234-0e0e8b6ca44a').item.where(linkId='obs-weight-newresult').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "height",
            "language" : "text/fhirpath",
            "expression" : "item.where(linkId='c587e3b6-b91a-40dc-9a16-179342d001e9').item.where(linkId='53d5d5a6-3198-4bec-92ac-03fe7d77fb68').item.where(linkId='6226a5c5-b5c3-4ebb-a689-2b286322cfe0').item.where(linkId='obs-height-newresult').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsTotalCholesterol",
            "language" : "application/x-fhir-query",
            "expression" : "Observation?code=14647-2&_sort=-date&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHDLCholesterol",
            "language" : "application/x-fhir-query",
            "expression" : "Observation?code=14646-4&_sort=-date&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsTotalCholesterolLatest",
            "language" : "text/fhirpath",
            "expression" : "%ObsTotalCholesterol.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "ObsHDLCholesterolLatest",
            "language" : "text/fhirpath",
            "expression" : "%ObsHDLCholesterol.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "CVDRiskResult",
            "language" : "application/x-fhir-query",
            "expression" : "Observation?code=441829007&_sort=-date&patient={{%patient.id}}"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "CVDRiskResultLatest",
            "language" : "text/fhirpath",
            "expression" : "%CVDRiskResult.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "CVDRiskResultValue",
            "language" : "text/fhirpath",
            "expression" : "%CVDRiskResultLatest.select((((value.ofType(Quantity).comparator + value.ofType(Quantity).value.toString() + value.ofType(Quantity).unit | value.ofType(Quantity).value.toString() + value.ofType(Quantity).unit).first() | (value.ofType(Range).low.value.toString() + ' - ' + value.ofType(Range).high.value.toString() + value.ofType(Range).high.unit)).first()) + ' ' + interpretation.coding.display)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "CVDRiskResultDateString",
            "language" : "text/fhirpath",
            "expression" : "%CVDRiskResultLatest.effective.toString()"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "CVDRiskResultDateFormatted",
            "language" : "text/fhirpath",
            "expression" : "%CVDRiskResultDateString.substring(8,2).toInteger().toString() + ' ' + %CVDRiskResultDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %CVDRiskResultDateString.substring(0,4)"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "NewAssessmentQuestionAnswer",
            "language" : "text/fhirpath",
            "expression" : "repeat(item).where(linkId='cvdrisk-newassessmentquestion').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "AusCVDRiskiAccessAnswer",
            "language" : "text/fhirpath",
            "expression" : "repeat(item).where(linkId='cvdrisk-auscvdriskiaccess').answer.value"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/variable",
          "valueExpression" : {
            "name" : "RepopulateOverrideAnswer",
            "language" : "text/fhirpath",
            "expression" : "repeat(item).where(linkId='cvdrisk-repopulateoverride').answer.value"
          }
        }
      ],
      "linkId" : "fd5af92e-c248-497a-8007-ee0952ccd4d9",
      "type" : "group",
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "2e82032a-dc28-45f2-916e-862303d39fe5",
          "text" : "About the health check",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-1').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-1').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-1",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-1').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-1",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-1').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-1",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "3da318f1-a5dd-4c8f-b258-99d83872a4f2",
              "text" : "Eligible for health check",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNoNA",
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-display-category",
                            "code" : "instructions"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "04f00512-888b-424e-ba76-9bd6fd8da682",
                  "text" : "not claimed 715 or 228 in past nine months",
                  "type" : "display"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%QuestionnaireResponseLatest.entry.resource.where(status='in-progress').exists()"
                  }
                }
              ],
              "linkId" : "5960c096-d5f7-4745-bd74-44ff2775bde9",
              "text" : "Health check already in progress?",
              "type" : "boolean",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%QuestionnaireResponseLatestCompleted.entry.resource.authored"
                  }
                }
              ],
              "linkId" : "01418489-1ec4-4c3b-b96a-7c14c3e21cfe",
              "text" : "Date of last completed health check",
              "type" : "dateTime",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "today()"
                  }
                }
              ],
              "linkId" : "63fe14f3-2374-4382-bce7-180e2747c97f",
              "text" : "Date this health check commenced",
              "type" : "date",
              "repeats" : false
            },
            {
              "linkId" : "about-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-1",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "1016f79d-9756-4daf-b6ee-29add134b34f",
          "text" : "Consent",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-30').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-30').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-30",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-30').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-30",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-30').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-30",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "d1e1ab3d-1c6c-430b-8ae7-af56b8f0af55",
              "text" : "Consent given after discussion of process and benefits of a health check",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNoNA"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "7fa8bc57-f3f9-4ddc-bf9b-12a9b9885dbd",
              "text" : "Consent given by parent/primary carer after discussion of process and benefits of a health check",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNoNA"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 24"
                  }
                }
              ],
              "linkId" : "80a6a405-49a4-44fb-bff3-212902096b95",
              "text" : "Parent/primary caregiver present",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "c72933c7-349f-4fef-94ff-c424c69da6f3",
                  "text" : "Parent/primary caregiver is present for health check?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "b7d116f9-0425-4cf1-8cde-fbf4dfaee550",
                  "text" : "Relationship to child",
                  "type" : "string",
                  "enableWhen" : [
                    {
                      "question" : "c72933c7-349f-4fef-94ff-c424c69da6f3",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : true
                }
              ]
            },
            {
              "linkId" : "d8c88bff-75ea-476f-8f83-e9b72fc9e1a0",
              "text" : "Consent for sharing of information",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "057483ce-f265-46df-a1c5-7a18d492c1ba",
                  "text" : "Consent given for sharing of information with relevant healthcare providers?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "43517c44-5cd2-4d9a-9f18-d6bf8124f4ae",
                  "text" : "Who/details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "057483ce-f265-46df-a1c5-7a18d492c1ba",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : true
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "today()"
                  }
                }
              ],
              "linkId" : "84162f36-f4af-4509-b178-ef2a3849d0b6",
              "text" : "Date",
              "type" : "date",
              "repeats" : false
            },
            {
              "linkId" : "0f92eb2d-4629-4215-96f8-46722a2efa73",
              "text" : "Doctor",
              "type" : "string",
              "repeats" : false
            },
            {
              "linkId" : "8b94a129-3aab-4d13-bb6d-7a748f5c41e5",
              "text" : "Nurse",
              "type" : "string",
              "repeats" : false
            },
            {
              "linkId" : "2a517291-e2f1-4f66-ad1f-ae5b091d2f8a",
              "text" : "Aboriginal and/or Torres Strait Islander Health Worker / Health Practitioner",
              "type" : "string",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                  "valueString" : "Other, please specify"
                }
              ],
              "linkId" : "5bbfb4a3-a667-4ef2-98c2-76e76da55c03",
              "text" : "Location of health check",
              "type" : "open-choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "257585005",
                    "display" : "Clinic"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "264362003",
                    "display" : "Home"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "257698009",
                    "display" : "School"
                  }
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                  "valueString" : "Other, please specify"
                }
              ],
              "linkId" : "9a51c056-021d-445d-8eaa-2123a69aa9c2",
              "text" : "Location of health check",
              "type" : "open-choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueCoding" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "257585005",
                    "display" : "Clinic"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "264362003",
                    "display" : "Home"
                  }
                },
                {
                  "valueCoding" : {
                    "system" : "http://snomed.info/sct",
                    "code" : "224848004",
                    "display" : "Early learning centre"
                  }
                }
              ]
            },
            {
              "linkId" : "consent-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-30",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "linkId" : "5b224753-9365-44e3-823b-9c17e7394005",
          "text" : "Patient Details",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-32').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-32').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-32",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-32').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-32",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-32').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-32",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "patientdetails-writebackinstruction",
              "text" : "This section contains several read only, non-editable items. Updates to these items will need to be done in the patient record. The form can be repopulated to include any updates.",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><em>This section contains several read only, non-editable items. Updates to these items will need to be done in the patient record. The form can be repopulated to include any updates.</em></div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%patient.name.where(use='official').select((family | (given | prefix).join(' ')).join(', ').where($this != '') | text) | %patient.name.select((family | (given | prefix).join(' ')).join(', ').where($this != '') | text)).first()"
                  }
                }
              ],
              "linkId" : "17596726-34cf-4133-9960-7081e1d63558",
              "text" : "Name",
              "type" : "string",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%patient.name.where(use='usual').select((family | (given | prefix).join(' ')).join(', ').where($this != '') | text)).first()"
                  }
                }
              ],
              "linkId" : "57093a06-62f7-4b8b-8cb4-2c9f451ac851",
              "text" : "Preferred name",
              "type" : "string",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.extension.where(exists(url='http://hl7.org/fhir/StructureDefinition/individual-pronouns') and extension.where(url='period').value.end.empty()).extension.where(url='value').value.coding"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "drop-down"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "540b1034-7c9a-4aba-a9ef-afb77d445a58",
              "text" : "Preferred pronouns",
              "type" : "choice",
              "repeats" : false,
              "readOnly" : true,
              "answerValueSet" : "#australian-pronouns-1"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.extension.where(exists(url='http://hl7.org/fhir/StructureDefinition/individual-genderIdentity') and extension.where(url='period').value.end.empty()).extension.where(url='value').value.coding"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "drop-down"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "f669a4fe-4818-429a-8847-d20da88d2bb3",
              "text" : "Gender identity",
              "type" : "choice",
              "repeats" : false,
              "readOnly" : true,
              "answerValueSet" : "#gender-identity-response-1"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.gender"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                  "valueBoolean" : true
                }
              ],
              "linkId" : "418e4a02-de77-48a0-a92a-fe8fcc52b1aa",
              "text" : "Administrative gender",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#administrative-gender"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%SexAtBirthCoding"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "drop-down"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "56ef44bb-3d1d-4972-aad1-834b69185d61",
              "text" : "Sex assigned at birth",
              "type" : "choice",
              "repeats" : false,
              "readOnly" : true,
              "answerValueSet" : "#biological-sex-1"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.birthDate"
                  }
                }
              ],
              "linkId" : "90ad8f16-16e4-4438-a7aa-b3189f510da2",
              "text" : "Date of birth",
              "type" : "date",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "iif(today().toString().select(substring(5,2) & substring(8,2)).toInteger() > %patient.birthDate.toString().select(substring(5,2) & substring(8,2)).toInteger(), today().toString().substring(0,4).toInteger() - %patient.birthDate.toString().substring(0,4).toInteger(), today().toString().substring(0,4).toInteger() - %patient.birthDate.toString().substring(0,4).toInteger() - 1)"
                  }
                }
              ],
              "linkId" : "e2a16e4d-2765-4b61-b286-82cfc6356b30",
              "text" : "Age",
              "type" : "integer",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.extension.where(url='http://hl7.org.au/fhir/StructureDefinition/indigenous-status').value"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "8acde9f8-7a91-4f0c-9216-38531ec984ef",
              "text" : "Aboriginal and/or Torres Strait Islander status",
              "type" : "choice",
              "repeats" : false,
              "readOnly" : true,
              "answerValueSet" : "#AboriginalTorresStraitIslander"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 24"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "check-box"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "c8852db9-efe9-4102-96db-cef3a8be0a5f",
              "text" : "Parents/primary carer/s",
              "type" : "choice",
              "repeats" : true,
              "answerValueSet" : "#PrimaryCarerParentGrandparent"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 24"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "7089c48e-4216-4089-a548-034cd585e4da",
              "text" : "Other family",
              "type" : "string",
              "repeats" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 24"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "42b1f5e0-bf4a-47d9-86a4-f2fe946ac01f",
              "text" : "Other",
              "type" : "string",
              "repeats" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "06737e46-e880-4037-9a2c-bcd278cd70ba",
              "text" : "Parents/primary carer/s details",
              "type" : "group",
              "repeats" : true,
              "item" : [
                {
                  "linkId" : "cc20ce96-af06-4cd7-aa9b-c2601a6169ad",
                  "text" : "Name of parent/primary carer",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "linkId" : "372d79bb-9d0b-42d2-a98c-cbe332bd3745",
                  "text" : "Relationship to child",
                  "type" : "string",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                  "valueExpression" : {
                    "name" : "HomeAddressRepeat",
                    "language" : "text/fhirpath",
                    "expression" : "%patient.address.where(all(use='home' and (type.empty() or type!='postal')))"
                  }
                }
              ],
              "linkId" : "f1262ade-843c-4eba-a86d-51a9c97d134b",
              "text" : "Home address",
              "type" : "group",
              "repeats" : false,
              "readOnly" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%HomeAddressRepeat.extension('http://hl7.org.au/fhir/StructureDefinition/no-fixed-address').value"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "311d83bb-f22e-4f60-9b50-b6e38dd2059b",
                  "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.extension:noFixedAddress",
                  "text" : "No fixed address",
                  "type" : "boolean",
                  "repeats" : false
                },
                {
                  "linkId" : "4e0dc185-f83e-4027-b7a8-ecb543d42c6d",
                  "text" : "Home address",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                        "valueBoolean" : true
                      }
                    ]
                  },
                  "type" : "group",
                  "enableWhen" : [
                    {
                      "question" : "311d83bb-f22e-4f60-9b50-b6e38dd2059b",
                      "operator" : "!=",
                      "answerBoolean" : true
                    }
                  ],
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%HomeAddressRepeat.select(line.join(', '))"
                          }
                        }
                      ],
                      "linkId" : "2fee2d51-7828-4178-b8c1-35edd32ba338",
                      "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.line",
                      "text" : "Street address",
                      "type" : "string",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%HomeAddressRepeat.city"
                          }
                        }
                      ],
                      "linkId" : "ddb65ed1-f4b2-4730-af2a-2f98bc73c76f",
                      "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.city",
                      "text" : "City",
                      "type" : "string",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%HomeAddressRepeat.state"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "drop-down"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "d9a1236c-8d6e-4f20-a12a-9d5de5a1d0f6",
                      "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.state",
                      "text" : "State",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "#australian-states-territories-2"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%HomeAddressRepeat.postalCode"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/regex",
                          "valueString" : "matches('^[0-9]{4}$')"
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                          "valueString" : "####"
                        }
                      ],
                      "linkId" : "3f61a1ea-1c74-4f52-8519-432ce861a74f",
                      "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.postalCode",
                      "text" : "Postcode",
                      "type" : "string",
                      "repeats" : false
                    }
                  ]
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                  "valueExpression" : {
                    "name" : "PostalAddressRepeat",
                    "language" : "text/fhirpath",
                    "expression" : "%patient.address.where(type='postal')"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%PostalAddress.exists()"
                  }
                }
              ],
              "linkId" : "edc081ea-b5ba-4234-9234-8ee598c2f95f",
              "text" : "Postal address",
              "type" : "group",
              "repeats" : true,
              "readOnly" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%PostalAddressRepeat.use"
                      }
                    }
                  ],
                  "linkId" : "622970f1-3cf1-4f0a-bf05-b00a08046eba",
                  "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.use",
                  "text" : "Purpose of use",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%PostalAddressRepeat.select(line.join(', '))"
                      }
                    }
                  ],
                  "linkId" : "2e8437cd-5ea0-4d44-8ab2-d2aa9ef18ba7",
                  "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.line",
                  "text" : "Street address",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%PostalAddressRepeat.city"
                      }
                    }
                  ],
                  "linkId" : "2bde25e5-2c4c-4c0c-b6f3-c6859535a764",
                  "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.city",
                  "text" : "City",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%PostalAddressRepeat.state"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "drop-down"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "b41a8b11-8dbf-4999-9d0a-71d39240fed1",
                  "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.state",
                  "text" : "State",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#australian-states-territories-2"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%PostalAddressRepeat.postalCode"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/regex",
                      "valueString" : "matches('^[0-9]{4}$')"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                      "valueString" : "####"
                    }
                  ],
                  "linkId" : "28b58e50-2a04-4192-9655-efc8d72f32fa",
                  "definition" : "http://hl7.org.au/fhir/StructureDefinition/au-address#Address.postalCode",
                  "text" : "Postcode",
                  "type" : "string",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.telecom.where(system = 'phone' and use = 'home').value"
                  }
                }
              ],
              "linkId" : "9541f0b0-f5ba-4fe7-a8e9-ad003cef897b",
              "text" : "Home phone",
              "type" : "string",
              "repeats" : true,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.telecom.where(system = 'phone' and use = 'mobile').value"
                  }
                }
              ],
              "linkId" : "4037a02b-4a85-40e0-9be6-5b17df1aac56",
              "text" : "Mobile phone",
              "type" : "string",
              "repeats" : true,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                  "valueExpression" : {
                    "name" : "EmergencyContactRepeat",
                    "language" : "text/fhirpath",
                    "expression" : "%patient.contact.where(relationship.coding.exists(code = 'C'))"
                  }
                }
              ],
              "linkId" : "c22390d3-1be6-4fd1-b775-6443b7239a6b",
              "text" : "Emergency contact",
              "type" : "group",
              "repeats" : true,
              "readOnly" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%EmergencyContactRepeat.name.select((family | (given | prefix).join(' ')).join(', ').where($this != '') | text)"
                      }
                    }
                  ],
                  "linkId" : "d7f2dd75-20c8-480f-8c22-71d604ebee8d",
                  "text" : "Name",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age <= 12"
                      }
                    }
                  ],
                  "linkId" : "aa35d559-f45b-4d35-9453-dd02e4a790f3",
                  "text" : "Relationship to child",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age > 12"
                      }
                    }
                  ],
                  "linkId" : "27099697-d6d1-42c0-bb0a-5e9ff7372a96",
                  "text" : "Relationship to patient",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%EmergencyContactRepeat.telecom.value"
                      }
                    }
                  ],
                  "linkId" : "626e3723-6310-4b99-81c1-525676b027c8",
                  "text" : "Phone",
                  "type" : "string",
                  "repeats" : true
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                  "valueExpression" : {
                    "name" : "MedicareNumberRepeat",
                    "language" : "text/fhirpath",
                    "expression" : "%patient.identifier.where(type.coding.exists(system='http://terminology.hl7.org/CodeSystem/v2-0203' and code='MC'))"
                  }
                }
              ],
              "linkId" : "df1475ea-bf7e-4bf0-a69f-7f9608c3ed3c",
              "text" : "Medicare number",
              "type" : "group",
              "repeats" : true,
              "readOnly" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%MedicareNumberRepeat.value.substring(0,10)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/regex",
                      "valueString" : "matches('^[0-9]{10}$')"
                    }
                  ],
                  "linkId" : "eb2a59ed-9632-4df1-b5b1-1e85c3b4b7cf",
                  "text" : "Number",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%MedicareNumberRepeat.value.substring(10,1)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/regex",
                      "valueString" : "matches('^[0-9]{1}$')"
                    }
                  ],
                  "linkId" : "d6253253-a124-494e-a1d8-7ce02c69ec11",
                  "text" : "Reference number",
                  "type" : "string",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%MedicareNumberRepeat.period.end.toString()"
                      }
                    }
                  ],
                  "linkId" : "c520e213-5313-42c3-860a-d30206620290",
                  "text" : "Expiry",
                  "type" : "string",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.identifier.where(type.coding.exists(system='http://terminology.hl7.org/CodeSystem/v2-0203' and code='PEN')).value"
                  }
                }
              ],
              "linkId" : "c1e4e967-c0aa-4280-b5d4-ab1f375ed9ac",
              "text" : "Pensioner Card Number",
              "type" : "string",
              "repeats" : false,
              "readOnly" : true,
              "maxLength" : 10
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.identifier.where(type.coding.exists(system='http://terminology.hl7.org/CodeSystem/v2-0203' and code='HC')).value"
                  }
                }
              ],
              "linkId" : "a7e97574-3cea-4dfa-bef2-2665e7748364",
              "text" : "Health Care Card Number",
              "type" : "string",
              "repeats" : false,
              "readOnly" : true,
              "maxLength" : 10
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%patient.extension.where(url='http://hl7.org.au/fhir/StructureDefinition/closing-the-gap-registration').value"
                  }
                }
              ],
              "linkId" : "83814495-3a81-43f4-88df-42186cce516a",
              "text" : "Registered for Closing the Gap PBS Co-payment Measure (CTG)",
              "type" : "boolean",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "e63547c6-1623-412f-963f-5f1ebf23563f",
              "text" : "Child has a birth certificate",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNoNA"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50"
                  }
                }
              ],
              "linkId" : "a8143230-b30d-4b85-9805-5f2f73f2dffa",
              "text" : "My Aged Care",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "7165c072-e3d8-4564-9d1d-d17f6807787c",
                  "text" : "Registered for My Aged Care",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "04e50521-dc85-4744-b7ab-6f8682aacb11",
                  "text" : "My Aged Care Number",
                  "type" : "string",
                  "enableWhen" : [
                    {
                      "question" : "7165c072-e3d8-4564-9d1d-d17f6807787c",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "2bfe50cb-7913-4f31-bce2-763c17ff8b1a",
              "text" : "National Disability Insurance Scheme",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "924b4500-53ac-4c4e-831b-7ab5569ff981",
                  "text" : "Registered for NDIS",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "7379a0fd-d95b-4ecb-a781-9f43d1394f10",
                  "text" : "NDIS Number",
                  "type" : "string",
                  "enableWhen" : [
                    {
                      "question" : "924b4500-53ac-4c4e-831b-7ab5569ff981",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age <= 49) and (%age > 12)"
                  }
                }
              ],
              "linkId" : "9bc882bc-e989-4600-9587-8089fb757641",
              "text" : "Children",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "e90b436b-2751-4e07-a40c-adfe951b6528",
                  "text" : "Do you have children?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "241f5fca-f61a-49bd-8972-52613c0e6d15",
                  "text" : "Number of children",
                  "type" : "integer",
                  "enableWhen" : [
                    {
                      "question" : "e90b436b-2751-4e07-a40c-adfe951b6528",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                },
                {
                  "linkId" : "74ce4c60-31d6-4e78-9056-579937379451",
                  "text" : "Number of children in your care",
                  "type" : "integer",
                  "enableWhen" : [
                    {
                      "question" : "e90b436b-2751-4e07-a40c-adfe951b6528",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                }
              ],
              "linkId" : "2b5ae784-4341-4172-875d-1698cc8069f0",
              "text" : "Someone's carer",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "a08271f1-194b-4fe9-91f9-4f3398858eb0",
                  "text" : "Are you responsible for caring for someone else?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "4c14b158-3ae4-4994-8446-76e02640702c",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "a08271f1-194b-4fe9-91f9-4f3398858eb0",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50"
                  }
                }
              ],
              "linkId" : "6c80c675-1320-4ca3-ae3f-51ad173da741",
              "text" : "Your carer",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "d05558fb-a3cc-4bd6-b803-b672b36b9c51",
                  "text" : "Do you have a carer?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "b9991e7e-ce03-465d-b4b0-5a1725b24e02",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "d05558fb-a3cc-4bd6-b803-b672b36b9c51",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "3494631c-6b56-46dc-abf7-a17bfc1d025f",
              "text" : "Providers",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "41210be5-d441-4c44-b9c2-8dd94a44cbb4",
                  "text" : "Are name and contact details of other key providers (eg case workers, support services) up to date?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "6733d6ec-5b6b-4ee2-a21e-0e9474c2b22b",
                  "text" : "Details",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50"
                  }
                }
              ],
              "linkId" : "38f81a73-447f-4ecd-a8eb-6eccd9dee050",
              "text" : "Advance care planning",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "c023ef16-b554-4ed9-8993-1331e5f5a3b4",
                  "text" : "Enduring Power of Attorney",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "radio-button"
                              }
                            ]
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                          "valueCode" : "horizontal"
                        }
                      ],
                      "linkId" : "036eace9-ea83-46ec-9d01-f2093f710816",
                      "text" : "Enduring Power of Attorney",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "#YesNoNA"
                    },
                    {
                      "linkId" : "83518215-7151-4365-b745-d7464bbb9528",
                      "text" : "Discussed today",
                      "type" : "text",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "linkId" : "c4f68251-26af-462f-879a-a69b449066ff",
                  "text" : "Advance Health Directive",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "radio-button"
                              }
                            ]
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                          "valueCode" : "horizontal"
                        }
                      ],
                      "linkId" : "b0632039-c12b-4748-9e94-52073590c0ba",
                      "text" : "Advance Health Directive",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "#YesNoNA"
                    },
                    {
                      "linkId" : "c4bc2d84-e411-488d-9c0d-761f0377a026",
                      "text" : "Discussed today",
                      "type" : "text",
                      "repeats" : false
                    }
                  ]
                }
              ]
            },
            {
              "linkId" : "patientdetails-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-32",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
              "valueString" : "Current priorities"
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "b3a3eee2-f340-452e-9d05-d1f54f677b81",
          "text" : "Current health/patient priorities",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-5').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-5').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-5",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-5').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-5",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-5').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-5",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "dcf182c0-a2bf-46ac-a19b-72e4d24ef24d",
              "text" : "What are the important things for you in this health check today?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "a0c06f8d-3210-480b-9031-7b5eb5bf1dda",
              "text" : "Is there anything you are worried about?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "96f3396e-f5f8-4347-8692-9abdecb97768",
              "text" : "Is there anything that you are worried about with your child's health or wellbeing?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                }
              ],
              "linkId" : "17651f83-8476-499c-a5ef-dd4e1a6c9f13",
              "text" : "Child Health Book",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "2655e0e1-fe4b-431e-87af-30d4ff1aca76",
                  "text" : "Does your child have a Child Health Book?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "a30d0101-06ce-4481-b142-9fa2c091fe4f",
                  "text" : "Is it up to date?",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "2655e0e1-fe4b-431e-87af-30d4ff1aca76",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "35b3f6d8-2907-4134-ae55-1e321b908f70",
              "text" : "Do you have any specific health goals? Is there anything in particular about your health and wellbeing that you would like to improve?",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "7cd424e5-7672-4e99-8a99-30b1fb3043fd",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "currentpriorities-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-5",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "28d5dbe4-1e65-487c-847a-847f544a6a91",
          "text" : "Medical history and current problems",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-17').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-17').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-17",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-17').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-17",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-17').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-17",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                }
              ],
              "linkId" : "b9de2b58-55e2-436d-95ab-49600508cdf7",
              "text" : "Birth history",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "wk"
                      }
                    }
                  ],
                  "linkId" : "a10a7375-e9d3-4e71-a47a-282e9ba38ec1",
                  "text" : "Gestation at birth",
                  "type" : "decimal",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "f3899852-36c4-441f-9a7d-544ef1617f08",
                      "text" : "weeks",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "kg"
                      }
                    }
                  ],
                  "linkId" : "29b6d8ea-23b2-4a69-98d9-899198692de7",
                  "text" : "Birth weight",
                  "type" : "decimal",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "87cf1ecd-6d1b-4de1-894d-58bd77dcfde1",
                      "text" : "kg",
                      "type" : "display"
                    }
                  ]
                }
              ]
            },
            {
              "linkId" : "medicalhistorysummary",
              "text" : "Medical history summary",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <p>Medical history summary</p>\r\n    <p style=\"font-size:0.9em; font-weight:normal\"><em>This section includes a list of existing items from the patient record. <br />Update these items here or update the patient record and repopulate the form. <br />Add new items at the bottom.</em></p>\r\n    </div>"
                  }
                ]
              },
              "type" : "group",
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/GroupHideAddItemButton",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "gtable"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                      "valueExpression" : {
                        "name" : "ConditionRepeat",
                        "language" : "text/fhirpath",
                        "expression" : "%Condition.entry.resource.where(verificationStatus.coding.all(code.empty() or code='confirmed'))"
                      }
                    },
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#ConditionPatchTemplate"
                          }
                        },
                        {
                          "url" : "https://smartforms.csiro.au/ig/StructureDefinition/TemplateExtractExtensionPatchRequestUrl",
                          "valueString" : "'Condition/' + item.where(linkId='conditionId').answer.value"
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    }
                  ],
                  "linkId" : "92bd7d05-9b5e-4cf9-900b-703f361dad9d",
                  "text" : "Medical history summary",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                        "valueBoolean" : true
                      }
                    ]
                  },
                  "type" : "group",
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ConditionRepeat.id"
                          }
                        }
                      ],
                      "linkId" : "conditionId",
                      "type" : "string"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                          "valueQuantity" : {
                            "value" : 40,
                            "system" : "http://unitsofmeasure.org",
                            "code" : "%"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ConditionRepeat.code.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())"
                          }
                        }
                      ],
                      "linkId" : "59b1900a-4f85-4a8c-b9cd-3fe2fd76f27e",
                      "text" : "Condition",
                      "type" : "open-choice",
                      "readOnly" : true,
                      "answerValueSet" : "#clinical-condition-1"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "drop-down"
                              }
                            ]
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ConditionRepeat.clinicalStatus.coding"
                          }
                        }
                      ],
                      "linkId" : "88bcfad7-386b-4d87-b34b-2e50482e4d2c",
                      "text" : "Clinical status",
                      "type" : "choice",
                      "answerValueSet" : "#condition-clinical"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ConditionRepeat.clinicalStatus.coding"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "medicalhistory-status-hidden",
                      "type" : "choice",
                      "answerValueSet" : "#condition-clinical"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ConditionRepeat.onset.ofType(dateTime).toDate()"
                          }
                        }
                      ],
                      "linkId" : "6ae641ad-95bb-4cdc-8910-5a52077e492c",
                      "text" : "Onset date",
                      "type" : "date",
                      "readOnly" : true
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ConditionRepeat.abatement.ofType(dateTime).toDate()"
                          }
                        }
                      ],
                      "linkId" : "e4524654-f6de-4717-b288-34919394d46b",
                      "text" : "Abatement date",
                      "type" : "date"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ConditionRepeat.abatement.ofType(dateTime).toDate()"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "medicalhistory-abatementdate-hidden",
                      "type" : "date"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "gtable"
                          }
                        ]
                      }
                    },
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#ConditionTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    }
                  ],
                  "linkId" : "newdiagnosis",
                  "text" : "New diagnosis",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                        "valueBoolean" : true
                      }
                    ]
                  },
                  "type" : "group",
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                          "valueQuantity" : {
                            "value" : 35,
                            "system" : "http://unitsofmeasure.org",
                            "code" : "%"
                          }
                        }
                      ],
                      "linkId" : "2da85994-2d5e-42f1-8a81-abf44f397468",
                      "text" : "Condition",
                      "type" : "open-choice",
                      "answerValueSet" : "#clinical-condition-1"
                    },
                    {
                      "linkId" : "4d55bffb-3286-4a23-a785-3b9c346d464d",
                      "text" : "Onset date",
                      "type" : "date"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-width",
                          "valueQuantity" : {
                            "value" : 45,
                            "system" : "http://unitsofmeasure.org",
                            "code" : "%"
                          }
                        }
                      ],
                      "linkId" : "newdiagnosis-comment",
                      "text" : "Comment",
                      "type" : "string"
                    }
                  ]
                }
              ]
            },
            {
              "linkId" : "62774152-8a6e-4449-af9f-87bdce8b9bf5",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "medicalhistory-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-17",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "7dfe7c6a-ca7f-4ddf-9241-a7b918a9695a",
          "text" : "Regular medications",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-23').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-23').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-23",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-23').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-23",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-23').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-23",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "regularmedications-instruction",
              "text" : "Check medications are still required, appropriate dose, understanding of medication and adherence",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n      <em>Check medications are still required, appropriate dose, understanding of medication and adherence</em>\r\n    </div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "regularmedications-summary",
              "text" : "Medication summary",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<p>Medication summary</p>\r\n<p style=\"font-size:0.9em; font-weight:normal\"><em>This section includes a list of existing items from the patient record. <br />Update these items here or update the patient record and repopulate the form. <br />Add new items at the bottom.</em></p>\r\n</div>"
                  }
                ]
              },
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                      "valueExpression" : {
                        "name" : "MedicationStatementRepeat",
                        "language" : "text/fhirpath",
                        "expression" : "%MedicationStatement.entry.resource.ofType(MedicationStatement)"
                      }
                    },
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#MedicationStatementPatchTemplate"
                          }
                        },
                        {
                          "url" : "https://smartforms.csiro.au/ig/StructureDefinition/TemplateExtractExtensionPatchRequestUrl",
                          "valueString" : "'MedicationStatement/' + item.where(linkId='medicationStatementId').answer.value"
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    },
                    {
                      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/GroupHideAddItemButton",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "regularmedications-summary-current",
                  "text" : "Current medications",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                        "valueBoolean" : true
                      }
                    ]
                  },
                  "type" : "group",
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%MedicationStatementRepeat.id"
                          }
                        }
                      ],
                      "linkId" : "medicationStatementId",
                      "type" : "string"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "iif(%MedicationStatementRepeat.medication.reference.replace('#', '') in %medicationsFromContained.id, %medicationsFromContained.where(id = %MedicationStatementRepeat.medication.reference.replace('#', '')).code.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first()), iif(%MedicationStatementRepeat.medication.reference.replace('Medication/', '') in %medicationsFromRef.id , %medicationsFromRef.where(id = %MedicationStatementRepeat.medication.reference.replace('Medication/', '')).code.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first()) ,%MedicationStatementRepeat.medication.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())))"
                          }
                        }
                      ],
                      "linkId" : "regularmedications-summary-current-medication",
                      "text" : "Medication",
                      "type" : "open-choice",
                      "repeats" : false,
                      "readOnly" : true,
                      "answerValueSet" : "#smart-health-checks-medicine-products"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%MedicationStatementRepeat.status"
                          }
                        }
                      ],
                      "linkId" : "regularmedications-summary-current-status",
                      "text" : "Status",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "#MedicationStatementStatusLimited"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%MedicationStatementRepeat.status"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "regularmedications-summary-current-status-hidden",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "#MedicationStatementStatusLimited"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%MedicationStatementRepeat.dosage.text"
                          }
                        }
                      ],
                      "linkId" : "regularmedications-summary-current-dosage",
                      "text" : "Dosage",
                      "type" : "text",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%MedicationStatementRepeat.dosage.text"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "regularmedications-summary-current-dosage-hidden",
                      "type" : "text",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%MedicationStatementRepeat.reasonCode.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())"
                          }
                        }
                      ],
                      "linkId" : "regularmedications-summary-current-reasoncode",
                      "text" : "Clinical indication",
                      "type" : "open-choice",
                      "repeats" : true,
                      "readOnly" : true,
                      "answerValueSet" : "#medication-reason-taken-1"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%MedicationStatementRepeat.note.text"
                          }
                        }
                      ],
                      "linkId" : "regularmedications-summary-current-comment",
                      "text" : "Comment",
                      "type" : "text",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%MedicationStatementRepeat.note.text"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "regularmedications-summary-current-comment-hidden",
                      "type" : "text",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#MedicationStatementTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    }
                  ],
                  "linkId" : "regularmedications-summary-new",
                  "text" : "New medications",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                        "valueBoolean" : true
                      }
                    ]
                  },
                  "type" : "group",
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "regularmedications-summary-new-medication",
                      "text" : "Medication",
                      "type" : "open-choice",
                      "repeats" : false,
                      "answerValueSet" : "#smart-health-checks-medicine-products"
                    },
                    {
                      "linkId" : "regularmedications-summary-new-dosage",
                      "text" : "Dosage",
                      "type" : "text",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "regularmedications-summary-new-reasoncode",
                      "text" : "Clinical indication",
                      "type" : "open-choice",
                      "repeats" : true,
                      "answerValueSet" : "#medication-reason-taken-1"
                    },
                    {
                      "linkId" : "regularmedications-summary-new-comment",
                      "text" : "Comment",
                      "type" : "text",
                      "repeats" : false
                    }
                  ]
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Does your child take any regular medications?"
                }
              ],
              "linkId" : "6eb59145-ed9a-4184-af83-3506d47e4d4e",
              "text" : "Does your child take any regular medications (prescribed, over-the-counter, traditional, complementary and alternative)?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNo"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Do you take any regular medications?"
                }
              ],
              "linkId" : "3a2d27b6-e918-4df5-aca9-b374fcf9faad",
              "text" : "Do you take any regular medications (prescribed, over-the-counter, traditional, complementary and alternative)?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNo"
            },
            {
              "linkId" : "874ec8db-95c9-4cc0-95db-e45edaa3cd12",
              "text" : "Check the health record is up to date",
              "type" : "boolean",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Understanding and adherence checked"
                }
              ],
              "linkId" : "36290837-ad70-48b2-9c66-31533fec918b",
              "text" : "Check medication understanding and adherence with patient",
              "type" : "boolean",
              "enableWhen" : [
                {
                  "question" : "6eb59145-ed9a-4184-af83-3506d47e4d4e",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                    "code" : "Y"
                  }
                },
                {
                  "question" : "3a2d27b6-e918-4df5-aca9-b374fcf9faad",
                  "operator" : "=",
                  "answerCoding" : {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                    "code" : "Y"
                  }
                }
              ],
              "enableBehavior" : "any",
              "repeats" : false
            },
            {
              "linkId" : "aa9ff2ed-bcd2-406d-a9ff-89c201df2605",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "regularmedications-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-23",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "allergy",
          "text" : "Allergies/adverse reactions",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-3').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-3').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-3",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-3').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-3",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-3').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-3",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "allergyinstruction",
              "text" : "Adverse reaction risk summary",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <p>Adverse reaction risk summary</p>\r\n    <p style=\"font-size:0.9em; font-weight:normal\"><em>This section includes a list of existing items from the patient record. <br />Update these items here or update the patient record and repopulate the form. <br />Add new items at the bottom.</em></p>\r\n    </div>"
                  }
                ]
              },
              "type" : "group",
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                      "valueExpression" : {
                        "name" : "AllergyIntoleranceRepeat",
                        "language" : "text/fhirpath",
                        "expression" : "%AllergyIntolerance.entry.resource.where(clinicalStatus.coding.exists(code='active')).where(verificationStatus.coding.all(code.empty() or code='confirmed'))"
                      }
                    },
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#AllergyIntolerancePatchTemplate"
                          }
                        },
                        {
                          "url" : "https://smartforms.csiro.au/ig/StructureDefinition/TemplateExtractExtensionPatchRequestUrl",
                          "valueString" : "'AllergyIntolerance/' + item.where(linkId='allergyIntoleranceId').answer.value"
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    },
                    {
                      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/GroupHideAddItemButton",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "allergysummary",
                  "text" : "Adverse reaction risk summary",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                        "valueBoolean" : true
                      }
                    ]
                  },
                  "type" : "group",
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%AllergyIntoleranceRepeat.id"
                          }
                        }
                      ],
                      "linkId" : "allergyIntoleranceId",
                      "type" : "string"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%AllergyIntoleranceRepeat.code.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "allergysummary-substance",
                      "text" : "Substance",
                      "type" : "open-choice",
                      "repeats" : false,
                      "readOnly" : true,
                      "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/adverse-reaction-agent-1"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%AllergyIntoleranceRepeat.clinicalStatus.coding"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "drop-down"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "allergysummary-status",
                      "text" : "Status",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "#AllergyIntoleranceClinicalStatusMinimal"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%AllergyIntoleranceRepeat.clinicalStatus.coding"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "allergysummary-status-hidden",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "#AllergyIntoleranceClinicalStatusMinimal"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%AllergyIntoleranceRepeat.reaction.manifestation.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "allergysummary-manifestation",
                      "text" : "Manifestation",
                      "type" : "open-choice",
                      "repeats" : true,
                      "readOnly" : true,
                      "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/clinical-finding-1"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%AllergyIntoleranceRepeat.note[0].text"
                          }
                        }
                      ],
                      "linkId" : "allergysummary-comment",
                      "text" : "Comment",
                      "type" : "text",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%AllergyIntoleranceRepeat.note[0].text"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "allergysummary-comment-hidden",
                      "type" : "text",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#AllergyIntoleranceTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    }
                  ],
                  "linkId" : "allergynew",
                  "text" : "New adverse reaction risks",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                        "valueBoolean" : true
                      }
                    ]
                  },
                  "type" : "group",
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "allergynew-substance",
                      "text" : "Substance",
                      "type" : "open-choice",
                      "required" : true,
                      "repeats" : false,
                      "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/adverse-reaction-agent-1"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "autocomplete"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "allergynew-manifestation",
                      "text" : "Manifestation",
                      "type" : "open-choice",
                      "repeats" : true,
                      "answerValueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/clinical-finding-1"
                    },
                    {
                      "linkId" : "allergynew-comment",
                      "text" : "Comment",
                      "type" : "text",
                      "repeats" : false
                    }
                  ]
                }
              ]
            },
            {
              "linkId" : "3e689aeb-69a1-4a9b-93bd-50377511dd9b",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "allergy-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-3",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "01f67f0b-e3be-48d8-a2ad-4c54f469cd13",
          "text" : "Family history",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-9').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-9').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-9",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-9').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-9",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-9').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-9",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "532e09ea-2c2d-48c6-81f8-e23380b329a0",
              "text" : "Provide relevant family history information",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Provide relevant family history information"
                }
              ],
              "linkId" : "df5b2081-a373-48ee-acab-96225dad3c1d",
              "text" : "Provide relevant family history information (including diabetes, heart disease, cancer, mental health)",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "49ee4583-c608-41d4-a1e9-c06cf4292369",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "familyhistory-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-9",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age > 12"
              }
            }
          ],
          "linkId" : "0a3c9c93-5836-4a5b-93e5-d7de559e053a",
          "text" : "Social and emotional wellbeing",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-27').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-27').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-27",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-27').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-27",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-27').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-27",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "c736d065-88f6-49c3-a5a4-91a2bd7a54bb",
              "text" : "Stressful life events",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "e7297156-cfed-4437-b877-c345f744168b",
                  "text" : "Have there been any particular stressful life events that are impacting on you/your health lately?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "4c3427ce-062f-4f62-b566-2decb506a9cb",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "e7297156-cfed-4437-b877-c345f744168b",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 24"
                  }
                }
              ],
              "linkId" : "7d783b71-7303-441b-822a-14e11a740038",
              "text" : "Social and emotional wellbeing assessment: consider tools such as Aboriginal and Torres Strait Islander Youth Social Emotional Wellbeing assessment question guide or HEEADSSS",
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 24"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "9e991b80-7080-40d5-9ad9-447dc47e3a68",
              "text" : "Consider conversation about social connection, which could include questions about sports/hobbies/clubs/other activities",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "b5a00aad-2a8b-4ac3-87b2-4a5920ca22ee",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "socialemotionalwellbeing-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-27",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 12"
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
              "valueString" : "Social history"
            }
          ],
          "linkId" : "a5cc8a8f-89cf-470c-a6bd-ce9da2f64ee9",
          "text" : "Social history: Information about family and child's living arrangements",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-28').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-28').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-28",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-28').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-28",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-28').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-28",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "1bb673a4-40f9-41c3-ad04-66c9f38fdc1b",
              "text" : "Who lives in your household? / Who does the child live with?",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "934d105e-a4d6-4926-9b64-55bb1049d839",
              "text" : "Stressful life events",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "062f5234-686a-4bf3-afcd-3fcd988afd6c",
                  "text" : "Have there been any stressful life events that would cause you or your child to be upset?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "1ea0a898-d680-4a5d-a0f1-91b57eb77a91",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "062f5234-686a-4bf3-afcd-3fcd988afd6c",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "272af1cb-4309-4227-bab4-a6cc9fb47635",
              "text" : "If indicated, ask about depression and other mental health concerns",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "76d51512-b94a-4092-b3ae-a656fbb9c360",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "socialhistorychild-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-28",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age > 12"
              }
            }
          ],
          "linkId" : "819b3305-bf93-4502-9986-242ea2ae5f43",
          "text" : "Home and family",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-12').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-12').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-12",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-12').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-12",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-12').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-12",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "29bb209f-6dfc-4ed0-8b8d-741016c0ac61",
              "text" : "Who do you live with?",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "64b979b6-cfc1-4024-868c-94e7be90d12b",
              "text" : "Housing stability",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "a7542da8-aad6-4a80-8b5b-806ca11d68d2",
                  "text" : "Do you have stable housing?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "476dae02-d0e8-4128-81a1-7ad71dd06e97",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "a7542da8-aad6-4a80-8b5b-806ca11d68d2",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "N"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "367ac5dd-07fa-4bda-a775-d9f38b15affd",
              "text" : "Home safety",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "6f73d1ee-dd8e-419a-9142-ede367200e3b",
                  "text" : "Do you feel safe at home?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "9bd5f571-8cbf-4c25-975c-5fc8395b75f5",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "6f73d1ee-dd8e-419a-9142-ede367200e3b",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "N"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "08d2e80e-3bb4-4f67-8b1c-090b1ace225a",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "homeandfamily-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-12",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 12"
              }
            }
          ],
          "linkId" : "3e7d7246-98f8-4803-b063-8405ac30b086",
          "text" : "Learning and development",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-15').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-15').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-15",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-15').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-15",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-15').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-15",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "818c9aaa-1b00-4c76-9971-49df74edff7a",
              "text" : "Is there anything that you are worried about with your child's development?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "e7ef5692-25e6-4598-aa08-d0107e21fe31",
              "text" : "Is there anything that you are worried about with your child's learning?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "fc658147-3fad-42a0-9c10-c14fbd30775e",
              "text" : "Is there anything that you are worried about with your child's behaviour?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "582fcfe5-c7a4-4847-9881-815452b9eafe",
              "text" : "Is there anything that you are worried about with your child's sleep?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "335f4c10-a6e6-455b-8a7e-2962158f5183",
              "text" : "What childcare/early learning centre/kindergarten does your child go to? How often?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "e5b886ad-840e-4f01-af04-55c5ea7f215d",
              "text" : "How often does your child miss childcare/early learning centre/kindergarten?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "f0e0ea74-cffc-46a5-8554-67e8fcc667f1",
              "text" : "Is there anything you are worried about at school?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "73a40641-04c9-4da4-813e-a8b9ae3a2ecf",
              "text" : "How often does your child miss school?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "47f09b28-9eea-4f8c-8d3c-7efef0504728",
              "text" : "Is your child having any difficulties making friends?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "9371dddc-49f4-4a8f-a9dc-a0e128f99636",
              "text" : "Are there any other concerns about your child's learning and development?",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "5ab80929-5901-431d-bf68-67d532f5fa58",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "learningdevelopment-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-15",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "(%age > 12) and (%age < 50)"
              }
            }
          ],
          "linkId" : "5437e30d-8a0a-4785-974e-00a10d2a1df0",
          "text" : "Learning and work",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-16').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-16').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-16",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-16').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-16",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-16').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-16",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age < 25"
                  }
                }
              ],
              "linkId" : "0e30e9b4-ec83-44ea-88ab-47963e52a2d7",
              "text" : "Learning",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "0cd9e27b-1e98-41af-917b-0c6ee21c0819",
                  "text" : "Are you studying at school/uni?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "18bdfa42-9845-4c6e-b737-843b14d54641",
                  "text" : "Details",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 25"
                  }
                }
              ],
              "linkId" : "c0ba8a79-a9c5-40cc-b0c2-041e736784e9",
              "text" : "Learning",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "4a81afc0-f0da-49e1-b8cc-c19cb0f5f4e9",
                  "text" : "Are you studying?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "linkId" : "1c648524-558e-4d24-bd83-c9f5cd35e97b",
                  "text" : "Details",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "ccf6f0b0-57ae-473e-9929-2a09184c8a14",
              "text" : "Work",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "aaead1e2-ea54-4979-be0a-647e61ab59a9",
                  "text" : "Are you working?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNA"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                      "valueString" : "Details"
                    }
                  ],
                  "linkId" : "749a4e1e-35ab-4f37-ab28-cb3f0830bb2a",
                  "text" : "Details (occupation including occupational hazards, study, training, disability, etc)",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "3569e514-a74b-4343-b31b-3395e58d991a",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "learningwork-adolescentsadults-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-16",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age >= 50"
              }
            }
          ],
          "linkId" : "dec713ae-246a-4961-95c9-0626bfebfed2",
          "text" : "Work",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-33').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-33').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-33",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-33').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-33",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-33').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-33",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "2bfc99a5-677c-4aea-a1ad-c37a181a3733",
              "text" : "Work",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "4c68ff3e-0e73-4ea2-b295-5057deaa590e",
                  "text" : "Are you working?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                      "valueString" : "Details"
                    }
                  ],
                  "linkId" : "794fc001-6799-4a51-9a80-f2ed7c685a42",
                  "text" : "Details (occupation including occupational hazards, study, training, disability, etc)",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "ed6f7800-e22a-4639-9d11-faf845513500",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "learningwork-olderpeople-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-33",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age > 12"
              }
            }
          ],
          "linkId" : "9559242e-9ffe-4e1f-a9fc-86d1fa62c4b9",
          "text" : "Mood",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-19').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-19').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-19",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-19').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-19",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-19').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-19",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "b3c510a7-bfd1-4ebe-8755-9f05e7a742ba",
              "text" : "How have you been feeling lately?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Ask about depression and complete risk assessment"
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "b4245702-afe5-4e4e-a102-1d3ceb4ad7c2",
              "text" : "If indicated, ask about depression (consider screening tools, eg aPHQ-9, K5 or K10) and complete risk assessment",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "6a99da48-366b-40c9-97ec-d0f2d52964a8",
              "text" : "Explore other mental health concerns as indicated",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "db9a8650-42a2-4bd3-8066-7e09394120d5",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "mood-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-19",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age >= 50"
              }
            }
          ],
          "linkId" : "1bd58e7b-2cb7-45fb-965f-d5fa33d0bb4c",
          "text" : "Memory and thinking",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-18').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-18').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-18",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-18').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-18",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-18').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-18",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "64fd0c95-b57b-4319-bf40-ad77d10a9832",
              "text" : "Personal concerns about your memory or thinking",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "e29701be-2b79-471d-a42e-7e3830459080",
                  "text" : "Do you have any worries about your memory or thinking?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "69985e2e-4619-42fa-a111-e6fb3118ef74",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "e29701be-2b79-471d-a42e-7e3830459080",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "44da9ba8-4636-4eaa-8bb1-aaa65f117fab",
              "text" : "Family concerns about your memory or thinking",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "06a67326-9e3d-4c4c-b271-af5b168d077c",
                  "text" : "Does anyone in your family have any worries about your memory or thinking?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "43d2cb6c-29a7-4293-a6c8-87a228a82e19",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "06a67326-9e3d-4c4c-b271-af5b168d077c",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "4ebb3c30-936b-4932-a330-f1e643b5ccd4",
              "text" : "If any concerns are raised and/or high risk for cognitive impairment identified, follow up with cognitive screening (eg clock test, GPCOG, KICA-Cog, MMSE)",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "1f0e7fde-e964-4f36-9151-dbdc5e145f94",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "memorythinking-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-18",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age >= 50"
              }
            }
          ],
          "linkId" : "c5da020c-c4f3-437c-b658-ea7e7667514d",
          "text" : "Chronic disease associated with ageing",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-4').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-4').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-4",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-4').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-4",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-4').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-4",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Assessment of chronic disease associated with ageing"
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "12e244c0-2887-4230-8792-9521d4f1ab33",
              "text" : "For older people with chronic disease and/or conditions associated with ageing, consider assessing: Osteoporosis risk; Falls risk; Balance, coordination and mobility; Pain; Nutrition; Regularity of chronic disease management and review",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <div>For older people with chronic disease and/or conditions associated with ageing, consider assessing:</div>\r\n    <ul>\r\n      <li>Osteoporosis risk</li>\r\n      <li>Falls risk</li>\r\n      <li>Balance, coordination and mobility</li>\r\n      <li>Pain</li>\r\n      <li>Nutrition</li>\r\n      <li>Regularity of chronic disease management and review</li>\r\n    </ul>\r\n    </div>"
                  }
                ]
              },
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "7292070b-8944-4a40-bcf6-9aaf1721e986",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "chronicdisease-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-4",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "(%age >= 50) and (%age <= 74)"
              }
            }
          ],
          "linkId" : "9674ffa0-2ad9-4ca3-80e6-e8bb0670a802",
          "text" : "Participation in screening programs",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-24').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-24').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-24",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-24').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-24",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-24').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-24",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "ed15e82b-803a-4d21-9344-9110b57b2313",
              "text" : "Cervical screening (age <=74 years)",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "c1cf9c00-15ef-4b98-bab0-20a5f01b4932",
                  "text" : "Cervical screening status",
                  "type" : "choice",
                  "repeats" : false,
                  "answerOption" : [
                    {
                      "valueString" : "Up to date"
                    },
                    {
                      "valueString" : "Discussed today"
                    },
                    {
                      "valueString" : "Not required"
                    },
                    {
                      "valueString" : "Declined"
                    },
                    {
                      "valueString" : "Next due"
                    }
                  ]
                },
                {
                  "linkId" : "4bd712ec-b11b-4ef9-aa0e-2cd2c02cf8bd",
                  "text" : "Cervical screening next due",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "linkId" : "4e0c55a0-c559-45fd-b165-5aaea3451423",
                  "text" : "Cervical screening details",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "17ff5354-fe9c-429c-a752-c27a871d4ee7",
              "text" : "Breast screening (age <=74 years)",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "29fada07-f981-44cf-8092-61c86365a965",
                  "text" : "Breast screening status",
                  "type" : "choice",
                  "repeats" : false,
                  "answerOption" : [
                    {
                      "valueString" : "Up to date"
                    },
                    {
                      "valueString" : "Discussed today"
                    },
                    {
                      "valueString" : "Not required"
                    },
                    {
                      "valueString" : "Declined"
                    },
                    {
                      "valueString" : "Next due"
                    }
                  ]
                },
                {
                  "linkId" : "9410ff22-86a4-4d01-b6ff-da9b1e7d17da",
                  "text" : "Breast screening next due",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "linkId" : "b63a03c8-2c7b-46a5-8f13-ebc7fb8b91ee",
                  "text" : "Breast screening details",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "bb5d56e3-efb9-45fe-854d-e4550b327d26",
              "text" : "Bowel cancer screening (age <=74 years)",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "521df1b1-ff36-458b-8f99-e41c2b1685c8",
                  "text" : "Bowel cancer screening status",
                  "type" : "choice",
                  "repeats" : false,
                  "answerOption" : [
                    {
                      "valueString" : "Up to date"
                    },
                    {
                      "valueString" : "Discussed today"
                    },
                    {
                      "valueString" : "Not required"
                    },
                    {
                      "valueString" : "Declined"
                    },
                    {
                      "valueString" : "Next due"
                    }
                  ]
                },
                {
                  "linkId" : "df2fbba0-cb6f-4fb8-a413-e3acf1a3a98e",
                  "text" : "Bowel cancer screening next due",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "linkId" : "0d59513c-7a77-4752-9c4e-492a54412731",
                  "text" : "Bowel cancer screening details",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "70f82c4b-d1f9-44d5-9903-bd7097799c05",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "screening-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-24",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "ae7a3801-9491-4b1f-820c-678236d18f56",
          "text" : "Healthy eating",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-11').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-11').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-11",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-11').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-11",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-11').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-11",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "9ac8c78d-9c36-4bf5-8c6e-e48109902dfa",
              "text" : "Child eating concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age <= 5"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "e2942894-5537-47a6-ab43-06eb6761f9b5",
                  "text" : "Is there anything that you are worried about with your child's feeding/eating?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age > 5"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "69d92a26-95ac-4556-94da-5b0e09940bfd",
                  "text" : "Is there anything that you are worried about with your child's eating?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "f6907808-3e42-4206-9bf8-ca4082ea4814",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "e2942894-5537-47a6-ab43-06eb6761f9b5",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    },
                    {
                      "question" : "69d92a26-95ac-4556-94da-5b0e09940bfd",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "enableBehavior" : "any",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "ff6a46e6-0812-4718-a854-489b24805925",
              "text" : "Breastfeeding history",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "b5f748d2-1874-4949-a7df-6e233f03135d",
              "text" : "Bottle feeding history",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                }
              ],
              "linkId" : "9266b946-74b3-4fc2-91ce-df557692e600",
              "text" : "Diet or weight concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "646302e9-d384-4943-99bc-11e638641703",
                  "text" : "Do you have any worries about your diet or weight?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "1d5c3354-6780-4b6a-b9af-7a17b0386781",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "646302e9-d384-4943-99bc-11e638641703",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50"
                  }
                }
              ],
              "linkId" : "c4c51d01-7acf-4551-a652-82f9fdf58a6d",
              "text" : "Unintended weight loss",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "6dc96b26-cbc5-4434-8f6b-0260196311c2",
                  "text" : "Have you lost weight without trying to in the last three months?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "ce71f016-c5e4-4121-abe5-fe0c974c1bba",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "6dc96b26-cbc5-4434-8f6b-0260196311c2",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "9f6adf74-f240-41a2-a509-d216d5308911",
              "text" : "Document conversation about age-appropriate healthy eating, which could include: current diet; transition to solids; dietary recommendations re fruit and vegetable intake, iron-rich foods, avoiding sugary drinks",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <div>Document conversation about age-appropriate healthy eating, which could include:</div>\r\n    <ul>\r\n      <li>current diet</li>\r\n      <li>transition to solids</li>\r\n      <li>dietary recommendations re fruit and vegetable intake, iron-rich foods, avoiding sugary drinks</li>\r\n    </ul>\r\n    </div>"
                  }
                ]
              },
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "7a22a4c4-6611-4687-af00-37c80c3f8fc0",
              "text" : "Document conversation about healthy eating which could include: current diet including food and drinks; recommendations about fruit and vegetable intake, water as the main drink, avoiding sugary drinks, avoiding highly processed foods (including supermarket-bought and take-away like KFC, Maccas, etc)",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <div>Document conversation about healthy eating which could include:</div>\r\n    <ul>\r\n      <li>current diet including food and drinks</li>\r\n      <li>recommendations about fruit and vegetable intake, water as the main drink, avoiding sugary drinks, avoiding highly processed foods (including supermarket-bought and take-away like KFC, Maccas, etc)</li>\r\n    </ul>\r\n    </div>"
                  }
                ]
              },
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "71e39493-f0b0-4074-934b-604155b349e1",
              "text" : "Food availability issues",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "12a41538-5dbd-4c1d-af69-52c59c48b1a9",
                  "text" : "Are there any issues about availability of food?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "92908e91-9453-4d22-99eb-23dad580c1cb",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "12a41538-5dbd-4c1d-af69-52c59c48b1a9",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "301789b0-8c6a-470d-8787-0ac6597e3bea",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "healthyeating-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-11",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age < 50"
              }
            }
          ],
          "linkId" : "74736baa-455b-41d2-af98-fb65cd463e97",
          "text" : "Physical activity and screen time",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-21').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-21').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-21",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-21').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-21",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-21').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-21",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "8c5e737f-820b-47a4-8c8a-27ce1eb18cf4",
              "text" : "Physical activity concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "304d0332-9bfd-42dc-a4be-a5122596fb89",
                  "text" : "Is there anything that you are worried about with your child's level of physical activity?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "26707b9a-4e3d-4063-a890-7ec2ff02ced1",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "304d0332-9bfd-42dc-a4be-a5122596fb89",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "e24d487b-3dd4-4a6d-a58e-85dfa8ce3f36",
              "text" : "Screen time concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "465eacce-f9ee-4022-9186-89065cf01ce2",
                  "text" : "Is there anything that you are worried about with your child's level of screen time?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "13040f64-5cbf-4592-a683-c03527c64ac6",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "465eacce-f9ee-4022-9186-89065cf01ce2",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                }
              ],
              "linkId" : "e9b6ac74-d810-4350-8b41-8ea2e4bd14fc",
              "text" : "Physical activity or screen time concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "08320c7a-831b-4237-95e2-d79aee155b90",
                  "text" : "Do you have any worries about physical activity or screen time?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "57fa51e3-11c5-43f1-bdf0-73b2b48414c3",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "08320c7a-831b-4237-95e2-d79aee155b90",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "a9aaba01-5f11-4d4e-ad39-40b6bef745da",
              "text" : "Document conversation about age-appropriate recommendations re physical activity and screen time",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age > 12) and (%age <= 24)"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "b2269be8-3ea5-494c-9368-06912b629789",
              "text" : "Document conversation about social connection, which could include questions about sports/hobbies/clubs/other activities",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "ccbd7fbf-0d40-4cb3-82b3-ad2c7cc7bba2",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "physicalactivity-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-21",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age >= 50"
              }
            }
          ],
          "linkId" : "d56234a0-aafd-4c22-96c9-00ead8424f0b",
          "text" : "Physical activity",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-34').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-34').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-34",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-34').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-34",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-34').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-34",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "015d986f-89cf-45b0-a753-9a3ab0c4b05b",
              "text" : "Physical activity concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "b30d5d21-c6d6-4bb3-aab4-0fdee80b3093",
                  "text" : "Do you have any worries about physical activity?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "fd6beb79-ffc3-4879-913b-f42b0ec930ba",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "b30d5d21-c6d6-4bb3-aab4-0fdee80b3093",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "eb326905-3709-4088-8491-8b83c97f2da4",
              "text" : "Document conversation about recommendations re physical activity",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "25b8b8fd-adb1-48ab-aeae-528603668c4b",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "physicalactivity-olderpeople-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-34",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 5"
              }
            }
          ],
          "linkId" : "b9a6ce8b-7766-47a5-8e1c-1590a1edbfa8",
          "text" : "Red flags early identification guide for children",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-22').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-22').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-22",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-22').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-22",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-22').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-22",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "dfbf13b5-e9e1-4f2f-83fc-1b3b9e50c921",
              "text" : "This is based on material from the The State of Queensland, Red flags early identification guide (for children aged birth to five years). 2nd edn. South Brisbane, Qld: Child Development Program, Queensland Health, 2016. Available at www.childrens.health.qld.gov.au/wp-content/uploads/PDF/red-flags-a3.pdf [Accessed 2 December 2019]. © Developed by the Child Development Program in conjunction with Brisbane North Primary Health Network. Updated: July 2016.",
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "check-box"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "0b520b20-98df-4024-b25d-2986f6b96e77",
              "text" : "What age group is the child closest to?",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "6 months"
                },
                {
                  "valueString" : "9 months"
                },
                {
                  "valueString" : "12 months"
                },
                {
                  "valueString" : "18 months"
                },
                {
                  "valueString" : "2 years"
                },
                {
                  "valueString" : "3 years"
                },
                {
                  "valueString" : "4 years"
                },
                {
                  "valueString" : "5 years"
                }
              ]
            },
            {
              "linkId" : "3ba3a34f-cb05-4d85-b5ea-0eddeb565aeb",
              "text" : "Red flags",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "9c717263-341e-416f-aad8-7aec7d2167c9",
                  "text" : "Social Emotional",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "6 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Does not smile or interact with people"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "c10acb25-fdc3-401e-b0aa-d85b2921e5bb",
                  "text" : "Social Emotional",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "9 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not sharing enjoyment with others using eye contact or facial expression"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "b6bb38f6-8084-4c89-a0f2-9d77aacab61d",
                  "text" : "Social Emotional",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "12 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Does not notice someone new"
                    },
                    {
                      "valueString" : "Does not play early turn taking games (e.g. peekaboo, rolling a ball)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "c0ad8dc5-4672-4b21-b30d-6dcc7a00109a",
                  "text" : "Social Emotional",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "18 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Lacks interest in playing and interacting with others"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "fc0977e1-fd83-4d0b-a57a-e94c7fd41fdb",
                  "text" : "Social Emotional",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "2 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "When playing with toys tends to bang, drop, or throw them rather than use them for their purpose (e.g. cuddle doll, build blocks)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "70f7b96f-eaae-490b-8522-1214c1b1aede",
                  "text" : "Social Emotional",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "3 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "No interest in pretend play or interacting with other children"
                    },
                    {
                      "valueString" : "Difficulty noticing and understanding feelings in themselves and others (eg happy, sad)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "03ff1391-f48d-4b99-894c-159f4d09eb33",
                  "text" : "Social Emotional",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "4 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Unwilling or unable to play cooperatively"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "ee5f0a61-a8a1-473e-addf-ca5b1eaad7d3",
                  "text" : "Social Emotional",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "5 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Play is different than their friends"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "2b23128e-1622-4880-abd6-c9cd429b48e3",
                  "text" : "Communication",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "6 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not starting to babble (e.g. aahh, oohh)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "dfb86be5-b6ff-400e-b7d6-68701df086da",
                  "text" : "Communication",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "9 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not using gestures (e.g. pointing, showing, waving)"
                    },
                    {
                      "valueString" : "Not using two part babble (e.g. bubu, dada)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "4d802a6d-c89e-4460-8091-874f855be4ad",
                  "text" : "Communication",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "12 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "No babbled phrases that sound like talking"
                    },
                    {
                      "valueString" : "No response to familiar words (e.g. bottle, daddy)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "b8e1a699-ed65-491f-9865-8ab855bb2d33",
                  "text" : "Communication",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "18 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "No clear words"
                    },
                    {
                      "valueString" : "Cannot understand short requests (e.g. 'Where is the ball?')"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "6c3637ed-4afd-45be-a15c-9d5e7d8e78e8",
                  "text" : "Communication",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "2 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not learning new words"
                    },
                    {
                      "valueString" : "Not putting words together (e.g. 'push car')"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "25d67a2f-8bbe-4f79-9488-1682d2ce49fa",
                  "text" : "Communication",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "3 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Speech is difficult for familiar people to understand"
                    },
                    {
                      "valueString" : "Not using simple sentences (e.g. big car go)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "f00b5ae1-cc33-44f9-bd9b-f9b6c93cc005",
                  "text" : "Communication",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "4 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Speech difficult to understand"
                    },
                    {
                      "valueString" : "Not able to follow directions with two steps (e.g. 'Put your bag away and then go play')"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "3e06438a-ee7d-4880-83aa-68d2ade997ce",
                  "text" : "Communication",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "5 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Difficulty telling a parent what is wrong"
                    },
                    {
                      "valueString" : "Not able to answer questions in a simple conversation (e.g. What's your name? Who is your family?)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "49d172b4-bc2f-46cd-95a8-2f3ecba8e852",
                  "text" : "Cognition, fine motor and self care",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "6 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not reaching for and holding (grasping) toys"
                    },
                    {
                      "valueString" : "Hands frequently clenched"
                    },
                    {
                      "valueString" : "Does not explore objects with hand and mouth"
                    },
                    {
                      "valueString" : "Does not bring hands together at midline"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "785ec313-7b25-4d0d-9421-382981286cbc",
                  "text" : "Cognition, fine motor and self care",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "9 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Does not hold objects"
                    },
                    {
                      "valueString" : "Does not 'give' objects on request"
                    },
                    {
                      "valueString" : "Cannot move toy from one hand to another"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "2c2b263e-41a5-4dae-94e1-814f5bfca20a",
                  "text" : "Cognition, fine motor and self care",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "12 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Does not feed self finger foods or hold own bottle/cup"
                    },
                    {
                      "valueString" : "Unable to pick up small items using index finger and thumb"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "d6d7d675-0fee-466d-85e8-5dae46adac40",
                  "text" : "Cognition, fine motor and self care",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "18 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Does not scribble with a crayon"
                    },
                    {
                      "valueString" : "Does not attempt to stack blocks after demonstration"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "c48e4138-0952-49a7-9c77-14b3e6d1dad3",
                  "text" : "Cognition, fine motor and self care",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "2 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Does not attempt to feed self using a spoon and/or help with dressing"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "433e768c-8458-476a-8330-3f59a4aa94b4",
                  "text" : "Cognition, fine motor and self care",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "3 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Does not attempt everyday care skills (such as feeding or dressing)"
                    },
                    {
                      "valueString" : "Difficulty in manipulating small objects (e.g. threading beads)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "06d96181-2b2d-48de-b80f-bd5ccb2fb3c1",
                  "text" : "Cognition, fine motor and self care",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "4 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not toilet trained by day"
                    },
                    {
                      "valueString" : "Not able to draw lines and circles"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "e08345d3-a919-4bf0-8775-5df84a173832",
                  "text" : "Cognition, fine motor and self care",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "5 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Concerns from teacher about school readiness"
                    },
                    {
                      "valueString" : "Not independently able to complete everyday routines such as feeding and dressing"
                    },
                    {
                      "valueString" : "Cannot draw simple pictures (e.g. stick person)"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "7f3861fd-b9f0-489d-8a39-5fdd18eeaf0e",
                  "text" : "Gross motor",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "6 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not holding head and shoulders up with good control when lying on tummy"
                    },
                    {
                      "valueString" : "Not holding head with good control in supported sitting"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "68809920-fbf4-48e5-89f7-c0b49a8b8f78",
                  "text" : "Gross motor",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "9 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not rolling"
                    },
                    {
                      "valueString" : "Not sitting independently/ without support"
                    },
                    {
                      "valueString" : "Not moving (eg creeping, crawling)"
                    },
                    {
                      "valueString" : "Not taking weight on legs when held in standing"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "5cf7c9bc-b3ec-43ac-8de8-65078f57a82b",
                  "text" : "Gross motor",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "12 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "No form of independent mobility (e.g. crawling, commando crawling, bottom shuffle)"
                    },
                    {
                      "valueString" : "Not pulling to stand independently and holding on for support"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "a1137862-767c-49fb-883b-92bee7588edc",
                  "text" : "Gross motor",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "18 months"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not standing independently"
                    },
                    {
                      "valueString" : "Not attempting to walk without support"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "dd83d558-6a7f-4b94-b677-7c2b31ccc52f",
                  "text" : "Gross motor",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "2 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not able to walk independently"
                    },
                    {
                      "valueString" : "Not able to walk up and down stairs holding on"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "5ea4460c-a4c5-4025-bf85-64884a66458f",
                  "text" : "Gross motor",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "3 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not able to walk up and down stairs independently"
                    },
                    {
                      "valueString" : "Not able to run or jump"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "75b597b4-3b38-4efd-aeb2-ab1551d83c3c",
                  "text" : "Gross motor",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "4 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not able to walk, run, climb, jump and uses stairs confidently"
                    },
                    {
                      "valueString" : "Cannot catch, throw or kick a ball"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "f23ac52c-2064-4032-b283-6ce09fc306fa",
                  "text" : "Gross motor",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "0b520b20-98df-4024-b25d-2986f6b96e77",
                      "operator" : "=",
                      "answerString" : "5 years"
                    }
                  ],
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Not able to walk, run, climb, jump and use stairs confidently"
                    },
                    {
                      "valueString" : "Not able to hop five times on one leg and stand on one leg for five seconds"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "758d4109-363a-48c9-95f3-8a8d8b1b32ec",
                  "text" : "Red flags at any age",
                  "type" : "choice",
                  "repeats" : true,
                  "answerOption" : [
                    {
                      "valueString" : "Strong parental concerns"
                    },
                    {
                      "valueString" : "Significant loss of skills"
                    },
                    {
                      "valueString" : "Lack of response to sound or visual stimuli"
                    },
                    {
                      "valueString" : "Poor interaction with adults or other children"
                    },
                    {
                      "valueString" : "Lack of, or limited eye contact"
                    },
                    {
                      "valueString" : "Differences between right and left sides of body in strength, movement or tone"
                    },
                    {
                      "valueString" : "Marked low tone (floppy) or high tone (stiff and tense) and significantly impacting on development and functional motor skills"
                    }
                  ]
                }
              ]
            },
            {
              "linkId" : "redflags-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-22",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age >= 12"
              }
            }
          ],
          "linkId" : "14a9fb5f-5b0e-4862-b143-08a11cd3ebf0",
          "text" : "Substance use, including tobacco",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-29').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-29').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-29",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-29').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-29",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-29').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-29",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "substanceuse-smoking",
              "text" : "Smoking",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "grid"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "substanceuse-smoking-smokingstatus",
                  "text" : "Smoking status",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                        "valueBoolean" : true
                      }
                    ]
                  },
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "substanceuse-smoking-smokingstatus-group",
                      "text" : "Smoking status",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "linkId" : "substanceuse-smoking-smokingstatus-group-laststatus",
                          "text" : "Last status",
                          "_text" : {
                            "extension" : [
                              {
                                "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                                "valueExpression" : {
                                  "language" : "text/fhirpath",
                                  "expression" : "iif(%ObsTobaccoSmokingStatusValue.exists() and %ObsTobaccoSmokingStatusDateFormatted.exists(), %ObsTobaccoSmokingStatusValue.display + ' ( ' + %ObsTobaccoSmokingStatusDateFormatted + ' )', 'Not available')"
                                }
                              }
                            ]
                          },
                          "type" : "display"
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsTobaccoSmokingStatusValue"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                              "valueBoolean" : true
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "drop-down"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "substanceuse-smoking-smokingstatus-group-laststatusvalue",
                          "type" : "choice",
                          "repeats" : false,
                          "answerValueSet" : "#TobaccoUseStatus-1"
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsTobaccoSmokingStatusLatest.effective.toDate()"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                              "valueBoolean" : true
                            }
                          ],
                          "linkId" : "substanceuse-smoking-smokingstatus-group-laststatusdate",
                          "type" : "date",
                          "repeats" : false
                        },
                        {
                          "extension" : [
                            {
                              "extension" : [
                                {
                                  "url" : "template",
                                  "valueReference" : {
                                    "reference" : "#SmokingStatusTemplate"
                                  }
                                }
                              ],
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "drop-down"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "b639a3a8-f476-4cc8-b5c7-f5d2abb23511",
                          "text" : "New status",
                          "type" : "choice",
                          "repeats" : false,
                          "answerValueSet" : "#TobaccoUseStatus-1"
                        },
                        {
                          "linkId" : "substanceuse-smoking-smokingstatus-group-newdate",
                          "text" : "New date",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "96dc7c22-d003-459c-8a56-f6cd182fc077",
                  "text" : "Quit status",
                  "type" : "choice",
                  "enableWhen" : [
                    {
                      "question" : "b639a3a8-f476-4cc8-b5c7-f5d2abb23511",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "8517006"
                      }
                    }
                  ],
                  "repeats" : false,
                  "answerValueSet" : "#SmokingQuitStatus-1"
                },
                {
                  "linkId" : "9e86387d-1be4-4c26-9047-9dd6b03e1ee0",
                  "text" : "How many?",
                  "type" : "string",
                  "enableWhen" : [
                    {
                      "question" : "b639a3a8-f476-4cc8-b5c7-f5d2abb23511",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "77176002"
                      }
                    },
                    {
                      "question" : "b639a3a8-f476-4cc8-b5c7-f5d2abb23511",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "8517006"
                      }
                    },
                    {
                      "question" : "b639a3a8-f476-4cc8-b5c7-f5d2abb23511",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "394872000"
                      }
                    }
                  ],
                  "enableBehavior" : "any",
                  "repeats" : false
                },
                {
                  "linkId" : "32e71641-f660-4ca2-af99-dff8917f07be",
                  "text" : "How long as a smoker?",
                  "type" : "string",
                  "enableWhen" : [
                    {
                      "question" : "b639a3a8-f476-4cc8-b5c7-f5d2abb23511",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "77176002"
                      }
                    },
                    {
                      "question" : "b639a3a8-f476-4cc8-b5c7-f5d2abb23511",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "8517006"
                      }
                    },
                    {
                      "question" : "b639a3a8-f476-4cc8-b5c7-f5d2abb23511",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://snomed.info/sct",
                        "code" : "394872000"
                      }
                    }
                  ],
                  "enableBehavior" : "any"
                }
              ]
            },
            {
              "linkId" : "34feaee8-8088-43ee-991d-9729990b5550",
              "text" : "Alcohol and other substance use",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                      "valueString" : "Quantity and frequency of substance use"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                      "valueString" : "Details"
                    }
                  ],
                  "linkId" : "ea73d52c-f831-46be-a45d-2c42250a5210",
                  "text" : "Quantity and frequency of: alcohol; caffeine (coffee, soft drinks, iced coffee); cannabis/yarndi/gunja; other substance use: IVDU, methamphetamine, opiates, solvents, other",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                        "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n        <div>Quantity and frequency of:</div>\r\n        <ul>\r\n          <li>alcohol</li>\r\n          <li>caffeine (coffee, soft drinks, iced coffee)</li>\r\n          <li>cannabis/yarndi/gunja</li>\r\n          <li>other substance use: IVDU, methamphetamine, opiates, solvents, other</li>\r\n        </ul>\r\n\t      </div>"
                      }
                    ]
                  },
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "f8e1cc1f-f1a1-4eb3-8255-77d600f52831",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "substanceuse-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-29",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age > 12"
              }
            }
          ],
          "linkId" : "a7bb0dd2-4b2d-49c2-9da6-3cb0a4dd9240",
          "text" : "Gambling",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-10').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-10').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-10",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-10').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-10",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-10').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-10",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "fb489c43-f311-41f5-9d6a-1b61748e165f",
              "text" : "Gambling issues",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "a233c01e-a72e-474b-9a26-bab1504491fa",
                  "text" : "Have you or someone close to you ever had issues with gambling?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "d1b68cfc-77cf-464e-83ce-0e8517bed9f3",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "a233c01e-a72e-474b-9a26-bab1504491fa",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "2ab74c97-55d9-4fd9-968f-8962d62ea573",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "gambling-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-10",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "(%age > 12) and (%age <= 24)"
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
              "valueString" : "Sexual health"
            }
          ],
          "linkId" : "4b49c291-6e93-4b7e-be3b-15ef8bc207ad",
          "text" : "Sexual health (sexual activity, contraception, safe sex/protection, sexual orientation, gender identity, pressure to have sex, STIs)",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-25').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-25').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-25",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-25').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-25",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-25').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-25",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "e5aeda89-b820-4bb3-8fbd-d4f662207b7d",
              "text" : "Puberty and sexual health concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "1d20138a-caf3-4c43-9693-04c08d37a84a",
                  "text" : "Is there anything that you are worried about in relation to puberty/your sexual health?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNotAskedDeclined"
                },
                {
                  "linkId" : "d7b92cad-4aa8-47d3-975c-92563f132325",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "1d20138a-caf3-4c43-9693-04c08d37a84a",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Consider discussing items relevant to age/sex/gender"
                }
              ],
              "linkId" : "0fba3972-faa3-4f40-940c-c2f1c9b55329",
              "text" : "Consider discussing as relevant to age/sex/gender: menstruation (including risk of anaemia); current sexual activity; contraception; safe sex practice (eg use of condoms); sexually transmitted infection symptoms and screening; blood-borne virus screening",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n      <div>Consider discussing as relevant to age/sex/gender:</div>\r\n      <ul>\r\n        <li>menstruation (including risk of anaemia)</li>\r\n        <li>current sexual activity</li>\r\n        <li>contraception</li>\r\n        <li>safe sex practice (eg use of condoms)</li>\r\n        <li>sexually transmitted infection symptoms and screening</li>\r\n        <li>blood-borne virus screening</li>\r\n      </ul>\r\n      </div>"
                  }
                ]
              },
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "b41572ba-cf36-4cec-addf-cb0b47fea63f",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "sexualhealth-adolescents-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-25",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "(%age > 24) and (%age <= 49)"
              }
            }
          ],
          "linkId" : "589b53a4-ceb2-41c0-850a-69438f9fd1cc",
          "text" : "Genitourinary and sexual health",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-35').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-35').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-35",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-35').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-35",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-35').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-35",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "5f5d4886-ce06-47fa-a4d8-f6808b9081c0",
              "text" : "Sexual health concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "e56e79e5-8fbb-43f0-b2a3-018b55750bd0",
                  "text" : "Is there anything that you are worried about in relation to your sexual health?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNotAskedDeclined"
                },
                {
                  "linkId" : "5148c6c6-c99f-480d-bb05-569064ba7118",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "e56e79e5-8fbb-43f0-b2a3-018b55750bd0",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "d844a31e-8e51-420b-855c-4f485a180a57",
              "text" : "Cervical screening",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "check-box"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "37dbd343-6d02-477c-89bf-59ba022efbb7",
                  "text" : "Cervical screening status",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#CervicalScreeningStatus-1"
                },
                {
                  "linkId" : "f93eb998-1502-4d8a-88a4-986117a387c5",
                  "text" : "Next due",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "linkId" : "862fc298-5b5e-4a46-badc-900c6ba1ff50",
                  "text" : "Details",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Consider discussing items relevant to age/sex/gender"
                }
              ],
              "linkId" : "39b02169-ea34-4af9-aa35-1c47f7f39333",
              "text" : "Consider discussing as relevant to age/sex/gender: contraception; menstruation; sexually transmitted infection symptoms and screening; blood-borne virus screening; continence; menopause; erectile dysfunction",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n      <div>Consider discussing as relevant to age/sex/gender:</div>\r\n      <ul>\r\n        <li>contraception</li>\r\n        <li>menstruation</li>\r\n        <li>sexually transmitted infection symptoms and screening</li>\r\n        <li>blood-borne virus screening</li>\r\n        <li>continence</li>\r\n        <li>menopause</li>\r\n        <li>erectile dysfunction</li>\r\n      </ul>\r\n      </div>"
                  }
                ]
              },
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "efd0735c-c379-471f-83bb-93b0392093aa",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "sexualhealth-adults-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-35",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age >= 50"
              }
            }
          ],
          "linkId" : "02048954-e9d7-424e-8c7b-6a3c495d7ce4",
          "text" : "Genitourinary and sexual health",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-36').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-36').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-36",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-36').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-36",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-36').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-36",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "8172aaac-81c4-4b06-b4cd-6a891a227e9f",
              "text" : "Sexual health concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "1c40a720-bdb7-4386-a9f6-be82b7349bf7",
                  "text" : "Consider asking when appropriate: Is there anything that you are worried about in relation to your sexual health?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNoNotAskedDeclined"
                },
                {
                  "linkId" : "f93fe768-9215-4a15-9376-686e9530ea79",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "1c40a720-bdb7-4386-a9f6-be82b7349bf7",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "2e1ea1cc-1f74-4b2e-bfda-f6a1d41e1e50",
              "text" : "Continence issues",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "64fd0f79-7e09-4934-905d-9bff6715f9ba",
                  "text" : "Do you have problems with urine leaking?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "4fc14fd9-4c7e-48ec-90c0-c406523400fa",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "64fd0f79-7e09-4934-905d-9bff6715f9ba",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Consider discussing items relevant to age/sex/gender"
                }
              ],
              "linkId" : "8d75d1f1-290b-41fc-8e32-ad0681c650bb",
              "text" : "Consider discussing as relevant to age/sex/gender: menopause; erectile dysfunction; prostatic symptoms",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n      <div>Consider discussing as relevant to age/sex/gender:</div>\r\n      <ul>\r\n        <li>menopause</li>\r\n        <li>erectile dysfunction</li>\r\n        <li>prostatic symptoms</li>\r\n      </ul>\r\n\t    </div>"
                  }
                ]
              },
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "e9936322-e6fe-4cf7-ab61-22846a8fbb95",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "sexualhealth-olderpeople-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-36",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "961da481-1698-4a1d-962b-a9c2185e335a",
          "text" : "Eye health",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-8').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-8').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-8",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-8').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-8",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-8').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-8",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "0e30de87-8d5a-4b7a-893a-f1791c4f31c5",
              "text" : "Vision concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age <= 12"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "bc49ee24-62a8-4252-a5ee-9c68bfed601c",
                  "text" : "Is there anything that you are worried about with your child's vision?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age > 12"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "6286346d-c805-4519-8e82-bf364a215c58",
                  "text" : "Is there anything that you are worried about with your vision?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "468770e4-af95-4377-8af5-280deb585e01",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "bc49ee24-62a8-4252-a5ee-9c68bfed601c",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    },
                    {
                      "question" : "6286346d-c805-4519-8e82-bf364a215c58",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "enableBehavior" : "any",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "grid"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "25d3e4b6-8c71-4c17-8f5a-aca90e232ed2",
              "text" : "Eye examination",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age < 1"
                      }
                    }
                  ],
                  "linkId" : "cb1b9349-2dd1-4bdd-904b-a529458e3b98",
                  "text" : "Red reflex (up to six months)",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "47ce0b44-ac12-4a1d-8657-2cc741a29d3a",
                      "text" : "Left eye",
                      "type" : "string",
                      "repeats" : false
                    },
                    {
                      "linkId" : "3f192141-0845-44d6-85ad-94f0295e062f",
                      "text" : "Right eye",
                      "type" : "string",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age <= 12"
                      }
                    }
                  ],
                  "linkId" : "3ff41163-549f-4834-8817-151144613988",
                  "text" : "Evidence of squint or other abnormality",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "83e65791-a04a-42e4-b3f2-1e552b8e8044",
                      "text" : "Left eye",
                      "type" : "string",
                      "repeats" : false
                    },
                    {
                      "linkId" : "2dd18bad-9491-436f-a2db-a4ed6022ac5c",
                      "text" : "Right eye",
                      "type" : "string",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age >= 3"
                      }
                    }
                  ],
                  "linkId" : "2c0e12a5-2650-4886-8f50-405dc0ead9c5",
                  "text" : "Visual acuity",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "43825f29-c720-40a5-9fd1-de50ee35479c",
                      "text" : "Left eye",
                      "type" : "string",
                      "repeats" : false
                    },
                    {
                      "linkId" : "e98428b4-bc8d-4272-a803-757a84813c3c",
                      "text" : "Right eye",
                      "type" : "string",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age >= 25"
                      }
                    }
                  ],
                  "linkId" : "bac129ef-a5c0-4d94-915c-ceadc6016594",
                  "text" : "Trachoma Check (endemic areas)",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "check-box"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "202b5b91-541e-4a72-b1f6-1d474b59b7a3",
                      "text" : "Left eye",
                      "type" : "choice",
                      "repeats" : false,
                      "answerOption" : [
                        {
                          "valueCoding" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "60332004",
                            "display" : "Trichiasis"
                          }
                        },
                        {
                          "valueCoding" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "95726001",
                            "display" : "Corneal scar"
                          }
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "check-box"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "6ae69487-345e-46a0-a8db-b1356671ee59",
                      "text" : "Right eye",
                      "type" : "choice",
                      "repeats" : false,
                      "answerOption" : [
                        {
                          "valueCoding" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "60332004",
                            "display" : "Trichiasis"
                          }
                        },
                        {
                          "valueCoding" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "95726001",
                            "display" : "Corneal scar"
                          }
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "linkId" : "8dcdc04c-7655-4b47-88eb-8425f0cdc0d0",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "eyehealth-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-8",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "de71bbd0-178c-4974-9c75-55d5a48c66f7",
          "text" : "Ear health and hearing",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-6').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-6').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-6",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-6').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-6",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-6').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-6",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "f3473e82-4336-4858-96de-3a61eff5abfb",
              "text" : "Child listening concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "f982c374-f023-4e68-8968-1f1f5d3969ae",
                  "text" : "Is there anything that you are worried about with your child's listening?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "297114f4-8c3f-4916-b840-c38ea14d37b1",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "f982c374-f023-4e68-8968-1f1f5d3969ae",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "d2a3a346-7b20-4634-beb4-f2bdc7252fe5",
              "text" : "Child language concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "06c150f8-4d54-4d10-aeff-2ef7567b6812",
                  "text" : "Is there anything you are worried about with your child's language/talking?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "30dc1581-f6b7-49f0-be09-3902178a495f",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "06c150f8-4d54-4d10-aeff-2ef7567b6812",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "6662bc91-fd05-4ea0-a96b-1cc124a9769a",
              "text" : "Child snoring",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "b326271b-e9b1-45a0-b899-125364833702",
                  "text" : "Do you notice snoring/noisy breathing at night/while your child is sleeping?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "36a3967c-e79a-49a7-8022-ac9561c4e656",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "b326271b-e9b1-45a0-b899-125364833702",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                }
              ],
              "linkId" : "ec7b6e93-e1f0-41f5-b2c2-43c7ddff8aed",
              "text" : "Hearing concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "3e53edc7-c90e-4681-a006-b7a05b91a02c",
                  "text" : "Is there anything that you are worried about with your hearing?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "d72dacb8-a9b3-483b-ae24-8b062873b2cb",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "3e53edc7-c90e-4681-a006-b7a05b91a02c",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "11aa62ca-5a52-428b-952b-cfbcd2c75824",
              "text" : "Last hearing test (audiology)",
              "type" : "date",
              "repeats" : false
            },
            {
              "linkId" : "31452c47-30b2-4590-95f4-b2b75aad2fb6",
              "text" : "Ear examination",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "44c3434d-ea52-43bd-b635-34184e5f037d",
                  "text" : "Otoscopy",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-display-category",
                                "code" : "instructions"
                              }
                            ]
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%age <= 12"
                          }
                        }
                      ],
                      "linkId" : "fe96046a-a202-4c22-ad3e-00419e717185",
                      "text" : "Video otoscopy procedure recommended where possible as it allows for parental education and for images to be saved for tracking over time.",
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%age <= 12"
                          }
                        }
                      ],
                      "linkId" : "2841915f-c8d2-4edb-8bc7-39b63385a2fb",
                      "text" : "Otoscopy findings",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "check-box"
                                  }
                                ]
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                              "valueString" : "Other, please specify"
                            }
                          ],
                          "linkId" : "dedfc83e-7451-404d-bd24-97b1254304eb",
                          "text" : "Left ear",
                          "type" : "open-choice",
                          "repeats" : true,
                          "answerOption" : [
                            {
                              "valueString" : "Clear and intact"
                            },
                            {
                              "valueString" : "Dull and intact"
                            },
                            {
                              "valueString" : "Discharge"
                            },
                            {
                              "valueString" : "Retracted"
                            },
                            {
                              "valueString" : "Unable to view eardrum"
                            },
                            {
                              "valueString" : "Wax"
                            },
                            {
                              "valueString" : "Grommet in canal"
                            },
                            {
                              "valueString" : "Grommet in eardrum"
                            },
                            {
                              "valueString" : "Perforation"
                            },
                            {
                              "valueString" : "Red/bulging"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "check-box"
                                  }
                                ]
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                              "valueString" : "Other, please specify"
                            }
                          ],
                          "linkId" : "23daa784-4476-447f-8aa2-42933b4490d9",
                          "text" : "Right ear",
                          "type" : "open-choice",
                          "repeats" : true,
                          "answerOption" : [
                            {
                              "valueString" : "Clear and intact"
                            },
                            {
                              "valueString" : "Dull and intact"
                            },
                            {
                              "valueString" : "Discharge"
                            },
                            {
                              "valueString" : "Retracted"
                            },
                            {
                              "valueString" : "Unable to view eardrum"
                            },
                            {
                              "valueString" : "Wax"
                            },
                            {
                              "valueString" : "Grommet in canal"
                            },
                            {
                              "valueString" : "Grommet in eardrum"
                            },
                            {
                              "valueString" : "Perforation"
                            },
                            {
                              "valueString" : "Red/bulging"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%age > 12"
                          }
                        }
                      ],
                      "linkId" : "361b3c80-375b-423e-bb61-5732826bc2f0",
                      "text" : "Otoscopy findings",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "check-box"
                                  }
                                ]
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                              "valueString" : "Other, please specify"
                            }
                          ],
                          "linkId" : "079df9c5-234c-4129-8769-800dab47a59a",
                          "text" : "Left ear",
                          "type" : "open-choice",
                          "repeats" : true,
                          "answerOption" : [
                            {
                              "valueString" : "Clear and intact"
                            },
                            {
                              "valueString" : "Dull and intact"
                            },
                            {
                              "valueString" : "Discharge"
                            },
                            {
                              "valueString" : "Retracted"
                            },
                            {
                              "valueString" : "Unable to view eardrum"
                            },
                            {
                              "valueString" : "Wax"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "check-box"
                                  }
                                ]
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                              "valueString" : "Other, please specify"
                            }
                          ],
                          "linkId" : "ce1fc869-a412-4aea-aa53-36e794a14519",
                          "text" : "Right ear",
                          "type" : "open-choice",
                          "repeats" : true,
                          "answerOption" : [
                            {
                              "valueString" : "Clear and intact"
                            },
                            {
                              "valueString" : "Dull and intact"
                            },
                            {
                              "valueString" : "Discharge"
                            },
                            {
                              "valueString" : "Retracted"
                            },
                            {
                              "valueString" : "Unable to view eardrum"
                            },
                            {
                              "valueString" : "Wax"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "(%age > 5) and (%age <= 12)"
                      }
                    }
                  ],
                  "linkId" : "972afa06-9649-43d9-b8ce-c802f7f27e39",
                  "text" : "Tympanometry",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "a0d1413f-31e5-4b29-a00b-235f50f91cf7",
                      "text" : "Left ear",
                      "type" : "text",
                      "repeats" : false
                    },
                    {
                      "linkId" : "6423348a-943f-41e5-b4f2-ef5a34e56414",
                      "text" : "Right ear",
                      "type" : "text",
                      "repeats" : false
                    }
                  ]
                }
              ]
            },
            {
              "linkId" : "ac87b23a-b022-4d62-9e82-1c56583bca34",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "earhealthandhearing-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-6",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "bde9ab00-a20f-4a7c-9266-11f53f60c65f",
          "text" : "Oral and dental health",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-20').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-20').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-20",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-20').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-20",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-20').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-20",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "70714d58-d936-4170-9763-82398f84a7a7",
              "text" : "Dental concerns",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age <= 12"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "e4cf4f15-7eed-4aa1-9f9d-61ccd659685c",
                  "text" : "Is there anything that you are worried about with your child's teeth or mouth?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age > 12"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "cb287506-9a64-4ee8-8f24-ba7cb77756f3",
                  "text" : "Is there anything that you are worried about with your teeth?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "cf949305-5ff7-4767-b946-7a50efd21cfc",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "e4cf4f15-7eed-4aa1-9f9d-61ccd659685c",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    },
                    {
                      "question" : "cb287506-9a64-4ee8-8f24-ba7cb77756f3",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "enableBehavior" : "any",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "1f362cb2-911f-448b-b717-2614f1aced86",
              "text" : "Last dental checkup",
              "type" : "date",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "ffe81bde-608f-4e3f-98ae-39d0b9884dcc",
              "text" : "Dentures?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNo"
            },
            {
              "linkId" : "5a3a56c6-b953-4d96-894d-95e07268473f",
              "text" : "Teeth and mouth check",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "6247ab4c-41cb-4e77-b028-c9c2a8c7da91",
                  "text" : "Examination findings",
                  "type" : "text",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                      "valueString" : "Details"
                    }
                  ],
                  "linkId" : "79e09f4d-dac6-4088-baa0-d95dc658fb0b",
                  "text" : "Document conversation about oral health and care of teeth",
                  "type" : "text",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "875574fa-9769-42ca-8381-9e80c3e5233d",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "oraldental-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-20",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 24"
              }
            }
          ],
          "linkId" : "7d4772cb-a1cd-49d9-853f-883ccd8343a6",
          "text" : "Skin",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-26').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-26').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-26",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-26').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-26",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-26').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-26",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "0d23be6b-3a30-4a80-9ebe-158acf32eb09",
              "text" : "Skin problems",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age <= 12"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "829de3f8-eea9-4139-8a18-47c16182ac9e",
                  "text" : "Does your child have any skin problems?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age > 12"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                      "valueCode" : "horizontal"
                    }
                  ],
                  "linkId" : "353f528b-3518-4fb3-a0bd-3ed5ae6b036a",
                  "text" : "Is there anything that you are worried about with your skin?",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#YesNo"
                },
                {
                  "linkId" : "b9332f4f-ed6c-4e87-a467-13d7e83bd550",
                  "text" : "Details",
                  "type" : "text",
                  "enableWhen" : [
                    {
                      "question" : "829de3f8-eea9-4139-8a18-47c16182ac9e",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    },
                    {
                      "question" : "353f528b-3518-4fb3-a0bd-3ed5ae6b036a",
                      "operator" : "=",
                      "answerCoding" : {
                        "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                        "code" : "Y"
                      }
                    }
                  ],
                  "enableBehavior" : "any",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "80e4349f-6d89-4017-8632-9a947e50e947",
              "text" : "Do you use sun protection?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNo"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/entryFormat",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "206f4e35-3b87-4252-97fc-c78bf9fb6f5d",
              "text" : "Document conversation about sun protection as appropriate (ie sunscreen, hats, shade).",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "7cec4c99-90da-40bc-86a6-f77abb093933",
              "text" : "General skin examination findings",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "88d23fa4-df88-43ab-a1d0-69315d55c3bf",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "skin-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-26",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "205677d6-17c7-4285-a7c4-61aa02b6c816",
          "text" : "Immunisation",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-13').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-13').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-13",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-13').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-13",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-13').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-13",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "54de7714-b917-4426-acb4-29d48648a2d8",
              "text" : "Check Child Health Record/Book and Australian Immunisation Register",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <p><em>Check Child Health Record/Book and Australian Immunisation Register</em></p>\r\n    </div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                }
              ],
              "linkId" : "d77c527d-6fde-4ed7-97b9-c71acf817f39",
              "text" : "Eligibility for funded vaccines may vary across jurisdictions",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <p><em>Eligibility for funded vaccines may vary across jurisdictions</em></p>\r\n    </div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age > 12) and (%age <= 24)"
                  }
                }
              ],
              "linkId" : "77d87581-d4d7-4267-9f3c-ad6541ad0f46",
              "text" : "Check Australian Immunisation Register",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <p><em>Check Australian Immunisation Register</em></p>\r\n    </div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age > 24) and (%age <= 49)"
                  }
                }
              ],
              "linkId" : "a2631d2c-2b5c-4147-9aca-05ae655a56a5",
              "text" : "Check recommended primary vaccinations completed and provide catch-up if required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">\r\n    <p><em>Check recommended primary vaccinations completed and provide catch-up if required</em></p>\r\n    </div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "gtable"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext",
                  "valueExpression" : {
                    "name" : "ImmunizationRepeat",
                    "language" : "text/fhirpath",
                    "expression" : "%Immunization.entry.resource"
                  }
                }
              ],
              "linkId" : "vaccinesprevious",
              "text" : "Vaccines previously given",
              "type" : "group",
              "repeats" : true,
              "readOnly" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "autocomplete"
                          }
                        ]
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ImmunizationRepeat.vaccineCode.select((coding.where(system='http://snomed.info/sct') | coding.where(system!='http://snomed.info/sct').first() | text ).first())"
                      }
                    }
                  ],
                  "linkId" : "vaccinesprevious-vaccine",
                  "text" : "Vaccine",
                  "type" : "open-choice",
                  "answerValueSet" : "#amt-vaccine-1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ImmunizationRepeat.lotNumber"
                      }
                    }
                  ],
                  "linkId" : "vaccinesprevious-batch",
                  "text" : "Batch number",
                  "type" : "string"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ImmunizationRepeat.occurrence.ofType(dateTime).toDate()"
                      }
                    }
                  ],
                  "linkId" : "vaccinesprevious-date",
                  "text" : "Administration date",
                  "type" : "date"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ImmunizationRepeat.note.text.first()"
                      }
                    }
                  ],
                  "linkId" : "vaccinesprevious-comment",
                  "text" : "Comment",
                  "type" : "string"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "vaccinesair",
              "text" : "Immunisations are up to date?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNo"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "autocomplete"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "vaccinesdue",
              "text" : "Immunisations due",
              "type" : "open-choice",
              "repeats" : true,
              "answerValueSet" : "#amt-vaccine-1"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "gtable"
                      }
                    ]
                  }
                },
                {
                  "extension" : [
                    {
                      "url" : "template",
                      "valueReference" : {
                        "reference" : "#ImmunizationTemplate"
                      }
                    }
                  ],
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                }
              ],
              "linkId" : "vaccinestoday",
              "text" : "Vaccines given today",
              "type" : "group",
              "repeats" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "autocomplete"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "vaccinestoday-vaccine",
                  "text" : "Vaccine",
                  "type" : "open-choice",
                  "answerValueSet" : "#amt-vaccine-1"
                },
                {
                  "linkId" : "vaccinestoday-batch",
                  "text" : "Batch number",
                  "type" : "string"
                },
                {
                  "linkId" : "vaccinestoday-date",
                  "text" : "Administration date",
                  "type" : "date"
                },
                {
                  "linkId" : "vaccinestoday-comment",
                  "text" : "Comment",
                  "type" : "string"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "vaccinesrecorded",
              "text" : "Have all vaccines been recorded on the Australian Immunisation Register?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNo"
            },
            {
              "linkId" : "bcd1c9f2-889e-41e5-8c2b-a70221c5cec5",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "immunisation-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-13",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "c587e3b6-b91a-40dc-9a16-179342d001e9",
          "text" : "Examination",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-7').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-7').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-7",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-7').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-7",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-7').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-7",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "d15824f8-eafc-4fa0-80a2-82f0ec7f8728",
              "text" : "Growth measures recorded on Centers for Disease Control and Prevention (CDC) and World Health Organization (WHO) growth charts for centile and tracking overtime",
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "grid"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "53d5d5a6-3198-4bec-92ac-03fe7d77fb68",
              "text" : "The tabled observations will display the most recent results available from the patient record. New observations may be added.",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p style=\"font-size:0.9em; font-weight:normal\"><em>The tabled observations will display the most recent results available from the patient record. New observations may be added.</em></p></div>"
                  }
                ]
              },
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age <= 5"
                      }
                    }
                  ],
                  "linkId" : "4e32e9b2-82e6-41ea-9545-79e928f7d6c2",
                  "text" : "Length/Height",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "837cd0ce-4a9e-4c8b-8679-007ed961f121",
                      "text" : "Last result",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                            "valueExpression" : {
                              "language" : "text/fhirpath",
                              "expression" : "iif(%ObsBodyHeightValue.exists() and %ObsBodyHeightDateFormatted.exists(), %ObsBodyHeightValue.round(0).toString() + ' cm ( ' + %ObsBodyHeightDateFormatted + ' )', 'Not available')"
                            }
                          },
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                            "valueString" : "text-align: left;"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsBodyHeightValue"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "cm"
                          }
                        }
                      ],
                      "linkId" : "obs-lengthheight-lastresult",
                      "type" : "decimal",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsBodyHeightLatest.effective.toDate()"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "obs-lengthheight-lastdate",
                      "type" : "date",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "template",
                              "valueReference" : {
                                "reference" : "#BodyHeightLengthTemplate"
                              }
                            }
                          ],
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "cm"
                          }
                        }
                      ],
                      "linkId" : "obs-lengthheight-newresult",
                      "text" : "New result",
                      "type" : "decimal",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "obslengthheight-newresult-unit",
                          "text" : "cm",
                          "type" : "display"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "iif(%resource.repeat(item).where(linkId='obs-lengthheight-newresult').answer.value.exists(), today())"
                          }
                        }
                      ],
                      "linkId" : "obs-lengthheight-newdate",
                      "text" : "New result date",
                      "type" : "date",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age > 5"
                      }
                    }
                  ],
                  "linkId" : "6226a5c5-b5c3-4ebb-a689-2b286322cfe0",
                  "text" : "Height",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "7035c7e7-ada3-4c6b-9ea8-f39666f5d4ea",
                      "text" : "Last result",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                            "valueExpression" : {
                              "language" : "text/fhirpath",
                              "expression" : "iif(%ObsBodyHeightValue.exists() and %ObsBodyHeightDateFormatted.exists(), %ObsBodyHeightValue.round(0).toString() + ' cm ( ' + %ObsBodyHeightDateFormatted + ' )', 'Not available')"
                            }
                          },
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                            "valueString" : "text-align: left;"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsBodyHeightValue"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "cm"
                          }
                        }
                      ],
                      "linkId" : "obs-height-lastresult",
                      "type" : "decimal",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsBodyHeightLatest.effective.toDate()"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "obs-height-lastdate",
                      "type" : "date",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "template",
                              "valueReference" : {
                                "reference" : "#BodyHeightTemplate"
                              }
                            }
                          ],
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "cm"
                          }
                        }
                      ],
                      "linkId" : "obs-height-newresult",
                      "text" : "New result",
                      "type" : "decimal",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "obs-height-newresult-unit",
                          "text" : "cm",
                          "type" : "display"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "iif(%resource.repeat(item).where(linkId='obs-height-newresult').answer.value.exists(), today())"
                          }
                        }
                      ],
                      "linkId" : "obs-height-newdate",
                      "text" : "New result date",
                      "type" : "date",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "linkId" : "97ed4c86-8820-4e4d-9234-0e0e8b6ca44a",
                  "text" : "Weight",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "443bd584-684a-449c-ab6e-9d07da4df9fa",
                      "text" : "Last result",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                            "valueExpression" : {
                              "language" : "text/fhirpath",
                              "expression" : "iif(%ObsBodyWeightValue.exists() and %ObsBodyWeightDateFormatted.exists(), %ObsBodyWeightValue.round(1).toString() + ' kg ( ' + %ObsBodyWeightDateFormatted + ' )', 'Not available')"
                            }
                          },
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                            "valueString" : "text-align: left;"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsBodyWeightValue"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "kg"
                          }
                        }
                      ],
                      "linkId" : "obs-weight-lastresult",
                      "type" : "decimal",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsBodyWeightLatest.effective.toDate()"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "obs-weight-lastdate",
                      "type" : "date",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "template",
                              "valueReference" : {
                                "reference" : "#BodyWeightTemplate"
                              }
                            }
                          ],
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "kg"
                          }
                        }
                      ],
                      "linkId" : "obs-weight-newresult",
                      "text" : "New result",
                      "type" : "decimal",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "obs-weight-newresult-unit",
                          "text" : "kg",
                          "type" : "display"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "iif(%resource.repeat(item).where(linkId='obs-weight-newresult').answer.value.exists(), today())"
                          }
                        }
                      ],
                      "linkId" : "obs-weight-newdate",
                      "text" : "New result date",
                      "type" : "date",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age > 12"
                      }
                    }
                  ],
                  "linkId" : "bc209c5e-ed28-48e3-b1a1-55cb7e435d8b",
                  "text" : "BMI (calculated)",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "2ada6633-03c6-4b05-bc23-18dec84ec150",
                      "text" : "Last result",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                            "valueExpression" : {
                              "language" : "text/fhirpath",
                              "expression" : "iif(%ObsBodyWeightValue.exists() and %ObsBodyHeightValue.exists(), (%ObsBodyWeightValue/((%ObsBodyHeightValue/100).power(2))).round(1).toString() + ' kg/m2', 'Not available')"
                            }
                          },
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                            "valueString" : "text-align: left;"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "(%ObsBodyWeightValue/((%ObsBodyHeightValue/100).power(2))).round(1)"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "kg/m2"
                          }
                        }
                      ],
                      "linkId" : "obs-bmi-lastresult",
                      "type" : "decimal",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                          "valueExpression" : {
                            "description" : "BMI calculation",
                            "language" : "text/fhirpath",
                            "expression" : "(%weight/((%height/100).power(2))).round(1)"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "kg/m2"
                          }
                        }
                      ],
                      "linkId" : "obs-bmi-newresult",
                      "text" : "New result",
                      "type" : "decimal",
                      "repeats" : false,
                      "readOnly" : true,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "obs-bmi-newresult-unit",
                          "text" : "kg/m2",
                          "type" : "display"
                        }
                      ]
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age <= 12"
                      }
                    }
                  ],
                  "linkId" : "d3557f55-1abf-401c-aada-2d4380151c56",
                  "text" : "Head circumference",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "7a4a6aac-558e-4bec-86c5-326ae07e37d6",
                      "text" : "Last result",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                            "valueExpression" : {
                              "language" : "text/fhirpath",
                              "expression" : "iif(%ObsHeadCircumferenceValue.exists() and %ObsHeadCircumferenceDateFormatted.exists(), %ObsHeadCircumferenceValue.round(0).toString() + ' cm ( ' + %ObsHeadCircumferenceDateFormatted + ' )', 'Not available')"
                            }
                          },
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                            "valueString" : "text-align: left;"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsHeadCircumferenceValue"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "cm"
                          }
                        }
                      ],
                      "linkId" : "obs-headcircumference-lastresult",
                      "type" : "decimal",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsHeadCircumferenceLatest.effective.toDate()"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "obs-headcircumference-lastdate",
                      "type" : "date",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "template",
                              "valueReference" : {
                                "reference" : "#HeadCircumferenceTemplate"
                              }
                            }
                          ],
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "cm"
                          }
                        }
                      ],
                      "linkId" : "obs-headcircumference-newresult",
                      "text" : "New result",
                      "type" : "decimal",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "obs-headcircumference-newresult-unit",
                          "text" : "cm",
                          "type" : "display"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "iif(%resource.repeat(item).where(linkId='obs-headcircumference-newresult').answer.value.exists(), today())"
                          }
                        }
                      ],
                      "linkId" : "obs-headcircumference-newdate",
                      "text" : "New result date",
                      "type" : "date",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%age >= 18"
                      }
                    }
                  ],
                  "linkId" : "ec884b64-ed8d-485b-930f-e7ac18ad4cc9",
                  "text" : "Waist circumference",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "8df0f5d8-821d-4f71-b3c1-d164616ea2f5",
                      "text" : "Last result",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                            "valueExpression" : {
                              "language" : "text/fhirpath",
                              "expression" : "iif(%ObsWaistCircumferenceValue.exists() and %ObsWaistCircumferenceDateFormatted.exists(), %ObsWaistCircumferenceValue.round(0).toString() + ' cm ( ' + %ObsWaistCircumferenceDateFormatted + ' )', 'Not available')"
                            }
                          },
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                            "valueString" : "text-align: left;"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsWaistCircumferenceValue"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "cm"
                          }
                        }
                      ],
                      "linkId" : "obs-waistcircumference-lastresult",
                      "type" : "decimal",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsWaistCircumferenceLatest.effective.toDate()"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "obs-waistcircumference-lastdate",
                      "type" : "date",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "template",
                              "valueReference" : {
                                "reference" : "#WaistCircumferenceTemplate"
                              }
                            }
                          ],
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                        }
                      ],
                      "linkId" : "obs-waistcircumference-newresult",
                      "text" : "New result",
                      "type" : "decimal",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "obs-waistcircumference-newresult-unit",
                          "text" : "cm",
                          "type" : "display"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "iif(%resource.repeat(item).where(linkId='obs-waistcircumference-newresult').answer.value.exists(), today())"
                          }
                        }
                      ],
                      "linkId" : "obs-waistcircumference-newdate",
                      "text" : "New result date",
                      "type" : "date",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "linkId" : "3d3e1079-d225-447b-959b-4caddc057f7d",
                  "text" : "Heart rate",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "49029ef0-eaa8-44f8-b26a-177820c82dfd",
                      "text" : "Last result",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                            "valueExpression" : {
                              "language" : "text/fhirpath",
                              "expression" : "iif(%ObsHeartRateValue.exists() and %ObsHeartRateDateFormatted.exists(), %ObsHeartRateValue.round(0).toString() + ' /min ( ' + %ObsHeartRateDateFormatted + ' )', 'Not available')"
                            }
                          },
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                            "valueString" : "text-align: left;"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsHeartRateValue"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "/min"
                          }
                        }
                      ],
                      "linkId" : "obs-heartrate-lastresult",
                      "type" : "integer",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsHeartRateLatest.effective.toDate()"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "obs-heartrate-lastdate",
                      "type" : "date",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "template",
                              "valueReference" : {
                                "reference" : "#HeartRateTemplate"
                              }
                            }
                          ],
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "/min"
                          }
                        }
                      ],
                      "linkId" : "obs-heartrate-newresult",
                      "text" : "New result",
                      "type" : "integer",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "obs-heartrate-newresult-unit",
                          "text" : "/min",
                          "type" : "display"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "iif(%resource.repeat(item).where(linkId='obs-heartrate-newresult').answer.value.exists(), today())"
                          }
                        }
                      ],
                      "linkId" : "obs-heartrate-newdate",
                      "text" : "New result date",
                      "type" : "date",
                      "repeats" : false
                    }
                  ]
                },
                {
                  "linkId" : "8d3d05cc-64bc-47ae-b989-060bac838d1c",
                  "text" : "Heart rhythm",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "99a8eb6f-a36a-4daf-99d7-27bfde0d4bb1",
                      "text" : "Last result",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                            "valueExpression" : {
                              "language" : "text/fhirpath",
                              "expression" : "iif(%ObsHeartRhythmValue.exists() and %ObsHeartRhythmDateFormatted.exists(), %ObsHeartRhythmValue.display + ' ( ' + %ObsHeartRhythmDateFormatted + ' )', 'Not available')"
                            }
                          },
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                            "valueString" : "text-align: left;"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsHeartRhythmValue"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "obs-heartrhythm-lastresult",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "#heart-rhythm-1"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsHeartRhythmLatest.effective.toDate()"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "obs-heartrhythm-lastdate",
                      "type" : "date",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "template",
                              "valueReference" : {
                                "reference" : "#HeartRhythmTemplate"
                              }
                            }
                          ],
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "radio-button"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "obs-heartrhythm-newresult",
                      "text" : "New result",
                      "type" : "choice",
                      "repeats" : false,
                      "answerValueSet" : "#heart-rhythm-1"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "iif(%resource.repeat(item).where(linkId='obs-heartrhythm-newresult').answer.value.exists(), today())"
                          }
                        }
                      ],
                      "linkId" : "obs-heartrhythm-newdate",
                      "text" : "New result date",
                      "type" : "date",
                      "repeats" : false
                    }
                  ]
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "grid"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "3639c586-9576-48d3-a52b-e91fd2138581",
              "text" : "Blood pressure",
              "_text" : {
                "extension" : [
                  {
                    "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                    "valueBoolean" : true
                  }
                ]
              },
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "705f6d04-acab-4d14-baab-98f9bfc4808e",
                  "text" : "Blood pressure",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "bp-bp-lastresult",
                      "text" : "Last result",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                            "valueExpression" : {
                              "language" : "text/fhirpath",
                              "expression" : "iif(%ObsBloodPressureValue.exists() and %ObsBloodPressureDateFormatted.exists(), %ObsBloodPressureValue + ' mm Hg ( ' + %ObsBloodPressureDateFormatted + ' )', 'Not available')"
                            }
                          },
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                            "valueString" : "text-align: left;"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsBloodPressureLatest.component.where(code.coding.exists(code='8480-6')).value.value.round(0)"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "mm[Hg]"
                          }
                        }
                      ],
                      "linkId" : "bp-lastbp-systolic",
                      "type" : "integer",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsBloodPressureLatest.component.where(code.coding.exists(code='8462-4')).value.value.round(0)"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "mm[Hg]"
                          }
                        }
                      ],
                      "linkId" : "bp-lastbp-diastolic",
                      "type" : "integer",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%ObsBloodPressureLatest.effective.toDate()"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                          "valueBoolean" : true
                        }
                      ],
                      "linkId" : "bp-lastbp-date",
                      "type" : "date",
                      "repeats" : false
                    },
                    {
                      "extension" : [
                        {
                          "extension" : [
                            {
                              "url" : "template",
                              "valueReference" : {
                                "reference" : "#BloodPressureTemplate"
                              }
                            }
                          ],
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "mm[Hg]"
                          }
                        }
                      ],
                      "linkId" : "bp-newbp-systolic",
                      "text" : "Systolic",
                      "type" : "integer",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "bp-newbp-systolic-unit",
                          "text" : "mm Hg",
                          "type" : "display"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "mm[Hg]"
                          }
                        }
                      ],
                      "linkId" : "bp-newbp-diastolic",
                      "text" : "Diastolic",
                      "type" : "integer",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "bp-newbp-diastolic-unit",
                          "text" : "mm Hg",
                          "type" : "display"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "iif(%resource.repeat(item).where(linkId='bp-newbp-systolic').answer.value.exists() or %resource.repeat(item).where(linkId='bp-newbp-diastolic').answer.value.exists(), today())"
                          }
                        }
                      ],
                      "linkId" : "bp-newbp-date",
                      "text" : "Date performed",
                      "type" : "date",
                      "repeats" : false
                    }
                  ]
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "213a3eac-e530-4e27-859c-407136c7a0a6",
              "text" : "Cardiac auscultation",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "8886f3bb-52de-4294-a5cb-8f960e2a6bbe",
              "text" : "Abdominal examination",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "5e10229c-390d-4968-90d3-f896840f3c50",
              "text" : "Gait examination (musculoskeletal structure, balance, coordination)",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age < 1"
                  }
                }
              ],
              "linkId" : "6c69ee91-f777-494c-bf09-d963773cd4ae",
              "text" : "Newborn examination (if indicated, infant aged <=6 weeks)",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "7a431d03-1726-4905-aae7-49f62a10ce5e",
              "text" : "Haemoglobin (children at risk of iron deficiency anaemia)",
              "type" : "string",
              "repeats" : false
            },
            {
              "linkId" : "fcbfa6e1-c101-4675-969d-aa11027859c2",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "examination-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-7",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age >= 25"
              }
            }
          ],
          "linkId" : "d95abe99-8ef2-4b97-bc88-a2901e2ebc9c",
          "text" : "Absolute cardiovascular disease risk calculation",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-2').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-2').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-2",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-2').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-2",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-2').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-2",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "Guidance-CVDRisk",
              "text" : "The Australian guideline for assessing and managing cardiovascular disease risk recommends the use of the Aus CVD Risk calculator.",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p style=\"font-size:1.1em;\">The Australian guideline for assessing and managing cardiovascular disease risk recommends the use of the Aus&nbsp;CVD&nbsp;Risk calculator.</p></div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "linkId" : "dabdc7b4-51db-44a0-9d59-77a88587cbe9",
              "text" : "CVD risk result",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%CVDRiskResultValue.exists() and %CVDRiskResultDateFormatted.exists(), %CVDRiskResultValue + ' ( ' + %CVDRiskResultDateFormatted + ' )', 'Not available')"
                      }
                    },
                    {
                      "url" : "https://smartforms.csiro.au/ig/StructureDefinition/questionnaire-initialExpression-repopulatable",
                      "valueCode" : "manual"
                    }
                  ],
                  "linkId" : "cvdrisk-latestresult",
                  "text" : "Latest available result",
                  "type" : "string",
                  "repeats" : false,
                  "readOnly" : true
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%CVDRiskResultValue.exists() and %CVDRiskResultDateFormatted.exists()"
                      }
                    }
                  ],
                  "linkId" : "cvdrisk-newassessmentquestion",
                  "text" : "A previous CVD risk result has been found. Do you want to perform a new assessment?",
                  "type" : "boolean",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%NewAssessmentQuestionAnswer = true or %CVDRiskResultValue.empty() or %CVDRiskResultDateFormatted.empty()"
                      }
                    }
                  ],
                  "linkId" : "cvdrisk-auscvdriskiaccess",
                  "text" : "Do you have access to the Aus CVD Risk-i application from your clinical system?",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                        "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Do you have access to the <em>Aus&nbsp;CVD&nbsp;Risk&#8209;i</em> application from your clinical system?</p></div>"
                      }
                    ]
                  },
                  "type" : "boolean",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%AusCVDRiskiAccessAnswer = true"
                      }
                    }
                  ],
                  "linkId" : "cvdrisk-auscvdriskiguidance",
                  "text" : "Using the Aus CVD Risk-i application, calculate the CVD risk result and save it to the patient record. This form can then be repopulated to retrieve and include the result above.",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                        "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p style=\"font-size:1.1em;\">Using the <em>Aus&nbsp;CVD&nbsp;Risk&#8209;i</em> application, calculate the CVD risk result and save it to the patient record. This form can then be repopulated to retrieve and include the result above.</p></div>"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%AusCVDRiskiAccessAnswer = true"
                      }
                    }
                  ],
                  "linkId" : "cvdrisk-repopulateoverride",
                  "text" : "Do you need to manually enter a new CVD risk result instead of repopulating?",
                  "type" : "boolean",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%AusCVDRiskiAccessAnswer != true or %RepopulateOverrideAnswer = true"
                      }
                    }
                  ],
                  "linkId" : "cvdrisk-cvdriskresultgroup",
                  "text" : "New CVD risk result",
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%AusCVDRiskiAccessAnswer != true"
                          }
                        }
                      ],
                      "linkId" : "cvdrisk-onlincecalculatorguidance",
                      "text" : "Use the online Australian CVD risk calculator - https://www.cvdcheck.org.au/calculator",
                      "_text" : {
                        "extension" : [
                          {
                            "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                            "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>The <a href=\"https://www.cvdcheck.org.au/calculator\" target=\"_blank\">Australian CVD risk calculator</a> on the Aus&nbsp;CVD&nbsp;Risk website should be used. Below is a read only view of a subset of variables that can be used as inputs for the online calculator. The calculated CVD risk result can be entered here.</p></div>"
                          }
                        ]
                      },
                      "type" : "display"
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                          "valueCoding" : {
                            "system" : "http://unitsofmeasure.org",
                            "code" : "%"
                          }
                        }
                      ],
                      "linkId" : "4c52fcec-0695-4916-b185-24a5c2711631",
                      "text" : "Risk result score",
                      "type" : "integer",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                              "valueCodeableConcept" : {
                                "coding" : [
                                  {
                                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                    "code" : "unit"
                                  }
                                ]
                              }
                            }
                          ],
                          "linkId" : "0162854e-c124-4b58-acd9-93c17562d407",
                          "text" : "%",
                          "type" : "display"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "radio-button"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "28ff9463-b77f-435d-9ba7-427682a61f96",
                      "text" : "Assessed risk category",
                      "type" : "choice",
                      "repeats" : false,
                      "answerOption" : [
                        {
                          "valueString" : "High Risk"
                        },
                        {
                          "valueString" : "Intermediate Risk"
                        },
                        {
                          "valueString" : "Low Risk"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%AusCVDRiskiAccessAnswer != true or %AusCVDRiskiAccessAnswer.empty()"
                  }
                }
              ],
              "linkId" : "8d02ef36-3f48-4912-b001-e9fec6aa7101",
              "text" : "CVD risk calculator variables",
              "type" : "group",
              "repeats" : false,
              "readOnly" : true,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "description" : "CVD Risk Age",
                        "language" : "text/fhirpath",
                        "expression" : "%age"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "a"
                      }
                    }
                  ],
                  "linkId" : "6909cb38-a6f4-44c9-abae-0e5d697a21f5",
                  "text" : "Age",
                  "type" : "integer",
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "b9aba16c-f910-4948-9267-e07851f69572",
                      "text" : "years",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "description" : "CVD Risk Sex At Birth",
                        "language" : "text/fhirpath",
                        "expression" : "%SexAtBirthCoding"
                      }
                    }
                  ],
                  "linkId" : "3dbb0e63-3b28-4567-8ef3-bac242fd95f6",
                  "text" : "Sex at birth",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#biological-sex-1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "grid"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "fe9feec6-593a-4106-8a7d-f9965a632ea2",
                  "text" : "Observation values",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                        "valueBoolean" : true
                      }
                    ]
                  },
                  "type" : "group",
                  "repeats" : false,
                  "item" : [
                    {
                      "linkId" : "bac0f824-3784-400e-80f9-ad18d46bd8cb",
                      "text" : "Smoking status",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsTobaccoSmokingStatusLatest.value.coding.where(system='http://snomed.info/sct').first()"
                              }
                            }
                          ],
                          "linkId" : "333007c7-47a9-482b-af11-e55484abf2ae",
                          "text" : "Value",
                          "type" : "choice",
                          "repeats" : false,
                          "answerOption" : [
                            {
                              "valueCoding" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "266919005",
                                "display" : "Lifetime non-smoker"
                              }
                            },
                            {
                              "valueCoding" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "77176002",
                                "display" : "Current smoker"
                              }
                            },
                            {
                              "valueCoding" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "8517006",
                                "display" : "Ex-smoker"
                              }
                            },
                            {
                              "valueCoding" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "16090371000119103",
                                "display" : "Exposure to second hand tobacco smoke"
                              }
                            },
                            {
                              "valueString" : "Wants to quit"
                            },
                            {
                              "valueString" : "Other tobacco use"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsTobaccoSmokingStatusLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "cvdrisk-smokingstatus-date",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "linkId" : "fa4f73a3-7633-410c-9177-8aa43b117122",
                      "text" : "Systolic Blood Pressure",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsBloodPressureLatest.component.where(code.coding.exists(code='8480-6')).value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "mm[Hg]"
                              }
                            }
                          ],
                          "linkId" : "818ce640-c8dd-457d-b607-3aaa8da38524",
                          "text" : "Value",
                          "type" : "integer",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "ddea5a62-a8c1-4b15-b667-7b69babec8cd",
                              "text" : "mm Hg",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsBloodPressureLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "85d8faf7-ddb0-446c-b489-28d786d6de50",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "linkId" : "e693c7d2-be69-4f1f-b72d-7ff2ea3cd536",
                      "text" : "Total Cholesterol",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsTotalCholesterolLatest.value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "mmol/L"
                              }
                            }
                          ],
                          "linkId" : "99932a93-8135-47b2-933b-fd751b34b7af",
                          "text" : "Value",
                          "type" : "decimal",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "fcfbfc9f-e400-4aae-993f-ea54096e7361",
                              "text" : "mmol/L",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsTotalCholesterolLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "16cbe87b-5c8d-4385-b7d9-da3f07f63f8a",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    },
                    {
                      "linkId" : "87eefaf6-010f-4b0d-9f51-2c33e46e6c69",
                      "text" : "HDL Cholesterol",
                      "type" : "group",
                      "repeats" : false,
                      "item" : [
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsHDLCholesterolLatest.value.value"
                              }
                            },
                            {
                              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                              "valueCoding" : {
                                "system" : "http://unitsofmeasure.org",
                                "code" : "mmol/L"
                              }
                            }
                          ],
                          "linkId" : "c14b4513-1e20-461d-97f4-4631711adc65",
                          "text" : "Value",
                          "type" : "decimal",
                          "repeats" : false,
                          "item" : [
                            {
                              "extension" : [
                                {
                                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                                  "valueCodeableConcept" : {
                                    "coding" : [
                                      {
                                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                        "code" : "unit"
                                      }
                                    ]
                                  }
                                }
                              ],
                              "linkId" : "2ba61002-b642-4b28-9e66-dc2b060c4e0e",
                              "text" : "mmol/L",
                              "type" : "display"
                            }
                          ]
                        },
                        {
                          "extension" : [
                            {
                              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                              "valueExpression" : {
                                "language" : "text/fhirpath",
                                "expression" : "%ObsHDLCholesterolLatest.effective"
                              }
                            }
                          ],
                          "linkId" : "6407e0a7-c416-4a75-933b-904c0dcf88ca",
                          "text" : "Date performed",
                          "type" : "date",
                          "repeats" : false
                        }
                      ]
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "description" : "CVD Risk Postcode",
                        "language" : "text/fhirpath",
                        "expression" : "%postcode"
                      }
                    }
                  ],
                  "linkId" : "fa8f03ca-9a5a-4ed1-a866-db26e567352a",
                  "text" : "Postcode",
                  "type" : "string"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%Condition.entry.resource.code.coding.where(system='http://snomed.info/sct' and code='44054006').exists()"
                      }
                    }
                  ],
                  "linkId" : "1c1eea28-6c82-4b7b-aaa3-8655ce70f2fd",
                  "text" : "Type 2 diabetes mellitus",
                  "type" : "boolean",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "f8022f3f-21fe-42c0-8abd-95f24e2e37e5",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "cvd-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-2",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age >= 12"
              }
            }
          ],
          "linkId" : "918f7f32-cdaf-4742-b33a-8254eda2d8bd",
          "text" : "Investigations",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-14').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-14').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-14",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-14').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-14",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-14').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-14",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 18"
                  }
                }
              ],
              "linkId" : "740cbc59-08e3-41e8-bc00-de22c1ad45a0",
              "text" : "Full blood count, HbA1c or blood glucose level, serum lipids, Kidney function including eGFR, Liver function tests, ACR",
              "type" : "text"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 30"
                  }
                }
              ],
              "linkId" : "73e1e470-5c41-4644-b279-03f57bde036d",
              "text" : "Chlamydia, gonorrhoea: <=30, first void urine (male and female) and/or endocervical swab or self-administered vaginal swab (female) or throat and anal swab (men who have sex with men [MSM])",
              "type" : "text"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 49"
                  }
                }
              ],
              "linkId" : "77847d34-103e-497d-a7d5-f62cbaf4f698",
              "text" : "Syphilis (endemic areas, MSM, others at high risk)",
              "type" : "text"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 30"
                  }
                }
              ],
              "linkId" : "4aa47bda-d740-4294-9466-52b1be2ec15b",
              "text" : "Trichomoniasis (<=30, male and female, remote areas and other endemic areas, first void urine and/or endocervical swab or self-administered vaginal swab)",
              "type" : "text"
            },
            {
              "linkId" : "b919de86-d81c-470d-8cb2-9caa4f8d3a42",
              "text" : "Blood-borne virus screening: HBV if status not known/not recorded on file, HCV if risk factors, HIV if risk factors",
              "type" : "text"
            },
            {
              "linkId" : "96a8d946-6078-4c85-9de8-3bf18d2c8150",
              "text" : "Health priorities, actions and follow-up",
              "type" : "text",
              "repeats" : false
            },
            {
              "linkId" : "investigations-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-14",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            },
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
              "valueString" : "Health Priorities Summary"
            }
          ],
          "linkId" : "e2c778e2-83df-40d5-89ea-f0f91b666b04",
          "text" : "Health Priorities, Actions And Follow-Up Summary",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "linkId" : "f948fb81-48e9-4bc6-bf81-8d778ac4375a",
              "text" : "The following information is a read-only collection of the 'Health priorities, actions and follow-up' sections entered in the previous tabs. Only sections where previous information entered will be displayed here.",
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryCurrentPriorities.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Current priorities calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryCurrentPriorities"
                  }
                }
              ],
              "linkId" : "4b03d116-84ee-488c-b132-427472d21fcd",
              "text" : "Current health/patient priorities",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryMedicalHistory.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Medical history calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryMedicalHistory"
                  }
                }
              ],
              "linkId" : "c848098c-85f3-487b-91af-01da4eba3aba",
              "text" : "Medical history and current problems",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryRegularMedications.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Regular medications calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryRegularMedications"
                  }
                }
              ],
              "linkId" : "0c0a389e-c23a-4687-84d9-e00c5a258c7a",
              "text" : "Regular medications",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryAllergiesAdverseReactions.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Allergies/adverse reactions calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryAllergiesAdverseReactions"
                  }
                }
              ],
              "linkId" : "34b7c4f3-c848-4dcb-ba9b-0b4c5ccd0785",
              "text" : "Allergies/adverse reactions",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryFamilyHistory.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Family history Calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryFamilyHistory"
                  }
                }
              ],
              "linkId" : "f81c85c7-587e-47de-8b02-9c1eeee13949",
              "text" : "Family history",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12 and %HealthPrioritiesSummarySocialEmotionalWellbeing.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Social and emotional wellbeing calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummarySocialEmotionalWellbeing"
                  }
                }
              ],
              "linkId" : "a57d29d3-b875-47ac-b8ed-c95eaa6a027d",
              "text" : "Social and emotional wellbeing",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12 and %HealthPrioritiesSummarySocialHistory.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Social history calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummarySocialHistory"
                  }
                }
              ],
              "linkId" : "ad9b85fc-24fe-495d-a980-941e2ad16533",
              "text" : "Social history",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12 and %HealthPrioritiesSummaryHomeFamily.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Home and family calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryHomeFamily"
                  }
                }
              ],
              "linkId" : "622f0877-80ec-4b91-bb1c-e741e5657e4c",
              "text" : "Home and family",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12 and %HealthPrioritiesSummaryLearningDevelopment.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Learning and development calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryLearningDevelopment"
                  }
                }
              ],
              "linkId" : "9a88bdf6-e97a-4c54-96ff-1dad9701b5ab",
              "text" : "Learning and development",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age > 12) and (%age < 50) and %HealthPrioritiesSummaryLearningWorkAdults.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Learning and work for adolescents and adults calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryLearningWorkAdults"
                  }
                }
              ],
              "linkId" : "aefbee8b-64fc-4cdc-9902-d6c3f50a2e18",
              "text" : "Learning and work",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50 and %HealthPrioritiesSummaryLearningWorkOlder.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Learning and work calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryLearningWorkOlder"
                  }
                }
              ],
              "linkId" : "a96cce74-cda3-4b6b-adc4-1b7d73df2317",
              "text" : "Work",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12 and %HealthPrioritiesSummaryMood.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Mood calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryMood"
                  }
                }
              ],
              "linkId" : "58bf5a0f-6c68-4d1f-b352-bfcba8e1e05e",
              "text" : "Mood",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50 and %HealthPrioritiesSummaryMemoryThinking.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Memory and thinking calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryMemoryThinking"
                  }
                }
              ],
              "linkId" : "d963364a-e2d3-4382-8430-c47c19fc206c",
              "text" : "Memory and thinking",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50 and %HealthPrioritiesSummaryChronicDiseaseAgeing.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Chronic disease associated with ageing calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryChronicDiseaseAgeing"
                  }
                }
              ],
              "linkId" : "1877223d-8cae-48af-8add-fd6b10b37209",
              "text" : "Chronic disease associated with ageing",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age >= 50) and (%age <= 74) and %HealthPrioritiesSummaryScreeningPrograms.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Participation in screening programs calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryScreeningPrograms"
                  }
                }
              ],
              "linkId" : "b031bccf-5413-4c57-8e70-f464d24a6e6c",
              "text" : "Participation in screening programs",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryHealthyEating.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Healthy eating calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryHealthyEating"
                  }
                }
              ],
              "linkId" : "6ef556cb-2a69-4d28-a6cf-b4866303a564",
              "text" : "Healthy eating",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age < 50 and %HealthPrioritiesSummaryPhysicalActivityScreenTimeNotOlder.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Physical activity and screen time calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryPhysicalActivityScreenTimeNotOlder"
                  }
                }
              ],
              "linkId" : "b7e32f62-a4e7-4419-a728-6addceefeb02",
              "text" : "Physical activity and screen time",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50 and %HealthPrioritiesSummaryPhysicalActivityScreenTimeOlder.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Physical activity and screen time calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryPhysicalActivityScreenTimeOlder"
                  }
                }
              ],
              "linkId" : "f1c3d1ba-240c-4e68-8afc-62c50cc313d1",
              "text" : "Physical activity",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 12 and %HealthPrioritiesSummarySubstanceUse.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Substance use, including tobacco calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummarySubstanceUse"
                  }
                }
              ],
              "linkId" : "c94f2749-4353-4f51-9c75-106f81c5b69f",
              "text" : "Substance use, including tobacco",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12 and %HealthPrioritiesSummaryGambling.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Gambling calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryGambling"
                  }
                }
              ],
              "linkId" : "931457d4-0de0-434c-88af-eb1b17746953",
              "text" : "Gambling",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age > 12) and (%age <= 24) and %HealthPrioritiesSummarySexualHealthAdolescents.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Sexual health calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummarySexualHealthAdolescents"
                  }
                }
              ],
              "linkId" : "797402ac-95de-4c0b-a04f-44b669755f7c",
              "text" : "Sexual health",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age > 24) and (%age <= 49) and %HealthPrioritiesSummarySexualHealthAdults.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Sexual health calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummarySexualHealthAdults"
                  }
                }
              ],
              "linkId" : "e4df6f14-7a9c-445c-8cf5-3fc489db7307",
              "text" : "Genitourinary and sexual health",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 50 and %HealthPrioritiesSummarySexualHealthOlder.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Sexual health calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummarySexualHealthOlder"
                  }
                }
              ],
              "linkId" : "23e293c4-537f-46ca-90f9-c8dfb7630211",
              "text" : "Genitourinary and sexual health",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryEyeHealth.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Eye health calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryEyeHealth"
                  }
                }
              ],
              "linkId" : "4b1bf353-a422-40fb-a6d3-42807ebf1a6a",
              "text" : "Eye health",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryEarHealthHearing.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Ear health and hearing calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryEarHealthHearing"
                  }
                }
              ],
              "linkId" : "c292557b-2798-4b45-854d-58c20ecf8233",
              "text" : "Ear health and hearing",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryOralDentalHealth.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Oral and dental health calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryOralDentalHealth"
                  }
                }
              ],
              "linkId" : "93c33ba0-e4cc-4e9d-978b-49f57ce4a5eb",
              "text" : "Oral and dental health",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 24 and %HealthPrioritiesSummarySkin.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Skin calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummarySkin"
                  }
                }
              ],
              "linkId" : "0ccc2bce-899f-42b0-9100-05e6874372a3",
              "text" : "Skin",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryImmunisation.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Immunisation calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryImmunisation"
                  }
                }
              ],
              "linkId" : "8a33280b-19b9-4e0f-a26f-d9a0f95a7714",
              "text" : "Immunisation",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryExamination.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Examination calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryExamination"
                  }
                }
              ],
              "linkId" : "a889034b-7942-460d-ada6-b728a9f57dc0",
              "text" : "Examination",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 25 and %HealthPrioritiesSummaryAbsoluteCVDRisk.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Absolute cardiovascular risk calculation calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryAbsoluteCVDRisk"
                  }
                }
              ],
              "linkId" : "fd51cc3f-f53d-4a7d-a3a3-4a3b7232d4ee",
              "text" : "Absolute cardiovascular risk calculation",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 12 and %HealthPrioritiesSummaryInvestigations.exists()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                  "valueExpression" : {
                    "description" : "Investigations calculation",
                    "language" : "text/fhirpath",
                    "expression" : "%HealthPrioritiesSummaryInvestigations"
                  }
                }
              ],
              "linkId" : "84fa4cca-aff7-4357-8d92-bb827074dc6a",
              "text" : "Investigations",
              "type" : "text",
              "repeats" : false,
              "readOnly" : true
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age.exists()"
              }
            }
          ],
          "linkId" : "16971bd2-5494-483d-9713-eda182c47f02",
          "text" : "Finalising the health check",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-31').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-31').answer.value.empty()"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-in-progress-31",
              "text" : "In progress",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-31').answer.value = 'Complete'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-complete-31",
              "text" : "Complete",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%resource.repeat(item).where(linkId='MarkComplete-31').answer.value = 'Attention required'"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                        "code" : "context-display"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "CD-attention-31",
              "text" : "Attention required",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                    "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                }
              ],
              "linkId" : "30532ad8-3465-4bdd-97ed-ec5664f9d733",
              "text" : "Patient priorities and goals: What does the parent/carer say are the important things that have come out of this health check?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age <= 12) and (%age > 5)"
                  }
                }
              ],
              "linkId" : "6aa0a113-4d33-4f6b-9899-fa249674075a",
              "text" : "Patient priorities and goals: What does the parent/carer and child say are the important things that have come out of this health check?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                }
              ],
              "linkId" : "71c19d58-a8ae-43ba-8b96-463c108c75dc",
              "text" : "Patient priorities and goals: What does the patient say are the important things that have come out of this health check?",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "check-box"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                  "valueString" : "Other"
                }
              ],
              "linkId" : "d0e58402-a08a-49ca-b2ca-9f4bbdb89da0",
              "text" : "Brief intervention: advice and information provided during health check",
              "type" : "open-choice",
              "repeats" : true,
              "answerOption" : [
                {
                  "valueString" : "Sugary drinks"
                },
                {
                  "valueString" : "Screen use"
                },
                {
                  "valueString" : "Healthy eating, including breastfeeding"
                },
                {
                  "valueString" : "Environmental exposure to harmful elements eg tobacco smoke"
                },
                {
                  "valueString" : "Physical activity and exercise"
                },
                {
                  "valueString" : "Sun protection"
                },
                {
                  "valueString" : "Parenting advice"
                },
                {
                  "valueString" : "Safe sleeping practices"
                },
                {
                  "valueString" : "Developmental milestones - including language and hearing"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age <= 12) and (%age > 5)"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "check-box"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                  "valueString" : "Other"
                }
              ],
              "linkId" : "0f70dec3-c1f2-4b36-b1f6-bd7f5743d5f8",
              "text" : "Brief intervention: advice and information provided during health check",
              "type" : "open-choice",
              "repeats" : true,
              "answerOption" : [
                {
                  "valueString" : "Healthy eating"
                },
                {
                  "valueString" : "Screen use"
                },
                {
                  "valueString" : "Sun protection"
                },
                {
                  "valueString" : "Environmental exposure to harmful elements (e.g. tobacco smoke)"
                },
                {
                  "valueString" : "Sugary drinks"
                },
                {
                  "valueString" : "Physical activity and exercise"
                },
                {
                  "valueString" : "Parenting advice"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age <= 24) and (%age > 12)"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "check-box"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                  "valueString" : "Other"
                }
              ],
              "linkId" : "eaed9770-95f4-4c6a-b06c-d573427a2616",
              "text" : "Brief intervention: advice and information provided during health check",
              "type" : "open-choice",
              "repeats" : true,
              "answerOption" : [
                {
                  "valueString" : "Healthy eating"
                },
                {
                  "valueString" : "Screen use"
                },
                {
                  "valueString" : "Physical activity and exercise"
                },
                {
                  "valueString" : "Mental health and wellbeing"
                },
                {
                  "valueString" : "Safety/risky behaviours"
                },
                {
                  "valueString" : "Smoking cessation"
                },
                {
                  "valueString" : "Substance use/harm minimisation"
                },
                {
                  "valueString" : "Safe sex/contraception"
                },
                {
                  "valueString" : "Care of teeth and gums"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age <= 49) and (%age > 24)"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "check-box"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                  "valueString" : "Other"
                }
              ],
              "linkId" : "25f27e83-fcf0-49c8-86c1-e285e201a043",
              "text" : "Brief intervention: advice and information provided during health check",
              "type" : "open-choice",
              "repeats" : true,
              "answerOption" : [
                {
                  "valueString" : "Healthy eating"
                },
                {
                  "valueString" : "Screen use"
                },
                {
                  "valueString" : "Physical activity and exercise"
                },
                {
                  "valueString" : "Mental health and wellbeing"
                },
                {
                  "valueString" : "Carer support"
                },
                {
                  "valueString" : "Safety/risky behaviours"
                },
                {
                  "valueString" : "Smoking cessation"
                },
                {
                  "valueString" : "Substance use/harm minimisation"
                },
                {
                  "valueString" : "Safe sex/contraception"
                },
                {
                  "valueString" : "Oral and dental health"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 49"
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "check-box"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-openLabel",
                  "valueString" : "Other"
                }
              ],
              "linkId" : "2657da9c-a27e-4939-af7a-08a19b9ab6f7",
              "text" : "Brief intervention: advice and information provided during health check",
              "type" : "open-choice",
              "repeats" : true,
              "answerOption" : [
                {
                  "valueString" : "Healthy eating"
                },
                {
                  "valueString" : "Physical activity and exercise"
                },
                {
                  "valueString" : "Mental health and wellbeing"
                },
                {
                  "valueString" : "Carer support"
                },
                {
                  "valueString" : "Smoking cessation"
                },
                {
                  "valueString" : "Substance use/harm minimisation"
                },
                {
                  "valueString" : "Social support and services"
                },
                {
                  "valueString" : "Oral and dental health"
                }
              ]
            },
            {
              "linkId" : "afbadad6-bef9-4fad-b5f4-111f666ccf11",
              "text" : "Care provided as part of the health check (eg immunisations, medication review, investigations requested)",
              "type" : "text"
            },
            {
              "linkId" : "4b3015f6-5b0a-4dfa-9791-994e4059f921",
              "text" : "Identified needs and plan (including new diagnoses)",
              "type" : "text"
            },
            {
              "linkId" : "5760a1f9-d725-4b9e-b74d-50800615a689",
              "text" : "Follow-up",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-display-category",
                            "code" : "instructions"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "b4110a63-8547-4aa2-84c6-c1f64f0d24da",
                  "text" : "Consider what follow-up appointments can be made at the time of the health check.",
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-display-category",
                            "code" : "instructions"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "c47cfd7e-0f15-4dd9-bd53-bb62851b677c",
                  "text" : "Reminder: MBS follow up items for clients at risk of or with chronic disease are available to support follow-up of health checks",
                  "type" : "display"
                },
                {
                  "linkId" : "1be25c55-2a2d-4b94-b826-bd17d9e35e92",
                  "text" : "Referrals and appointments",
                  "type" : "group",
                  "repeats" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%age <= 5"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "drop-down"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "4044d0b4-94b2-4a89-b826-a14614298511",
                      "text" : "Who",
                      "type" : "open-choice",
                      "repeats" : false,
                      "answerOption" : [
                        {
                          "valueString" : "GP follow-up"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                        },
                        {
                          "valueString" : "Practice nurse follow-up"
                        },
                        {
                          "valueString" : "Child health nurse"
                        },
                        {
                          "valueString" : "Dentist"
                        },
                        {
                          "valueString" : "Paediatrician"
                        },
                        {
                          "valueString" : "Audiology"
                        },
                        {
                          "valueString" : "Speech pathology"
                        },
                        {
                          "valueString" : "Mental health"
                        },
                        {
                          "valueString" : "Early intervention (development) services"
                        },
                        {
                          "valueString" : "Parenting programs/support services"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "(%age <= 12) and (%age > 5)"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "drop-down"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "f97f211a-ef2a-49a3-aef7-c4e9cd08aa2a",
                      "text" : "Who",
                      "type" : "open-choice",
                      "repeats" : false,
                      "answerOption" : [
                        {
                          "valueString" : "GP follow-up"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                        },
                        {
                          "valueString" : "Practice nurse follow-up"
                        },
                        {
                          "valueString" : "Dentist"
                        },
                        {
                          "valueString" : "Paediatrician"
                        },
                        {
                          "valueString" : "Audiology"
                        },
                        {
                          "valueString" : "Speech pathology"
                        },
                        {
                          "valueString" : "Mental health"
                        },
                        {
                          "valueString" : "Parenting programs/support services"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "(%age <= 24) and (%age > 12)"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "drop-down"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "07cfe077-ba93-4f93-b2a5-027023faa33b",
                      "text" : "Who",
                      "type" : "open-choice",
                      "repeats" : false,
                      "answerOption" : [
                        {
                          "valueString" : "GP follow-up"
                        },
                        {
                          "valueString" : "GP review of results of investigations"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                        },
                        {
                          "valueString" : "Practice nurse follow-up"
                        },
                        {
                          "valueString" : "Dentist"
                        },
                        {
                          "valueString" : "Paediatrician"
                        },
                        {
                          "valueString" : "Audiology"
                        },
                        {
                          "valueString" : "Speech pathology"
                        },
                        {
                          "valueString" : "Parenting programs/support services"
                        },
                        {
                          "valueString" : "Social and emotional wellbeing/mental health"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "(%age <= 49) and (%age > 24)"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "drop-down"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "a525c370-d8c3-4764-ab3a-bf62081725e0",
                      "text" : "Who",
                      "type" : "open-choice",
                      "repeats" : false,
                      "answerOption" : [
                        {
                          "valueString" : "GP follow-up"
                        },
                        {
                          "valueString" : "GP review of results of investigations"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                        },
                        {
                          "valueString" : "Practice nurse follow-up"
                        },
                        {
                          "valueString" : "Dentist"
                        },
                        {
                          "valueString" : "Medication review"
                        },
                        {
                          "valueString" : "Smoking cessation"
                        },
                        {
                          "valueString" : "Audiology"
                        },
                        {
                          "valueString" : "Dietician"
                        },
                        {
                          "valueString" : "Physiotherapist or exercise program"
                        },
                        {
                          "valueString" : "Parenting programs/support services"
                        },
                        {
                          "valueString" : "Social and emotional wellbeing/mental health"
                        }
                      ]
                    },
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                          "valueExpression" : {
                            "language" : "text/fhirpath",
                            "expression" : "%age > 49"
                          }
                        },
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "drop-down"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "d68d9693-48d3-4663-9dbb-dd3a7aec5278",
                      "text" : "Who",
                      "type" : "open-choice",
                      "repeats" : false,
                      "answerOption" : [
                        {
                          "valueString" : "GP follow-up"
                        },
                        {
                          "valueString" : "GP review of results of investigations"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Worker follow-up"
                        },
                        {
                          "valueString" : "Aboriginal and/or Torres Strait Islander Health Practitioner follow-up"
                        },
                        {
                          "valueString" : "Practice nurse follow-up"
                        },
                        {
                          "valueString" : "Dentist"
                        },
                        {
                          "valueString" : "Medication review"
                        },
                        {
                          "valueString" : "Geriatrician"
                        },
                        {
                          "valueString" : "Smoking cessation"
                        },
                        {
                          "valueString" : "Audiologist"
                        },
                        {
                          "valueString" : "Dietician"
                        },
                        {
                          "valueString" : "Physiotherapist or exercise program"
                        },
                        {
                          "valueString" : "Optometrist"
                        },
                        {
                          "valueString" : "Podiatrist"
                        },
                        {
                          "valueString" : "Social and emotional wellbeing/mental health"
                        },
                        {
                          "valueString" : "Social support and services"
                        }
                      ]
                    },
                    {
                      "linkId" : "0ef84b09-ca34-44c2-96d1-fcbbea0bae66",
                      "text" : "When",
                      "type" : "date",
                      "enableWhen" : [
                        {
                          "question" : "4044d0b4-94b2-4a89-b826-a14614298511",
                          "operator" : "exists",
                          "answerBoolean" : true
                        },
                        {
                          "question" : "f97f211a-ef2a-49a3-aef7-c4e9cd08aa2a",
                          "operator" : "exists",
                          "answerBoolean" : true
                        },
                        {
                          "question" : "07cfe077-ba93-4f93-b2a5-027023faa33b",
                          "operator" : "exists",
                          "answerBoolean" : true
                        },
                        {
                          "question" : "a525c370-d8c3-4764-ab3a-bf62081725e0",
                          "operator" : "exists",
                          "answerBoolean" : true
                        },
                        {
                          "question" : "d68d9693-48d3-4663-9dbb-dd3a7aec5278",
                          "operator" : "exists",
                          "answerBoolean" : true
                        }
                      ],
                      "enableBehavior" : "any",
                      "repeats" : false
                    }
                  ]
                }
              ]
            },
            {
              "linkId" : "a400fe69-c99f-47ed-bee1-083c3e4be467",
              "text" : "Recalls",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-display-category",
                            "code" : "instructions"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "b0c69e16-5dc3-481f-8e8f-fc0a93627184",
                  "text" : "e.g. clinical review, investigations, influenza vaccination, asthma plan/cycle of care, diabetes cycle of care, care plan review, cervical screening, investigations",
                  "type" : "display"
                },
                {
                  "linkId" : "fece6a3c-f8f1-4592-a166-5ea5a3c60c8e",
                  "text" : "Recall entered",
                  "type" : "string",
                  "repeats" : true
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                }
              ],
              "linkId" : "5a0c98f8-5349-4045-9ba0-27a4f35630b9",
              "text" : "Parent/carer actions",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "(%age <= 12) and (%age > 5)"
                  }
                }
              ],
              "linkId" : "cde03bf0-182a-4998-a37e-7b3f22786617",
              "text" : "Parent/patient actions",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                }
              ],
              "linkId" : "51ff0c15-312a-45ce-a25a-6c6a4bf0e17e",
              "text" : "Patient actions",
              "type" : "text",
              "repeats" : false
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Copy of health check"
                }
              ],
              "linkId" : "8176151f-6d86-45eb-91b1-12458d75a181",
              "text" : "A copy of this health check has been offered - including details of follow-up and future appointments",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Yes, copy taken"
                },
                {
                  "valueString" : "Yes, but declined"
                },
                {
                  "valueString" : "Not offered. Plan to follow up and offer at a later date"
                }
              ]
            },
            {
              "linkId" : "finalising-section-end-divider",
              "_text" : {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                    "valueString" : "border-top: 1px solid #ccc;"
                  }
                ]
              },
              "type" : "display"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                }
              ],
              "linkId" : "MarkComplete-31",
              "text" : "Section completion status",
              "type" : "choice",
              "repeats" : false,
              "answerOption" : [
                {
                  "valueString" : "Complete"
                },
                {
                  "valueString" : "In progress"
                },
                {
                  "valueString" : "Attention required"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
