# Smart Health Checks Patch Element Name Codes - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Patch Element Name Codes**

## CodeSystem: Smart Health Checks Patch Element Name Codes 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/CodeSystem/SHCPatchElementNameCodes | *Version*:0.4.0 |
| Draft as of 2025-12-18 | *Computable Name*:SHCPatchElementNameCodes |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The Smart Health Checks Patch Element Name Codes code system defines concepts that identify element names that are the target of a patch operation for Smart Health Checks. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SHCPatchAllergyIntoleranceElementName](ValueSet-SHCPatchAllergyIntoleranceElementName.md)
* [SHCPatchConditionElementName](ValueSet-SHCPatchConditionElementName.md)
* [SHCPatchMedicationStatementElementName](ValueSet-SHCPatchMedicationStatementElementName.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "SHCPatchElementNameCodes",
  "url" : "https://smartforms.csiro.au/ig/CodeSystem/SHCPatchElementNameCodes",
  "version" : "0.4.0",
  "name" : "SHCPatchElementNameCodes",
  "title" : "Smart Health Checks Patch Element Name Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-18T05:29:19+00:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "The Smart Health Checks Patch Element Name Codes code system defines concepts that identify element names that are the target of a patch operation for Smart Health Checks.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 6,
  "concept" : [
    {
      "code" : "clinicalStatus",
      "display" : "clinicalStatus"
    },
    {
      "code" : "text",
      "display" : "text"
    },
    {
      "code" : "note",
      "display" : "note"
    },
    {
      "code" : "abatement",
      "display" : "abatement"
    },
    {
      "code" : "status",
      "display" : "status"
    },
    {
      "code" : "dosage",
      "display" : "dosage"
    }
  ]
}

```
