# SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check**

## CodeSystem: SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement | *Version*:0.4.0 |
| Draft as of 2025-12-18 | *Computable Name*:HealthChecksSCTSupplement |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check code system supplement defines consumer friendly terms for use in the health check Questionnaire. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CervicalScreeningStatus](ValueSet-CervicalScreeningStatus-1.md)
* [SmokingQuitStatus](ValueSet-SmokingQuitStatus-1.md)
* [TobaccoUseStatus](ValueSet-TobaccoUseStatus-1.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "HealthChecksSCTSupplement",
  "url" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksSCTSupplement",
  "version" : "0.4.0",
  "name" : "HealthChecksSCTSupplement",
  "title" : "SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-18T05:29:19+00:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "The SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check code system supplement defines consumer friendly terms for use in the health check Questionnaire.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "content" : "supplement",
  "supplements" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031",
  "concept" : [
    {
      "code" : "736595007",
      "display" : "Declined"
    },
    {
      "code" : "171154002",
      "display" : "Not required"
    },
    {
      "code" : "171155001",
      "display" : "Up to date"
    },
    {
      "code" : "48031000119106",
      "display" : "Quit >12 months"
    },
    {
      "code" : "735128000",
      "display" : "Quit <12 months"
    },
    {
      "code" : "266919005",
      "display" : "Never smoked"
    },
    {
      "code" : "77176002",
      "display" : "Current smoker"
    },
    {
      "code" : "8517006",
      "display" : "Ex-smoker"
    },
    {
      "code" : "16090371000119103",
      "display" : "Exposure to second hand tobacco smoke"
    },
    {
      "code" : "394872000",
      "display" : "Wants to quit"
    },
    {
      "code" : "713914004",
      "display" : "Other tobacco use"
    }
  ]
}

```
