# ValueSet - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**Aboriginal and Torres Strait Islander Health Check**](Questionnaire-AssemblyInstructions.md)
* **ValueSet**

## ValueSet: ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715#condition-clinical | *Version*:0.4.0 |
| Draft as of 2019-11-01 | *Computable Name*:ConditionClinicalStatusCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.3.164 | |
| **Copyright/Legal**: Copyright © 2011+ HL7. Licensed under Creative Commons "No Rights Reserved". | |

 
Preferred value set for Condition Clinical Status. 

 **References** 

* [Condition](http://hl7.org/fhir/R4/condition.html)
* [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

