# Aboriginal and Torres Strait Islander Health Check - Learning And Work - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Aboriginal and Torres Strait Islander Health Check - Learning And Work**

## Questionnaire: Aboriginal and Torres Strait Islander Health Check - Learning And Work 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715/LearningAndWork | *Version*:0.4.0 |
| Draft as of 2025-03-14 | *Computable Name*:LearningAndWork |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "LearningAndWork",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-render",
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-modular"
    ]
  },
  "contained" : [
    {
      "resourceType" : "ValueSet",
      "id" : "YesNo",
      "url" : "https://smartforms.csiro.au/ig/ValueSet/YesNo",
      "name" : "YesNo",
      "title" : "Yes/No",
      "status" : "draft",
      "experimental" : false,
      "description" : "Concepts for Yes and No",
      "compose" : {
        "include" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "concept" : [
              {
                "code" : "Y",
                "display" : "Yes"
              },
              {
                "code" : "N",
                "display" : "No"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:5d9dbf1e-e156-4961-bb02-051dfc831832",
        "timestamp" : "2025-09-18T16:28:54+10:00",
        "total" : 2,
        "offset" : 0,
        "parameter" : [
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v2-0532|2.0.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "Y",
            "display" : "Yes"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "code" : "N",
            "display" : "No"
          }
        ]
      }
    },
    {
      "resourceType" : "ValueSet",
      "id" : "YesNoNA",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/valueset-supplement",
          "valueCanonical" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksExpandedYesNoIndicatorSupplement|0.4.0"
        }
      ],
      "url" : "https://smartforms.csiro.au/ig/ValueSet/YesNoNA",
      "name" : "YesNoNA",
      "title" : "Yes/No/NA",
      "status" : "draft",
      "experimental" : false,
      "description" : "Concepts for Yes, No and Not applicable",
      "compose" : {
        "include" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "concept" : [
              {
                "code" : "Y",
                "display" : "Yes"
              },
              {
                "code" : "N",
                "display" : "No"
              },
              {
                "code" : "NA",
                "display" : "N/A"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:e9020f5b-3df2-4fcb-9f8f-9aa20ef6f181",
        "timestamp" : "2025-10-29T16:30:17+10:00",
        "total" : 3,
        "parameter" : [
          {
            "name" : "used-supplement",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksExpandedYesNoIndicatorSupplement|0.4.0"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v2-0532|2.0.0"
          },
          {
            "name" : "version",
            "valueUri" : "http://terminology.hl7.org/CodeSystem/v2-0532|2.0.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/CodeSystem/HealthChecksExpandedYesNoIndicatorSupplement|0.4.0"
          },
          {
            "name" : "warning-draft",
            "valueUri" : "https://smartforms.csiro.au/ig/ValueSet/YesNoNA|0.4.0"
          }
        ],
        "contains" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "code" : "Y",
            "display" : "Yes"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "code" : "N",
            "display" : "No"
          },
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0532",
            "version" : "2.0.0",
            "code" : "NA",
            "display" : "N/A"
          }
        ]
      }
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assemble-expectation",
      "valueCode" : "assemble-child"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "patient"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Patient"
        },
        {
          "url" : "description",
          "valueString" : "The patient that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "user"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Practitioner"
        },
        {
          "url" : "description",
          "valueString" : "The practitioner user that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "encounter"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Encounter"
        },
        {
          "url" : "description",
          "valueString" : "The encounter that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembleContext",
      "valueString" : "age"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Questionnaire.versionAlgorithm[x]",
      "valueCoding" : {
        "system" : "http://hl7.org/fhir/version-algorithm",
        "code" : "semver"
      }
    }
  ],
  "url" : "http://www.health.gov.au/assessments/mbs/715/LearningAndWork",
  "version" : "0.4.0",
  "name" : "LearningAndWork",
  "title" : "Aboriginal and Torres Strait Islander Health Check - Learning And Work",
  "status" : "draft",
  "experimental" : false,
  "subjectType" : ["Patient"],
  "date" : "2025-03-14",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "(%age > 12) and (%age < 50)"
          }
        }
      ],
      "linkId" : "5437e30d-8a0a-4785-974e-00a10d2a1df0",
      "text" : "Learning and work",
      "type" : "group",
      "repeats" : false,
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-16').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-16').answer.value.empty()"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-in-progress-16",
          "text" : "In progress",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-16').answer.value = 'Complete'"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-complete-16",
          "text" : "Complete",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-16').answer.value = 'Attention required'"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-attention-16",
          "text" : "Attention required",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age < 25"
              }
            }
          ],
          "linkId" : "0e30e9b4-ec83-44ea-88ab-47963e52a2d7",
          "text" : "Learning",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "0cd9e27b-1e98-41af-917b-0c6ee21c0819",
              "text" : "Are you studying at school/uni?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNoNA"
            },
            {
              "linkId" : "18bdfa42-9845-4c6e-b737-843b14d54641",
              "text" : "Details",
              "type" : "text",
              "repeats" : false
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age >= 25"
              }
            }
          ],
          "linkId" : "c0ba8a79-a9c5-40cc-b0c2-041e736784e9",
          "text" : "Learning",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "4a81afc0-f0da-49e1-b8cc-c19cb0f5f4e9",
              "text" : "Are you studying?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNoNA"
            },
            {
              "linkId" : "1c648524-558e-4d24-bd83-c9f5cd35e97b",
              "text" : "Details",
              "type" : "text",
              "repeats" : false
            }
          ]
        },
        {
          "linkId" : "ccf6f0b0-57ae-473e-9929-2a09184c8a14",
          "text" : "Work",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "aaead1e2-ea54-4979-be0a-647e61ab59a9",
              "text" : "Are you working?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNoNA"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "749a4e1e-35ab-4f37-ab28-cb3f0830bb2a",
              "text" : "Details (occupation including occupational hazards, study, training, disability, etc)",
              "type" : "text",
              "repeats" : false
            }
          ]
        },
        {
          "linkId" : "3569e514-a74b-4343-b31b-3395e58d991a",
          "text" : "Health priorities, actions and follow-up",
          "type" : "text",
          "repeats" : false
        },
        {
          "linkId" : "learningwork-adolescentsadults-section-end-divider",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                "valueString" : "border-top: 1px solid #ccc;"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "radio-button"
                  }
                ]
              }
            }
          ],
          "linkId" : "MarkComplete-16",
          "text" : "Section completion status",
          "type" : "choice",
          "repeats" : false,
          "answerOption" : [
            {
              "valueString" : "Complete"
            },
            {
              "valueString" : "In progress"
            },
            {
              "valueString" : "Attention required"
            }
          ]
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%age >= 50"
          }
        }
      ],
      "linkId" : "dec713ae-246a-4961-95c9-0626bfebfed2",
      "text" : "Work",
      "type" : "group",
      "repeats" : false,
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-33').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-33').answer.value.empty()"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-in-progress-33",
          "text" : "In progress",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-33').answer.value = 'Complete'"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-complete-33",
          "text" : "Complete",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-33').answer.value = 'Attention required'"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-attention-33",
          "text" : "Attention required",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "linkId" : "2bfc99a5-677c-4aea-a1ad-c37a181a3733",
          "text" : "Work",
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "http://hl7.org/fhir/questionnaire-item-control",
                        "code" : "radio-button"
                      }
                    ]
                  }
                },
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation",
                  "valueCode" : "horizontal"
                }
              ],
              "linkId" : "4c68ff3e-0e73-4ea2-b295-5057deaa590e",
              "text" : "Are you working?",
              "type" : "choice",
              "repeats" : false,
              "answerValueSet" : "#YesNo"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-shortText",
                  "valueString" : "Details"
                }
              ],
              "linkId" : "794fc001-6799-4a51-9a80-f2ed7c685a42",
              "text" : "Details (occupation including occupational hazards, study, training, disability, etc)",
              "type" : "text",
              "repeats" : false
            }
          ]
        },
        {
          "linkId" : "ed6f7800-e22a-4639-9d11-faf845513500",
          "text" : "Health priorities, actions and follow-up",
          "type" : "text",
          "repeats" : false
        },
        {
          "linkId" : "learningwork-olderpeople-section-end-divider",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                "valueString" : "border-top: 1px solid #ccc;"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "radio-button"
                  }
                ]
              }
            }
          ],
          "linkId" : "MarkComplete-33",
          "text" : "Section completion status",
          "type" : "choice",
          "repeats" : false,
          "answerOption" : [
            {
              "valueString" : "Complete"
            },
            {
              "valueString" : "In progress"
            },
            {
              "valueString" : "Attention required"
            }
          ]
        }
      ]
    }
  ]
}

```
