# Aboriginal and Torres Strait Islander Health Check - Examination - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Aboriginal and Torres Strait Islander Health Check - Examination**

## Questionnaire: Aboriginal and Torres Strait Islander Health Check - Examination 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715/Examination | *Version*:0.4.0 |
| Draft as of 2025-03-14 | *Computable Name*:Examination |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |



## Resource Content

```json
{
  "resourceType" : "Questionnaire",
  "id" : "Examination",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-render",
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-modular",
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-behave",
      "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-extr-template"
    ]
  },
  "contained" : [
    {
      "resourceType" : "ValueSet",
      "id" : "heart-rhythm-1",
      "url" : "https://smartforms.csiro.au/ig/ValueSet/heart-rhythm-1",
      "name" : "HeartRhythm",
      "title" : "Heart Rhythm",
      "status" : "draft",
      "experimental" : false,
      "description" : "The Heart Rhythm value set includes values that may be used to represent the heart rhythm of an individual.",
      "compose" : {
        "include" : [
          {
            "system" : "http://snomed.info/sct",
            "concept" : [
              {
                "code" : "933506231000036108",
                "display" : "Regular heart rhythm"
              },
              {
                "code" : "361137007",
                "display" : "Irregular heart rhythm"
              }
            ]
          }
        ]
      },
      "expansion" : {
        "identifier" : "urn:uuid:7743ad1f-02f2-4977-b7a4-ea993b57023b",
        "timestamp" : "2025-10-28T16:39:30+10:00",
        "offset" : 0,
        "parameter" : [
          {
            "name" : "displayLanguage",
            "valueCode" : "en"
          },
          {
            "name" : "count",
            "valueInteger" : 1000
          },
          {
            "name" : "offset",
            "valueInteger" : 0
          },
          {
            "name" : "excludeNested",
            "valueBoolean" : false
          },
          {
            "name" : "system-version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107"
          },
          {
            "name" : "used-codesystem",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          },
          {
            "name" : "version",
            "valueUri" : "http://snomed.info/sct|http://snomed.info/sct/32506021000036107/version/20251031"
          }
        ],
        "contains" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "933506231000036108",
            "display" : "Regular heart rhythm"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "361137007",
            "display" : "Irregular heart rhythm"
          }
        ]
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "BodyHeightTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8302-2"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "50373000"
          }
        ],
        "text" : "Height"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-height-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "cm",
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "BodyHeightLengthTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8302-2"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "50373000"
          }
        ],
        "text" : "Height"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-lengthheight-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "cm",
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "BodyWeightTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "29463-7"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "27113001"
          }
        ],
        "text" : "Weight"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-weight-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "kg",
        "system" : "http://unitsofmeasure.org",
        "code" : "kg"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "WaistCircumferenceTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8280-0"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "276361009"
          }
        ],
        "text" : "Waist circumference"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-waistcircumference-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "cm",
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "HeadCircumferenceTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "9843-4"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "363812007"
          }
        ],
        "text" : "Head circumference"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-headcircumference-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value"
            }
          ]
        },
        "unit" : "cm",
        "system" : "http://unitsofmeasure.org",
        "code" : "cm"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "HeartRateTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8867-4"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "364075005"
          }
        ],
        "text" : "Heart rate"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-heartrate-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueQuantity" : {
        "_value" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "$this.answer.value.toDecimal()"
            }
          ]
        },
        "unit" : "/min",
        "system" : "http://unitsofmeasure.org",
        "code" : "/min"
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "HeartRhythmTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8884-9"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "364074009"
          }
        ],
        "text" : "Heart rhythm"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='obs-heartrhythm-newdate').answer.value.toDateTime()"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                "valueString" : "$this.answer.value"
              }
            ]
          }
        ]
      }
    },
    {
      "resourceType" : "Observation",
      "id" : "BloodPressureTemplate",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs"
            }
          ]
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "85354-9"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "75367002"
          }
        ],
        "text" : "Blood pressure"
      },
      "subject" : {
        "_reference" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
              "valueString" : "%resource.subject.reference"
            }
          ]
        }
      },
      "_effectiveDateTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
            "valueString" : "%resource.repeat(item).where(linkId='bp-newbp-date').answer.value.toDateTime()"
          }
        ]
      },
      "component" : [
        {
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "8480-6"
              },
              {
                "system" : "http://snomed.info/sct",
                "code" : "271649006"
              }
            ],
            "text" : "Systolic"
          },
          "valueQuantity" : {
            "_value" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                  "valueString" : "$this.answer.value.toDecimal()"
                }
              ]
            },
            "unit" : "mm[Hg]",
            "system" : "http://unitsofmeasure.org",
            "code" : "mm[Hg]"
          }
        },
        {
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "8462-4"
              },
              {
                "system" : "http://snomed.info/sct",
                "code" : "271650006"
              }
            ],
            "text" : "Diastolic"
          },
          "valueQuantity" : {
            "_value" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtractValue",
                  "valueString" : "%resource.repeat(item).where(linkId='bp-newbp-diastolic').answer.value.toDecimal()"
                }
              ]
            },
            "unit" : "mm[Hg]",
            "system" : "http://unitsofmeasure.org",
            "code" : "mm[Hg]"
          }
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assemble-expectation",
      "valueCode" : "assemble-child"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "patient"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Patient"
        },
        {
          "url" : "description",
          "valueString" : "The patient that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "user"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Practitioner"
        },
        {
          "url" : "description",
          "valueString" : "The practitioner user that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "extension" : [
        {
          "url" : "name",
          "valueCoding" : {
            "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/launchContext",
            "code" : "encounter"
          }
        },
        {
          "url" : "type",
          "valueCode" : "Encounter"
        },
        {
          "url" : "description",
          "valueString" : "The encounter that is to be used to pre-populate the form"
        }
      ],
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-launchContext"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembleContext",
      "valueString" : "ObsBloodPressure"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembleContext",
      "valueString" : "ObsBloodPressureLatest"
    },
    {
      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-assembleContext",
      "valueString" : "age"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsWaistCircumference",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=8280-0&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRate",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=8867-4&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRhythm",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=364074009&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyHeight",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=8302-2&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyWeight",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=29463-7&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeadCircumference",
        "language" : "application/x-fhir-query",
        "expression" : "Observation?code=9843-4&_sort=-date&patient={{%patient.id}}"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsWaistCircumferenceLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsWaistCircumference.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRateLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRate.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRhythmLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRhythm.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyHeightLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyHeight.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyWeightLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyWeight.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeadCircumferenceLatest",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeadCircumference.entry.resource.where(status = 'final' or status = 'amended' or status = 'corrected').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyHeightValue",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyHeightLatest.value.where(exists(system='http://unitsofmeasure.org' and code='cm')).value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyHeightDateString",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyHeightLatest.effective.toDate().toString()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyHeightDateFormatted",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyHeightDateString.substring(8,2).toInteger().toString() + ' ' + %ObsBodyHeightDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsBodyHeightDateString.substring(0,4)"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyWeightValue",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyWeightLatest.value.where(exists(system='http://unitsofmeasure.org' and code='kg')).value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyWeightDateString",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyWeightLatest.effective.toDate().toString()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBodyWeightDateFormatted",
        "language" : "text/fhirpath",
        "expression" : "%ObsBodyWeightDateString.substring(8,2).toInteger().toString() + ' ' + %ObsBodyWeightDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsBodyWeightDateString.substring(0,4)"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeadCircumferenceValue",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeadCircumferenceLatest.value.where(exists(system='http://unitsofmeasure.org' and code='cm')).value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeadCircumferenceDateString",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeadCircumferenceLatest.effective.toDate().toString()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeadCircumferenceDateFormatted",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeadCircumferenceDateString.substring(8,2).toInteger().toString() + ' ' + %ObsHeadCircumferenceDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsHeadCircumferenceDateString.substring(0,4)"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsWaistCircumferenceValue",
        "language" : "text/fhirpath",
        "expression" : "%ObsWaistCircumferenceLatest.value.where(exists(system='http://unitsofmeasure.org' and code='cm')).value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsWaistCircumferenceDateString",
        "language" : "text/fhirpath",
        "expression" : "%ObsWaistCircumferenceLatest.effective.toDate().toString()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsWaistCircumferenceDateFormatted",
        "language" : "text/fhirpath",
        "expression" : "%ObsWaistCircumferenceDateString.substring(8,2).toInteger().toString() + ' ' + %ObsWaistCircumferenceDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsWaistCircumferenceDateString.substring(0,4)"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRateValue",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRateLatest.value.where(exists(system='http://unitsofmeasure.org' and code='/min')).value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRateDateString",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRateLatest.effective.toDate().toString()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRateDateFormatted",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRateDateString.substring(8,2).toInteger().toString() + ' ' + %ObsHeartRateDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsHeartRateDateString.substring(0,4)"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRhythmValue",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRhythmLatest.value.coding.where(system='http://snomed.info/sct').first()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRhythmDateString",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRhythmLatest.effective.toDate().toString()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsHeartRhythmDateFormatted",
        "language" : "text/fhirpath",
        "expression" : "%ObsHeartRhythmDateString.substring(8,2).toInteger().toString() + ' ' + %ObsHeartRhythmDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsHeartRhythmDateString.substring(0,4)"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBloodPressureValue",
        "language" : "text/fhirpath",
        "expression" : "%ObsBloodPressureLatest.component.where(code.coding.exists(code='8480-6')).value.value.round(0).toString() + ' / ' + %ObsBloodPressureLatest.component.where(code.coding.exists(code='8462-4')).value.value.round(0).toString()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBloodPressureDateString",
        "language" : "text/fhirpath",
        "expression" : "%ObsBloodPressureLatest.effective.toDate().toString()"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "ObsBloodPressureDateFormatted",
        "language" : "text/fhirpath",
        "expression" : "%ObsBloodPressureDateString.substring(8,2).toInteger().toString() + ' ' + %ObsBloodPressureDateString.substring(5,2).replace('01','Jan').replace('02','Feb').replace('03','Mar').replace('04','Apr').replace('05','May').replace('06','Jun').replace('07','Jul').replace('08','Aug').replace('09','Sep').replace('10','Oct').replace('11','Nov').replace('12','Dec') + ' ' + %ObsBloodPressureDateString.substring(0,4)"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "weight",
        "language" : "text/fhirpath",
        "expression" : "item.where(linkId='c587e3b6-b91a-40dc-9a16-179342d001e9').item.where(linkId='53d5d5a6-3198-4bec-92ac-03fe7d77fb68').item.where(linkId='97ed4c86-8820-4e4d-9234-0e0e8b6ca44a').item.where(linkId='obs-weight-newresult').answer.value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/variable",
      "valueExpression" : {
        "name" : "height",
        "language" : "text/fhirpath",
        "expression" : "item.where(linkId='c587e3b6-b91a-40dc-9a16-179342d001e9').item.where(linkId='53d5d5a6-3198-4bec-92ac-03fe7d77fb68').item.where(linkId='6226a5c5-b5c3-4ebb-a689-2b286322cfe0').item.where(linkId='obs-height-newresult').answer.value"
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Questionnaire.versionAlgorithm[x]",
      "valueCoding" : {
        "system" : "http://hl7.org/fhir/version-algorithm",
        "code" : "semver"
      }
    }
  ],
  "url" : "http://www.health.gov.au/assessments/mbs/715/Examination",
  "version" : "0.4.0",
  "name" : "Examination",
  "title" : "Aboriginal and Torres Strait Islander Health Check - Examination",
  "status" : "draft",
  "experimental" : false,
  "subjectType" : ["Patient"],
  "date" : "2025-03-14",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "item" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
          "valueExpression" : {
            "language" : "text/fhirpath",
            "expression" : "%age.exists()"
          }
        }
      ],
      "linkId" : "c587e3b6-b91a-40dc-9a16-179342d001e9",
      "text" : "Examination",
      "type" : "group",
      "repeats" : false,
      "item" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-7').answer.value = 'In progress' or %resource.repeat(item).where(linkId='MarkComplete-7').answer.value.empty()"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-in-progress-7",
          "text" : "In progress",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"In progress\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,\r\n\t\tPHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiM3NTc1NzUiIGQ9Im0xNS44NCAxMC4ybC0xLjAxIDEuMDFsLTIuMDctMi4wM2wxLjAxLTEuMDJjLjItLjIxLjU0LS4yMi43OCAwbDEuMjkgMS4yNWMuMjEuMjEuMjIuNTUgMCAuNzlNOCAxMy45MWw0LjE3LTQuMTlsMi4wNyAyLjA4bC00LjE2IDQuMkg4di0yLjA5TTEzIDJ2MmM0LjM5LjU0IDcuNSA0LjUzIDYuOTYgOC45MkE4LjAxNCA4LjAxNCAwIDAgMSAxMyAxOS44OHYyYzUuNS0uNiA5LjQ1LTUuNTQgOC44NS0xMS4wM0MyMS4zMyA2LjE5IDE3LjY2IDIuNSAxMyAybS0yIDBjLTEuOTYuMTgtMy44MS45NS01LjMzIDIuMkw3LjEgNS43NGMxLjEyLS45IDIuNDctMS40OCAzLjktMS42OHYtMk00LjI2IDUuNjdBOS44MSA5LjgxIDAgMCAwIDIuMDUgMTFoMmMuMTktMS40Mi43NS0yLjc3IDEuNjQtMy45TDQuMjYgNS42N00yLjA2IDEzYy4yIDEuOTYuOTcgMy44MSAyLjIxIDUuMzNsMS40Mi0xLjQzQTguMDAyIDguMDAyIDAgMCAxIDQuMDYgMTNoLTJtNSA1LjM3bC0xLjM5IDEuMzdBOS45OTQgOS45OTQgMCAwIDAgMTEgMjJ2LTJhOC4wMDIgOC4wMDIgMCAwIDEtMy45LTEuNjNoLS4wNFoiLz48L3N2Zz4=' \r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-7').answer.value = 'Complete'"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-complete-7",
          "text" : "Complete",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"Complete\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjQgMjQiPjxwYXRoIGZpbGw9IiMyZTdkMzIiIGQ9Ik0yMCAxMmE4IDggMCAwIDEtOCA4YTggOCAwIDAgMS04LThhOCA4IDAgMCAxIDgtOGMuNzYgMCAxLjUuMTEgMi4yLjMxbDEuNTctMS41N0E5LjgyMiA5LjgyMiAwIDAgMCAxMiAyQTEwIDEwIDAgMCAwIDIgMTJhMTAgMTAgMCAwIDAgMTAgMTBhMTAgMTAgMCAwIDAgMTAtMTBNNy45MSAxMC4wOEw2LjUgMTEuNUwxMSAxNkwyMSA2bC0xLjQxLTEuNDJMMTEgMTMuMTdsLTMuMDktMy4wOVoiLz48L3N2Zz4='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%resource.repeat(item).where(linkId='MarkComplete-7').answer.value = 'Attention required'"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireItemControlExtended",
                    "code" : "context-display"
                  }
                ]
              }
            }
          ],
          "linkId" : "CD-attention-7",
          "text" : "Attention required",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div title=\"Attention required\" xmlns=\"http://www.w3.org/1999/xhtml\">\r\n\t<div style=\"display: flex; flex-direction: row;\">\r\n\t\t<img width='24' height='24' src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAxMDAgMTAwIj48Y2lyY2xlIGN4PSI1MCIgY3k9IjUwIiByPSI0MiIgZmlsbD0ibm9uZSIgc3Ryb2tlPSIjRkZD MTA3IiBzdHJva2Utd2lkdGg9IjgiLz48bGluZSB4MT0iNTAiIHkxPSIyOCIgeDI9IjUwIiB5Mj0iNjAiIHN0cm9rZT0iI0ZGQzEwNyIgc3Ryb2tlLXdpZHRoPSI4Ii8+PGNpcmNsZSBjeD0iNTAiIGN5PSI3NCIgcj0iNSIgZmlsbD0iI0ZGQzEwNyIvPjwvc3ZnPg=='\r\n\t\tstyle=\"align-self: center;\"/>\r\n\t</div>\r\n</div>"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 12"
              }
            }
          ],
          "linkId" : "d15824f8-eafc-4fa0-80a2-82f0ec7f8728",
          "text" : "Growth measures recorded on Centers for Disease Control and Prevention (CDC) and World Health Organization (WHO) growth charts for centile and tracking overtime",
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "grid"
                  }
                ]
              }
            }
          ],
          "linkId" : "53d5d5a6-3198-4bec-92ac-03fe7d77fb68",
          "text" : "The tabled observations will display the most recent results available from the patient record. New observations may be added.",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-xhtml",
                "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p style=\"font-size:0.9em; font-weight:normal\"><em>The tabled observations will display the most recent results available from the patient record. New observations may be added.</em></p></div>"
              }
            ]
          },
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 5"
                  }
                }
              ],
              "linkId" : "4e32e9b2-82e6-41ea-9545-79e928f7d6c2",
              "text" : "Length/Height",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "837cd0ce-4a9e-4c8b-8679-007ed961f121",
                  "text" : "Last result",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                        "valueExpression" : {
                          "language" : "text/fhirpath",
                          "expression" : "iif(%ObsBodyHeightValue.exists() and %ObsBodyHeightDateFormatted.exists(), %ObsBodyHeightValue.round(0).toString() + ' cm ( ' + %ObsBodyHeightDateFormatted + ' )', 'Not available')"
                        }
                      },
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                        "valueString" : "text-align: left;"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsBodyHeightValue"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "cm"
                      }
                    }
                  ],
                  "linkId" : "obs-lengthheight-lastresult",
                  "type" : "decimal",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsBodyHeightLatest.effective.toDate()"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "obs-lengthheight-lastdate",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#BodyHeightLengthTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "cm"
                      }
                    }
                  ],
                  "linkId" : "obs-lengthheight-newresult",
                  "text" : "New result",
                  "type" : "decimal",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "obslengthheight-newresult-unit",
                      "text" : "cm",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%resource.repeat(item).where(linkId='obs-lengthheight-newresult').answer.value.exists(), today())"
                      }
                    }
                  ],
                  "linkId" : "obs-lengthheight-newdate",
                  "text" : "New result date",
                  "type" : "date",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 5"
                  }
                }
              ],
              "linkId" : "6226a5c5-b5c3-4ebb-a689-2b286322cfe0",
              "text" : "Height",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "7035c7e7-ada3-4c6b-9ea8-f39666f5d4ea",
                  "text" : "Last result",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                        "valueExpression" : {
                          "language" : "text/fhirpath",
                          "expression" : "iif(%ObsBodyHeightValue.exists() and %ObsBodyHeightDateFormatted.exists(), %ObsBodyHeightValue.round(0).toString() + ' cm ( ' + %ObsBodyHeightDateFormatted + ' )', 'Not available')"
                        }
                      },
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                        "valueString" : "text-align: left;"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsBodyHeightValue"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "cm"
                      }
                    }
                  ],
                  "linkId" : "obs-height-lastresult",
                  "type" : "decimal",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsBodyHeightLatest.effective.toDate()"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "obs-height-lastdate",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#BodyHeightTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "cm"
                      }
                    }
                  ],
                  "linkId" : "obs-height-newresult",
                  "text" : "New result",
                  "type" : "decimal",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "obs-height-newresult-unit",
                      "text" : "cm",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%resource.repeat(item).where(linkId='obs-height-newresult').answer.value.exists(), today())"
                      }
                    }
                  ],
                  "linkId" : "obs-height-newdate",
                  "text" : "New result date",
                  "type" : "date",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "97ed4c86-8820-4e4d-9234-0e0e8b6ca44a",
              "text" : "Weight",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "443bd584-684a-449c-ab6e-9d07da4df9fa",
                  "text" : "Last result",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                        "valueExpression" : {
                          "language" : "text/fhirpath",
                          "expression" : "iif(%ObsBodyWeightValue.exists() and %ObsBodyWeightDateFormatted.exists(), %ObsBodyWeightValue.round(1).toString() + ' kg ( ' + %ObsBodyWeightDateFormatted + ' )', 'Not available')"
                        }
                      },
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                        "valueString" : "text-align: left;"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsBodyWeightValue"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "kg"
                      }
                    }
                  ],
                  "linkId" : "obs-weight-lastresult",
                  "type" : "decimal",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsBodyWeightLatest.effective.toDate()"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "obs-weight-lastdate",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#BodyWeightTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "kg"
                      }
                    }
                  ],
                  "linkId" : "obs-weight-newresult",
                  "text" : "New result",
                  "type" : "decimal",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "obs-weight-newresult-unit",
                      "text" : "kg",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%resource.repeat(item).where(linkId='obs-weight-newresult').answer.value.exists(), today())"
                      }
                    }
                  ],
                  "linkId" : "obs-weight-newdate",
                  "text" : "New result date",
                  "type" : "date",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age > 12"
                  }
                }
              ],
              "linkId" : "bc209c5e-ed28-48e3-b1a1-55cb7e435d8b",
              "text" : "BMI (calculated)",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "2ada6633-03c6-4b05-bc23-18dec84ec150",
                  "text" : "Last result",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                        "valueExpression" : {
                          "language" : "text/fhirpath",
                          "expression" : "iif(%ObsBodyWeightValue.exists() and %ObsBodyHeightValue.exists(), (%ObsBodyWeightValue/((%ObsBodyHeightValue/100).power(2))).round(1).toString() + ' kg/m2', 'Not available')"
                        }
                      },
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                        "valueString" : "text-align: left;"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "(%ObsBodyWeightValue/((%ObsBodyHeightValue/100).power(2))).round(1)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "kg/m2"
                      }
                    }
                  ],
                  "linkId" : "obs-bmi-lastresult",
                  "type" : "decimal",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "description" : "BMI calculation",
                        "language" : "text/fhirpath",
                        "expression" : "(%weight/((%height/100).power(2))).round(1)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "kg/m2"
                      }
                    }
                  ],
                  "linkId" : "obs-bmi-newresult",
                  "text" : "New result",
                  "type" : "decimal",
                  "repeats" : false,
                  "readOnly" : true,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "obs-bmi-newresult-unit",
                      "text" : "kg/m2",
                      "type" : "display"
                    }
                  ]
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age <= 12"
                  }
                }
              ],
              "linkId" : "d3557f55-1abf-401c-aada-2d4380151c56",
              "text" : "Head circumference",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "7a4a6aac-558e-4bec-86c5-326ae07e37d6",
                  "text" : "Last result",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                        "valueExpression" : {
                          "language" : "text/fhirpath",
                          "expression" : "iif(%ObsHeadCircumferenceValue.exists() and %ObsHeadCircumferenceDateFormatted.exists(), %ObsHeadCircumferenceValue.round(0).toString() + ' cm ( ' + %ObsHeadCircumferenceDateFormatted + ' )', 'Not available')"
                        }
                      },
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                        "valueString" : "text-align: left;"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsHeadCircumferenceValue"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "cm"
                      }
                    }
                  ],
                  "linkId" : "obs-headcircumference-lastresult",
                  "type" : "decimal",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsHeadCircumferenceLatest.effective.toDate()"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "obs-headcircumference-lastdate",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#HeadCircumferenceTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "cm"
                      }
                    }
                  ],
                  "linkId" : "obs-headcircumference-newresult",
                  "text" : "New result",
                  "type" : "decimal",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "obs-headcircumference-newresult-unit",
                      "text" : "cm",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%resource.repeat(item).where(linkId='obs-headcircumference-newresult').answer.value.exists(), today())"
                      }
                    }
                  ],
                  "linkId" : "obs-headcircumference-newdate",
                  "text" : "New result date",
                  "type" : "date",
                  "repeats" : false
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
                  "valueExpression" : {
                    "language" : "text/fhirpath",
                    "expression" : "%age >= 18"
                  }
                }
              ],
              "linkId" : "ec884b64-ed8d-485b-930f-e7ac18ad4cc9",
              "text" : "Waist circumference",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "8df0f5d8-821d-4f71-b3c1-d164616ea2f5",
                  "text" : "Last result",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                        "valueExpression" : {
                          "language" : "text/fhirpath",
                          "expression" : "iif(%ObsWaistCircumferenceValue.exists() and %ObsWaistCircumferenceDateFormatted.exists(), %ObsWaistCircumferenceValue.round(0).toString() + ' cm ( ' + %ObsWaistCircumferenceDateFormatted + ' )', 'Not available')"
                        }
                      },
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                        "valueString" : "text-align: left;"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsWaistCircumferenceValue"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "cm"
                      }
                    }
                  ],
                  "linkId" : "obs-waistcircumference-lastresult",
                  "type" : "decimal",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsWaistCircumferenceLatest.effective.toDate()"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "obs-waistcircumference-lastdate",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#WaistCircumferenceTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    }
                  ],
                  "linkId" : "obs-waistcircumference-newresult",
                  "text" : "New result",
                  "type" : "decimal",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "obs-waistcircumference-newresult-unit",
                      "text" : "cm",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%resource.repeat(item).where(linkId='obs-waistcircumference-newresult').answer.value.exists(), today())"
                      }
                    }
                  ],
                  "linkId" : "obs-waistcircumference-newdate",
                  "text" : "New result date",
                  "type" : "date",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "3d3e1079-d225-447b-959b-4caddc057f7d",
              "text" : "Heart rate",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "49029ef0-eaa8-44f8-b26a-177820c82dfd",
                  "text" : "Last result",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                        "valueExpression" : {
                          "language" : "text/fhirpath",
                          "expression" : "iif(%ObsHeartRateValue.exists() and %ObsHeartRateDateFormatted.exists(), %ObsHeartRateValue.round(0).toString() + ' /min ( ' + %ObsHeartRateDateFormatted + ' )', 'Not available')"
                        }
                      },
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                        "valueString" : "text-align: left;"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsHeartRateValue"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "/min"
                      }
                    }
                  ],
                  "linkId" : "obs-heartrate-lastresult",
                  "type" : "integer",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsHeartRateLatest.effective.toDate()"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "obs-heartrate-lastdate",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#HeartRateTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "/min"
                      }
                    }
                  ],
                  "linkId" : "obs-heartrate-newresult",
                  "text" : "New result",
                  "type" : "integer",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "obs-heartrate-newresult-unit",
                      "text" : "/min",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%resource.repeat(item).where(linkId='obs-heartrate-newresult').answer.value.exists(), today())"
                      }
                    }
                  ],
                  "linkId" : "obs-heartrate-newdate",
                  "text" : "New result date",
                  "type" : "date",
                  "repeats" : false
                }
              ]
            },
            {
              "linkId" : "8d3d05cc-64bc-47ae-b989-060bac838d1c",
              "text" : "Heart rhythm",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "99a8eb6f-a36a-4daf-99d7-27bfde0d4bb1",
                  "text" : "Last result",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                        "valueExpression" : {
                          "language" : "text/fhirpath",
                          "expression" : "iif(%ObsHeartRhythmValue.exists() and %ObsHeartRhythmDateFormatted.exists(), %ObsHeartRhythmValue.display + ' ( ' + %ObsHeartRhythmDateFormatted + ' )', 'Not available')"
                        }
                      },
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                        "valueString" : "text-align: left;"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsHeartRhythmValue"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "obs-heartrhythm-lastresult",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#heart-rhythm-1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsHeartRhythmLatest.effective.toDate()"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "obs-heartrhythm-lastdate",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#HeartRhythmTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                      "valueCodeableConcept" : {
                        "coding" : [
                          {
                            "system" : "http://hl7.org/fhir/questionnaire-item-control",
                            "code" : "radio-button"
                          }
                        ]
                      }
                    }
                  ],
                  "linkId" : "obs-heartrhythm-newresult",
                  "text" : "New result",
                  "type" : "choice",
                  "repeats" : false,
                  "answerValueSet" : "#heart-rhythm-1"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%resource.repeat(item).where(linkId='obs-heartrhythm-newresult').answer.value.exists(), today())"
                      }
                    }
                  ],
                  "linkId" : "obs-heartrhythm-newdate",
                  "text" : "New result date",
                  "type" : "date",
                  "repeats" : false
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age > 12"
              }
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "grid"
                  }
                ]
              }
            }
          ],
          "linkId" : "3639c586-9576-48d3-a52b-e91fd2138581",
          "text" : "Blood pressure",
          "_text" : {
            "extension" : [
              {
                "url" : "https://smartforms.csiro.au/ig/StructureDefinition/QuestionnaireItemTextHidden",
                "valueBoolean" : true
              }
            ]
          },
          "type" : "group",
          "repeats" : false,
          "item" : [
            {
              "linkId" : "705f6d04-acab-4d14-baab-98f9bfc4808e",
              "text" : "Blood pressure",
              "type" : "group",
              "repeats" : false,
              "item" : [
                {
                  "linkId" : "bp-bp-lastresult",
                  "text" : "Last result",
                  "_text" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/cqf-expression",
                        "valueExpression" : {
                          "language" : "text/fhirpath",
                          "expression" : "iif(%ObsBloodPressureValue.exists() and %ObsBloodPressureDateFormatted.exists(), %ObsBloodPressureValue + ' mm Hg ( ' + %ObsBloodPressureDateFormatted + ' )', 'Not available')"
                        }
                      },
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                        "valueString" : "text-align: left;"
                      }
                    ]
                  },
                  "type" : "display"
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsBloodPressureLatest.component.where(code.coding.exists(code='8480-6')).value.value.round(0)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "mm[Hg]"
                      }
                    }
                  ],
                  "linkId" : "bp-lastbp-systolic",
                  "type" : "integer",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsBloodPressureLatest.component.where(code.coding.exists(code='8462-4')).value.value.round(0)"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "mm[Hg]"
                      }
                    }
                  ],
                  "linkId" : "bp-lastbp-diastolic",
                  "type" : "integer",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "%ObsBloodPressureLatest.effective.toDate()"
                      }
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden",
                      "valueBoolean" : true
                    }
                  ],
                  "linkId" : "bp-lastbp-date",
                  "type" : "date",
                  "repeats" : false
                },
                {
                  "extension" : [
                    {
                      "extension" : [
                        {
                          "url" : "template",
                          "valueReference" : {
                            "reference" : "#BloodPressureTemplate"
                          }
                        }
                      ],
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-templateExtract"
                    },
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "mm[Hg]"
                      }
                    }
                  ],
                  "linkId" : "bp-newbp-systolic",
                  "text" : "Systolic",
                  "type" : "integer",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "bp-newbp-systolic-unit",
                      "text" : "mm Hg",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-unit",
                      "valueCoding" : {
                        "system" : "http://unitsofmeasure.org",
                        "code" : "mm[Hg]"
                      }
                    }
                  ],
                  "linkId" : "bp-newbp-diastolic",
                  "text" : "Diastolic",
                  "type" : "integer",
                  "repeats" : false,
                  "item" : [
                    {
                      "extension" : [
                        {
                          "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
                          "valueCodeableConcept" : {
                            "coding" : [
                              {
                                "system" : "http://hl7.org/fhir/questionnaire-item-control",
                                "code" : "unit"
                              }
                            ]
                          }
                        }
                      ],
                      "linkId" : "bp-newbp-diastolic-unit",
                      "text" : "mm Hg",
                      "type" : "display"
                    }
                  ]
                },
                {
                  "extension" : [
                    {
                      "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-calculatedExpression",
                      "valueExpression" : {
                        "language" : "text/fhirpath",
                        "expression" : "iif(%resource.repeat(item).where(linkId='bp-newbp-systolic').answer.value.exists() or %resource.repeat(item).where(linkId='bp-newbp-diastolic').answer.value.exists(), today())"
                      }
                    }
                  ],
                  "linkId" : "bp-newbp-date",
                  "text" : "Date performed",
                  "type" : "date",
                  "repeats" : false
                }
              ]
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 12"
              }
            }
          ],
          "linkId" : "213a3eac-e530-4e27-859c-407136c7a0a6",
          "text" : "Cardiac auscultation",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 12"
              }
            }
          ],
          "linkId" : "8886f3bb-52de-4294-a5cb-8f960e2a6bbe",
          "text" : "Abdominal examination",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 12"
              }
            }
          ],
          "linkId" : "5e10229c-390d-4968-90d3-f896840f3c50",
          "text" : "Gait examination (musculoskeletal structure, balance, coordination)",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age < 1"
              }
            }
          ],
          "linkId" : "6c69ee91-f777-494c-bf09-d963773cd4ae",
          "text" : "Newborn examination (if indicated, infant aged <=6 weeks)",
          "type" : "text",
          "repeats" : false
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-enableWhenExpression",
              "valueExpression" : {
                "language" : "text/fhirpath",
                "expression" : "%age <= 12"
              }
            }
          ],
          "linkId" : "7a431d03-1726-4905-aae7-49f62a10ce5e",
          "text" : "Haemoglobin (children at risk of iron deficiency anaemia)",
          "type" : "string",
          "repeats" : false
        },
        {
          "linkId" : "fcbfa6e1-c101-4675-969d-aa11027859c2",
          "text" : "Health priorities, actions and follow-up",
          "type" : "text",
          "repeats" : false
        },
        {
          "linkId" : "examination-section-end-divider",
          "_text" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/rendering-style",
                "valueString" : "border-top: 1px solid #ccc;"
              }
            ]
          },
          "type" : "display"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/questionnaire-item-control",
                    "code" : "radio-button"
                  }
                ]
              }
            }
          ],
          "linkId" : "MarkComplete-7",
          "text" : "Section completion status",
          "type" : "choice",
          "repeats" : false,
          "answerOption" : [
            {
              "valueString" : "Complete"
            },
            {
              "valueString" : "In progress"
            },
            {
              "valueString" : "Attention required"
            }
          ]
        }
      ]
    }
  ]
}

```
