# chloramphenicol-pat-sf - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **chloramphenicol-pat-sf**

## Example MedicationStatement: chloramphenicol-pat-sf

Profile: [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md)

**status**: Active

**medication**: Chloramphenicol 1% eye ointment

**subject**: [Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)

**dateAsserted**: 2024-02-05

**reasonCode**: Bacterial conjunctivitis

### Dosages

| | |
| :--- | :--- |
| - | **Text** |
| * | Apply 1 drop to each eye every 2 hours for 7 days |



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "chloramphenicol-pat-sf",
  "meta" : {
    "profile" : [
      "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedicationStatement"
    ]
  },
  "status" : "active",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "22717011000036101",
        "display" : "Chloramphenicol 1% eye ointment"
      }
    ],
    "text" : "Chloramphenicol 1% eye ointment"
  },
  "subject" : {
    "reference" : "Patient/pat-sf"
  },
  "dateAsserted" : "2024-02-05",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "128350005"
        }
      ],
      "text" : "Bacterial conjunctivitis"
    }
  ],
  "dosage" : [
    {
      "text" : "Apply 1 drop to each eye every 2 hours for 7 days"
    }
  ]
}

```
