# fever-pat-sf - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **fever-pat-sf**

## Example Condition: fever-pat-sf

Profile: [Smart Health Checks Condition](StructureDefinition-SHCCondition.md)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Problem List Item

**severity**: Moderate

**code**: Remittent fever

**subject**: [Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)

**onset**: 2015-02-11 00:00:00+0000

**recordedDate**: 2015-02-12

**recorder**: [Practitioner Peter Primary](Practitioner-primary-peter.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "fever-pat-sf",
  "meta" : {
    "profile" : [
      "https://smartforms.csiro.au/ig/StructureDefinition/SHCCondition"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ],
    "text" : "Confirmed"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "problem-list-item"
        }
      ]
    }
  ],
  "severity" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "6736007",
        "display" : "Moderate"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "63993003",
        "display" : "Remittent fever"
      }
    ],
    "text" : "Remittent fever"
  },
  "subject" : {
    "reference" : "Patient/pat-sf"
  },
  "onsetDateTime" : "2015-02-11T00:00:00.000Z",
  "recordedDate" : "2015-02-12",
  "recorder" : {
    "reference" : "Practitioner/primary-peter"
  }
}

```
