# Smart Health Checks Patch Element Path Codes - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Patch Element Path Codes**

## CodeSystem: Smart Health Checks Patch Element Path Codes 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/CodeSystem/SHCPatchElementPathCodes | *Version*:0.4.0 |
| Draft as of 2025-12-18 | *Computable Name*:SHCPatchElementPathCodes |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The Smart Health Checks Patch Element Path Codes code system defines concepts that identify element paths where the patch operation is to be performed for Smart Health Checks. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SHCPatchAllergyIntoleranceElementPath](ValueSet-SHCPatchAllergyIntoleranceElementPath.md)
* [SHCPatchConditionElementPath](ValueSet-SHCPatchConditionElementPath.md)
* [SHCPatchMedicationStatementElementPath](ValueSet-SHCPatchMedicationStatementElementPath.md)
* [SHCPatchPath](ValueSet-SHCPatchPath.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "SHCPatchElementPathCodes",
  "url" : "https://smartforms.csiro.au/ig/CodeSystem/SHCPatchElementPathCodes",
  "version" : "0.4.0",
  "name" : "SHCPatchElementPathCodes",
  "title" : "Smart Health Checks Patch Element Path Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-18T05:29:19+00:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "The Smart Health Checks Patch Element Path Codes code system defines concepts that identify element paths where the patch operation is to be performed for Smart Health Checks.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 6,
  "concept" : [
    {
      "code" : "AllergyIntolerance",
      "display" : "AllergyIntolerance"
    },
    {
      "code" : "AllergyIntolerance.note[0]",
      "display" : "AllergyIntolerance.note[0]"
    },
    {
      "code" : "Condition",
      "display" : "Condition"
    },
    {
      "code" : "MedicationStatement",
      "display" : "MedicationStatement"
    },
    {
      "code" : "MedicationStatement.note[0]",
      "display" : "MedicationStatement.note[0]"
    },
    {
      "code" : "MedicationStatement.dosage[0]",
      "display" : "MedicationStatement.dosage[0]"
    }
  ]
}

```
