# SHC App - Smart Health Checks v0.4.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SHC App**

## CapabilityStatement: SHC App 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/CapabilityStatement/SHCAppCapabilityStatement | *Version*:0.4.0 |
| Draft as of 2025-04-16 | *Computable Name*:SHCApp |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This CapabilityStatement describes the capabilities of the SHC App. These capabilities include supported FHIR profiles, RESTful operations, and search parameters. It covers supported tasks such as SMART App launch context, prepopulation, write-back of extracted resources and completion of forms. 

 [Raw OpenAPI-Swagger Definition file](SHCAppCapabilityStatement.openapi.json) | [Download](SHCAppCapabilityStatement.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "SHCAppCapabilityStatement",
  "url" : "https://smartforms.csiro.au/ig/CapabilityStatement/SHCAppCapabilityStatement",
  "version" : "0.4.0",
  "name" : "SHCApp",
  "title" : "SHC App",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-04-16",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This CapabilityStatement describes the capabilities of the SHC App. These capabilities include supported FHIR profiles, RESTful operations, and search parameters. It covers supported tasks such as SMART App launch context, prepopulation, write-back of extracted resources and completion of forms.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "kind" : "capability",
  "instantiates" : [
    "http://hl7.org/fhir/uv/sdc/CapabilityStatement/sdc-form-filler",
    "http://hl7.org.au/fhir/core/CapabilityStatement/au-core-requester"
  ],
  "software" : {
    "name" : "Smart Health Checks Application"
  },
  "fhirVersion" : "4.0.1",
  "format" : ["json"],
  "patchFormat" : ["application/fhir+json"],
  "implementationGuide" : [
    "http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch|2.2.0"
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "The SHC App performs interactions to support SMART App Launch, form prepopulation, write-back of extracted resources and form filling.",
      "security" : {
        "cors" : true,
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "SMART-on-FHIR"
              }
            ]
          }
        ],
        "description" : "SMART App Launch supported to allow secure data exchange."
      },
      "resource" : [
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "AllergyIntolerance",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCAllergyIntolerance"
          ],
          "documentation" : "The client supports the AllergyIntolerance resource, the Smart Health Checks profile and the conformance expectations for the AllergyIntolerance resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            },
            {
              "code" : "patch"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "type" : "Bundle",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCExtractBundle"
          ],
          "documentation" : "The client supports the Bundle resource, the Smart Health Checks profile listed and the conformance expectations for the Bundle resource."
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "category"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Condition",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCCondition"
          ],
          "documentation" : "The client supports the Condition resource, the Smart Health Checks and the conformance expectations for the Condition resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            },
            {
              "code" : "patch"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both."
            },
            {
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Condition-category",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values. \n\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "type" : "Encounter",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCEncounter"
          ],
          "documentation" : "The client supports the Encounter resource, the Smart Health Checks profile and the conformance expectations for the Encounter resource.",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Immunization",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCImmunization"
          ],
          "documentation" : "The client supports the Immunization resource, the Smart Health Checks profile and the conformance expectations for the Immunization resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both."
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/Immunization-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values. \n\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "type" : "Medication",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedication"
          ],
          "documentation" : "The client supports the Medication resource, the Smart Health Checks profile and the conformance expectations for the Medication resource.",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                },
                {
                  "url" : "required",
                  "valueString" : "_include"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "MedicationStatement",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedicationStatement"
          ],
          "documentation" : "The client supports the MedicationStatement resource, the Smart Health Checks profile and the conformance expectations for the MedicationStatement resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            },
            {
              "code" : "patch"
            }
          ],
          "searchInclude" : ["MedicationStatement:medication"],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both."
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/medications-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values.\n\nThe server **SHALL** support both.\n\nThe client **SHALL** support `multipleOr`.\n\nThe server **SHALL** support `multipleOr`."
            },
            {
              "name" : "_include",
              "type" : "reference",
              "documentation" : "If a medication in a MedicationStatement resource is represented as an external Medication resource reference, the server **SHALL** support the `_include` parameter for searching this element (`MedicationStatement:medication`).\n\nThe client **SHALL** support this method."
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "code"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Observation",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBloodPressure",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyHeight",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyWeight",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeadCircumference",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRate",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRhythm",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPathologyResult",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCSmokingStatus",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCWaistCircumference"
          ],
          "documentation" : "The client supports the Observation resource, the Smart Health Checks profiles listed and the conformance expectations for the Observation resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both. "
            },
            {
              "name" : "code",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-code",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the code and system values. \n\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_sort",
              "type" : "string",
              "documentation" : "The client and server **SHALL** support search result sorting by date and **MAY** support other values."
            }
          ]
        },
        {
          "type" : "Parameters",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchCondition",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          ],
          "_supportedProfile" : [
            null,
            null,
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The client supports the Parameters resource, the Smart Health Checks profiles listed and the conformance expectations for the Parameters resource."
        },
        {
          "type" : "Patient",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatient"
          ],
          "documentation" : "The client supports the Patient resource, Smart Health Checks profile and the conformance expectations for the Patient resource.",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPractitioner"
          ],
          "documentation" : "The client supports the Practitioner resource, Smart Health Checks profile and the conformance expectations for the Practitioner resource.",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "url"
                },
                {
                  "url" : "required",
                  "valueString" : "version"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "title"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Questionnaire",
          "profile" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire",
          "documentation" : "The client supports the Questionnaire resource, Structured Data Capture profile and the conformance expectations for the Questionnaire resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            }
          ],
          "searchParam" : [
            {
              "name" : "url",
              "definition" : "http://hl7.org/fhir/SearchParameter/Questionnaire-url",
              "type" : "uri"
            },
            {
              "name" : "version",
              "definition" : "http://hl7.org/fhir/SearchParameter/Questionnaire-version",
              "type" : "token"
            },
            {
              "name" : "title",
              "definition" : "http://hl7.org/fhir/SearchParameter/Questionnaire-title",
              "type" : "string",
              "documentation" : "The client supports search using the :contains modifier."
            },
            {
              "name" : "_count",
              "type" : "number",
              "documentation" : "The client supports search result limiting."
            },
            {
              "name" : "_sort",
              "type" : "string",
              "documentation" : "The client supports search result sorting by date and **MAY** support other values."
            }
          ],
          "operation" : [
            {
              "name" : "assemble",
              "definition" : "http://hl7.org/fhir/uv/sdc/OperationDefinition/Questionnaire-assemble"
            },
            {
              "name" : "populate",
              "definition" : "http://hl7.org/fhir/uv/sdc/OperationDefinition/Questionnaire-populate"
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                },
                {
                  "url" : "required",
                  "valueString" : "questionnaire"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "QuestionnaireResponse",
          "profile" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCQuestionnaireResponse",
          "documentation" : "The client supports the QuestionnaireResponse resource, Smart Health Checks profile and the conformance expectations for the QuestionnaireResponse resource.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            },
            {
              "code" : "update"
            }
          ],
          "versioning" : "versioned-update",
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both. "
            },
            {
              "name" : "questionnaire",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-questionnaire",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \n\nThe server **SHALL** support both.\n\nThe client and server **SHALL** support chained search questionnaire.title using the :contains modifier."
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the code and system values. \n\nThe server **SHALL** support both."
            },
            {
              "name" : "_count",
              "type" : "number",
              "documentation" : "The client and server **SHALL** support search result limiting."
            },
            {
              "name" : "_sort",
              "type" : "string",
              "documentation" : "The client and server **SHALL** support search result sorting by authored and **MAY** support other values."
            }
          ]
        },
        {
          "type" : "ValueSet",
          "documentation" : "The client supports the ValueSet resource and the conformance expectations for the ValueSet resource.",
          "operation" : [
            {
              "name" : "expand",
              "definition" : "http://hl7.org/fhir/OperationDefinition/ValueSet-expand"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "code" : "transaction"
        },
        {
          "code" : "batch"
        }
      ]
    }
  ]
}

```
