# Resource SHCApp



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "SHCApp",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.url",
      "valueUri" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.version",
      "valueString" : "0.4.0"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.name",
      "valueString" : "SHCApp"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.title",
      "valueString" : "SHC App"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.experimental",
      "valueBoolean" : false
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.date",
      "valueDateTime" : "2025-12-18T05:29:19+00:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.publisher",
      "valueString" : "AEHRC CSIRO"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.contact",
      "valueContactDetail" : {
        "name" : "AEHRC CSIRO",
        "telecom" : [
          {
            "system" : "url",
            "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.description",
      "valueMarkdown" : "The SHC App is a system that a SHC Host can launch allowing a user to fill out a health check form, prepopulated with patient health information retrieved from the SHC Host FHIR Server, and writeback data collected in the form."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.jurisdiction",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.copyright",
      "valueMarkdown" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.type",
      "valueCode" : "system"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.documentation",
      "valueMarkdown" : "The Smart Health Checks (SHC) App: \n- **SHALL** accept [App Launch](https://hl7.org/fhir/smart-app-launch/app-launch.html#launch-app-ehr-launch) request\n- **SHALL** invoke [SMART Authorization Configuration](https://hl7.org/fhir/smart-app-launch/app-launch.html#retrieve-well-knownsmart-configuration) request\n- **SHALL** redirect to [Authorization Request](https://hl7.org/fhir/smart-app-launch/app-launch.html#obtain-authorization-code)\n- **SHALL** accept Authorization Callback request\n- **SHALL** invoke [Token Request](https://hl7.org/fhir/smart-app-launch/app-launch.html#obtain-access-token)\n- **SHALL** authorise FHIR API requests using Bearer access token per [SMART APP Launch Access FHIR API](https://hl7.org/fhir/smart-app-launch/app-launch.html#access-fhir-api)\n- **SHALL** invoke read Practitioner request\n- **SHALL** invoke read Patient request\n- **SHALL** invoke search QuestionnaireResponse request\n- **SHALL** invoke read QuestionnaireResponse request\n- **SHALL** invoke create and update QuestionnaireResponse request\n- **SHALL** invoke search and read requests for resources required by this IG to pre-populate questionnaire response\n- **SHALL** invoke create and patch requests in a transaction Bundle for resources required by this IG"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.capabilities",
      "valueCanonical" : "https://smartforms.csiro.au/ig/CapabilityStatement/SHCAppCapabilityStatement"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.derivedFrom",
      "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "ActorDefinition"
      }
    ]
  }
}

```
