# Home - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* **Home**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

## Home

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/ImplementationGuide/csiro.fhir.au.smartforms | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SmartHealthChecks |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

* [Introduction](#introduction)
* [Smart Health Checks Actors](#smart-health-checks-actors)
* [Smart Health Checks Interactions](#smart-health-checks-interactions)
* [Dependencies](#dependencies)
* [Usage](#usage)
* [How to read this guide](#how-to-read-this-guide)
* [Collaboration](#collaboration)

### Introduction

This implementation guide is provided to support the integration of the Smart Health Checks App within a patient management system enabling users to complete health check assessments such as the Aboriginal and Torres Strait Islander Health Check.

The Smart Health Checks App is a FHIR-based client application aimed at demonstrating effective undertaking of healthcare assessments. It leverages [SMART App Launch](http://www.hl7.org/fhir/smart-app-launch), [Structured Data Capture specification](http://build.fhir.org/ig/HL7/sdc/index.html) and [AU Core](https://hl7.org.au/fhir/core/) to improve clinical workflow, enhance the usefulness of information in the practice record and improve interoperability of health information to support better clinical outcomes.

The Smart Health Checks App is based on the CSIRO Smart Forms App which was provided as a [Reference Implementation](reference-implementation.md) of using FHIR standards and implementation guides to provide reusable software components that can be applied within Australian healthcare software systems to support uses cases such as national health check assessment forms.

### Smart Health Checks Actors

The following figure provides an overview of the actors involved in the Smart Health Checks (SHC) solution.

![](overviewactors.png)

#### SHC App

The SHC App allows a user of the SHC Host to launch the SHC App for filling out a health check form prepopulated with authorized patient health information retrieved from the SHC Host FHIR Server and writeback the collected form data.

The SHC App actor is implemented by the CSIRO Smart Forms App.

#### SHC Host

The SHC Host allows a user to launch the SHC App within an embedded or externally launched web browser to fill out a health check form.

The SHC Host actor is implemented by the patient management system.

#### SHC Host FHIR Server

The SHC Host FHIR Server allows the SHC App to retrieve patient health information and writeback collected health check data.

The SHC Host actor is implemented by the patient management system.

#### SHC Host Authorization Server

The SHC Host Authorization Server allows the SHC App to request authorisation from the user to access patient health information to prepopulate and write back health checks data using the SHC Host FHIR Server.

### Smart Health Checks Interactions

The Smart Health Check App follows a standard set of interactions which are summarised as:

1. App Launch: The SHC User initiates the SHC Host to launch SHC App with a context of the current user, patient and health check form.
1. SMART Authorization Configuration: The SHC App uses SHC Host FHIR Server to locate the SHC Host Authorization Server endpoints and capability.
1. Authorization Request: SHC App redirects to the SHC Host Authorization Server to authorise access to patient health information using the SHC Host FHIR Server. The SHC User may be prompted to permit or deny access to the requested data.
1. Authorization Callback: The SHC Host redirects back to the SHC App to proceed with the authorised launch of the health check form.
1. Token Request: SHC App requests an access token and associated launch context, including user, patient and health check form, from the SHC Host Authorization Server.
1. Prepopulate Health Check: SHC App uses the launch context to use the SHC Host FHIR Server to:
1. read Practitioner;
1. read Patient;
1. read or search QuestionnaireResponse; and
1. various search requests to prepopulate the health check form
![](launchinteractions.png)
1. Fill and Save Health Check: The user fills out the health check form and saves the form data.
1. Writeback Questionnaire Response: The health check form data is written back to the SHC Host FHIR Server as a QuestionnaireResponse.
1. Writeback Extract Transaction: The health check form data extracted from a completed form as FHIR Resources are written back to the SHC Host FHIR Server as transaction Bundle.![](writebackdraftqr.png)![](writebackqrextract.png)

### Dependencies









Smart Forms is also dependent on:

* Terminology published in Australia's [National Clinical Terminology Service](https://www.healthterminologies.gov.au/access-clinical-terminology/access-fhir-terminology-resources/)

In addition, the following FHIR implementation guides are referenced:

* [SMART App Launch](http://www.hl7.org/fhir/smart-app-launch)

### Usage

This document is a working specification that may be directly implemented by FHIR®© system producers.

FHIR®© connectathon events are key to the verification of the guide as being suitable for implementation. This implementation guide will be used as the basis for Australian connectathon events.

### How to read this guide

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for this guide.
* Guidance 
* [General Requirements](general-requirements.md): This page documents how CapabilityStatements declare conformance to the SHC profiles and their FHIR interactions. It also defines the expectations for mandatory and **Must Support** elements.
* [SHC App Integration](smart-health-checks-app-integration.md): This page provides an overview of the integration requirements to launch the Smart Health Check Application.
* [Reference Implementation](reference-implementation.md): This page describes software components that have been developed to demonstrate the Smart Health Checks solution.
 
* FHIR Artefacts: These pages provide detailed descriptions and formal definitions for all the FHIR artefacts defined in this guide. 
* [Artefact Summary](artifacts.md): This page lists all of the FHIR artefacts defined in this guide.
* [Questionnaires](questionnaires.md): This page lists all of the Questionnaire resources defined in this guide.
* [Profiles and Extensions](profiles-and-extensions.md): This page lists all of the StructureDefinition resources defined in this guide.
* [Capability Statements](capability-statements.md): This page lists all of the CapabilityStatement resources defined in this guide.
* [Actor Definitions](actor-definitions.md): This page lists all of the ActorDefinition resources defined in this guide.
 
* [Downloads](downloads.md): This page provides links to downloadable artefacts including the Smart Forms FHIR NPM package.

### Collaboration

This guide is the product of collaborative work undertaken with participants from:

* Australian Government Department of Health and Aged Care
* National Aboriginal Community Controlled Health Organisation
* The Royal Australian College of General Practitioners
* Primary Care Data Quality Foundations Working Group
* Australian FHIR Implementers Community
* CSIRO Australian e-Health Research Centre

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

