# Artifacts Summary - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

## Artifacts Summary

Contents:

*  [Requirements: Actor Definitions](#1) 
*  [Behavior: Capability Statements](#2) 
*  [Structures: Questionnaires](#3) 
*  [Structures: Resource Profiles](#4) 
*  [Structures: Extension Definitions](#5) 
*  [Terminology: Value Sets](#6) 
*  [Terminology: Code Systems](#7) 
*  [Example: Example Instances](#8) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [SHC App](ActorDefinition-SHCApp.md) | The SHC App is a system that a SHC Host can launch allowing a user to fill out a health check form, prepopulated with patient health information retrieved from the SHC Host FHIR Server, and writeback data collected in the form. |
| [SHC Host](ActorDefinition-SHCHost.md) | The SHC Host is a system that allows a user to launch the SHC App within an embedded or externally launched web browser to fill out a health check form. |
| [SHC Host Authorization Server](ActorDefinition-SHCHostAuthorizationServer.md) | The SHC Host Authorization Server allows the SHC App to request authorisation from the PMS user to access patient health information to prepopulate and write back health checks data using the PMS FHIR Server. |
| [SHC Host FHIR Server](ActorDefinition-SHCHostFHIRServer.md) | The SHC Host FHIR Server allows the SHC App to retrieve patient health information and writeback collected health check data. |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) | This CapabilityStatement describes the capabilities of the SHC App. These capabilities include supported FHIR profiles, RESTful operations, and search parameters. It covers supported tasks such as SMART App launch context, prepopulation, write-back of extracted resources and completion of forms. |
| [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md) | This CapabilityStatement describes the expected capabilities for systems to launch and exchange data with the[SHC App](CapabilityStatement-SHCAppCapabilityStatement.md)to support the[Aboriginal and Torres Strait Islander Health Check](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.md). It lists the server's conformance expectations for the resource types required as a launch context, resource types required to support prepopulation of the form, resource types required to support writing back to the patient record, and QuestionnaireResponse requirements for managing form responses. These expectations include supported FHIR profiles, RESTful operations, and search parameters. |

### Structures: Questionnaires 

These define forms used by systems conforming to this implementation guide to capture or expose data to end users.

| |
| :--- |
| [Aboriginal and Torres Strait Islander Health Check](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.md) |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU Core Head Circumference](StructureDefinition-au-core-headcircum.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch head circumference observations with standard coding and units of measure. It is based on the[FHIR Head Circumference Profile](http://hl7.org/fhir/R4/headcircum.html)and identifies the**additional**mandatory core elements, extensions, vocabularies and value sets that**SHALL**be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md) | This profile sets the minimum expectations for an AllergyIntolerance resource to record, search and save allergy or intolerance information when used within Smart Health Checks. |
| [Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md) | This profile sets the minimum expectations for a Blood Pressure resource to record, search and save blood pressure information when used within Smart Health Checks. |
| [Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md) | This profile sets the minimum expectations for a Body Height resource to record, search and save body height information when used within Smart Health Checks. |
| [Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md) | This profile sets the minimum expectations for a Body Weight resource to record, search and save body weight information when used within Smart Health Checks. |
| [Smart Health Checks Condition](StructureDefinition-SHCCondition.md) | This profile sets the minimum expectations for a Condition resource to record, search and save condition information when used within Smart Health Checks. |
| [Smart Health Checks Encounter](StructureDefinition-SHCEncounter.md) | This profile sets the minimum expectations for a Encounter resource to search and retrieve encounter information when used within Smart Health Checks. |
| [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md) | This profile sets the expectations for a Bundle resource when used to represent a transaction bundle of resources extracted by the SHC App following the completion of a Smart Health Checks Questionnaire. This bundle is used to write patient information to the SHC Host FHIR server. |
| [Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md) | This profile sets the minimum expectations for a Head Circumference resource to record, search and save head circumference information when used within Smart Health Checks. |
| [Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md) | This profile sets the minimum expectations for a Heart Rate resource to record, search and save heart rate information when used within Smart Health Checks. |
| [Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md) | This profile sets the minimum expectations for an Observation resource to record heart rhythm observations. It is used to represent heart rhythm data captured during a First Nations Health Check that can be used to record the observation in a clinical record. |
| [Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md) | This profile sets the minimum expectations for an Immunization resource to record, search and save immunization information when used within Smart Health Checks. |
| [Smart Health Checks Medication](StructureDefinition-SHCMedication.md) | This profile sets the minimum expectations for a Medication resource to search and retrieve medication information when used within Smart Health Checks. |
| [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md) | This profile sets the minimum expectations for a MedicationStatement resource to record, search and save medication information when used within Smart Health Checks. |
| [Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md) | This profile sets the expectations for a Parameters resource when used to patch AllergyIntolerance resources within Smart Health Checks. |
| [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md) | This profile sets the expectations for a Parameters resource when used to patch Condition resources within Smart Health Checks. |
| [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md) | This profile sets the expectations for a Parameters resource when used to patch MedicationStatement resources within Smart Health Checks. |
| [Smart Health Checks Pathology Result](StructureDefinition-SHCPathologyResult.md) | This profile sets the minimum expectations for an Observation resource to search and retrieve pathology result information when used within Smart Health Checks. |
| [Smart Health Checks Patient](StructureDefinition-SHCPatient.md) | This profile sets the minimum expectations for a Patient resource to search and retrieve patient information when used within Smart Health Checks. |
| [Smart Health Checks Practitioner](StructureDefinition-SHCPractitioner.md) | This profile sets the minimum expectations for a Practitioner resource to search and retrieve practitioner information when used within Smart Health Checks. |
| [Smart Health Checks Questionnaire Response](StructureDefinition-SHCQuestionnaireResponse.md) | This profile sets the minimum expectations for a QuestionnaireResponse resource to record, search and save form information when used within Smart Health Checks. |
| [Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md) | This profile sets the minimum expectations for a Smoking Status resource to record, search and save smoking status information when used within Smart Health Checks. |
| [Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md) | This profile sets the minimum expectations for a Waist Circumference resource to record, search and save waist circumference information when used within Smart Health Checks. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Contained Resource Reference](StructureDefinition-ContainedResourceReference.md) | This extension is intended to be used as a work around to a known bug whereby contained resources that are not referenced with the type, 'Reference' are removed before a resource is created in a HAPI FHIR server. This is problematic when referencing with the type, 'canonical'. The extension can be used to reference contained resources so they are retained when added to a HAPI FHIR server. |
| [Group Hide Add Item Button](StructureDefinition-GroupHideAddItemButton.md) | This custom extension is used to hide the UI component that allows a user to add new items for repeating groups in a Questionnaire. This is useful for preventing users from adding additional groups when it is not appropriate to do so, such as when a group is intended to be prepopulated with existing data but no new ones added by the user. |
| [Questionnaire Initial Expression Repopulatable](StructureDefinition-questionnaire-initialExpression-repopulatable.md) | This custom extension is used to add a UI component that allows a user to repopulate an individual Questionnaire item with the latest data from the FHIR server. This is useful for updating specific items without having to refresh the entire form. |
| [Questionnaire Item Text Hidden](StructureDefinition-QuestionnaireItemTextHidden.md) | This custom extension is used to indicate that the text of a Questionnaire item should be hidden in the user interface. This is useful for items where the text is not intended to be displayed to the user but is still needed for other processes. |
| [Template Extract Extension Patch Request URL](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.md) | This extension is used to specify the value of the request URL for a bundle entry containing a Parameters resource for a PATCH method. It identifies the resource instance being patched and will specify both the resource type and the resource Id. It is to be used as a sub-extension of the[Extract Template - Resource](https://build.fhir.org/ig/HL7/sdc/StructureDefinition-sdc-questionnaire-templateExtract.html)extension. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Aboriginal and/or Torres Strait Islander](ValueSet-AboriginalTorresStraitIslander.md) | The Aboriginal and/or Torres Strait Islander value set includes the Australian Indigenous statuses for Indigenous people. |
| [AdministrativeGender](ValueSet-administrative-gender.md) | The gender of a person used for administrative purposes. |
| [Allergy Intolerance Clinical Status Minimal](ValueSet-AllergyIntoleranceClinicalStatusMinimal.md) | This value set includes the minimal set of codes to represent the clinical status of an allergy intolerance (i.e., active and inactive). |
| [Australian Medicines Terminology Vaccine](ValueSet-amt-vaccine-1.md) | The Australian Medicines Terminology (AMT) Vaccine value set includes AMT product concepts that may be used to record a vaccine product. |
| [Australian Pronouns](ValueSet-australian-pronouns-1.md) | The Australian Pronouns value set includes values that indicate the pronouns to be used when communicating with or about an individual. |
| [Australian States and Territories](ValueSet-australian-states-territories-2.md) | The Australian States and Territories value set includes values that represent the Australian states and territories. |
| [Biological Sex](ValueSet-biological-sex-1.md) | The Biological Sex value set includes values that represent the biological sex of an individual. |
| [Cervical Screening Status](ValueSet-CervicalScreeningStatus-1.md) | The Cervical Screening Status value set includes values that can be used to represent the status of an individual's participation in a cervical screening program. |
| [Clinical Condition](ValueSet-clinical-condition-1.md) | The Clinical Condition value set includes values that cover a broad range of clinical concepts to support the representation of conditions, including problems, diagnoses and disorders. |
| [Condition Clinical Status Codes](ValueSet-condition-clinical.md) | Preferred value set for Condition Clinical Status. |
| [Gender Identity Response](ValueSet-gender-identity-response-1.md) | The Gender Identity Response value set includes values that may be used to represent a response for an individual's gender. A person's gender is a social and cultural identity, expression and experience. |
| [Heart Rhythm](ValueSet-heart-rhythm-1.md) | The Heart Rhythm value set includes values that may be used to represent the heart rhythm of an individual. |
| [Medication Reason Taken](ValueSet-medication-reason-taken-1.md) | The Medication Reason Taken value set includes values that identify a reason why a medication has been or is being taken. |
| [Medication Statement Status Limited](ValueSet-MedicationStatementStatusLimited.md) | This value set includes the minimal set of codes to represent the status of a medication statement (i.e., active, completed, stopped and on-hold). |
| [Primary Carer Of Parent Or Grandparent](ValueSet-PrimaryCarerParentGrandparent.md) | The Primary Carer Of Parent Or Grandparent value set includes values that can indicate whether a primary carer is one of the parents or a grandparent. |
| [Questionnaire Repopulation Behavior](ValueSet-QuestionnaireRepopulationBehavior.md) | The Questionnaire Repopulation Behavior value set includes values that can indicate how a Questionnaire item's initial expression can be re-evaluated and the item repopulated. |
| [Smart Health Checks Medicine Products](ValueSet-smart-health-checks-medicine-products.md) | The Smart Health Checks Medicine Products value set includes Australian Medicines Terminology (AMT) product concepts that may be used for the identification of a medicine with form, ingredient and unit of measure details. |
| [Smart Health Checks Patch AllergyIntolerance Element Name](ValueSet-SHCPatchAllergyIntoleranceElementName.md) | The Smart Health Checks Patch AllergyIntolerance Element Name value set includes values that can be used to identify the element names in the AllergyIntolerance resource that are the target of a patch operation for Smart Health Checks. |
| [Smart Health Checks Patch AllergyIntolerance Element Path](ValueSet-SHCPatchAllergyIntoleranceElementPath.md) | The Smart Health Checks Patch AllergyIntolerance Element Path value set includes values that can be used to identify the element paths in the AllergyIntolerance resource where the patch operation is to be performed for Smart Health Checks. |
| [Smart Health Checks Patch Condition Element Name](ValueSet-SHCPatchConditionElementName.md) | The Smart Health Checks Patch Condition Element Name value set includes values that can be used to identify the element names in the Condition resource that are the target of a patch operation for Smart Health Checks. |
| [Smart Health Checks Patch Condition Element Path](ValueSet-SHCPatchConditionElementPath.md) | The Smart Health Checks Patch Condition Element Path value set includes values that can be used to identify the element paths in the Condition resource where the patch operation is to be performed for Smart Health Checks. |
| [Smart Health Checks Patch MedicationStatement Element Name](ValueSet-SHCPatchMedicationStatementElementName.md) | The Smart Health Checks Patch MedicationStatement Element Name value set includes values that can be used to identify the element names in the MedicationStatement resource that are the target of a patch operation for Smart Health Checks. |
| [Smart Health Checks Patch MedicationStatement Element Path](ValueSet-SHCPatchMedicationStatementElementPath.md) | The Smart Health Checks Patch MedicationStatement Element Path value set includes values that can be used to identify the element paths in the MedicationStatement resource where the patch operation is to be performed for Smart Health Checks. |
| [Smart Health Checks Patch Path](ValueSet-SHCPatchPath.md) | The Smart Health Checks Patch Path value set includes values that can be used to identify the element paths that are the target of a patch operation for Smart Health Checks. |
| [Smoking Quit Status](ValueSet-SmokingQuitStatus-1.md) | The Smoking Quit Status value set includes values that can indicate how long ago an individual quit smoking. |
| [Tobacco Use Status](ValueSet-TobaccoUseStatus-1.md) | The Tobacco Use Status value set includes values that may be used to represent an individual's current tobacco use and exposure status. |
| [Yes/No](ValueSet-YesNo.md) | Concepts for Yes and No |
| [Yes/No/NA](ValueSet-YesNoNA.md) | Concepts for Yes, No and Not applicable |
| [Yes/No/Not Asked/Asked But Declined](ValueSet-YesNoNotAskedDeclined.md) | Concepts for Yes, No, Not Asked and Asked But Declined |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Questionnaire Item Control Extension](CodeSystem-QuestionnaireItemControlExtended.md) | The Questionnaire Item Control Extension code system defines concepts that extend the HL7 questionnaire item control concepts in http://hl7.org/fhir/questionnaire-item-control. They represent interface control/display mechanisms interface control/display mechanisms that might be used when rendering an item in a questionnaire. |
| [Questionnaire Repopulation Behavior Codes](CodeSystem-QuestionnaireRepopulationBehaviorCodes.md) | The Questionnaire Repopulation Behavior Codes code system defines concepts that describe the repopulation behaviour that can be applied to the initial expression of a Questionnaire item. |
| [SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check](CodeSystem-HealthChecksSCTSupplement.md) | The SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check code system supplement defines consumer friendly terms for use in the health check Questionnaire. |
| [Smart Health Checks Patch Element Name Codes](CodeSystem-SHCPatchElementNameCodes.md) | The Smart Health Checks Patch Element Name Codes code system defines concepts that identify element names that are the target of a patch operation for Smart Health Checks. |
| [Smart Health Checks Patch Element Path Codes](CodeSystem-SHCPatchElementPathCodes.md) | The Smart Health Checks Patch Element Path Codes code system defines concepts that identify element paths where the patch operation is to be performed for Smart Health Checks. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [604a-pat-sf](AllergyIntolerance-604a-pat-sf.md) |  |
| [Aboriginal and Torres Strait Islander Health Check](Questionnaire-AssemblyInstructions.md) | Aboriginal and Torres Strait Islander Health Check assessment form. |
| [Aboriginal and Torres Strait Islander Health Check - About The Health Check](Questionnaire-AboutTheHealthCheck.md) | About The Health Check sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Absolute Cardiovascular Disease Risk Calculation](Questionnaire-AbsoluteCVDRiskCalculation.md) | Absolute Cardiovascular Disease Risk Calculation sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Allergies/Adverse Reactions](Questionnaire-AllergiesAdverseReactions.md) | Allergies/Adverse Reactions sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Chronic Disease Ageing](Questionnaire-ChronicDiseaseAgeing.md) | Chronic Disease Ageing sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Consent](Questionnaire-Consent.md) | Consent sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Current Priorities](Questionnaire-CurrentPriorities.md) | Current Priorities sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Ear Health And Hearing](Questionnaire-EarHealthAndHearing.md) | Ear Health And Hearing sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Examination](Questionnaire-Examination.md) | Examination sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Eye Health](Questionnaire-EyeHealth.md) | Eye Health sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Family History](Questionnaire-FamilyHistory.md) | Family History sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Finalising the Health Check](Questionnaire-FinalisingHealthCheck.md) | Finalising the Health Check sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Gambling](Questionnaire-Gambling.md) | Gambling sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Health Priorities, Actions And Follow-Up Summary](Questionnaire-HealthPrioritiesSummary.md) | Health Priorities, Actions And Follow-Up Summary sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Healthy Eating](Questionnaire-HealthyEating.md) | Healthy Eating sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Home And Family](Questionnaire-HomeAndFamily.md) | Home And Family sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Immunisation](Questionnaire-Immunisation.md) | Immunisation sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Investigations](Questionnaire-Investigations.md) | Investigations sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Learning And Development](Questionnaire-LearningAndDevelopment.md) | Learning And Development sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Learning And Work](Questionnaire-LearningAndWork.md) | Learning And Work sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Medical History](Questionnaire-MedicalHistoryCurrentProblems.md) | Medical History sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Memory And Thinking](Questionnaire-MemoryAndThinking.md) | Memory And Thinking sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Mood](Questionnaire-Mood.md) | Mood sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Oral And Dental Health](Questionnaire-OralAndDentalHealth.md) | Oral And Dental Health sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Patient Details](Questionnaire-PatientDetails.md) | Patient Details sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Physical Activity And Screen Time](Questionnaire-PhysicalActivityAndScreenTime.md) | Physical Activity And Screen Time sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Red Flags Early Identification Guide For Children](Questionnaire-RedFlagsEarlyIdentificationGuide.md) | Red Flags Early Identification Guide For Children sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Regular Medications](Questionnaire-RegularMedications.md) | Regular Medications sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Screening Programs](Questionnaire-ScreeningPrograms.md) | Screening Programs sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Sexual Health](Questionnaire-SexualHealth.md) | Sexual Health sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Skin](Questionnaire-Skin.md) | Skin sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Social And Emotional Wellbeing](Questionnaire-SocialAndEmotionalWellbeing.md) | Social And Emotional Wellbeing sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Social History Child](Questionnaire-SocialHistoryChild.md) | Social History Child sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [Aboriginal and Torres Strait Islander Health Check - Substance Use](Questionnaire-SubstanceUse.md) | Substance Use sub-questionnaire for Aboriginal and Torres Strait Islander Health Check. |
| [SHCPatchAllergyIntolerance1](Parameters-SHCPatchAllergyIntolerance1.md) |  |
| [SHCPatchAllergyIntolerance2](Parameters-SHCPatchAllergyIntolerance2.md) |  |
| [SHCPatchCondition1](Parameters-SHCPatchCondition1.md) |  |
| [SHCPatchMedicationStatement1](Parameters-SHCPatchMedicationStatement1.md) |  |
| [SHCPatchMedicationStatement2](Parameters-SHCPatchMedicationStatement2.md) |  |
| [SHCPatchMedicationStatement3](Parameters-SHCPatchMedicationStatement3.md) |  |
| [SHCPatchMedicationStatement4](Parameters-SHCPatchMedicationStatement4.md) |  |
| [active-bisoprolol-pat-sf](MedicationStatement-active-bisoprolol-pat-sf.md) |  |
| [bisoprolol-pat-sf](Medication-bisoprolol-pat-sf.md) |  |
| [chloramphenicol-pat-sf](MedicationStatement-chloramphenicol-pat-sf.md) |  |
| [fever-pat-sf](Condition-fever-pat-sf.md) |  |
| [pat-sf](Patient-pat-sf.md) |  |
| [primary-peter](Practitioner-primary-peter.md) |  |
| [sdc-template-extract-928bbdd27d15](Bundle-sdc-template-extract-928bbdd27d15.md) |  |

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

