# Actor Definitions - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* **Actor Definitions**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

## Actor Definitions

The following actor definitions have been defined for this implementation guide.

* [SHC App](ActorDefinition-SHCApp.md) 
* The SHC App allows a user of the SHC Host to launch the SHC App for filling out a health check form prepopulated with a authorized patient health information retrieved from the SHC Host FHIR Server and writeback the collected form data.
 
* [SHC Host](ActorDefinition-SHCHost.md) 
* The SHC Host allows a user to launch the SHC App within an embedded or externally launched web browser to fill out a health check form.
 
* [SHC Host Authorization Server](ActorDefinition-SHCHostAuthorizationServer.md) 
* The SHC Host Authorization Server allows the SHC App to request authorisation from the PMS user to access patient health information to prepopulate and write back health checks data using the PMS FHIR Server.
 
* [SHC Host FHIR Server](ActorDefinition-SHCHostFHIRServer.md) 
* The SHC Host FHIR Server allows the SHC App to retrieve patient health information and write back collected health check data.
 

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

