# Smart Health Checks Medicine Products - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Medicine Products**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-smart-health-checks-medicine-products.xml.md) 
*  [JSON](ValueSet-smart-health-checks-medicine-products.json.md) 
*  [TTL](ValueSet-smart-health-checks-medicine-products.ttl.md) 

## ValueSet: Smart Health Checks Medicine Products 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/ValueSet/smart-health-checks-medicine-products | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SmartHealthChecksMedicineProducts |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The Smart Health Checks Medicine Products value set includes Australian Medicines Terminology (AMT) product concepts that may be used for the identification of a medicine with form, ingredient and unit of measure details. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include codes from[`http://snomed.info/sct`](http://www.snomed.org/) where constraint = ^ 929360081000036101|Medicinal product pack reference set| OR ^ 929360071000036103|Medicinal product unit of use reference set| OR ^ 929360041000036105|Trade product pack reference set| OR ^ 929360031000036100|Trade product unit of use reference set| OR ^ 929360051000036108|Containered trade product pack reference set|

 

### Expansion

Expansion from tx.ontoserver.csiro.au based on SNOMED CT Australian Edition edition 30-Sep 2025

This value set has 146,079 codes in it. In order to keep the publication size manageable, only a selection (1,000 codes) of the whole set of codes is shown.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

