# Australian States and Territories - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Australian States and Territories**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-australian-states-territories-2.xml.md) 
*  [JSON](ValueSet-australian-states-territories-2.json.md) 
*  [TTL](ValueSet-australian-states-territories-2.ttl.md) 

## ValueSet: Australian States and Territories 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2 | *Version*:2.0.2 | |
| Active as of 2020-05-31 | *Responsible:*Australian Digital Health Agency | *Computable Name*:AustralianStatesAndTerritories |
| *Other Identifiers:*OID:1.2.36.1.2001.1004.201.10026 | | |
| **Copyright/Legal**: Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/.This resource includes material that is based on Australian Institute of Health and Welfare material.All copies of this resource must include this copyright statement and all information contained in this statement. | | |

 
The Australian States and Territories value set includes values that represent the Australian states and territories. 

 **References** 

* [Australian Address](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-au-address.html)

### Logical Definition (CLD)

Profiles: [Shareable ValueSet](http://hl7.org/fhir/R4/shareablevalueset.html), `https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4`

* Include these codes as defined in [`https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1`](https://tx.ontoserver.csiro.au/fhir)

 

### Expansion

Expansion based on [codesystem Australian States and Territories v1.1.3 (CodeSystem)](https://tx.ontoserver.csiro.au/fhir/ValueSet/australian-states-territories-1)

This value set contains 9 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

