# Smart Health Checks Patch Condition Element Path - Smart Health Checks v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Patch Condition Element Path**

Smart Health Checks, published by AEHRC CSIRO. This guide is not an authorized publication; it is the continuous build for version 0.3.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/aehrc/smart-forms-ig/](https://github.com/aehrc/smart-forms-ig/) and changes regularly. See the [Directory of published versions](https://smartforms.csiro.au/ig/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-SHCPatchConditionElementPath.xml.md) 
*  [JSON](ValueSet-SHCPatchConditionElementPath.json.md) 
*  [TTL](ValueSet-SHCPatchConditionElementPath.ttl.md) 

## ValueSet: Smart Health Checks Patch Condition Element Path 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/ValueSet/SHCPatchConditionElementPath | *Version*:0.3.0 |
| Draft as of 2025-10-01 | *Computable Name*:SHCPatchConditionElementPath |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The Smart Health Checks Patch Condition Element Path value set includes values that can be used to identify the element paths in the Condition resource where the patch operation is to be performed for Smart Health Checks. 

 **References** 

* [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)

### Logical Definition (CLD)

* Include these codes as defined in [`https://smartforms.csiro.au/ig/CodeSystem/SHCPatchElementPathCodes`](CodeSystem-SHCPatchElementPathCodes.md)

 

### Expansion

Expansion performed internally based on [codesystem Smart Health Checks Patch Element Path Codes v0.3.0 (CodeSystem)](CodeSystem-SHCPatchElementPathCodes.md)

This value set contains 1 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2022+ [AEHRC CSIRO](https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2). Package csiro.fhir.au.smartforms#0.3.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

